/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.query.criteria;

import org.neodatis.odb.OID;
import org.neodatis.odb.Objects;
import org.neodatis.odb.core.layers.layer2.instance.IInstanceBuilder;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.query.IQuery;
import org.neodatis.odb.core.query.execution.IMatchingObjectAction;
import org.neodatis.odb.impl.core.query.list.objects.InMemoryBTreeCollection;
import org.neodatis.odb.impl.core.query.list.objects.LazyBTreeCollection;
import org.neodatis.odb.impl.core.query.list.objects.LazySimpleListFromOid;
import org.neodatis.odb.impl.core.query.list.objects.SimpleList;
import org.neodatis.tool.wrappers.OdbComparable;

public class CollectionQueryResultAction
implements IMatchingObjectAction {
    private IQuery query;
    private boolean inMemory;
    private long nbObjects;
    private IStorageEngine storageEngine;
    private boolean returnObjects;
    private Objects<Object> result;
    private boolean queryHasOrderBy;
    protected IInstanceBuilder instanceBuilder;

    public CollectionQueryResultAction(IQuery query, boolean inMemory, IStorageEngine storageEngine, boolean returnObjects, IInstanceBuilder instanceBuilder) {
        this.query = query;
        this.inMemory = inMemory;
        this.storageEngine = storageEngine;
        this.returnObjects = returnObjects;
        this.queryHasOrderBy = query.hasOrderBy();
        this.instanceBuilder = instanceBuilder;
    }

    @Override
    public void objectMatch(OID oid, OdbComparable orderByKey) {
        if (this.queryHasOrderBy) {
            this.result.addWithKey(orderByKey, (Object)oid);
        } else {
            this.result.add(oid);
        }
    }

    @Override
    public void objectMatch(OID oid, Object object, OdbComparable orderByKey) {
        NonNativeObjectInfo nnoi = (NonNativeObjectInfo)object;
        if (this.inMemory) {
            if (this.returnObjects) {
                if (this.queryHasOrderBy) {
                    this.result.addWithKey(orderByKey, this.getCurrentInstance(nnoi));
                } else {
                    this.result.add(this.getCurrentInstance(nnoi));
                }
            } else if (this.queryHasOrderBy) {
                this.result.addWithKey(orderByKey, (Object)nnoi);
            } else {
                this.result.add(nnoi);
            }
        } else if (this.queryHasOrderBy) {
            this.result.addWithKey(orderByKey, (Object)oid);
        } else {
            this.result.add(oid);
        }
    }

    @Override
    public void start() {
        this.result = this.inMemory ? (this.query != null && this.query.hasOrderBy() ? new InMemoryBTreeCollection<Object>((int)this.nbObjects, this.query.getOrderByType()) : new SimpleList<Object>((int)this.nbObjects)) : (this.query != null && this.query.hasOrderBy() ? new LazyBTreeCollection<Object>((int)this.nbObjects, this.storageEngine, this.returnObjects) : new LazySimpleListFromOid<Object>((int)this.nbObjects, this.storageEngine, this.returnObjects));
    }

    @Override
    public void end() {
    }

    public Object getCurrentInstance(NonNativeObjectInfo nnoi) {
        if (nnoi.getObject() != null) {
            return nnoi.getObject();
        }
        return this.instanceBuilder.buildOneInstance(nnoi);
    }

    public Objects<Object> getObjects() {
        return this.result;
    }
}

