/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.layers.layer3.oid;

import org.neodatis.odb.OID;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.ICoreProvider;
import org.neodatis.odb.core.layers.layer3.IIdManager;
import org.neodatis.odb.core.layers.layer3.IObjectReader;
import org.neodatis.odb.core.layers.layer3.IObjectWriter;
import org.neodatis.odb.core.transaction.ISession;
import org.neodatis.odb.impl.core.layers.layer3.engine.StorageEngineConstant;
import org.neodatis.tool.DLogger;

public class DefaultIdManager
implements IIdManager {
    private static final String LOG_ID = "IdManager";
    private ICoreProvider provider = OdbConfiguration.getCoreProvider();
    private long currentBlockIdPosition;
    private int currentBlockIdNumber;
    public OID nextId;
    public OID maxId;
    protected IObjectWriter objectWriter;
    protected IObjectReader objectReader;
    protected ISession session;
    protected OID[] lastIds;
    protected long[] lastIdPositions;
    private int lastIdIndex;
    private static final int ID_BUFFER_SIZE = 10;

    public DefaultIdManager(IObjectWriter objectWriter, IObjectReader objectReader, long currentBlockIdPosition, int currentBlockIdNumber, OID currentMaxId) {
        this.objectWriter = objectWriter;
        this.objectReader = objectReader;
        this.session = objectWriter.getSession();
        this.currentBlockIdPosition = currentBlockIdPosition;
        this.currentBlockIdNumber = currentBlockIdNumber;
        this.maxId = this.provider.getObjectOID((long)currentBlockIdNumber * (long)OdbConfiguration.getNB_IDS_PER_BLOCK(), 0L);
        this.nextId = this.provider.getObjectOID(currentMaxId.getObjectId() + 1L, 0L);
        this.lastIds = new OID[10];
        for (int i = 0; i < 10; ++i) {
            this.lastIds[i] = StorageEngineConstant.NULL_OBJECT_ID;
        }
        this.lastIdPositions = new long[10];
        this.lastIdIndex = 0;
    }

    @Override
    public synchronized boolean mustShift() {
        return this.nextId.compareTo(this.maxId) > 0;
    }

    synchronized OID getNextId(long objectPosition, byte idType, byte idStatus, String label) {
        long idPosition;
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug("  Start of " + label + " for object with position " + objectPosition);
        }
        if (this.mustShift()) {
            this.shiftBlock();
        }
        OID currentNextId = this.nextId;
        if (idType == 2) {
            currentNextId = this.provider.getClassOID(currentNextId.getObjectId());
        }
        int currentIndex = (this.lastIdIndex + 1) % 10;
        this.lastIds[currentIndex] = currentNextId;
        this.lastIdPositions[currentIndex] = idPosition = this.associateIdToObject(idType, idStatus, objectPosition);
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug("  End of " + label + " for object with position " + idPosition + " : returning " + currentNextId);
        }
        this.lastIdIndex = currentIndex;
        return currentNextId;
    }

    @Override
    public synchronized OID getNextObjectId(long objectPosition) {
        return this.getNextId(objectPosition, (byte)1, (byte)1, "getNextObjectId");
    }

    @Override
    public synchronized OID getNextClassId(long objectPosition) {
        return this.getNextId(objectPosition, (byte)2, (byte)1, "getNextClassId");
    }

    @Override
    public void updateObjectPositionForOid(OID oid, long objectPosition, boolean writeInTransaction) {
        long idPosition = this.getIdPosition(oid);
        this.objectWriter.updateObjectPositionForObjectOIDWithPosition(idPosition, objectPosition, writeInTransaction);
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug("IDManager : Updating id " + oid + " with position " + objectPosition);
        }
    }

    @Override
    public void updateClassPositionForId(OID classId, long objectPosition, boolean writeInTransaction) {
        long idPosition = this.getIdPosition(classId);
        this.objectWriter.updateClassPositionForClassOIDWithPosition(idPosition, objectPosition, writeInTransaction);
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug("Updating id " + classId + " with position " + objectPosition);
        }
    }

    @Override
    public void updateIdStatus(OID id, byte newStatus) {
        long idPosition = this.getIdPosition(id);
        this.objectWriter.updateStatusForIdWithPosition(idPosition, newStatus, true);
    }

    private long getIdPosition(OID oid) {
        if (this.lastIds[this.lastIdIndex] != null && this.lastIds[this.lastIdIndex].equals(oid)) {
            return this.lastIdPositions[this.lastIdIndex];
        }
        for (int i = 0; i < 10; ++i) {
            if (this.lastIds[i] == null || !this.lastIds[i].equals(oid)) continue;
            return this.lastIdPositions[i];
        }
        return this.objectReader.readOidPosition(oid);
    }

    private long associateIdToObject(byte idType, byte idStatus, long objectPosition) {
        long idPosition = this.objectWriter.associateIdToObject(idType, idStatus, this.currentBlockIdPosition, this.nextId, objectPosition, false);
        this.nextId = this.provider.getObjectOID(this.nextId.getObjectId() + 1L, 0L);
        return idPosition;
    }

    private void shiftBlock() {
        long currentBlockPosition = this.currentBlockIdPosition;
        long newBlockPosition = this.createNewBlock();
        this.markBlockAsFull(currentBlockPosition, newBlockPosition);
        ++this.currentBlockIdNumber;
        this.currentBlockIdPosition = newBlockPosition;
        this.maxId = this.provider.getObjectOID((long)this.currentBlockIdNumber * (long)OdbConfiguration.getNB_IDS_PER_BLOCK(), 0L);
    }

    private void markBlockAsFull(long currentBlockIdPosition, long nextBlockPosition) {
        this.objectWriter.markIdBlockAsFull(currentBlockIdPosition, nextBlockPosition, false);
    }

    private long createNewBlock() {
        long position = this.objectWriter.writeIdBlock(-1L, OdbConfiguration.getIdBlockSize(), (byte)1, this.currentBlockIdNumber + 1, this.currentBlockIdPosition, false);
        return position;
    }

    @Override
    public synchronized OID consultNextOid() {
        return this.nextId;
    }

    @Override
    public void reserveIds(long nbIds) {
        OID id = null;
        while (this.nextId.getObjectId() < nbIds + 1L) {
            id = this.getNextId(-1L, (byte)0, (byte)0, "reserving id");
            if (!OdbConfiguration.isDebugEnabled(LOG_ID)) continue;
            DLogger.debug("reserving id " + id);
        }
    }

    @Override
    public long getObjectPositionWithOid(OID oid, boolean useCache) {
        return this.objectReader.getObjectPositionFromItsOid(oid, useCache, true);
    }

    @Override
    public void clear() {
        this.objectReader = null;
        this.objectWriter = null;
        this.session = null;
        this.lastIdPositions = null;
        this.lastIds = null;
    }

    protected ISession getSession() {
        return this.session;
    }
}

