/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.layers.layer2.instance;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.IError;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer1.introspector.IClassIntrospector;
import org.neodatis.odb.core.layers.layer2.instance.IClassPool;
import org.neodatis.odb.core.layers.layer2.instance.IInstanceBuilder;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ArrayObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.AtomicNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.CollectionObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.EnumNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.MapObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeNullObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.oid.OIDFactory;
import org.neodatis.odb.core.transaction.ICache;
import org.neodatis.odb.core.transaction.ICrossSessionCache;
import org.neodatis.odb.core.transaction.ISession;
import org.neodatis.odb.core.trigger.ITriggerManager;
import org.neodatis.odb.impl.core.transaction.CacheFactory;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.map.OdbHashMap;

public abstract class InstanceBuilder
implements IInstanceBuilder {
    private static final String LOG_ID = "InstanceBuilder";
    private static final String LOG_ID_DEBUG = "InstanceBuilder.debug";
    private ITriggerManager triggerManager;
    protected IStorageEngine engine;
    private IClassIntrospector classIntrospector;
    private IClassPool classPool;
    private Map<OID, Object> localCache;

    public InstanceBuilder(IStorageEngine engine) {
        this.triggerManager = OdbConfiguration.getCoreProvider().getLocalTriggerManager(engine);
        this.classIntrospector = OdbConfiguration.getCoreProvider().getClassIntrospector();
        this.classPool = OdbConfiguration.getCoreProvider().getClassPool();
        this.engine = engine;
        this.localCache = new OdbHashMap<OID, Object>(50);
    }

    protected abstract ISession getSession();

    @Override
    public Object buildOneInstance(NonNativeObjectInfo objectInfo) {
        try {
            Object object = this.internalBuildOneInstance(objectInfo);
            return object;
        }
        finally {
            this.localCache.clear();
        }
    }

    protected Object internalBuildOneInstance(AbstractObjectInfo objectInfo) {
        Object object = null;
        if (objectInfo instanceof NonNativeNullObjectInfo) {
            return null;
        }
        object = objectInfo.getClass() == NonNativeObjectInfo.class ? this.internalBuildOneInstance((NonNativeObjectInfo)objectInfo) : this.internalBuildOneInstance((NativeObjectInfo)objectInfo, null);
        return object;
    }

    protected Object internalBuildCollectionInstance(CollectionObjectInfo coi) {
        Collection newCollection = null;
        try {
            newCollection = (Collection)this.classPool.getClass(coi.getRealCollectionClassName()).newInstance();
        }
        catch (Exception e) {
            throw new ODBRuntimeException(NeoDatisError.COLLECTION_INSTANCIATION_ERROR.addParameter(coi.getRealCollectionClassName()), (Throwable)e);
        }
        Iterator<AbstractObjectInfo> iterator = coi.getCollection().iterator();
        AbstractObjectInfo aoi = null;
        while (iterator.hasNext()) {
            aoi = iterator.next();
            if (aoi.isDeletedObject()) continue;
            newCollection.add(this.internalBuildOneInstance(aoi));
        }
        return newCollection;
    }

    protected Object internalBuildEnumInstance(EnumNativeObjectInfo enoi) {
        Class clazz = this.classPool.getClass(enoi.getEnumClassInfo().getFullClassName());
        Object theEnum = Enum.valueOf(clazz, enoi.getEnumName());
        return theEnum;
    }

    protected Object internalBuildArrayInstance(ArrayObjectInfo aoi) {
        ODBType type = ODBType.getFromName(aoi.getRealArrayComponentClassName());
        Class arrayClazz = type.getNativeClass();
        Object array = Array.newInstance(arrayClazz, aoi.getArray().length);
        Object object = null;
        AbstractObjectInfo aboi = null;
        for (int i = 0; i < aoi.getArrayLength(); ++i) {
            aboi = (AbstractObjectInfo)aoi.getArray()[i];
            if (aboi == null || aboi.isDeletedObject() || aboi.isNull()) continue;
            object = this.internalBuildOneInstance(aboi);
            Array.set(array, i, object);
        }
        return array;
    }

    protected Map internalBuildMapInstance(MapObjectInfo mapObjectInfo) {
        Map newMap;
        Map<AbstractObjectInfo, AbstractObjectInfo> map = mapObjectInfo.getMap();
        try {
            newMap = (Map)this.classPool.getClass(mapObjectInfo.getRealMapClassName()).newInstance();
        }
        catch (Exception e) {
            throw new ODBRuntimeException(NeoDatisError.MAP_INSTANCIATION_ERROR.addParameter(map.getClass().getName()));
        }
        Iterator<AbstractObjectInfo> iterator = map.keySet().iterator();
        AbstractObjectInfo key = null;
        while (iterator.hasNext()) {
            key = iterator.next();
            Object realKey = this.internalBuildOneInstance(key);
            Object realValue = this.internalBuildOneInstance(map.get(key));
            newMap.put(realKey, realValue);
        }
        return newMap;
    }

    protected Object internalBuildOneInstance(NonNativeObjectInfo objectInfo) {
        ICache cache = this.getSession().getCache();
        if (objectInfo.isDeletedObject()) {
            throw new ODBRuntimeException(NeoDatisError.OBJECT_IS_MARKED_AS_DELETED_FOR_OID.addParameter(objectInfo.getOid()));
        }
        Object o = cache.getObjectWithOid(objectInfo.getOid());
        if (o != null) {
            return o;
        }
        o = this.localCache.get(objectInfo.getOid());
        if (o != null) {
            return o;
        }
        Class instanceClazz = null;
        String className = objectInfo.getClassInfo().getFullClassName();
        instanceClazz = this.classPool.getClass(className);
        o = this.classIntrospector.newFullInstanceOf(instanceClazz, objectInfo);
        if (o != null) {
            cache.addObject(objectInfo.getOid(), o, objectInfo.getHeader());
            if (this.triggerManager != null) {
                this.triggerManager.manageSelectTriggerAfter(objectInfo.getClassInfo().getFullClassName(), objectInfo, objectInfo.getOid());
            }
            if (OdbConfiguration.reconnectObjectsToSession()) {
                ICrossSessionCache crossSessionCache = CacheFactory.getCrossSessionCache(this.engine.getBaseIdentification().getIdentification());
                crossSessionCache.addObject(o, objectInfo.getOid());
            }
            return o;
        }
        try {
            o = this.classIntrospector.newInstanceOf(instanceClazz);
        }
        catch (Exception e) {
            throw new ODBRuntimeException(NeoDatisError.INSTANCIATION_ERROR.addParameter(className), (Throwable)e);
        }
        if (o == null) {
            return null;
        }
        this.localCache.put(objectInfo.getOid(), o);
        ClassInfo ci = objectInfo.getClassInfo();
        IOdbList<Field> fields = this.classIntrospector.getAllFields(className);
        Field field = null;
        AbstractObjectInfo aoi = null;
        Object value = null;
        for (int i = 0; i < fields.size(); ++i) {
            field = (Field)fields.get(i);
            int attributeId = ci.getAttributeId(field.getName());
            if (attributeId == -1) {
                throw new ODBRuntimeException(NeoDatisError.CLASS_INFO_DO_NOT_HAVE_THE_ATTRIBUTE.addParameter(ci.getFullClassName()).addParameter(field.getName()));
            }
            aoi = objectInfo.getAttributeValueFromId(attributeId);
            if (aoi == null || aoi.isNull()) continue;
            if (aoi.isNative()) {
                value = this.internalBuildOneInstance((NativeObjectInfo)aoi, field.getType());
            } else if (aoi.isNonNativeObject()) {
                if (aoi.isDeletedObject()) {
                    if (OdbConfiguration.displayWarnings()) {
                        IError warning = NeoDatisError.ATTRIBUTE_REFERENCES_A_DELETED_OBJECT.addParameter(className).addParameter(objectInfo.getOid()).addParameter(field.getName());
                        DLogger.info(warning.toString());
                    }
                    value = null;
                } else {
                    value = this.internalBuildOneInstance((NonNativeObjectInfo)aoi);
                }
            }
            if (value == null) continue;
            try {
                field.set(o, value);
                continue;
            }
            catch (Exception e) {
                throw new ODBRuntimeException(NeoDatisError.INSTANCE_BUILDER_WRONG_OBJECT_CONTAINER_TYPE.addParameter(objectInfo.getClassInfo().getFullClassName()).addParameter(value.getClass().getName()).addParameter(field.getType().getName()), (Throwable)e);
            }
        }
        if (o != null && !o.getClass().getName().equals(objectInfo.getClassInfo().getFullClassName())) {
            new ODBRuntimeException(NeoDatisError.INSTANCE_BUILDER_WRONG_OBJECT_TYPE.addParameter(objectInfo.getClassInfo().getFullClassName()).addParameter(o.getClass().getName()));
        }
        cache.addObject(objectInfo.getOid(), o, objectInfo.getHeader());
        if (this.triggerManager != null) {
            this.triggerManager.manageSelectTriggerAfter(objectInfo.getClassInfo().getFullClassName(), objectInfo, objectInfo.getOid());
        }
        if (OdbConfiguration.reconnectObjectsToSession()) {
            ICrossSessionCache crossSessionCache = CacheFactory.getCrossSessionCache(this.engine.getBaseIdentification().getIdentification());
            crossSessionCache.addObject(o, objectInfo.getOid());
        }
        return o;
    }

    protected Object internalBuildOneInstance(NativeObjectInfo objectInfo, Class fieldType) {
        if (objectInfo.isNull()) {
            return null;
        }
        if (objectInfo.isAtomicNativeObject()) {
            return objectInfo.getObject();
        }
        if (objectInfo.isCollectionObject()) {
            Object value = this.internalBuildCollectionInstance((CollectionObjectInfo)objectInfo);
            if (fieldType == null) {
                fieldType = objectInfo.getObject().getClass();
            }
            return value;
        }
        if (objectInfo.isArrayObject()) {
            return this.internalBuildArrayInstance((ArrayObjectInfo)objectInfo);
        }
        if (objectInfo.isMapObject()) {
            return this.internalBuildMapInstance((MapObjectInfo)objectInfo);
        }
        if (objectInfo.isEnumObject()) {
            EnumNativeObjectInfo enoi = (EnumNativeObjectInfo)objectInfo;
            return this.internalBuildEnumInstance((EnumNativeObjectInfo)objectInfo);
        }
        throw new ODBRuntimeException(NeoDatisError.INSTANCE_BUILDER_NATIVE_TYPE.addParameter(ODBType.getNameFromId(objectInfo.getOdbTypeId())));
    }

    protected Object internalBuildOneInstance(AtomicNativeObjectInfo objectInfo) {
        int odbTypeId = objectInfo.getOdbTypeId();
        Long l = null;
        switch (odbTypeId) {
            case 0: {
                return null;
            }
            case 210: {
                return objectInfo.getObject();
            }
            case 170: 
            case 171: 
            case 172: {
                return objectInfo.getObject();
            }
            case 60: 
            case 120: {
                if (objectInfo.getObject().getClass() == Long.class) {
                    return objectInfo.getObject();
                }
                return new Long(objectInfo.getObject().toString());
            }
            case 50: 
            case 110: {
                if (objectInfo.getObject().getClass() == Integer.class) {
                    return objectInfo.getObject();
                }
                return new Integer(objectInfo.getObject().toString());
            }
            case 10: 
            case 160: {
                if (objectInfo.getObject().getClass() == Boolean.class) {
                    return objectInfo.getObject();
                }
                return new Boolean(objectInfo.getObject().toString());
            }
            case 20: 
            case 90: {
                if (objectInfo.getObject().getClass() == Byte.class) {
                    return objectInfo.getObject();
                }
                return new Byte(objectInfo.getObject().toString());
            }
            case 40: 
            case 100: {
                if (objectInfo.getObject().getClass() == Short.class) {
                    return objectInfo.getObject();
                }
                return new Short(objectInfo.getObject().toString());
            }
            case 70: 
            case 130: {
                if (objectInfo.getObject().getClass() == Float.class) {
                    return objectInfo.getObject();
                }
                return new Float(objectInfo.getObject().toString());
            }
            case 80: 
            case 140: {
                if (objectInfo.getObject().getClass() == Double.class) {
                    return objectInfo.getObject();
                }
                return new Double(objectInfo.getObject().toString());
            }
            case 200: {
                return new BigDecimal(objectInfo.getObject().toString());
            }
            case 190: {
                return new BigInteger(objectInfo.getObject().toString());
            }
            case 30: 
            case 150: {
                if (objectInfo.getObject().getClass() == Character.class) {
                    return objectInfo.getObject();
                }
                return new Character(objectInfo.getObject().toString().charAt(0));
            }
            case 181: {
                if (objectInfo.getObject().getClass() == Long.class) {
                    l = (Long)objectInfo.getObject();
                } else {
                    OID oid = (OID)objectInfo.getObject();
                    l = new Long(oid.getObjectId());
                }
                return OIDFactory.buildObjectOID(l);
            }
            case 182: {
                l = objectInfo.getObject().getClass() == Long.class ? (Long)objectInfo.getObject() : new Long(objectInfo.getObject().toString());
                return OIDFactory.buildClassOID(l);
            }
        }
        throw new ODBRuntimeException(NeoDatisError.INSTANCE_BUILDER_NATIVE_TYPE_IN_COLLECTION_NOT_SUPPORTED.addParameter(ODBType.getNameFromId(odbTypeId)));
    }

    @Override
    public String getSessionId() {
        return this.engine.getSession(true).getId();
    }

    @Override
    public boolean isLocal() {
        return this.engine.isLocal();
    }
}

