/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.gui.xml;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.neodatis.odb.ODB;
import org.neodatis.odb.ODBFactory;
import org.neodatis.odb.gui.LoggerPanel;
import org.neodatis.odb.gui.Messages;
import org.neodatis.odb.gui.component.GUITool;
import org.neodatis.odb.xml.XMLExporter;
import org.neodatis.tool.ILogger;
import org.neodatis.tool.wrappers.OdbString;
import org.neodatis.tool.wrappers.OdbTime;

public class XmlExportPanel
extends JPanel
implements ActionListener,
Runnable {
    private JButton btExport;
    private JButton btCancel;
    private JTextField tfXmlFile;
    private JButton btBrowseXml;
    private JTextField tfOdbFile;
    private JButton btBrowseOdb;
    private JTextField tfUser;
    private JTextField tfPassword;
    private LoggerPanel loggerPanel;
    private ILogger logger;

    public XmlExportPanel(ILogger logger) {
        this.logger = logger;
        this.init();
    }

    private void init() {
        JLabel label1 = new JLabel(Messages.getString("Xml File name to export to"));
        JLabel label2 = new JLabel(Messages.getString("ODB file to export from"));
        this.tfXmlFile = new JTextField(20);
        this.tfOdbFile = new JTextField(20);
        this.btBrowseXml = new JButton(Messages.getString("..."));
        this.btBrowseOdb = new JButton(Messages.getString("..."));
        this.btExport = new JButton(Messages.getString("Export File"));
        this.btCancel = new JButton(Messages.getString("Cancel"));
        this.btBrowseOdb.setActionCommand("browse-odb");
        this.btBrowseXml.setActionCommand("browse-xml");
        this.btExport.setActionCommand("export");
        this.btCancel.setActionCommand("cancel");
        this.loggerPanel = new LoggerPanel();
        this.btBrowseOdb.addActionListener(this);
        this.btBrowseXml.addActionListener(this);
        this.btExport.addActionListener(this);
        this.btCancel.addActionListener(this);
        JPanel left = new JPanel(new GridLayout(3, 1, 2, 2));
        JPanel center = new JPanel(new GridLayout(3, 1, 2, 2));
        left.add(label1);
        JPanel panel1 = new JPanel();
        panel1.add(this.tfXmlFile);
        panel1.add(this.btBrowseXml);
        left.add(label2);
        left.add(new JLabel());
        JPanel panel2 = new JPanel();
        panel2.add(this.tfOdbFile);
        panel2.add(this.btBrowseOdb);
        JPanel panel3 = new JPanel();
        JLabel lbUser = new JLabel("User");
        JLabel lbPassword = new JLabel("Password");
        this.tfUser = new JTextField(5);
        this.tfPassword = new JPasswordField(5);
        panel3.add(lbUser);
        panel3.add(this.tfUser);
        panel3.add(lbPassword);
        panel3.add(this.tfPassword);
        center.add(panel1);
        center.add(panel2);
        center.add(panel3);
        JPanel wpanel = new JPanel(new BorderLayout(2, 2));
        wpanel.add((Component)left, "West");
        wpanel.add((Component)center, "Center");
        wpanel.add((Component)new JScrollPane(this.loggerPanel), "South");
        wpanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel bpanel = new JPanel();
        bpanel.add(this.btCancel);
        bpanel.add(this.btExport);
        this.setLayout(new BorderLayout(4, 4));
        this.add((Component)wpanel, "Center");
        this.add((Component)bpanel, "South");
        this.add((Component)GUITool.buildHeaderPanel("XML Export Wizard"), "North");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if ("browse-xml".equals(action)) {
            this.browse("xml");
        }
        if ("browse-odb".equals(action)) {
            this.browse("odb");
        }
        if ("cancel".equals(action)) {
            this.cancel();
        }
        if ("export".equals(action)) {
            try {
                Thread t = new Thread(this);
                t.start();
            }
            catch (Exception e1) {
                this.logger.error("Error while export to XML : ", e1);
            }
        }
    }

    private void exportToXml() throws Exception {
        boolean ok = false;
        File xmlFile = new File(this.tfXmlFile.getText());
        File odbFile = new File(this.tfOdbFile.getText());
        if (!odbFile.exists()) {
            JOptionPane.showMessageDialog(this, Messages.getString("The database file " + odbFile.getPath() + " does not exist!"));
            return;
        }
        long start = OdbTime.getCurrentTimeInMs();
        this.setCursor(Cursor.getPredefinedCursor(3));
        String user = this.tfUser.getText();
        String password = this.tfPassword.getText();
        if (user.length() == 0 && password.length() == 0) {
            user = null;
            password = null;
        }
        ODB odb = ODBFactory.open(odbFile.getPath(), user, password);
        XMLExporter exporter = new XMLExporter(odb);
        exporter.setExternalLogger(this.loggerPanel);
        try {
            exporter.export(xmlFile.getParent(), xmlFile.getName());
            ok = true;
        }
        catch (Throwable e) {
            this.logger.error(OdbString.exceptionToString(e, true));
        }
        odb.close();
        this.disableFields();
        this.setCursor(Cursor.getPredefinedCursor(0));
        long end = OdbTime.getCurrentTimeInMs();
        if (ok) {
            this.loggerPanel.info("export successfull (" + (end - start) + "ms)");
        } else {
            this.loggerPanel.info("Error while exporting (" + (end - start) + "ms)");
        }
    }

    private void cancel() {
        this.disableFields();
    }

    private void disableFields() {
        this.tfOdbFile.setEnabled(false);
        this.tfXmlFile.setEnabled(false);
        this.btExport.setEnabled(false);
        this.btCancel.setEnabled(false);
        this.btBrowseOdb.setEnabled(false);
        this.btBrowseXml.setEnabled(false);
    }

    private void browse(String type) {
        JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));
        String title = null;
        title = type.equals("xml") ? Messages.getString("Choose the name of the xml file to export to") : Messages.getString("Choose the name of the ODB file to export from");
        fc.setDialogTitle(title);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            if (type.equals("xml")) {
                this.tfXmlFile.setText(fc.getSelectedFile().getPath());
            } else {
                this.tfOdbFile.setText(fc.getSelectedFile().getPath());
            }
        }
    }

    @Override
    public void run() {
        try {
            this.exportToXml();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e);
            this.loggerPanel.error(e);
        }
    }
}

