/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.gui.objectbrowser.flat;

import java.util.Collection;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ArrayObjectInfo;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.gui.ObjectInfoUtil;

public class FlatQueryTableModel
extends DefaultTableModel {
    private List attributeList;
    private List valueList;

    public FlatQueryTableModel(IStorageEngine engine, String fullClassName, Collection objectInfoValues) {
        this.init(engine, fullClassName, objectInfoValues);
    }

    private void init(IStorageEngine engine, String fullClassName, Collection objectInfoValues) {
        this.attributeList = ObjectInfoUtil.buildAttributeNameList(engine.getSession(true).getMetaModel().getClassInfo(fullClassName, true));
        this.valueList = ObjectInfoUtil.buildValueList(engine.getSession(true).getMetaModel().getClassInfo(fullClassName, true), objectInfoValues);
    }

    @Override
    public String getColumnName(int column) {
        String name = this.attributeList.get(column).toString();
        if (name.length() > 20) {
            int index = name.lastIndexOf(".");
            name = "... " + name.substring(index + 1);
        }
        return name;
    }

    @Override
    public int getColumnCount() {
        if (this.attributeList == null) {
            return 0;
        }
        return this.attributeList.size();
    }

    @Override
    public int getRowCount() {
        if (this.valueList == null) {
            return 0;
        }
        return this.valueList.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        List l = (List)this.valueList.get(row);
        if (column >= l.size()) {
            return "?";
        }
        Object o = l.get(column);
        if (o instanceof String) {
            return o;
        }
        AbstractObjectInfo aoi = (AbstractObjectInfo)o;
        if (aoi.isArrayObject()) {
            return this.arrayRepresentation((ArrayObjectInfo)aoi);
        }
        return o;
    }

    private Object arrayRepresentation(ArrayObjectInfo aoi) {
        StringBuffer buffer = new StringBuffer();
        AbstractObjectInfo element = null;
        for (int i = 0; i < aoi.getArrayLength(); ++i) {
            if (i != 0) {
                buffer.append(",");
            }
            buffer.append(i).append("=");
            element = (AbstractObjectInfo)aoi.getArray()[i];
            if (element.isNull()) {
                buffer.append("null");
                continue;
            }
            buffer.append(element);
        }
        return buffer.toString();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        super.setValueAt(aValue, row, column);
    }

    public List getAttributeList() {
        return this.attributeList;
    }

    public List getValueList() {
        return this.valueList;
    }
}

