/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.query.execution;

import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.Objects;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.query.IQuery;
import org.neodatis.odb.core.query.execution.EmptyExecutionPlan;
import org.neodatis.odb.core.query.execution.IMatchingObjectAction;
import org.neodatis.odb.core.query.execution.IMultiClassQueryExecutor;
import org.neodatis.odb.core.query.execution.IQueryExecutor;
import org.neodatis.tool.wrappers.list.IOdbList;

public class MultiClassGenericQueryExecutor
implements IQueryExecutor {
    private static final String LOG_ID = "MultiClassGenericQueryExecutor";
    private IMultiClassQueryExecutor executor;

    public MultiClassGenericQueryExecutor(IMultiClassQueryExecutor executor) {
        this.executor = executor;
        this.executor.setExecuteStartAndEndOfQueryAction(false);
    }

    @Override
    public <T> Objects<T> execute(boolean inMemory, int startIndex, int endIndex, boolean returnObjects, IMatchingObjectAction queryResultAction) {
        if (this.executor.getStorageEngine().isClosed()) {
            throw new ODBRuntimeException(NeoDatisError.ODB_IS_CLOSED.addParameter(this.executor.getStorageEngine().getBaseIdentification().getIdentification()));
        }
        if (this.executor.getStorageEngine().getSession(true).isRollbacked()) {
            throw new ODBRuntimeException(NeoDatisError.ODB_HAS_BEEN_ROLLBACKED);
        }
        String fullClassName = this.executor.getFullClassName(this.executor.getQuery());
        queryResultAction.start();
        IOdbList<ClassInfo> allClassInfos = this.executor.getStorageEngine().getSession(true).getMetaModel().getPersistentSubclassesOf(fullClassName);
        int nbClasses = allClassInfos.size();
        ClassInfo ci = null;
        for (int i = 0; i < nbClasses; ++i) {
            ci = allClassInfos.get(i);
            this.executor.setClassInfo(ci);
            this.executor.execute(inMemory, startIndex, endIndex, returnObjects, queryResultAction);
        }
        if (nbClasses == 0) {
            this.executor.getQuery().setExecutionPlan(new EmptyExecutionPlan());
        }
        queryResultAction.end();
        return queryResultAction.getObjects();
    }

    public boolean executeStartAndEndOfQueryAction() {
        return false;
    }

    @Override
    public String getFullClassName(IQuery query) {
        return this.executor.getFullClassName(this.executor.getQuery());
    }
}

