/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.query;

import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.OrderByConstants;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.query.IQuery;
import org.neodatis.odb.core.query.execution.IQueryExecutionPlan;
import org.neodatis.tool.wrappers.OdbString;

public abstract class AbstractQuery
implements IQuery {
    protected String[] orderByFields;
    protected OrderByConstants orderByType = OrderByConstants.ORDER_BY_NONE;
    protected transient IStorageEngine storageEngine;
    protected IQueryExecutionPlan executionPlan;
    protected boolean polymorphic = false;
    private boolean optimizeObjectComparison = true;
    protected OID oidOfObjectToQuery;

    @Override
    public IQuery orderByDesc(String fields) {
        this.orderByType = OrderByConstants.ORDER_BY_DESC;
        this.orderByFields = OdbString.split(fields, ",");
        return this;
    }

    @Override
    public IQuery orderByAsc(String fields) {
        this.orderByType = OrderByConstants.ORDER_BY_ASC;
        this.orderByFields = OdbString.split(fields, ",");
        return this;
    }

    @Override
    public String[] getOrderByFieldNames() {
        return this.orderByFields;
    }

    public void setOrderByFields(String[] orderByFields) {
        this.orderByFields = orderByFields;
    }

    @Override
    public OrderByConstants getOrderByType() {
        return this.orderByType;
    }

    public void setOrderByType(OrderByConstants orderByType) {
        this.orderByType = orderByType;
    }

    @Override
    public boolean hasOrderBy() {
        return !this.orderByType.isOrderByNone();
    }

    @Override
    public IStorageEngine getStorageEngine() {
        return this.storageEngine;
    }

    @Override
    public void setStorageEngine(IStorageEngine storageEngine) {
        this.storageEngine = storageEngine;
    }

    @Override
    public IQueryExecutionPlan getExecutionPlan() {
        if (this.executionPlan == null) {
            throw new ODBRuntimeException(NeoDatisError.EXECUTION_PLAN_IS_NULL_QUERY_HAS_NOT_BEEN_EXECUTED);
        }
        return this.executionPlan;
    }

    @Override
    public void setExecutionPlan(IQueryExecutionPlan plan) {
        this.executionPlan = plan;
    }

    @Override
    public boolean isPolymorphic() {
        return this.polymorphic;
    }

    @Override
    public IQuery setPolymorphic(boolean yes) {
        this.polymorphic = yes;
        return this;
    }

    @Override
    public OID getOidOfObjectToQuery() {
        return this.oidOfObjectToQuery;
    }

    public void setOidOfObjectToQuery(OID oidOfObjectToQuery) {
        this.oidOfObjectToQuery = oidOfObjectToQuery;
    }

    @Override
    public boolean isForSingleOid() {
        return this.oidOfObjectToQuery != null;
    }

    @Override
    public boolean optimizeObjectComparison() {
        return this.optimizeObjectComparison;
    }

    @Override
    public IQuery setOptimizeObjectComparison(boolean yesNo) {
        this.optimizeObjectComparison = yesNo;
        return this;
    }
}

