/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.oid;

import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.impl.core.oid.ExternalClassOID;
import org.neodatis.odb.impl.core.oid.ExternalObjectOID;
import org.neodatis.odb.impl.core.oid.OdbClassOID;
import org.neodatis.odb.impl.core.oid.OdbObjectOID;
import org.neodatis.tool.wrappers.OdbString;

public class OIDFactory {
    public static OID buildObjectOID(long oid) {
        return OdbConfiguration.getCoreProvider().getObjectOID(oid, 0L);
    }

    public static OID buildClassOID(long oid) {
        return OdbConfiguration.getCoreProvider().getClassOID(oid);
    }

    public static OID oidFromString(String oidString) {
        String[] tokens = OdbString.split(oidString, ":");
        if (tokens[0].equals("object-oid")) {
            return OdbObjectOID.oidFromString(oidString);
        }
        if (tokens[0].equals("class-oid")) {
            return OdbClassOID.oidFromString(oidString);
        }
        if (tokens[0].equals("ext-object-oid")) {
            return ExternalObjectOID.oidFromString(oidString);
        }
        if (tokens[0].equals("ext-class-oid")) {
            return ExternalClassOID.oidFromString(oidString);
        }
        throw new ODBRuntimeException(NeoDatisError.INVALID_OID_REPRESENTATION.addParameter(oidString));
    }
}

