/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer2.meta;

import java.util.Map;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.NativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeDeletedObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeNullObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.layers.layer2.meta.ObjectInfoHeader;
import org.neodatis.odb.core.layers.layer2.meta.ObjectReference;
import org.neodatis.odb.impl.core.layers.layer3.engine.StorageEngineConstant;
import org.neodatis.tool.wrappers.OdbClassUtil;
import org.neodatis.tool.wrappers.OdbString;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.list.OdbArrayList;

public class NonNativeObjectInfo
extends AbstractObjectInfo {
    protected transient Object object;
    private ClassInfo classInfo;
    private ObjectInfoHeader objectHeader;
    private AbstractObjectInfo[] attributeValues;
    private IOdbList<NonNativeObjectInfo> allNonNativeObjects;
    private int maxNbattributes;

    public NonNativeObjectInfo() {
        super(null);
    }

    public NonNativeObjectInfo(ObjectInfoHeader oip, ClassInfo classInfo) {
        super(null);
        this.classInfo = classInfo;
        this.objectHeader = oip;
        if (classInfo != null) {
            this.maxNbattributes = classInfo.getMaxAttributeId();
            this.attributeValues = new AbstractObjectInfo[this.maxNbattributes];
        }
        this.allNonNativeObjects = null;
    }

    public NonNativeObjectInfo(ClassInfo classInfo) {
        super(null);
        this.classInfo = classInfo;
        this.objectHeader = new ObjectInfoHeader(-1L, null, null, classInfo != null ? classInfo.getId() : null, null, null);
        if (classInfo != null) {
            this.maxNbattributes = classInfo.getMaxAttributeId();
            this.attributeValues = new AbstractObjectInfo[this.maxNbattributes];
        }
        this.allNonNativeObjects = null;
    }

    public NonNativeObjectInfo(Object object, ClassInfo info, AbstractObjectInfo[] values, long[] attributesIdentification, int[] attributeIds) {
        super(ODBType.getFromName(info.getFullClassName()));
        this.object = object;
        this.classInfo = info;
        this.attributeValues = values;
        this.maxNbattributes = this.classInfo.getMaxAttributeId();
        if (this.attributeValues == null) {
            this.attributeValues = new AbstractObjectInfo[this.maxNbattributes];
        }
        this.objectHeader = new ObjectInfoHeader(-1L, null, null, this.classInfo != null ? this.classInfo.getId() : null, attributesIdentification, attributeIds);
        this.allNonNativeObjects = new OdbArrayList<NonNativeObjectInfo>();
    }

    public ObjectInfoHeader getHeader() {
        return this.objectHeader;
    }

    public AbstractObjectInfo getAttributeValueFromId(int attributeId) {
        return this.attributeValues[attributeId - 1];
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    public void setClassInfo(ClassInfo classInfo) {
        if (classInfo != null) {
            this.classInfo = classInfo;
            this.objectHeader.setClassInfoId(classInfo.getId());
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.classInfo.getFullClassName()).append("(").append(this.getOid()).append(")=");
        if (this.attributeValues == null) {
            buffer.append("null attribute values");
            return buffer.toString();
        }
        for (int i = 0; i < this.attributeValues.length; ++i) {
            if (i != 0) {
                buffer.append(",");
            }
            String attributeName = this.classInfo != null ? this.classInfo.getAttributeInfo(i).getName() : "?";
            buffer.append(attributeName).append("=");
            AbstractObjectInfo object = this.attributeValues[i];
            if (object == null) {
                buffer.append(" null java object - should not happen , ");
                continue;
            }
            ODBType type = ODBType.getFromClass(this.attributeValues[i].getClass());
            if (object instanceof NonNativeNullObjectInfo) {
                buffer.append("null");
                continue;
            }
            if (object instanceof NonNativeDeletedObjectInfo) {
                buffer.append("deleted object");
                continue;
            }
            if (object instanceof NativeObjectInfo) {
                NativeObjectInfo noi = (NativeObjectInfo)object;
                buffer.append(noi.toString());
                continue;
            }
            if (object instanceof ObjectReference) {
                buffer.append(object.toString());
                continue;
            }
            if (object instanceof NonNativeObjectInfo) {
                NonNativeObjectInfo nnoi = (NonNativeObjectInfo)object;
                buffer.append("@").append(nnoi.getClassInfo().getFullClassName()).append("(id=").append(nnoi.getOid()).append(")");
                continue;
            }
            buffer.append("@").append(OdbClassUtil.getClassName(type.getName()));
        }
        return buffer.toString();
    }

    public OID getNextObjectOID() {
        return this.objectHeader.getNextObjectOID();
    }

    public void setNextObjectOID(OID nextObjectOID) {
        this.objectHeader.setNextObjectOID(nextObjectOID);
    }

    public OID getPreviousObjectOID() {
        return this.objectHeader.getPreviousObjectOID();
    }

    public void setPreviousInstanceOID(OID previousObjectOID) {
        this.objectHeader.setPreviousObjectOID(previousObjectOID);
    }

    @Override
    public long getPosition() {
        return this.objectHeader.getPosition();
    }

    @Override
    public void setPosition(long position) {
        this.objectHeader.setPosition(position);
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    public Object getValueOf(String attributeName) {
        boolean isRelation;
        int attributeId = -1;
        boolean bl = isRelation = attributeName.indexOf(".") != -1;
        if (!isRelation) {
            attributeId = this.getClassInfo().getAttributeId(attributeName);
            return this.getAttributeValueFromId(attributeId).getObject();
        }
        int firstDotIndex = attributeName.indexOf(".");
        String firstAttributeName = OdbString.substring(attributeName, 0, firstDotIndex);
        attributeId = this.getClassInfo().getAttributeId(firstAttributeName);
        AbstractObjectInfo object = this.attributeValues[attributeId];
        if (object instanceof NonNativeObjectInfo) {
            NonNativeObjectInfo nnoi = (NonNativeObjectInfo)object;
            return nnoi.getValueOf(OdbString.substring(attributeName, firstDotIndex + 1, attributeName.length()));
        }
        throw new ODBRuntimeException(NeoDatisError.CLASS_INFO_DO_NOT_HAVE_THE_ATTRIBUTE.addParameter(this.getClassInfo().getFullClassName()).addParameter(attributeName));
    }

    public AbstractObjectInfo getMetaValueOf(String attributeName) {
        boolean isRelation;
        int attributeId = -1;
        boolean bl = isRelation = attributeName.indexOf(".") != -1;
        if (!isRelation) {
            attributeId = this.getClassInfo().getAttributeId(attributeName);
            return this.getAttributeValueFromId(attributeId);
        }
        int firstDotIndex = attributeName.indexOf(".");
        String firstAttributeName = OdbString.substring(attributeName, 0, firstDotIndex);
        attributeId = this.getClassInfo().getAttributeId(firstAttributeName);
        AbstractObjectInfo object = this.attributeValues[attributeId];
        if (object instanceof NonNativeObjectInfo) {
            NonNativeObjectInfo nnoi = (NonNativeObjectInfo)object;
            return nnoi.getMetaValueOf(OdbString.substring(attributeName, firstDotIndex + 1, attributeName.length()));
        }
        throw new ODBRuntimeException(NeoDatisError.CLASS_INFO_DO_NOT_HAVE_THE_ATTRIBUTE.addParameter(this.getClassInfo().getFullClassName()).addParameter(attributeName));
    }

    public void setValueOf(String attributeName, AbstractObjectInfo aoi) {
        boolean isRelation;
        int attributeId = -1;
        boolean bl = isRelation = attributeName.indexOf(".") != -1;
        if (!isRelation) {
            attributeId = this.getClassInfo().getAttributeId(attributeName);
            this.setAttributeValue(attributeId, aoi);
            return;
        }
        int firstDotIndex = attributeName.indexOf(".");
        String firstAttributeName = OdbString.substring(attributeName, 0, firstDotIndex);
        attributeId = this.getClassInfo().getAttributeId(firstAttributeName);
        AbstractObjectInfo object = this.attributeValues[attributeId];
        if (object instanceof NonNativeObjectInfo) {
            NonNativeObjectInfo nnoi = (NonNativeObjectInfo)object;
            nnoi.setValueOf(OdbString.substring(attributeName, firstDotIndex + 1, attributeName.length()), aoi);
        }
        throw new ODBRuntimeException(NeoDatisError.CLASS_INFO_DO_NOT_HAVE_THE_ATTRIBUTE.addParameter(this.getClassInfo().getFullClassName()).addParameter(attributeName));
    }

    public OID getOid() {
        if (this.getHeader() == null) {
            throw new ODBRuntimeException(NeoDatisError.UNEXPECTED_SITUATION.addParameter("Null Object Info Header"));
        }
        return this.getHeader().getOid();
    }

    public void setOid(OID oid) {
        if (this.getHeader() != null) {
            this.getHeader().setOid(oid);
        }
    }

    @Override
    public boolean isNonNativeObject() {
        return true;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    public void clear() {
        this.attributeValues = null;
    }

    @Override
    public AbstractObjectInfo createCopy(Map<OID, AbstractObjectInfo> cache, boolean onlyData) {
        NonNativeObjectInfo nnoi = (NonNativeObjectInfo)cache.get(this.objectHeader.getOid());
        if (nnoi != null) {
            return nnoi;
        }
        if (onlyData) {
            ObjectInfoHeader oih = new ObjectInfoHeader();
            nnoi = new NonNativeObjectInfo(this.object, this.classInfo, null, oih.getAttributesIdentification(), oih.getAttributeIds());
        } else {
            nnoi = new NonNativeObjectInfo(this.object, this.classInfo, null, this.objectHeader.getAttributesIdentification(), this.objectHeader.getAttributeIds());
            nnoi.getHeader().setOid(this.getHeader().getOid());
        }
        AbstractObjectInfo[] newAttributeValues = new AbstractObjectInfo[this.attributeValues.length];
        for (int i = 0; i < this.attributeValues.length; ++i) {
            newAttributeValues[i] = this.attributeValues[i].createCopy(cache, onlyData);
        }
        nnoi.attributeValues = newAttributeValues;
        cache.put(this.objectHeader.getOid(), nnoi);
        return nnoi;
    }

    public void setAttributeValue(int attributeId, AbstractObjectInfo aoi) {
        this.attributeValues[attributeId - 1] = aoi;
    }

    public AbstractObjectInfo[] getAttributeValues() {
        return this.attributeValues;
    }

    public int getMaxNbattributes() {
        return this.maxNbattributes;
    }

    public int getAttributeId(AbstractObjectInfo aoi) {
        for (int i = 0; i < this.attributeValues.length; ++i) {
            if (aoi != this.attributeValues[i]) continue;
            return i + 1;
        }
        return -1;
    }

    public long getAttributeDefinitionPosition(int attributeId) {
        long offset = StorageEngineConstant.OBJECT_OFFSET_NB_ATTRIBUTES;
        long delta = ODBType.INTEGER.getSize() + (attributeId - 1) * (ODBType.INTEGER.getSize() + ODBType.LONG.getSize()) + ODBType.INTEGER.getSize();
        return this.getPosition() + offset + delta;
    }

    @Override
    public void setObject(Object object) {
        this.object = object;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.objectHeader == null) {
            return -1;
        }
        return this.objectHeader.hashCode();
    }

    public void setHeader(ObjectInfoHeader header) {
        this.objectHeader = header;
    }
}

