/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.map;

import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import org.tmatesoft.sqljet.core.internal.map.SqlJetMapIndexCursor;
import org.tmatesoft.sqljet.core.map.ISqlJetMapIndex;
import org.tmatesoft.sqljet.core.map.ISqlJetMapIndexCursor;
import org.tmatesoft.sqljet.core.map.ISqlJetMapTransaction;
import org.tmatesoft.sqljet.core.map.SqlJetMapDb;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;
import org.tmatesoft.sqljet.core.table.engine.ISqlJetEngineSynchronized;
import org.tmatesoft.sqljet.core.table.engine.SqlJetEngine;

public class SqlJetMapIndex
implements ISqlJetMapIndex {
    private final SqlJetMapDb mapDb;
    private final ISqlJetBtree btree;
    private ISqlJetIndexDef indexDef;
    private boolean writable;

    public SqlJetMapIndex(SqlJetMapDb mapDb, ISqlJetBtree btree, ISqlJetIndexDef indexDef, boolean writable) {
        this.mapDb = mapDb;
        this.btree = btree;
        this.indexDef = indexDef;
        this.writable = writable;
    }

    @Override
    public ISqlJetMapIndexCursor getCursor() throws SqlJetException {
        return (ISqlJetMapIndexCursor)this.mapDb.runSynchronized(new ISqlJetEngineSynchronized(){

            @Override
            public Object runSynchronized(SqlJetEngine engine) throws SqlJetException {
                return new SqlJetMapIndexCursor(SqlJetMapIndex.this.mapDb, SqlJetMapIndex.this.btree, SqlJetMapIndex.this.indexDef, SqlJetMapIndex.this.writable);
            }
        });
    }

    @Override
    public void put(final Object[] key, final Long value) throws SqlJetException {
        if (!this.writable) {
            throw new SqlJetException("Read-only");
        }
        this.mapDb.runWriteTransaction(new ISqlJetMapTransaction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run(SqlJetMapDb mapDb) throws SqlJetException {
                try (ISqlJetMapIndexCursor cursor = SqlJetMapIndex.this.getCursor();){
                    cursor.put(key, value);
                    Object var3_3 = null;
                    return var3_3;
                }
            }
        });
    }

    @Override
    public Long get(final Object[] key) throws SqlJetException {
        return (Long)this.mapDb.runReadTransaction(new ISqlJetMapTransaction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run(SqlJetMapDb mapDb) throws SqlJetException {
                try (ISqlJetMapIndexCursor cursor = SqlJetMapIndex.this.getCursor();){
                    if (cursor.goToKey(key)) {
                        Long l = cursor.getValue();
                        return l;
                    }
                    Object var3_4 = null;
                    return var3_4;
                }
            }
        });
    }
}

