/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Map;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.ParentMap;
import org.jgraph.plaf.basic.BasicGraphTransferable;

public class GraphTransferable
extends BasicGraphTransferable
implements Serializable,
ClipboardOwner {
    public static DataFlavor dataFlavor;
    protected Object[] cells;
    protected ConnectionSet cs;
    protected ParentMap pm;
    protected Map attributeMap;
    protected Rectangle2D bounds;

    public GraphTransferable(Object[] cells, Map attrMap, Rectangle2D bounds, ConnectionSet cs, ParentMap pm) {
        this.attributeMap = attrMap;
        this.bounds = bounds;
        this.cells = cells;
        this.cs = cs;
        this.pm = pm;
    }

    public Object[] getCells() {
        return this.cells;
    }

    public ConnectionSet getConnectionSet() {
        return this.cs;
    }

    public ParentMap getParentMap() {
        return this.pm;
    }

    public Map getAttributeMap() {
        return this.attributeMap;
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    @Override
    public void lostOwnership(Clipboard clip, Transferable contents) {
    }

    @Override
    public DataFlavor[] getRicherFlavors() {
        return new DataFlavor[]{dataFlavor};
    }

    @Override
    public Object getRicherData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor.equals(dataFlavor)) {
            return this;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public boolean isPlainSupported() {
        return this.cells != null && this.cells.length == 1;
    }

    @Override
    public String getPlainData() {
        Object obj;
        if (this.cells[0] instanceof DefaultGraphCell && (obj = ((DefaultGraphCell)this.cells[0]).getUserObject()) != null) {
            return obj.toString();
        }
        return this.cells[0].toString();
    }

    @Override
    public boolean isHTMLSupported() {
        return this.isPlainSupported();
    }

    @Override
    public String getHTMLData() {
        StringBuffer buf = new StringBuffer();
        buf.append("<html><body><p>");
        buf.append(this.getPlainData());
        buf.append("</p></body></html>");
        return buf.toString();
    }

    static {
        DataFlavor localDataFlavor;
        try {
            localDataFlavor = new DataFlavor("application/x-java-jvm-local-objectref; class=org.jgraph.graph.GraphTransferable");
        }
        catch (ClassNotFoundException cnfe) {
            localDataFlavor = null;
        }
        dataFlavor = localDataFlavor;
    }
}

