/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphModel;

public class GraphConstants {
    public static Font DEFAULTFONT = null;
    public static int DEFAULTDECORATIONSIZE;
    public static int DEFAULTINSET;
    public static final int PERMILLE = 1000;
    protected static float[] dash;
    public static Stroke SELECTION_STROKE;
    public static final int ARROW_NONE = 0;
    public static final int ARROW_CLASSIC = 1;
    public static final int ARROW_TECHNICAL = 2;
    public static final int ARROW_SIMPLE = 4;
    public static final int ARROW_CIRCLE = 5;
    public static final int ARROW_LINE = 7;
    public static final int ARROW_DOUBLELINE = 8;
    public static final int ARROW_DIAMOND = 9;
    public static final int STYLE_ORTHOGONAL = 11;
    public static final int STYLE_BEZIER = 12;
    public static final int STYLE_SPLINE = 13;
    public static final int X_AXIS = 1;
    public static final int Y_AXIS = 2;
    public static Edge.Routing ROUTING_DEFAULT;
    public static final Edge.Routing ROUTING_SIMPLE;
    public static final String SIZEABLEAXIS = "sizeableAxis";
    public static final String MOVEABLEAXIS = "moveableAxis";
    public static final String REPLACEATTRIBUTES = "replaceAttributes";
    public static final String REMOVEATTRIBUTES = "removeAttributes";
    public static final String REMOVEALL = "removeAll";
    public static final String ICON = "icon";
    public static final String FONT = "font";
    public static final String OPAQUE = "opaque";
    public static final String GROUPOPAQUE = "groupOpaque";
    public static final String BORDER = "border";
    public static final String LINECOLOR = "linecolor";
    public static final String BORDERCOLOR = "bordercolor";
    public static final String LINEWIDTH = "linewidth";
    public static final String FOREGROUND = "foregroundColor";
    public static final String BACKGROUND = "backgroundColor";
    public static final String GRADIENTCOLOR = "gradientColor";
    public static final String VERTICAL_ALIGNMENT = "verticalAlignment";
    public static final String HORIZONTAL_ALIGNMENT = "horizontalAlignment";
    public static final String VERTICAL_TEXT_POSITION = "verticalTextPosition";
    public static final String HORIZONTAL_TEXT_POSITION = "horizontalTextPosition";
    public static final String DASHPATTERN = "dashPattern";
    public static final String DASHOFFSET = "dashOffset";
    public static final String LINESTYLE = "lineStyle";
    public static final String LINEBEGIN = "lineBegin";
    public static final String LINEEND = "lineEnd";
    public static final String BEGINSIZE = "beginSize";
    public static final String ENDSIZE = "endSize";
    public static final String BEGINFILL = "beginFill";
    public static final String ENDFILL = "endFill";
    public static final String VALUE = "value";
    public static final String EDITABLE = "editable";
    public static final String MOVEABLE = "moveable";
    public static final String SIZEABLE = "sizeable";
    public static final String AUTOSIZE = "autosize";
    public static final String RESIZE = "resize";
    public static final String INSET = "inset";
    public static final String CONSTRAINED = "constrained";
    public static final String SELECTABLE = "selectable";
    public static final String CHILDRENSELECTABLE = "childrenSelectable";
    public static final String MOVEHIDDENCHILDREN = "childrenSelectable";
    public static final String BENDABLE = "bendable";
    public static final String CONNECTABLE = "connectable";
    public static final String DISCONNECTABLE = "disconnectable";
    public static final String BOUNDS = "bounds";
    public static final String POINTS = "points";
    public static final String ROUTING = "routing";
    public static final String LABELPOSITION = "labelposition";
    public static final String EXTRALABELS = "extraLabels";
    public static final String EXTRALABELPOSITIONS = "extraLabelPositions";
    public static final String LABELALONGEDGE = "labelAlongEdge";
    public static final String ABSOLUTEX = "absoluteX";
    public static final String ABSOLUTEY = "absoluteY";
    public static final String OFFSET = "offset";
    public static final String SIZE = "size";
    public static final String LINK = "link";
    public static final String LABELENABLED = "labelEnabled";
    public static final String EXACTSEGMENTRELATIVE = "labelEnabled";

    public static Map createAttributes(Object cell, Object key, Object value) {
        return GraphConstants.createAttributes(new Object[]{cell}, new Object[]{key}, new Object[]{value});
    }

    public static Map createAttributes(Object[] cells, Object key, Object value) {
        return GraphConstants.createAttributes(cells, new Object[]{key}, new Object[]{value});
    }

    public static Map createAttributes(Object[] cells, Object[] keys, Object[] values) {
        if (keys != null && values != null && keys.length != values.length) {
            throw new IllegalArgumentException("Keys and values must have same length");
        }
        Hashtable nested = new Hashtable();
        for (int i = 0; i < cells.length; ++i) {
            if (cells[i] == null) continue;
            Hashtable<Object, Object> attributes = new Hashtable<Object, Object>();
            for (int j = 0; j < keys.length; ++j) {
                if (keys[j] == null || values[j] == null) continue;
                attributes.put(keys[j], values[j]);
            }
            nested.put(cells[i], attributes);
        }
        return nested;
    }

    public static Map createAttributes(Object[] elements, CellMapper cm) {
        Hashtable<Object, Object> attributes = new Hashtable<Object, Object>();
        for (int i = 0; i < elements.length; ++i) {
            CellView view = null;
            Object key = elements[i];
            if (key instanceof CellView) {
                view = (CellView)key;
                key = view.getCell();
            } else if (cm != null) {
                view = cm.getMapping(key, false);
            }
            if (view == null) continue;
            attributes.put(key, view.getAllAttributes().clone());
        }
        return attributes;
    }

    public static Map createAttributesFromModel(Object[] elements, GraphModel model) {
        Hashtable<Object, Object> attributes = new Hashtable<Object, Object>();
        for (int i = 0; i < elements.length; ++i) {
            AttributeMap attr = model.getAttributes(elements[i]);
            if (attr == null || attr.size() <= 0) continue;
            attributes.put(elements[i], attr.clone());
        }
        return attributes;
    }

    public static Map replaceKeys(Map keyMap, Map map) {
        Hashtable newMap = new Hashtable();
        for (Map.Entry entry : map.entrySet()) {
            Object newKey;
            if (!(entry.getValue() instanceof Map) || (newKey = keyMap.get(entry.getKey())) == null) continue;
            AttributeMap val = (AttributeMap)((AttributeMap)entry.getValue()).clone();
            newMap.put(newKey, val);
        }
        return newMap;
    }

    public static Map merge(Map change, Map target) {
        if (change != null && target != null) {
            change = new Hashtable(change);
            for (Map.Entry entry : target.entrySet()) {
                Map map = (Map)entry.getValue();
                Map additional = (Map)change.remove(entry.getKey());
                if (additional == null) continue;
                map.putAll(additional);
            }
            target.putAll(change);
        }
        return target;
    }

    public static void setFont(Map map, Font font) {
        map.put(FONT, font);
    }

    public static Font getFont(Map map) {
        Font font = (Font)map.get(FONT);
        if (font == null) {
            font = DEFAULTFONT;
        }
        return font;
    }

    public static final void setRemoveAttributes(Map map, Object[] value) {
        map.put(REMOVEATTRIBUTES, value);
    }

    public static final Object[] getRemoveAttributes(Map map) {
        return (Object[])map.get(REMOVEATTRIBUTES);
    }

    public static final void setMoveableAxis(Map map, int axis) {
        map.put(MOVEABLEAXIS, new Integer(axis));
    }

    public static final int getMoveableAxis(Map map) {
        Integer intObj = (Integer)map.get(MOVEABLEAXIS);
        if (intObj != null) {
            return intObj;
        }
        return 0;
    }

    public static final void setSizeableAxis(Map map, int axis) {
        map.put(SIZEABLEAXIS, new Integer(axis));
    }

    public static final int getSizeableAxis(Map map) {
        Integer intObj = (Integer)map.get(SIZEABLEAXIS);
        if (intObj != null) {
            return intObj;
        }
        return 0;
    }

    public static final void setIcon(Map map, Icon value) {
        map.put(ICON, value);
    }

    public static final Icon getIcon(Map map) {
        return (Icon)map.get(ICON);
    }

    public static final void setOpaque(Map map, boolean flag) {
        map.put(OPAQUE, new Boolean(flag));
    }

    public static final boolean isOpaque(Map map) {
        Boolean bool = (Boolean)map.get(OPAQUE);
        if (bool != null) {
            return bool;
        }
        return false;
    }

    public static final void setGroupOpaque(Map map, boolean flag) {
        map.put(GROUPOPAQUE, new Boolean(flag));
    }

    public static final boolean isGroupOpaque(Map map) {
        Boolean bool = (Boolean)map.get(GROUPOPAQUE);
        if (bool != null) {
            return bool;
        }
        return false;
    }

    public static final void setBorder(Map map, Border value) {
        map.put(BORDER, value);
    }

    public static final Border getBorder(Map map) {
        return (Border)map.get(BORDER);
    }

    public static final void setLineColor(Map map, Color value) {
        map.put(LINECOLOR, value);
    }

    public static final Color getLineColor(Map map) {
        return (Color)map.get(LINECOLOR);
    }

    public static final void setBorderColor(Map map, Color value) {
        map.put(BORDERCOLOR, value);
    }

    public static final Color getBorderColor(Map map) {
        return (Color)map.get(BORDERCOLOR);
    }

    public static final void setLineWidth(Map map, float width) {
        map.put(LINEWIDTH, new Float(width));
    }

    public static final float getLineWidth(Map map) {
        Float floatObj = (Float)map.get(LINEWIDTH);
        if (floatObj != null) {
            return floatObj.floatValue();
        }
        return 1.0f;
    }

    public static final void setForeground(Map map, Color value) {
        map.put(FOREGROUND, value);
    }

    public static final Color getForeground(Map map) {
        return (Color)map.get(FOREGROUND);
    }

    public static final void setBackground(Map map, Color value) {
        map.put(BACKGROUND, value);
    }

    public static final Color getBackground(Map map) {
        return (Color)map.get(BACKGROUND);
    }

    public static final void setGradientColor(Map map, Color value) {
        map.put(GRADIENTCOLOR, value);
    }

    public static final Color getGradientColor(Map map) {
        return (Color)map.get(GRADIENTCOLOR);
    }

    public static final void setVerticalAlignment(Map map, int alignment) {
        map.put(VERTICAL_ALIGNMENT, new Integer(alignment));
    }

    public static final int getVerticalAlignment(Map map) {
        Integer intObj = (Integer)map.get(VERTICAL_ALIGNMENT);
        if (intObj != null) {
            return intObj;
        }
        return 0;
    }

    public static final void setHorizontalAlignment(Map map, int alignment) {
        map.put(HORIZONTAL_ALIGNMENT, new Integer(alignment));
    }

    public static final int getHorizontalAlignment(Map map) {
        Integer intObj = (Integer)map.get(HORIZONTAL_ALIGNMENT);
        if (intObj != null) {
            return intObj;
        }
        return 0;
    }

    public static final void setVerticalTextPosition(Map map, int textPosition) {
        map.put(VERTICAL_TEXT_POSITION, new Integer(textPosition));
    }

    public static final int getVerticalTextPosition(Map map) {
        Integer intObj = (Integer)map.get(VERTICAL_TEXT_POSITION);
        if (intObj != null) {
            return intObj;
        }
        return 3;
    }

    public static final void setHorizontalTextPosition(Map map, int textPosition) {
        map.put(HORIZONTAL_TEXT_POSITION, new Integer(textPosition));
    }

    public static final int getHorizontalTextPosition(Map map) {
        Integer intObj = (Integer)map.get(HORIZONTAL_TEXT_POSITION);
        if (intObj != null) {
            return intObj;
        }
        return 0;
    }

    public static final void setDashPattern(Map map, float[] value) {
        map.put(DASHPATTERN, value);
    }

    public static final float[] getDashPattern(Map map) {
        return (float[])map.get(DASHPATTERN);
    }

    public static final void setDashOffset(Map map, float value) {
        map.put(DASHOFFSET, new Float(value));
    }

    public static final float getDashOffset(Map map) {
        Float floatObj = (Float)map.get(DASHOFFSET);
        if (floatObj != null) {
            return floatObj.floatValue();
        }
        return 1.0f;
    }

    public static final void setLineStyle(Map map, int style) {
        map.put(LINESTYLE, new Integer(style));
    }

    public static final int getLineStyle(Map map) {
        Integer intObj = (Integer)map.get(LINESTYLE);
        if (intObj != null) {
            return intObj;
        }
        return 11;
    }

    public static final void setBeginSize(Map map, int style) {
        map.put(BEGINSIZE, new Integer(style));
    }

    public static final int getBeginSize(Map map) {
        Integer intObj = (Integer)map.get(BEGINSIZE);
        if (intObj != null) {
            return intObj;
        }
        return DEFAULTDECORATIONSIZE;
    }

    public static final void setEndSize(Map map, int style) {
        map.put(ENDSIZE, new Integer(style));
    }

    public static final int getEndSize(Map map) {
        Integer intObj = (Integer)map.get(ENDSIZE);
        if (intObj != null) {
            return intObj;
        }
        return DEFAULTDECORATIONSIZE;
    }

    public static final void setLineBegin(Map map, int style) {
        map.put(LINEBEGIN, new Integer(style));
    }

    public static final int getLineBegin(Map map) {
        Integer intObj = (Integer)map.get(LINEBEGIN);
        if (intObj != null) {
            return intObj;
        }
        return 0;
    }

    public static final void setLineEnd(Map map, int style) {
        map.put(LINEEND, new Integer(style));
    }

    public static final int getLineEnd(Map map) {
        Integer intObj = (Integer)map.get(LINEEND);
        if (intObj != null) {
            return intObj;
        }
        return 0;
    }

    public static final void setValue(Map map, Object value) {
        map.put(VALUE, value);
    }

    public static final Object getValue(Map map) {
        return map.get(VALUE);
    }

    public static final void setLabelPosition(Map map, Point2D position) {
        map.put(LABELPOSITION, position);
    }

    public static final Point2D getLabelPosition(Map map) {
        return (Point2D)map.get(LABELPOSITION);
    }

    public static final void setExtraLabels(Map map, Object[] definitions) {
        map.put(EXTRALABELS, definitions);
    }

    public static final Object[] getExtraLabels(Map map) {
        return (Object[])map.get(EXTRALABELS);
    }

    public static final void setExtraLabelPositions(Map map, Point2D[] positions) {
        map.put(EXTRALABELPOSITIONS, positions);
    }

    public static final Point2D[] getExtraLabelPositions(Map map) {
        return (Point2D[])map.get(EXTRALABELPOSITIONS);
    }

    public static final void setLabelAlongEdge(Map map, boolean flag) {
        map.put(LABELALONGEDGE, new Boolean(flag));
    }

    public static final boolean isLabelAlongEdge(Map map) {
        Boolean bool = (Boolean)map.get(LABELALONGEDGE);
        if (bool != null) {
            return bool;
        }
        return false;
    }

    public static final void setEditable(Map map, boolean flag) {
        map.put(EDITABLE, new Boolean(flag));
    }

    public static final boolean isEditable(Map map) {
        Boolean bool = (Boolean)map.get(EDITABLE);
        if (bool != null) {
            return bool;
        }
        return true;
    }

    public static final void setMoveable(Map map, boolean flag) {
        map.put(MOVEABLE, new Boolean(flag));
    }

    public static final boolean isMoveable(Map map) {
        Boolean bool = (Boolean)map.get(MOVEABLE);
        if (bool != null) {
            return bool;
        }
        return true;
    }

    public static final void setSizeable(Map map, boolean flag) {
        map.put(SIZEABLE, new Boolean(flag));
    }

    public static final boolean isSizeable(Map map) {
        Boolean bool = (Boolean)map.get(SIZEABLE);
        if (bool != null) {
            return bool;
        }
        return true;
    }

    public static final void setAutoSize(Map map, boolean flag) {
        map.put(AUTOSIZE, new Boolean(flag));
    }

    public static final boolean isAutoSize(Map map) {
        Boolean bool = (Boolean)map.get(AUTOSIZE);
        if (bool != null) {
            return bool;
        }
        return false;
    }

    public static final void setResize(Map map, boolean flag) {
        map.put(RESIZE, new Boolean(flag));
    }

    public static final boolean isResize(Map map) {
        Boolean bool = (Boolean)map.get(RESIZE);
        if (bool != null) {
            return bool;
        }
        return false;
    }

    public static final void setConstrained(Map map, boolean flag) {
        map.put(CONSTRAINED, new Boolean(flag));
    }

    public static final boolean isConstrained(Map map) {
        Boolean bool = (Boolean)map.get(CONSTRAINED);
        if (bool != null) {
            return bool;
        }
        return false;
    }

    public static final void setSelectable(Map map, boolean flag) {
        map.put(SELECTABLE, new Boolean(flag));
    }

    public static final boolean isSelectable(Map map) {
        Boolean bool = (Boolean)map.get(SELECTABLE);
        if (bool != null) {
            return bool;
        }
        return true;
    }

    public static final void setChildrenSelectable(Map map, boolean flag) {
        map.put("childrenSelectable", new Boolean(flag));
    }

    public static final boolean isChildrenSelectable(Map map) {
        Boolean bool = (Boolean)map.get("childrenSelectable");
        if (bool != null) {
            return bool;
        }
        return true;
    }

    public static final void setBendable(Map map, boolean flag) {
        map.put(BENDABLE, new Boolean(flag));
    }

    public static final boolean isBendable(Map map) {
        Boolean bool = (Boolean)map.get(BENDABLE);
        if (bool != null) {
            return bool;
        }
        return true;
    }

    public static final void setConnectable(Map map, boolean flag) {
        map.put(CONNECTABLE, new Boolean(flag));
    }

    public static final boolean isConnectable(Map map) {
        Boolean bool = (Boolean)map.get(CONNECTABLE);
        if (bool != null) {
            return bool;
        }
        return true;
    }

    public static final void setDisconnectable(Map map, boolean flag) {
        map.put(DISCONNECTABLE, new Boolean(flag));
    }

    public static final boolean isDisconnectable(Map map) {
        Boolean bool = (Boolean)map.get(DISCONNECTABLE);
        if (bool != null) {
            return bool;
        }
        return true;
    }

    public static final void setPoints(Map map, List list) {
        map.put(POINTS, list);
    }

    public static final List getPoints(Map map) {
        return (List)map.get(POINTS);
    }

    public static final void setRouting(Map map, Edge.Routing routing) {
        map.put(ROUTING, routing);
    }

    public static final Edge.Routing getRouting(Map map) {
        Edge.Routing routing = (Edge.Routing)map.get(ROUTING);
        if (routing == null) {
            routing = ROUTING_DEFAULT;
        }
        return routing;
    }

    public static final void setBounds(Map map, Rectangle2D bounds) {
        map.put(BOUNDS, bounds);
    }

    public static final Rectangle2D getBounds(Map map) {
        return (Rectangle2D)map.get(BOUNDS);
    }

    public static final void setInset(Map map, int width) {
        map.put(INSET, new Integer(width));
    }

    public static final int getInset(Map map) {
        Integer intObj = (Integer)map.get(INSET);
        if (intObj != null) {
            return intObj;
        }
        return DEFAULTINSET;
    }

    public static final void setSize(Map map, Dimension size) {
        map.put(SIZE, size);
    }

    public static final Dimension getSize(Map map) {
        return (Dimension)map.get(SIZE);
    }

    public static final void setOffset(Map map, Point2D offset) {
        map.put(OFFSET, offset);
    }

    public static final Point2D getOffset(Map map) {
        return (Point2D)map.get(OFFSET);
    }

    public static final void setBeginFill(Map map, boolean flag) {
        map.put(BEGINFILL, new Boolean(flag));
    }

    public static final boolean isBeginFill(Map map) {
        Boolean bool = (Boolean)map.get(BEGINFILL);
        if (bool != null) {
            return bool;
        }
        return false;
    }

    public static final void setEndFill(Map map, boolean flag) {
        map.put(ENDFILL, new Boolean(flag));
    }

    public static final boolean isEndFill(Map map) {
        Boolean bool = (Boolean)map.get(ENDFILL);
        if (bool != null) {
            return bool;
        }
        return false;
    }

    public static final void setAbsolute(Map map, boolean flag) {
        GraphConstants.setAbsoluteX(map, flag);
        GraphConstants.setAbsoluteY(map, flag);
    }

    public static final void setAbsoluteY(Map map, boolean flag) {
        map.put(ABSOLUTEY, new Boolean(flag));
    }

    public static final boolean isAbsoluteY(Map map) {
        Boolean bool = (Boolean)map.get(ABSOLUTEY);
        if (bool != null) {
            return bool;
        }
        return false;
    }

    public static final void setAbsoluteX(Map map, boolean flag) {
        map.put(ABSOLUTEX, new Boolean(flag));
    }

    public static final boolean isAbsoluteX(Map map) {
        Boolean bool = (Boolean)map.get(ABSOLUTEX);
        if (bool != null) {
            return bool;
        }
        return false;
    }

    public static final void setRemoveAll(Map map, boolean flag) {
        map.put(REMOVEALL, new Boolean(flag));
    }

    public static final boolean isRemoveAll(Map map) {
        Boolean bool = (Boolean)map.get(REMOVEALL);
        if (bool != null) {
            return bool;
        }
        return false;
    }

    public static Edge.Routing getROUTING_SIMPLE() {
        return ROUTING_SIMPLE;
    }

    public static Edge.Routing getROUTING_DEFAULT() {
        return ROUTING_DEFAULT;
    }

    public static void setLink(Map map, String link) {
        map.put(LINK, link);
    }

    public static String getLink(Map map) {
        String link = (String)map.get(LINK);
        return link;
    }

    public static void setLabelEnabled(Map map, boolean flag) {
        map.put("labelEnabled", new Boolean(flag));
    }

    public static boolean isLabelEnabled(Map map) {
        Boolean bool = (Boolean)map.get("labelEnabled");
        if (bool != null) {
            return bool;
        }
        return true;
    }

    public static void setExactSegmentLabel(Map map, boolean flag) {
        map.put("labelEnabled", new Boolean(flag));
    }

    public static boolean isExactSegmentLabel(Map map) {
        Boolean bool = (Boolean)map.get("labelEnabled");
        if (bool != null) {
            return bool;
        }
        return false;
    }

    static {
        try {
            DEFAULTFONT = UIManager.getDefaults().getFont("Label.font");
        }
        catch (InternalError internalError) {
            // empty catch block
        }
        DEFAULTDECORATIONSIZE = 10;
        DEFAULTINSET = 0;
        dash = new float[]{5.0f, 5.0f};
        SELECTION_STROKE = new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f);
        ROUTING_DEFAULT = new DefaultEdge.LoopRouting();
        ROUTING_SIMPLE = new DefaultEdge.DefaultRouting();
    }
}

