/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jgraph.JGraph;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.Edge;
import org.jgraph.graph.EdgeRenderer;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.PortView;
import org.jgraph.plaf.GraphUI;
import org.jgraph.plaf.basic.BasicGraphUI;

public class EdgeView
extends AbstractCellView {
    public static transient EdgeRenderer renderer = new EdgeRenderer();
    protected List points;
    protected CellView source;
    protected CellView target;
    protected CellView sourceParentView;
    protected CellView targetParentView;
    protected Point2D labelPosition;
    protected Point2D[] extraLabelPositions;
    protected transient Point2D labelVector = null;
    public transient Shape beginShape;
    public transient Shape endShape;
    public transient Shape lineShape;
    public transient GeneralPath sharedPath = null;
    protected transient Rectangle2D cachedBounds = null;
    public static boolean LEGACY_DISCONNECTABLE = true;

    public EdgeView() {
    }

    public EdgeView(Object cell) {
        super(cell);
    }

    @Override
    public void refresh(GraphLayoutCache cache, CellMapper mapper, boolean createDependentViews) {
        this.points = null;
        super.refresh(cache, mapper, createDependentViews);
        GraphModel model = cache.getModel();
        Object modelSource = model.getSource(this.cell);
        Object modelTarget = model.getTarget(this.cell);
        this.setSource(mapper.getMapping(modelSource, createDependentViews));
        this.setTarget(mapper.getMapping(modelTarget, createDependentViews));
        this.sourceParentView = modelSource != null && this.getSource() == null ? this.getVisibleParent(model, mapper, modelSource) : null;
        this.targetParentView = modelTarget != null && this.getTarget() == null ? this.getVisibleParent(model, mapper, modelTarget) : null;
    }

    protected CellView getVisibleParent(GraphModel model, CellMapper mapper, Object port) {
        CellView view = null;
        do {
            view = mapper.getMapping(port, false);
            port = model.getParent(port);
        } while (view == null && port != null);
        return view;
    }

    @Override
    public void update(GraphLayoutCache cache) {
        super.update(cache);
        ArrayList<Point2D> controlPoints = GraphConstants.getPoints(this.allAttributes);
        if (controlPoints == null) {
            controlPoints = new ArrayList<Point2D>(4);
            controlPoints.add(this.allAttributes.createPoint(10.0, 10.0));
            controlPoints.add(this.allAttributes.createPoint(20.0, 20.0));
            GraphConstants.setPoints(this.allAttributes, controlPoints);
        }
        if (this.points == null) {
            this.points = controlPoints;
        }
        Edge.Routing routing = GraphConstants.getRouting(this.allAttributes);
        List routedPoints = null;
        if (routing != null) {
            routedPoints = routing.route(cache, this);
        }
        List<Point2D> list = this.points = routedPoints != null && !routedPoints.isEmpty() ? routedPoints : controlPoints;
        if (this.points == controlPoints) {
            if (this.source != null) {
                this.setSource(this.source);
            }
            if (this.target != null) {
                this.setTarget(this.target);
            }
        }
        this.checkDefaultLabelPosition();
        Point2D[] positions = GraphConstants.getExtraLabelPositions(this.allAttributes);
        if (positions != null) {
            this.extraLabelPositions = new Point2D[positions.length];
            for (int i = 0; i < positions.length; ++i) {
                this.extraLabelPositions[i] = positions[i];
            }
        } else {
            this.extraLabelPositions = null;
        }
        this.beginShape = null;
        this.endShape = null;
        this.lineShape = null;
        this.invalidate();
    }

    protected void checkDefaultLabelPosition() {
        this.labelPosition = GraphConstants.getLabelPosition(this.allAttributes);
        String label = String.valueOf(this.getCell());
        if (this.labelPosition == null && label != null && label.length() > 0) {
            int center = 500;
            this.labelPosition = new Point(center, 0);
            GraphConstants.setLabelPosition(this.allAttributes, this.labelPosition);
        }
    }

    protected void invalidate() {
        this.labelVector = null;
        this.sharedPath = null;
        this.cachedBounds = null;
    }

    public Shape getShape() {
        if (this.sharedPath != null) {
            return this.sharedPath;
        }
        this.sharedPath = (GeneralPath)this.getEdgeRenderer().createShape();
        return this.sharedPath;
    }

    @Override
    public boolean intersects(JGraph graph, Rectangle2D rect) {
        boolean intersects = super.intersects(graph, rect);
        if (!this.isLeaf()) {
            return intersects;
        }
        if (intersects) {
            Rectangle r = new Rectangle((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
            return this.getEdgeRenderer().intersects(graph, this, r);
        }
        return false;
    }

    @Override
    public Rectangle2D getBounds() {
        Rectangle2D rect = super.getBounds();
        if (rect == null) {
            if (this.cachedBounds == null) {
                this.cachedBounds = this.getEdgeRenderer().getBounds(this);
            }
            rect = this.cachedBounds;
        }
        return rect;
    }

    EdgeRenderer getEdgeRenderer() {
        return (EdgeRenderer)this.getRenderer();
    }

    @Override
    public CellViewRenderer getRenderer() {
        return renderer;
    }

    @Override
    public CellHandle getHandle(GraphContext context) {
        return new EdgeHandle(this, context);
    }

    public CellView getSource() {
        return this.source;
    }

    public CellView getSourceParentView() {
        return this.sourceParentView;
    }

    public void setSource(CellView sourceView) {
        this.sourceParentView = null;
        this.source = sourceView;
        if (this.source != null) {
            this.points.set(0, this.source);
        } else {
            this.points.set(0, this.getPoint(0));
        }
        this.invalidate();
    }

    public CellView getTarget() {
        return this.target;
    }

    public CellView getTargetParentView() {
        return this.targetParentView;
    }

    public void setTarget(CellView targetView) {
        this.target = targetView;
        this.targetParentView = null;
        int n = this.points.size() - 1;
        if (this.target != null) {
            this.points.set(n, this.target);
        } else {
            this.points.set(n, this.getPoint(n));
        }
        this.invalidate();
    }

    public Point2D getExtraLabelPosition(int index) {
        return this.extraLabelPositions[index];
    }

    public Point2D getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(Point2D pos) {
        this.labelPosition.setLocation(pos);
        this.invalidate();
    }

    public void setExtraLabelPosition(int index, Point2D pos) {
        this.extraLabelPositions[index].setLocation(pos);
        this.invalidate();
    }

    public boolean isLoop() {
        return this.getSource() != null && this.getSource() == this.getTarget() || this.sourceParentView != null && this.sourceParentView == this.targetParentView || this.sourceParentView != null && this.getTarget() != null && this.getTarget().getParentView() == this.sourceParentView || this.targetParentView != null && this.getSource() != null && this.getSource().getParentView() == this.targetParentView;
    }

    public List getPoints() {
        return this.points;
    }

    public int getPointCount() {
        if (this.points != null) {
            return this.points.size();
        }
        return 0;
    }

    public Point2D getPoint(int index) {
        Object obj = this.points.get(index);
        if (index == 0 && this.sourceParentView != null) {
            return this.sourceParentView.getPerimeterPoint(this, EdgeView.getCenterPoint(this.sourceParentView), this.getNearestPoint(index == 0));
        }
        if (index == this.getPointCount() - 1 && this.targetParentView != null) {
            return this.targetParentView.getPerimeterPoint(this, EdgeView.getCenterPoint(this.targetParentView), this.getNearestPoint(index == 0));
        }
        if (obj instanceof PortView) {
            return ((PortView)obj).getLocation(this, this.getNearestPoint(index == 0));
        }
        if (obj instanceof CellView) {
            Rectangle2D r = ((CellView)obj).getBounds();
            return new Point2D.Double(r.getX(), r.getY());
        }
        if (obj instanceof Point2D) {
            return (Point2D)obj;
        }
        return null;
    }

    protected Point2D getNearestPoint(boolean source) {
        if (this.getPointCount() == 2) {
            if (source && this.target instanceof PortView && GraphConstants.getOffset(this.target.getAllAttributes()) != null) {
                return ((PortView)this.target).getLocation(this);
            }
            if (!source && this.source instanceof PortView && GraphConstants.getOffset(this.source.getAllAttributes()) != null) {
                return ((PortView)this.source).getLocation(this);
            }
            if (source && this.targetParentView != null && this.targetParentView.isLeaf()) {
                return EdgeView.getCenterPoint(this.targetParentView);
            }
            if (!source && this.sourceParentView != null && this.sourceParentView.isLeaf()) {
                return EdgeView.getCenterPoint(this.sourceParentView);
            }
        }
        return this.getPointLocation(source ? 1 : this.getPointCount() - 2);
    }

    protected Point2D getPointLocation(int index) {
        CellView vertex;
        Object obj = this.points.get(index);
        if (obj instanceof Point2D) {
            return (Point2D)obj;
        }
        if (obj instanceof PortView && (vertex = ((CellView)obj).getParentView()) != null) {
            return EdgeView.getCenterPoint(vertex);
        }
        return null;
    }

    public void setPoint(int index, Point2D p) {
        this.points.set(index, p);
        this.invalidate();
    }

    public void addPoint(int index, Point2D p) {
        this.points.add(index, p);
        this.invalidate();
    }

    public void removePoint(int index) {
        this.points.remove(index);
        this.invalidate();
    }

    public void addExtraLabel(Point2D location, Object label) {
        Object[] extraLabels = GraphConstants.getExtraLabels(this.getAllAttributes());
        Point2D[] positions = GraphConstants.getExtraLabelPositions(this.getAllAttributes());
        if (extraLabels == null) {
            extraLabels = new Object[1];
            positions = new Point2D[1];
        } else {
            Object[] tmp = new Object[extraLabels.length + 1];
            System.arraycopy(extraLabels, 0, tmp, 0, extraLabels.length);
            extraLabels = tmp;
            Point2D[] pts = new Point2D[positions.length + 1];
            System.arraycopy(positions, 0, pts, 0, positions.length);
            positions = pts;
        }
        int newIndex = extraLabels.length - 1;
        extraLabels[newIndex] = label;
        positions[newIndex] = location;
        GraphConstants.setExtraLabels(this.getAllAttributes(), extraLabels);
        GraphConstants.setExtraLabelPositions(this.getAllAttributes(), positions);
    }

    public void removeExtraLabel(int index) {
        Object[] labels = GraphConstants.getExtraLabels(this.getAllAttributes());
        Point2D[] pts = GraphConstants.getExtraLabelPositions(this.getAllAttributes());
        if (labels == null || labels.length > 1) {
            Object[] newLabels = new Object[labels.length - 1];
            Point2D[] newPts = new Point2D[pts.length - 1];
            System.arraycopy(labels, 0, newLabels, 0, index);
            if (index < newLabels.length) {
                System.arraycopy(labels, index + 1, newLabels, index, newLabels.length - index);
            }
            System.arraycopy(pts, 0, newPts, 0, index);
            if (index < newPts.length) {
                System.arraycopy(pts, index + 1, newPts, index, newPts.length - index);
            }
            GraphConstants.setExtraLabels(this.getAllAttributes(), newLabels);
            GraphConstants.setExtraLabelPositions(this.getAllAttributes(), newPts);
        } else {
            GraphConstants.setExtraLabels(this.getAllAttributes(), new Object[0]);
            GraphConstants.setExtraLabelPositions(this.getAllAttributes(), new Point2D[0]);
        }
    }

    public int getFirstPointOfSegment() {
        boolean exactSegment = GraphConstants.isExactSegmentLabel(this.allAttributes);
        double dx = 0.0;
        double dy = 0.0;
        int n = this.getPointCount();
        if (exactSegment) {
            Point2D lastPoint = this.getPoint(0);
            double totalLength = 0.0;
            for (int i = 1; i < n; ++i) {
                Point2D currentPoint = this.getPoint(i);
                dx = currentPoint.getX() - lastPoint.getX();
                dy = currentPoint.getY() - lastPoint.getY();
                totalLength += Math.sqrt(dx * dx + dy * dy);
                lastPoint = currentPoint;
            }
            double relativeX = this.getLabelPosition().getX() / 1000.0;
            double labelXPositionDistance = relativeX * totalLength;
            totalLength = 0.0;
            lastPoint = this.getPoint(0);
            if (relativeX <= 0.0 || relativeX >= 1.0) {
                return -1;
            }
            for (int i = 1; i < n; ++i) {
                Point2D currentPoint = this.getPoint(i);
                dx = currentPoint.getX() - lastPoint.getX();
                if (!((totalLength += Math.sqrt(dx * dx + (dy = currentPoint.getY() - lastPoint.getY()) * dy)) > labelXPositionDistance)) continue;
                return i - 1;
            }
        } else {
            return -1;
        }
        return -1;
    }

    public Point2D getLabelVector() {
        if (this.labelVector == null) {
            Point2D p0 = this.getPoint(0);
            double dx = 0.0;
            double dy = 0.0;
            int n = this.getPointCount();
            if (this.isLoop()) {
                for (int i = 1; i < n; ++i) {
                    Point2D point = this.getPoint(i);
                    dx += point.getX() - p0.getX();
                    dy += point.getY() - p0.getY();
                }
                this.labelVector = new Point2D.Double(dx /= (double)(n /= 2), dy /= (double)n);
            } else {
                boolean exactSegment = GraphConstants.isExactSegmentLabel(this.allAttributes);
                if (exactSegment) {
                    Point2D lastPoint = this.getPoint(0);
                    double totalLength = 0.0;
                    for (int i = 1; i < n; ++i) {
                        Point2D currentPoint = this.getPoint(i);
                        dx = currentPoint.getX() - lastPoint.getX();
                        dy = currentPoint.getY() - lastPoint.getY();
                        totalLength += Math.sqrt(dx * dx + dy * dy);
                        lastPoint = currentPoint;
                    }
                    double relativeX = this.getLabelPosition().getX() / 1000.0;
                    double labelXPositionDistance = relativeX * totalLength;
                    totalLength = 0.0;
                    lastPoint = this.getPoint(0);
                    if (relativeX <= 0.0 || relativeX >= 1.0) {
                        exactSegment = false;
                    } else {
                        for (int i = 1; i < n; ++i) {
                            Point2D currentPoint = this.getPoint(i);
                            dx = currentPoint.getX() - lastPoint.getX();
                            if ((totalLength += Math.sqrt(dx * dx + (dy = currentPoint.getY() - lastPoint.getY()) * dy)) > labelXPositionDistance) {
                                this.labelVector = new Point2D.Double(dx, dy);
                                break;
                            }
                            lastPoint = currentPoint;
                        }
                    }
                }
                if (!exactSegment || this.labelVector == null) {
                    Point2D point = this.getPoint(n - 1);
                    dx = point.getX() - p0.getX();
                    dy = point.getY() - p0.getY();
                    this.labelVector = new Point2D.Double(dx, dy);
                }
            }
        }
        return this.labelVector;
    }

    protected Point2D getAbsoluteLabelPosition() {
        Point2D result = this.getAbsoluteLabelPositionFromRelative(GraphConstants.getLabelPosition(this.getAllAttributes()));
        return result;
    }

    protected Point2D getAbsoluteExtraLabelPosition(int index) {
        Point2D[] positions = GraphConstants.getExtraLabelPositions(this.getAllAttributes());
        if (positions != null && positions.length > index) {
            Point2D result = this.getAbsoluteLabelPositionFromRelative(positions[index]);
            return result;
        }
        return null;
    }

    protected Point2D getAbsoluteLabelPositionFromRelative(Point2D geometry) {
        Point2D result = this.convertRelativeLabelPositionToAbsolute(geometry);
        if (result != null) {
            double offsetX = 0.0;
            double offsetY = 0.0;
            Point2D offset = GraphConstants.getOffset(this.getAllAttributes());
            if (offset != null) {
                offsetX = offset.getX();
                offsetY = offset.getY();
            }
            double x = result.getX() + offsetX;
            double y = result.getY() + offsetY;
            return new Point2D.Double(x, y);
        }
        return null;
    }

    protected Point2D convertRelativeLabelPositionToAbsolute(Point2D geometry) {
        Point2D pt = this.getPoint(0);
        if (pt != null) {
            double length = 0.0;
            int pointCount = this.getPointCount();
            double[] segments = new double[pointCount];
            for (int i = 1; i < pointCount; ++i) {
                double segment;
                Point2D tmp = this.getPoint(i);
                if (tmp == null) continue;
                double dx = pt.getX() - tmp.getX();
                double dy = pt.getY() - tmp.getY();
                segments[i - 1] = segment = Math.sqrt(dx * dx + dy * dy);
                length += segment;
                pt = tmp;
            }
            double x = geometry.getX() / 1000.0;
            double y = geometry.getY();
            double dist = x * length;
            length = 0.0;
            int index = 1;
            double segment = segments[0];
            while (dist > length + segment && index < pointCount - 1) {
                length += segment;
                segment = segments[index++];
            }
            double factor = (dist - length) / segment;
            Point2D p0 = this.getPoint(index - 1);
            Point2D pe = this.getPoint(index);
            if (p0 != null && pe != null) {
                double dx = pe.getX() - p0.getX();
                double dy = pe.getY() - p0.getY();
                double nx = dy / segment;
                double ny = dx / segment;
                x = p0.getX() + dx * factor - nx * y;
                y = p0.getY() + dy * factor + ny * y;
                return new Point2D.Double(x, y);
            }
        }
        return null;
    }

    public static double getLength(CellView view) {
        double cost = 1.0;
        if (view instanceof EdgeView) {
            EdgeView edge = (EdgeView)view;
            Point2D last = null;
            Point2D current = null;
            for (int i = 0; i < edge.getPointCount(); ++i) {
                current = edge.getPoint(i);
                if (last != null) {
                    cost += last.distance(current);
                }
                last = current;
            }
        }
        return cost;
    }

    @Override
    public Point2D getPerimeterPoint(EdgeView edge, Point2D source, Point2D p) {
        if (this.getPointCount() > 2) {
            return this.getPoint(this.getPointCount() / 2);
        }
        Point2D p0 = this.getPoint(0);
        Point2D pe = this.getPoint(this.getPointCount() - 1);
        return new Point2D.Double((pe.getX() + p0.getX()) / 2.0, (pe.getY() + p0.getY()) / 2.0);
    }

    public static class EdgeHandle
    implements CellHandle,
    Serializable {
        protected JGraph graph;
        protected EdgeView edge;
        protected EdgeView orig;
        protected boolean label = false;
        protected boolean source = false;
        protected boolean target = false;
        protected int currentLabel = -1;
        protected int currentIndex = -1;
        protected Point2D currentPoint;
        protected transient Rectangle2D[] r;
        protected transient Rectangle2D loc;
        protected transient Rectangle2D[] extraLabelLocations;
        protected boolean firstOverlayCall = true;
        protected boolean isEdgeConnectable = true;
        protected EdgeView relevantEdge = null;
        protected boolean editing = false;
        protected Point2D initialLabelLocation = null;
        protected boolean edgeModified = false;
        protected JComponent highlight = new JPanel();

        public EdgeHandle(EdgeView edge, GraphContext ctx) {
            this.graph = ctx.getGraph();
            this.edge = edge;
            this.editing = this.graph.getEditingCell() == edge.getCell();
            this.loc = new Rectangle();
            Object[] labels = GraphConstants.getExtraLabels(edge.getAllAttributes());
            if (labels != null) {
                this.extraLabelLocations = new Rectangle[labels.length];
                for (int i = 0; i < this.extraLabelLocations.length; ++i) {
                    this.extraLabelLocations[i] = new Rectangle();
                }
            }
            this.orig = (EdgeView)this.graph.getGraphLayoutCache().getMapping(edge.getCell(), false);
            this.reloadPoints(this.orig);
            this.isEdgeConnectable = GraphConstants.isConnectable(edge.getAllAttributes());
            this.highlight = this.createHighlight();
        }

        protected JComponent createHighlight() {
            JPanel panel = new JPanel();
            panel.setBorder(BorderFactory.createBevelBorder(0));
            panel.setVisible(false);
            panel.setOpaque(false);
            return panel;
        }

        protected void reloadPoints(EdgeView edge) {
            this.relevantEdge = edge;
            this.r = new Rectangle[edge.getPointCount()];
            for (int i = 0; i < this.r.length; ++i) {
                this.r[i] = new Rectangle();
            }
            this.invalidate();
        }

        @Override
        public void paint(Graphics g) {
            this.invalidate();
            if (!this.edge.isLeaf()) {
                return;
            }
            for (int i = 0; i < this.r.length; ++i) {
                Point2D tmp;
                if (this.isEdgeConnectable && !this.editing) {
                    g.setColor(this.graph.getHandleColor());
                } else {
                    g.setColor(this.graph.getLockedHandleColor());
                }
                g.fill3DRect((int)this.r[i].getX(), (int)this.r[i].getY(), (int)this.r[i].getWidth(), (int)this.r[i].getHeight(), true);
                CellView port = null;
                if (i == 0 && this.edge.getSource() != null) {
                    port = this.edge.getSource();
                } else if (i == this.r.length - 1 && this.edge.getTarget() != null) {
                    port = this.edge.getTarget();
                }
                if (port == null && (i != 0 || this.edge.getSourceParentView() == null) && (i != this.r.length - 1 || this.edge.getTargetParentView() == null)) continue;
                g.setColor(this.graph.getLockedHandleColor());
                Point2D point2D = tmp = port != null ? GraphConstants.getOffset(port.getAllAttributes()) : null;
                if (tmp != null) {
                    g.drawLine((int)this.r[i].getX() + 1, (int)this.r[i].getY() + 1, (int)(this.r[i].getX() + this.r[i].getWidth()) - 3, (int)(this.r[i].getY() + this.r[i].getHeight()) - 3);
                    g.drawLine((int)this.r[i].getX() + 1, (int)(this.r[i].getY() + this.r[i].getHeight()) - 3, (int)(this.r[i].getX() + this.r[i].getWidth()) - 3, (int)this.r[i].getY() + 1);
                    continue;
                }
                g.drawRect((int)this.r[i].getX() + 2, (int)this.r[i].getY() + 2, (int)this.r[i].getWidth() - 5, (int)this.r[i].getHeight() - 5);
            }
            if (!this.graph.isXorEnabled()) {
                this.firstOverlayCall = false;
                this.overlay(g);
            }
        }

        protected void highlight(JGraph graph, CellView cellView) {
            if (cellView != null) {
                this.highlight.setBounds(this.getHighlightBounds(graph, cellView));
                if (this.highlight.getParent() == null) {
                    graph.add(this.highlight);
                    this.highlight.setVisible(true);
                }
            } else if (this.highlight.getParent() != null) {
                this.highlight.setVisible(false);
                this.highlight.getParent().remove(this.highlight);
            }
        }

        protected Rectangle getHighlightBounds(JGraph graph, CellView cellView) {
            boolean offset = GraphConstants.getOffset(cellView.getAllAttributes()) != null;
            Rectangle2D r = offset ? cellView.getBounds() : cellView.getParentView().getBounds();
            r = graph.toScreen((Rectangle2D)r.clone());
            int s = 3;
            return new Rectangle((int)(r.getX() - (double)s), (int)(r.getY() - (double)s), (int)(r.getWidth() + (double)(2 * s)), (int)(r.getHeight() + (double)(2 * s)));
        }

        @Override
        public void overlay(Graphics g) {
            if (this.edge != null && !this.firstOverlayCall && this.edge.isLeaf()) {
                g.setColor(this.graph.getForeground());
                if (this.graph.isXorEnabled()) {
                    g.setXORMode(this.graph.getBackground().darker());
                }
                Graphics2D g2 = (Graphics2D)g;
                AffineTransform oldTransform = g2.getTransform();
                g2.scale(this.graph.getScale(), this.graph.getScale());
                this.graph.getUI().paintCell(g, this.edge, this.edge.getBounds(), true);
                g2.setTransform(oldTransform);
                if (this.graph.isXorEnabled()) {
                    if (this.isSourceEditing() && this.edge.getSource() != null) {
                        this.paintPort(g, this.edge.getSource());
                    } else if (this.isTargetEditing() && this.edge.getTarget() != null) {
                        this.paintPort(g, this.edge.getTarget());
                    }
                }
            }
            if (!this.graph.isXorEnabled()) {
                if (this.isSourceEditing()) {
                    this.highlight(this.graph, this.edge.getSource());
                } else if (this.isTargetEditing()) {
                    this.highlight(this.graph, this.edge.getTarget());
                }
            }
            this.firstOverlayCall = false;
        }

        protected void paintPort(Graphics g, CellView p) {
            boolean offset = GraphConstants.getOffset(p.getAllAttributes()) != null;
            Rectangle2D r = offset ? p.getBounds() : p.getParentView().getBounds();
            r = this.graph.toScreen((Rectangle2D)r.clone());
            int s = 3;
            r.setFrame(r.getX() - (double)s, r.getY() - (double)s, r.getWidth() + (double)(2 * s), r.getHeight() + (double)(2 * s));
            this.graph.getUI().paintCell(g, p, r, true);
        }

        protected boolean snap(boolean source, Point2D point) {
            boolean connect = this.graph.isConnectable() && this.isEdgeConnectable;
            Object port = this.graph.getPortForLocation(point.getX(), point.getY());
            if (port != null && this.graph.getModel().getParent(port) == this.edge.getCell()) {
                port = null;
            }
            if (port != null && connect) {
                CellView portView = this.graph.getGraphLayoutCache().getMapping(port, false);
                Rectangle2D dirty = this.edge.getBounds();
                dirty.add(portView.getParentView().getBounds());
                if (GraphConstants.isConnectable(portView.getParentView().getAllAttributes())) {
                    Object cell = this.edge.getCell();
                    if (source && this.graph.getModel().acceptsSource(cell, port)) {
                        if (this.edge.getSource() != portView) {
                            this.edgeModified = true;
                            if (this.graph.isXorEnabled()) {
                                this.overlay(this.graph.getGraphics());
                            }
                            this.edge.setSource(portView);
                            this.edge.update(this.graph.getGraphLayoutCache());
                            if (this.graph.isXorEnabled()) {
                                this.overlay(this.graph.getGraphics());
                            } else {
                                dirty.add(this.edge.getBounds());
                                this.graph.repaint((int)dirty.getX(), (int)dirty.getY(), (int)dirty.getWidth(), (int)dirty.getHeight());
                            }
                        }
                        return true;
                    }
                    if (!source && this.graph.getModel().acceptsTarget(cell, port)) {
                        if (this.edge.getTarget() != portView) {
                            this.edgeModified = true;
                            if (this.graph.isXorEnabled()) {
                                this.overlay(this.graph.getGraphics());
                            }
                            this.edge.setTarget(portView);
                            this.edge.update(this.graph.getGraphLayoutCache());
                            if (this.graph.isXorEnabled()) {
                                this.overlay(this.graph.getGraphics());
                            } else {
                                dirty.add(this.edge.getBounds());
                                this.graph.repaint((int)dirty.getX(), (int)dirty.getY(), (int)dirty.getWidth(), (int)dirty.getHeight());
                            }
                        }
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean isConstrainedMoveEvent(MouseEvent e) {
            GraphUI ui = this.graph.getUI();
            if (ui instanceof BasicGraphUI) {
                return ((BasicGraphUI)ui).isConstrainedMoveEvent(e);
            }
            return false;
        }

        public boolean isAddPointEvent(MouseEvent event) {
            return event.isPopupTrigger() || SwingUtilities.isRightMouseButton(event);
        }

        public boolean isRemovePointEvent(MouseEvent event) {
            return event.isPopupTrigger() || SwingUtilities.isRightMouseButton(event);
        }

        protected boolean isSourceEditing() {
            return this.source;
        }

        protected boolean isTargetEditing() {
            return this.target;
        }

        protected boolean isEditing() {
            return this.source || this.target || this.label || this.currentLabel >= 0 || this.currentPoint != null;
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            int i;
            for (i = 0; i < this.r.length; ++i) {
                if (!this.r[i].contains(event.getPoint())) continue;
                this.graph.setCursor(new Cursor(1));
                event.consume();
                return;
            }
            if (this.loc.contains(event.getPoint()) && this.graph.isMoveable() && GraphConstants.isMoveable(this.edge.getAllAttributes())) {
                this.graph.setCursor(new Cursor(12));
                event.consume();
            }
            if (this.extraLabelLocations != null && this.graph.isMoveable() && GraphConstants.isMoveable(this.edge.getAllAttributes())) {
                for (i = 0; i < this.extraLabelLocations.length; ++i) {
                    if (!this.extraLabelLocations[i].contains(event.getPoint())) continue;
                    this.graph.setCursor(new Cursor(12));
                    event.consume();
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            int s;
            Rectangle2D rect;
            if (!this.edge.isLeaf()) {
                return;
            }
            boolean bendable = this.graph.isBendable() && GraphConstants.isBendable(this.edge.getAllAttributes());
            int x = event.getX();
            int y = event.getY();
            int index = 0;
            for (index = 0; index < this.r.length; ++index) {
                if (!this.r[index].contains(x, y)) continue;
                if (LEGACY_DISCONNECTABLE) {
                    this.currentPoint = this.edge.getPoint(index);
                    this.currentIndex = index;
                    this.source = index == 0;
                    this.target = index == this.r.length - 1;
                    break;
                }
                if (index > 0 && index < this.r.length - 1 || GraphConstants.isDisconnectable(this.edge.getAllAttributes())) {
                    this.currentPoint = this.edge.getPoint(index);
                    this.currentIndex = index;
                    this.source = index == 0;
                    this.target = index == this.r.length - 1;
                    break;
                }
                event.consume();
            }
            if (!this.isEditing() && this.graph.isMoveable() && GraphConstants.isMoveable(this.edge.getAllAttributes()) && this.loc != null && this.loc.contains(x, y) && !this.isAddPointEvent(event) && !this.isRemovePointEvent(event) && this.graph.getEdgeLabelsMovable()) {
                this.initialLabelLocation = (Point2D)this.edge.getLabelPosition().clone();
                this.label = true;
            } else if (this.extraLabelLocations != null && !this.isEditing() && this.graph.isMoveable() && this.graph.getEdgeLabelsMovable() && GraphConstants.isMoveable(this.edge.getAllAttributes())) {
                for (int i = 0; i < this.extraLabelLocations.length; ++i) {
                    if (this.extraLabelLocations[i] == null || !this.extraLabelLocations[i].contains(x, y)) continue;
                    this.currentLabel = i;
                    this.initialLabelLocation = (Point2D)this.edge.getExtraLabelPosition(this.currentLabel).clone();
                    if (!this.isRemovePointEvent(event)) break;
                    this.edge.removeExtraLabel(i);
                    this.edgeModified = true;
                    this.mouseReleased(event);
                    break;
                }
            }
            if (!(!this.isRemovePointEvent(event) || this.currentPoint == null || this.source || this.target || !bendable || this.edge.getSource() != null && this.currentIndex <= 0 || this.edge.getTarget() != null && this.currentIndex >= this.edge.getPointCount() - 1)) {
                this.edge.removePoint(index);
                this.edgeModified = true;
                this.mouseReleased(event);
            } else if (this.isAddPointEvent(event) && !this.isEditing() && bendable && this.edge.intersects(this.graph, rect = this.graph.fromScreen(new Rectangle(x - (s = this.graph.getHandleSize()), y - s, 2 * s, 2 * s)))) {
                Point2D point = this.graph.fromScreen(this.graph.snap(new Point(event.getPoint())));
                double min = Double.MAX_VALUE;
                double dist = 0.0;
                for (int i = 0; i < this.edge.getPointCount() - 1; ++i) {
                    Point2D p1;
                    Point2D p = this.edge.getPoint(i);
                    dist = new Line2D.Double(p, p1 = this.edge.getPoint(i + 1)).ptSegDistSq(point);
                    if (!(dist < min)) continue;
                    min = dist;
                    index = i + 1;
                }
                this.edge.addPoint(index, point);
                this.edgeModified = true;
                this.currentPoint = point;
                this.reloadPoints(this.edge);
                this.paint(this.graph.getGraphics());
            }
            if (this.isEditing()) {
                event.consume();
            }
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            Rectangle2D dirty = this.edge.getBounds();
            Point2D p = this.graph.fromScreen(new Point(event.getPoint()));
            if (this.label || this.currentLabel >= 0) {
                Rectangle2D r = this.edge.getBounds();
                if (r != null) {
                    this.edgeModified = true;
                    if (this.graph.isXorEnabled()) {
                        this.overlay(this.graph.getGraphics());
                    }
                    if (!GraphConstants.isLabelAlongEdge(this.edge.getAllAttributes())) {
                        p = this.getRelativeLabelPosition(this.edge, p);
                    } else {
                        double x = p.getX();
                        double y = p.getY();
                        Point2D p0 = this.edge.getPoint(0);
                        double p0x = p0.getX();
                        double p0y = p0.getY();
                        Point2D vector = this.edge.getLabelVector();
                        double dx = vector.getX();
                        double dy = vector.getY();
                        double pex = p0.getX() + dx;
                        double pey = p0.getY() + dy;
                        double len = Math.sqrt(dx * dx + dy * dy);
                        if (len > 0.0) {
                            double u = 1000.0;
                            double posy = len * (-y * dx + p0y * dx + x * dy - p0x * dy) / (-pey * dy + p0y * dy - dx * pex + dx * p0x);
                            double posx = u * (-y * pey + y * p0y + p0y * pey - p0y * p0y - pex * x + pex * p0x + p0x * x - p0x * p0x) / (-pey * dy + p0y * dy - dx * pex + dx * p0x);
                            p = new Point2D.Double(posx, posy);
                        } else {
                            p = new Point2D.Double(x - p0.getX(), y - p0.getY());
                        }
                    }
                    if (this.label) {
                        this.edge.setLabelPosition(p);
                    } else {
                        this.edge.setExtraLabelPosition(this.currentLabel, p);
                    }
                    this.edge.update(this.graph.getGraphLayoutCache());
                    if (this.graph.isXorEnabled()) {
                        this.overlay(this.graph.getGraphics());
                    } else {
                        this.graph.repaint((int)dirty.getX() - 1, (int)dirty.getY() - 1, (int)dirty.getWidth() + 2, (int)dirty.getHeight() + 2);
                    }
                }
            } else if (this.isEditing() && this.currentPoint != null) {
                boolean disconnectable;
                boolean bl = disconnectable = !this.source && !this.target || this.graph.isDisconnectable() && GraphConstants.isDisconnectable(this.orig.getAllAttributes());
                if (this.source) {
                    boolean bl2 = disconnectable = disconnectable && (this.orig.getSource() == null && this.orig.getSourceParentView() == null || this.orig.getSource() != null && GraphConstants.isDisconnectable(this.orig.getSource().getParentView().getAllAttributes()) || this.orig.getSourceParentView() != null && GraphConstants.isDisconnectable(this.orig.getSourceParentView().getAllAttributes()));
                }
                if (this.target) {
                    boolean bl3 = disconnectable = disconnectable && (this.orig.getTarget() == null && this.orig.getTargetParentView() == null || this.orig.getTarget() != null && GraphConstants.isDisconnectable(this.orig.getTarget().getParentView().getAllAttributes()) || this.orig.getTargetParentView() != null && GraphConstants.isDisconnectable(this.orig.getTargetParentView().getAllAttributes()));
                }
                if (!(this.source && this.snap(true, event.getPoint()) || this.target && this.snap(false, event.getPoint()) || !disconnectable)) {
                    boolean acceptTarget;
                    boolean acceptSource = this.source && (this.graph.getModel().acceptsSource(this.edge.getCell(), null) || this.graph.isPreviewInvalidNullPorts());
                    boolean bl4 = acceptTarget = this.target && (this.graph.getModel().acceptsTarget(this.edge.getCell(), null) || this.graph.isPreviewInvalidNullPorts());
                    if (acceptSource || acceptTarget || !this.source && !this.target) {
                        this.edgeModified = true;
                        if (this.edge.getSource() != null) {
                            dirty.add(this.edge.getSource().getParentView().getBounds());
                        }
                        if (this.edge.getTarget() != null) {
                            dirty.add(this.edge.getTarget().getParentView().getBounds());
                        }
                        if (this.graph.isXorEnabled()) {
                            this.overlay(this.graph.getGraphics());
                        }
                        p = this.graph.fromScreen(this.graph.snap(new Point(event.getPoint())));
                        if (this.isConstrainedMoveEvent(event) && this.currentIndex >= 0) {
                            EdgeView orig = (EdgeView)this.graph.getGraphLayoutCache().getMapping(this.edge.getCell(), false);
                            Point2D origPoint = orig.getPoint(this.currentIndex);
                            double totDx = p.getX() - origPoint.getX();
                            double totDy = p.getY() - origPoint.getY();
                            if (Math.abs(totDx) < Math.abs(totDy)) {
                                p.setLocation(origPoint.getX(), p.getY());
                            } else {
                                p.setLocation(p.getX(), origPoint.getY());
                            }
                        }
                        p.setLocation(Math.max(0.0, p.getX()), Math.max(0.0, p.getY()));
                        this.currentPoint.setLocation(p);
                        if (this.source) {
                            this.edge.setPoint(0, p);
                            this.edge.setSource(null);
                        } else if (this.target) {
                            this.edge.setPoint(this.edge.getPointCount() - 1, p);
                            this.edge.setTarget(null);
                        }
                        this.edge.update(this.graph.getGraphLayoutCache());
                        dirty.add(this.edge.getBounds());
                        if (this.graph.isXorEnabled()) {
                            this.overlay(this.graph.getGraphics());
                        } else {
                            if (this.edge.getSource() != null) {
                                dirty.add(this.edge.getSource().getParentView().getBounds());
                            }
                            if (this.edge.getTarget() != null) {
                                dirty.add(this.edge.getTarget().getParentView().getBounds());
                            }
                            dirty = this.graph.toScreen((Rectangle2D)dirty.clone());
                            this.graph.repaint((int)dirty.getX(), (int)dirty.getY(), (int)dirty.getWidth(), (int)dirty.getHeight());
                        }
                    }
                } else if (!this.graph.isXorEnabled()) {
                    dirty.add(this.edge.getBounds());
                    dirty = this.graph.toScreen((Rectangle2D)dirty.clone());
                    this.graph.repaint((int)dirty.getX(), (int)dirty.getY(), (int)dirty.getWidth(), (int)dirty.getHeight());
                }
            }
        }

        protected Point2D getRelativeLabelPosition(EdgeView edge, Point2D p) {
            Point2D.Double result;
            Point2D storedRelativePosition;
            Point2D p0;
            int pointCount = edge.getPointCount();
            double totalLength = 0.0;
            double[] segments = new double[pointCount];
            Point2D pt = p0 = edge.getPoint(0);
            for (int i = 1; i < pointCount; ++i) {
                double segment;
                Point2D tmp = edge.getPoint(i);
                if (tmp == null) continue;
                double dx = pt.getX() - tmp.getX();
                double dy = pt.getY() - tmp.getY();
                segments[i - 1] = segment = Math.sqrt(dx * dx + dy * dy);
                totalLength += segment;
                pt = tmp;
            }
            Point2D last = edge.getPoint(1);
            Line2D.Double line = new Line2D.Double(p0, last);
            double minDist = line.ptSegDistSq(p);
            int index = 0;
            double tmp = 0.0;
            double length = 0.0;
            for (int i = 2; i < pointCount; ++i) {
                tmp += segments[i - 2];
                line = new Line2D.Double(edge.getPoint(i), last);
                double dist = line.ptSegDistSq(p);
                if (dist < minDist) {
                    minDist = dist;
                    index = i - 1;
                    length = tmp;
                }
                last = edge.getPoint(i);
            }
            double seg = segments[index];
            pt = edge.getPoint(index);
            double x2 = pt.getX();
            double y2 = pt.getY();
            Point2D pt2 = edge.getPoint(index + 1);
            double x1 = pt2.getX();
            double y1 = pt2.getY();
            double px = p.getX();
            double py = p.getY();
            double xSegment = x2 - x1;
            double ySegment = y2 - y1;
            px -= x1;
            py -= y1;
            double projlenSq = 0.0;
            double dotprod = (px = xSegment - px) * xSegment + (py = ySegment - py) * ySegment;
            projlenSq = dotprod <= 0.0 ? 0.0 : dotprod * dotprod / (xSegment * xSegment + ySegment * ySegment);
            double projlen = Math.sqrt(projlenSq);
            if (projlen > seg) {
                projlen = seg;
            }
            double yDistance = Line2D.ptLineDist(pt2.getX(), pt2.getY(), pt.getX(), pt.getY(), p.getX(), p.getY());
            int direction = Line2D.relativeCCW(pt2.getX(), pt2.getY(), pt.getX(), pt.getY(), p.getX(), p.getY());
            if (direction == -1) {
                yDistance = -yDistance;
            }
            if (p.equals(storedRelativePosition = edge.convertRelativeLabelPositionToAbsolute(result = new Point2D.Double(((totalLength / 2.0 - length - projlen) / totalLength * -2.0 + 1.0) * 1000.0 / 2.0, yDistance)))) {
                GraphConstants.setRemoveAttributes(edge.getAllAttributes(), new Object[]{"offset"});
                edge.getAllAttributes().remove("offset");
            } else {
                Point2D.Double off = new Point2D.Double(p.getX() - storedRelativePosition.getX(), p.getY() - storedRelativePosition.getY());
                GraphConstants.setOffset(edge.getAllAttributes(), off);
            }
            return result;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Object target;
            this.highlight(this.graph, null);
            boolean clone = e.isControlDown() && this.graph.isCloneable();
            GraphModel model = this.graph.getModel();
            Object source = this.edge.getSource() != null ? this.edge.getSource().getCell() : null;
            Object object = target = this.edge.getTarget() != null ? this.edge.getTarget().getCell() : null;
            if (this.edgeModified && model.acceptsSource(this.edge.getCell(), source) && model.acceptsTarget(this.edge.getCell(), target)) {
                List currentPoints;
                if (clone && this.initialLabelLocation != null) {
                    Object value = null;
                    Point2D location = null;
                    Object[] extraLabels = GraphConstants.getExtraLabels(this.edge.getAllAttributes());
                    if (this.label) {
                        location = (Point2D)this.edge.getLabelPosition().clone();
                        value = this.graph.convertValueToString(this.orig);
                        this.edge.setLabelPosition(this.initialLabelLocation);
                    } else {
                        location = (Point2D)this.edge.getExtraLabelPosition(this.currentLabel).clone();
                        value = extraLabels[this.currentLabel];
                        this.edge.setExtraLabelPosition(this.currentLabel, this.initialLabelLocation);
                    }
                    this.edge.addExtraLabel(location, value);
                    this.edge.update(this.graph.getGraphLayoutCache());
                    clone = false;
                }
                ConnectionSet cs = this.createConnectionSet(this.edge, clone);
                Map nested = GraphConstants.createAttributes(new CellView[]{this.edge}, null);
                Map tmp = (Map)nested.get(this.edge.getCell());
                List controlPoints = GraphConstants.getPoints(tmp);
                if (controlPoints != (currentPoints = this.edge.getPoints())) {
                    controlPoints.set(0, this.edge.getPoint(0));
                    controlPoints.set(controlPoints.size() - 1, this.edge.getPoint(this.edge.getPointCount() - 1));
                }
                if (clone) {
                    Map cellMap = this.graph.cloneCells(this.graph.getDescendants(new Object[]{this.edge.getCell()}));
                    this.processNestedMap(nested, true);
                    nested = GraphConstants.replaceKeys(cellMap, nested);
                    cs = cs.clone(cellMap);
                    Object[] cells = cellMap.values().toArray();
                    this.graph.getGraphLayoutCache().insert(cells, nested, cs, null, null);
                } else {
                    this.processNestedMap(nested, false);
                    this.graph.getGraphLayoutCache().edit(nested, cs, null, null);
                }
            } else {
                if (this.graph.isXorEnabled()) {
                    this.overlay(this.graph.getGraphics());
                } else {
                    Rectangle2D dirty = this.edge.getBounds();
                    this.graph.repaint((int)dirty.getX(), (int)dirty.getY(), (int)dirty.getWidth(), (int)dirty.getHeight());
                }
                this.edge.refresh(this.graph.getGraphLayoutCache(), this.graph.getGraphLayoutCache(), false);
            }
            this.initialLabelLocation = null;
            this.currentPoint = null;
            this.edgeModified = false;
            this.label = false;
            this.source = false;
            this.target = false;
            this.currentLabel = -1;
            this.currentIndex = -1;
            this.firstOverlayCall = true;
            e.consume();
        }

        protected void processNestedMap(Map nested, boolean clone) {
        }

        protected ConnectionSet createConnectionSet(EdgeView view, boolean verbose) {
            Object edge = view.getCell();
            GraphModel model = this.graph.getModel();
            ConnectionSet cs = new ConnectionSet();
            Object sourcePort = null;
            Object targetPort = null;
            if (view.getSource() != null) {
                sourcePort = view.getSource().getCell();
            } else if (view.getSourceParentView() != null) {
                sourcePort = model.getSource(edge);
            }
            if (view.getTarget() != null) {
                targetPort = view.getTarget().getCell();
            } else if (view.getTargetParentView() != null) {
                targetPort = model.getTarget(edge);
            }
            if (view.getTarget() != null) {
                targetPort = view.getTarget().getCell();
            }
            if (verbose || sourcePort != model.getSource(edge) && this.source) {
                cs.connect(edge, sourcePort, true);
            }
            if (verbose || targetPort != model.getTarget(edge) && this.target) {
                cs.connect(edge, targetPort, false);
            }
            return cs;
        }

        protected void invalidate() {
            int i;
            EdgeView e = this.relevantEdge;
            int handlesize = this.graph.getHandleSize();
            EdgeRenderer er = (EdgeRenderer)this.edge.getRenderer();
            Point2D labelPosition = er.getLabelPosition(e);
            Point2D p = null;
            if (labelPosition != null) {
                p = (Point2D)labelPosition.clone();
                this.graph.toScreen(p);
            }
            Dimension d = er.getLabelSize(e, this.graph.convertValueToString(e));
            if (p != null && d != null) {
                Point2D s = this.graph.toScreen(new Point2D.Double(d.width, d.height));
                this.loc.setFrame(p.getX() - s.getX() / 2.0, p.getY() - s.getY() / 2.0, s.getX(), s.getY());
            }
            for (i = 0; i < this.r.length; ++i) {
                p = e.getPoint(i);
                p = this.graph.toScreen(new Point2D.Double(p.getX(), p.getY()));
                this.r[i].setFrame(p.getX() - (double)handlesize, p.getY() - (double)handlesize, 2 * handlesize, 2 * handlesize);
            }
            if (this.extraLabelLocations != null) {
                for (i = 0; i < this.extraLabelLocations.length; ++i) {
                    p = er.getExtraLabelPosition(e, i);
                    if (p == null) continue;
                    p = this.graph.toScreen((Point2D)p.clone());
                    d = er.getExtraLabelSize(this.graph, e, i);
                    if (d == null) continue;
                    Point2D s = this.graph.toScreen(new Point2D.Double(d.width, d.height));
                    this.extraLabelLocations[i].setFrame(p.getX() - s.getX() / 2.0, p.getY() - s.getY() / 2.0, s.getX(), s.getY());
                }
            }
        }
    }
}

