/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import org.jgraph.event.GraphLayoutCacheEvent;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.BasicMarqueeHandler;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultCellViewFactory;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultGraphSelectionModel;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphSelectionModel;
import org.jgraph.graph.PortView;
import org.jgraph.plaf.GraphUI;
import org.jgraph.plaf.basic.BasicGraphUI;

public class JGraph
extends JComponent
implements Scrollable,
Accessible,
Serializable {
    public static final String VERSION = "JGraph (v5.13.0.0)";
    public static final int DOT_GRID_MODE = 0;
    public static final int CROSS_GRID_MODE = 1;
    public static final int LINE_GRID_MODE = 2;
    public static boolean IS_MAC = false;
    private static final String uiClassID = "GraphUI";
    protected transient GraphSelectionRedirector selectionRedirector;
    protected transient GraphModel graphModel;
    protected transient GraphLayoutCache graphLayoutCache;
    protected transient GraphSelectionModel selectionModel;
    protected transient BasicMarqueeHandler marquee;
    protected transient Image offscreen;
    protected transient Rectangle2D offscreenBounds;
    protected transient Point2D offscreenOffset;
    protected transient Graphics offgraphics;
    protected transient Rectangle2D offscreenDirty = null;
    protected transient boolean wholeOffscreenDirty = false;
    protected transient double wholeOffscreenDirtyProportion = 0.8;
    protected transient int offscreenBuffer = 300;
    protected boolean volatileOffscreen = false;
    protected boolean lastBufferAllocated = true;
    protected ImageIcon backgroundImage;
    protected Component backgroundComponent;
    protected boolean backgroundScaled = true;
    protected double scale = 1.0;
    protected boolean antiAliased = false;
    protected boolean editable = true;
    protected boolean groupsEditable = false;
    protected boolean selectionEnabled = true;
    protected boolean previewInvalidNullPorts = true;
    protected boolean gridVisible = false;
    protected double gridSize = 10.0;
    protected int gridMode = 0;
    protected boolean portsVisible = false;
    protected boolean portsScaled = true;
    protected boolean portsOnTop = true;
    protected boolean moveBelowZero = false;
    protected boolean moveBeyondGraphBounds = true;
    protected boolean edgeLabelsMovable = true;
    protected boolean autoResizeGraph = true;
    protected Color highlightColor = Color.green;
    protected Color handleColor;
    protected Color lockedHandleColor;
    protected Color marqueeColor;
    protected Color gridColor;
    protected boolean dragEnabled = false;
    protected boolean dropEnabled = true;
    protected boolean xorEnabled = !IS_MAC;
    protected int editClickCount = 2;
    protected boolean enabled = true;
    protected boolean gridEnabled = false;
    protected int handleSize = 3;
    protected int tolerance = 4;
    protected int minimumMove = 5;
    protected boolean isJumpToDefaultPort = false;
    protected boolean isMoveIntoGroups = false;
    protected boolean isMoveOutOfGroups = false;
    protected boolean disconnectOnMove = false;
    protected boolean moveable = true;
    protected boolean cloneable = false;
    protected boolean sizeable = true;
    protected boolean bendable = true;
    protected boolean connectable = true;
    protected boolean disconnectable = true;
    protected boolean invokesStopCellEditing;
    public static final String GRAPH_MODEL_PROPERTY = "model";
    public static final String GRAPH_LAYOUT_CACHE_PROPERTY = "view";
    public static final String MARQUEE_HANDLER_PROPERTY = "marquee";
    public static final String EDITABLE_PROPERTY = "editable";
    public static final String SELECTIONENABLED_PROPERTY = "selectionEnabled";
    public static final String SCALE_PROPERTY = "scale";
    public static final String ANTIALIASED_PROPERTY = "antiAliased";
    public static final String GRID_SIZE_PROPERTY = "gridSize";
    public static final String GRID_VISIBLE_PROPERTY = "gridVisible";
    public static final String GRID_COLOR_PROPERTY = "gridColor";
    public static final String HANDLE_COLOR_PROPERTY = "handleColor";
    public static final String HANDLE_SIZE_PROPERTY = "handleSize";
    public static final String LOCKED_HANDLE_COLOR_PROPERTY = "lockedHandleColor";
    public static final String PORTS_VISIBLE_PROPERTY = "portsVisible";
    public static final String PORTS_SCALED_PROPERTY = "portsScaled";
    public static final String SELECTION_MODEL_PROPERTY = "selectionModel";
    public static final String INVOKES_STOP_CELL_EDITING_PROPERTY = "invokesStopCellEditing";
    public static final String PROPERTY_BACKGROUNDIMAGE = "backgroundImage";

    public static void addSampleData(GraphModel model) {
        ConnectionSet cs = new ConnectionSet();
        Hashtable<DefaultGraphCell, Map> attributes = new Hashtable<DefaultGraphCell, Map>();
        AttributeMap implementStyle = new AttributeMap();
        GraphConstants.setLineBegin(implementStyle, 2);
        GraphConstants.setBeginSize(implementStyle, 10);
        GraphConstants.setDashPattern(implementStyle, new float[]{3.0f, 3.0f});
        if (GraphConstants.DEFAULTFONT != null) {
            GraphConstants.setFont(implementStyle, GraphConstants.DEFAULTFONT.deriveFont(10));
        }
        AttributeMap extendStyle = new AttributeMap();
        GraphConstants.setLineBegin(extendStyle, 2);
        GraphConstants.setBeginFill(extendStyle, true);
        GraphConstants.setBeginSize(extendStyle, 10);
        if (GraphConstants.DEFAULTFONT != null) {
            GraphConstants.setFont(extendStyle, GraphConstants.DEFAULTFONT.deriveFont(10));
        }
        AttributeMap aggregateStyle = new AttributeMap();
        GraphConstants.setLineBegin(aggregateStyle, 9);
        GraphConstants.setBeginFill(aggregateStyle, true);
        GraphConstants.setBeginSize(aggregateStyle, 6);
        GraphConstants.setLineEnd(aggregateStyle, 4);
        GraphConstants.setEndSize(aggregateStyle, 8);
        GraphConstants.setLabelPosition(aggregateStyle, new Point2D.Double(500.0, 0.0));
        if (GraphConstants.DEFAULTFONT != null) {
            GraphConstants.setFont(aggregateStyle, GraphConstants.DEFAULTFONT.deriveFont(10));
        }
        DefaultGraphCell gm = new DefaultGraphCell("GraphModel");
        attributes.put(gm, JGraph.createBounds(new AttributeMap(), 20, 100, Color.blue));
        gm.addPort(null, "GraphModel/Center");
        DefaultGraphCell dgm = new DefaultGraphCell("DefaultGraphModel");
        attributes.put(dgm, JGraph.createBounds(new AttributeMap(), 20, 180, Color.blue));
        dgm.addPort(null, "DefaultGraphModel/Center");
        DefaultEdge dgmImplementsGm = new DefaultEdge("implements");
        cs.connect((Object)dgmImplementsGm, (Object)gm.getChildAt(0), dgm.getChildAt(0));
        attributes.put(dgmImplementsGm, implementStyle);
        DefaultGraphCell modelGroup = new DefaultGraphCell("ModelGroup");
        modelGroup.add(gm);
        modelGroup.add(dgm);
        modelGroup.add(dgmImplementsGm);
        DefaultGraphCell jc = new DefaultGraphCell("JComponent");
        attributes.put(jc, JGraph.createBounds(new AttributeMap(), 180, 20, Color.green));
        jc.addPort(null, "JComponent/Center");
        DefaultGraphCell jg = new DefaultGraphCell("JGraph");
        attributes.put(jg, JGraph.createBounds(new AttributeMap(), 180, 100, Color.green));
        jg.addPort(null, "JGraph/Center");
        DefaultEdge jgExtendsJc = new DefaultEdge("extends");
        cs.connect((Object)jgExtendsJc, (Object)jc.getChildAt(0), jg.getChildAt(0));
        attributes.put(jgExtendsJc, extendStyle);
        DefaultGraphCell cu = new DefaultGraphCell("ComponentUI");
        attributes.put(cu, JGraph.createBounds(new AttributeMap(), 340, 20, Color.red));
        cu.addPort(null, "ComponentUI/Center");
        DefaultGraphCell gu = new DefaultGraphCell(uiClassID);
        attributes.put(gu, JGraph.createBounds(new AttributeMap(), 340, 100, Color.red));
        gu.addPort(null, "GraphUI/Center");
        DefaultGraphCell dgu = new DefaultGraphCell("BasicGraphUI");
        attributes.put(dgu, JGraph.createBounds(new AttributeMap(), 340, 180, Color.red));
        dgu.addPort(null, "BasicGraphUI/Center");
        DefaultEdge guExtendsCu = new DefaultEdge("extends");
        cs.connect((Object)guExtendsCu, (Object)cu.getChildAt(0), gu.getChildAt(0));
        attributes.put(guExtendsCu, extendStyle);
        DefaultEdge dguImplementsDu = new DefaultEdge("implements");
        cs.connect((Object)dguImplementsDu, (Object)gu.getChildAt(0), dgu.getChildAt(0));
        attributes.put(dguImplementsDu, implementStyle);
        DefaultGraphCell uiGroup = new DefaultGraphCell("UIGroup");
        uiGroup.add(cu);
        uiGroup.add(gu);
        uiGroup.add(dgu);
        uiGroup.add(dguImplementsDu);
        uiGroup.add(guExtendsCu);
        DefaultEdge jgAggregatesGm = new DefaultEdge(GRAPH_MODEL_PROPERTY);
        cs.connect((Object)jgAggregatesGm, (Object)jg.getChildAt(0), gm.getChildAt(0));
        attributes.put(jgAggregatesGm, aggregateStyle);
        DefaultEdge jcAggregatesCu = new DefaultEdge("ui");
        cs.connect((Object)jcAggregatesCu, (Object)jc.getChildAt(0), cu.getChildAt(0));
        attributes.put(jcAggregatesCu, aggregateStyle);
        Object[] cells = new Object[]{jgAggregatesGm, jcAggregatesCu, modelGroup, jc, jg, jgExtendsJc, uiGroup};
        model.insert(cells, attributes, cs, null, null);
    }

    public static Map createBounds(AttributeMap map, int x, int y, Color c) {
        GraphConstants.setBounds(map, map.createRect(x, y, 90.0, 30.0));
        GraphConstants.setBorder(map, BorderFactory.createRaisedBevelBorder());
        GraphConstants.setBackground(map, c.darker().darker());
        GraphConstants.setGradientColor(map, c.brighter().brighter().brighter());
        GraphConstants.setForeground(map, Color.white);
        if (GraphConstants.DEFAULTFONT != null) {
            GraphConstants.setFont(map, GraphConstants.DEFAULTFONT.deriveFont(1, 12.0f));
        }
        GraphConstants.setOpaque(map, true);
        return map;
    }

    public JGraph() {
        this((GraphModel)null);
    }

    public JGraph(GraphModel model) {
        this(model, (GraphLayoutCache)null);
    }

    public JGraph(GraphLayoutCache cache) {
        this(cache != null ? cache.getModel() : null, cache);
    }

    public JGraph(GraphModel model, GraphLayoutCache cache) {
        this(model, cache, new BasicMarqueeHandler());
    }

    public JGraph(GraphModel model, BasicMarqueeHandler mh) {
        this(model, null, mh);
    }

    public JGraph(GraphModel model, GraphLayoutCache layoutCache, BasicMarqueeHandler mh) {
        this.setDoubleBuffered(true);
        this.selectionModel = new DefaultGraphSelectionModel(this);
        this.setLayout(null);
        this.marquee = mh;
        if (model == null) {
            model = new DefaultGraphModel();
            this.setModel(model);
            JGraph.addSampleData(model);
        } else {
            this.setModel(model);
        }
        if (layoutCache == null) {
            layoutCache = new GraphLayoutCache(model, new DefaultCellViewFactory());
        }
        this.setGraphLayoutCache(layoutCache);
        this.updateUI();
    }

    @Override
    public GraphUI getUI() {
        return (GraphUI)this.ui;
    }

    public void setUI(GraphUI ui) {
        if ((GraphUI)this.ui != ui) {
            super.setUI(ui);
        }
    }

    @Override
    public void updateUI() {
        this.setUI(new BasicGraphUI());
        this.invalidate();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public Object[] getRoots() {
        return DefaultGraphModel.getRoots(this.graphModel);
    }

    public Object[] getRoots(Rectangle clip) {
        CellView[] views = this.graphLayoutCache.getRoots(clip);
        Object[] cells = new Object[views.length];
        for (int i = 0; i < views.length; ++i) {
            cells[i] = views[i].getCell();
        }
        return cells;
    }

    public Object[] getDescendants(Object[] cells) {
        return DefaultGraphModel.getDescendants(this.getModel(), cells).toArray();
    }

    public Object[] order(Object[] cells) {
        return DefaultGraphModel.order(this.getModel(), cells);
    }

    public Map cloneCells(Object[] cells) {
        return this.graphModel.cloneCells(cells);
    }

    public CellView getTopmostViewAt(double x, double y, boolean reverse, boolean leafsOnly) {
        int i;
        Rectangle2D.Double r = new Rectangle2D.Double(x, y, 1.0, 1.0);
        Object[] cells = this.getDescendants(this.getRoots());
        int n = i = reverse ? cells.length - 1 : 0;
        while (i >= 0 && i < cells.length) {
            CellView view = this.getGraphLayoutCache().getMapping(cells[i], false);
            if (view != null && (!leafsOnly || view.isLeaf()) && (view.isLeaf() && view.intersects(this, r) || !view.isLeaf() && view.getBounds().contains(x, y))) {
                return view;
            }
            i += reverse ? -1 : 1;
        }
        return null;
    }

    public Object getFirstCellForLocation(double x, double y) {
        return this.getNextCellForLocation(null, x, y);
    }

    public Object getNextCellForLocation(Object current, double x, double y) {
        CellView cur = this.graphLayoutCache.getMapping(current, false);
        CellView cell = this.getNextViewAt(cur, x, y);
        if (cell != null) {
            return cell.getCell();
        }
        return null;
    }

    public Rectangle2D getCellBounds(Object cell) {
        CellView view = this.graphLayoutCache.getMapping(cell, false);
        if (view != null) {
            return view.getBounds();
        }
        return null;
    }

    public Rectangle2D getCellBounds(Object[] cells) {
        if (cells != null && cells.length > 0) {
            Rectangle2D r = this.getCellBounds(cells[0]);
            Rectangle2D ret = r != null ? (Rectangle2D)r.clone() : null;
            for (int i = 1; i < cells.length; ++i) {
                r = this.getCellBounds(cells[i]);
                if (r == null) continue;
                if (ret == null) {
                    ret = r != null ? (Rectangle2D)r.clone() : null;
                    continue;
                }
                Rectangle2D.union(ret, r, ret);
            }
            return ret;
        }
        return null;
    }

    public CellView getNextViewAt(CellView current, double x, double y) {
        return this.getNextViewAt(current, x, y, false);
    }

    public CellView getNextViewAt(CellView current, double x, double y, boolean leafsOnly) {
        CellView[] cells = AbstractCellView.getDescendantViews(this.getGraphLayoutCache().getRoots());
        return this.getNextViewAt(cells, current, x, y, leafsOnly);
    }

    public CellView getNextSelectableViewAt(CellView current, double x, double y) {
        CellView[] selectables = this.getGraphLayoutCache().getMapping(this.getSelectionModel().getSelectables(), false);
        return this.getNextViewAt(selectables, current, x, y);
    }

    public CellView getNextViewAt(CellView[] cells, CellView c, double x, double y) {
        return this.getNextViewAt(cells, c, x, y, false);
    }

    public CellView getNextViewAt(CellView[] cells, CellView c, double x, double y, boolean leafsOnly) {
        if (cells != null) {
            Rectangle2D r = this.fromScreen(new Rectangle2D.Double(x - (double)this.tolerance, y - (double)this.tolerance, 2 * this.tolerance, 2 * this.tolerance));
            if (r.getWidth() < 1.0) {
                r.setFrame(r.getX(), r.getY(), 1.0, r.getHeight());
            }
            if (r.getHeight() < 1.0) {
                r.setFrame(r.getX(), r.getY(), r.getWidth(), 1.0);
            }
            CellView first = null;
            boolean active = c == null;
            for (int i = 0; i < cells.length; ++i) {
                if (cells[i] == null || leafsOnly && !cells[i].isLeaf() || !cells[i].intersects(this, r)) continue;
                if (active && !this.selectionModel.isChildrenSelected(cells[i].getCell())) {
                    return cells[i];
                }
                if (first == null) {
                    first = cells[i];
                }
                active |= cells[i] == c;
            }
            return first;
        }
        return null;
    }

    public CellView getLeafViewAt(double x, double y) {
        return this.getNextViewAt(null, x, y, true);
    }

    public Object getPortForLocation(double x, double y) {
        PortView view = this.getPortViewAt(x, y, this.tolerance);
        if (view != null) {
            return view.getCell();
        }
        return null;
    }

    public PortView getPortViewAt(double x, double y) {
        return this.getPortViewAt(x, y, this.tolerance);
    }

    public PortView getPortViewAt(double x, double y, int tolerance) {
        double sx = x / this.scale;
        double sy = y / this.scale;
        Rectangle2D.Double r = new Rectangle2D.Double(sx - (double)tolerance, sy - (double)tolerance, 2 * tolerance, 2 * tolerance);
        PortView[] ports = this.graphLayoutCache.getPorts();
        if (ports != null) {
            for (int i = ports.length - 1; i >= 0; --i) {
                if (ports[i] == null || !ports[i].intersects(this, r)) continue;
                return ports[i];
            }
            if (this.isJumpToDefaultPort()) {
                CellView cellView = this.getNextViewAt(null, x, y, true);
                if (cellView != null && this.graphModel.isEdge(cellView.getCell())) {
                    CellView nextView = this.getNextViewAt(cellView, x, y, true);
                    while (nextView != cellView && this.graphModel.isEdge(nextView.getCell())) {
                        nextView = this.getNextViewAt(nextView, x, y, true);
                    }
                    cellView = nextView;
                }
                if (cellView != null) {
                    PortView defaultPort = this.getDefaultPortForCell(cellView.getCell());
                    return defaultPort;
                }
            }
        }
        return null;
    }

    public PortView getDefaultPortForCell(Object cell) {
        if (cell != null && !this.getModel().isEdge(cell)) {
            int childCount = this.getModel().getChildCount(cell);
            for (int i = 0; i < childCount; ++i) {
                Point2D offset;
                Object childCell = this.getModel().getChild(cell, i);
                CellView child = this.getGraphLayoutCache().getMapping(childCell, false);
                if (!(child instanceof PortView) || (offset = GraphConstants.getOffset(child.getAllAttributes())) != null && childCount != 1) continue;
                return (PortView)child;
            }
        }
        return null;
    }

    public String convertValueToString(Object value) {
        if (value instanceof CellView) {
            value = ((CellView)value).getCell();
        }
        return String.valueOf(value);
    }

    public Point2D snap(Point2D p) {
        if (this.gridEnabled && p != null) {
            double sgs = this.gridSize * this.getScale();
            p.setLocation(Math.round((double)Math.round(p.getX() / sgs) * sgs), Math.round((double)Math.round(p.getY() / sgs) * sgs));
        }
        return p;
    }

    public Rectangle2D snap(Rectangle2D r) {
        if (this.gridEnabled && r != null) {
            double sgs = this.gridSize * this.getScale();
            r.setFrame(Math.round((double)Math.round(r.getX() / sgs) * sgs), Math.round((double)Math.round(r.getY() / sgs) * sgs), 1L + Math.round((double)Math.round(r.getWidth() / sgs) * sgs), 1L + Math.round((double)Math.round(r.getHeight() / sgs) * sgs));
        }
        return r;
    }

    public Dimension2D snap(Dimension2D d) {
        if (this.gridEnabled && d != null) {
            double sgs = this.gridSize * this.getScale();
            d.setSize(1L + Math.round((double)Math.round(d.getWidth() / sgs) * sgs), 1L + Math.round((double)Math.round(d.getHeight() / sgs) * sgs));
        }
        return d;
    }

    public Point2D toScreen(Point2D p) {
        if (p == null) {
            return null;
        }
        p.setLocation(Math.round(p.getX() * this.scale), Math.round(p.getY() * this.scale));
        return p;
    }

    public Point2D fromScreen(Point2D p) {
        if (p == null) {
            return null;
        }
        p.setLocation(Math.round(p.getX() / this.scale), Math.round(p.getY() / this.scale));
        return p;
    }

    public Rectangle2D toScreen(Rectangle2D rect) {
        if (rect == null) {
            return null;
        }
        rect.setFrame(rect.getX() * this.scale, rect.getY() * this.scale, rect.getWidth() * this.scale, rect.getHeight() * this.scale);
        return rect;
    }

    public Rectangle2D fromScreen(Rectangle2D rect) {
        if (rect == null) {
            return null;
        }
        rect.setFrame(rect.getX() / this.scale, rect.getY() / this.scale, rect.getWidth() / this.scale, rect.getHeight() / this.scale);
        return rect;
    }

    public void updateAutoSize(CellView view) {
        if (view != null && !this.isEditing()) {
            Rectangle2D bounds = view.getAttributes() != null ? GraphConstants.getBounds(view.getAttributes()) : null;
            AttributeMap attrs = this.getModel().getAttributes(view.getCell());
            if (bounds == null) {
                bounds = GraphConstants.getBounds(attrs);
            }
            if (bounds != null) {
                boolean autosize = GraphConstants.isAutoSize(view.getAllAttributes());
                boolean resize = GraphConstants.isResize(view.getAllAttributes());
                if (autosize || resize) {
                    Dimension2D d = this.getUI().getPreferredSize(this, view);
                    bounds.setFrame(bounds.getX(), bounds.getY(), d.getWidth(), d.getHeight());
                    this.snap(bounds);
                    if (resize) {
                        if (view.getAttributes() != null) {
                            view.getAttributes().remove("resize");
                        }
                        attrs.remove("resize");
                    }
                    view.refresh(this.getGraphLayoutCache(), this.getGraphLayoutCache(), false);
                }
            }
        }
    }

    public AttributeMap getAttributes(Object cell) {
        CellView cellView = this.getGraphLayoutCache().getMapping(cell, false);
        AttributeMap attrs = cellView != null ? cellView.getAllAttributes() : this.getModel().getAttributes(cell);
        return attrs;
    }

    public int getEditClickCount() {
        return this.editClickCount;
    }

    public void setEditClickCount(int count) {
        this.editClickCount = count;
    }

    public boolean isDropEnabled() {
        return this.dropEnabled;
    }

    public void setDropEnabled(boolean flag) {
        this.dropEnabled = flag;
    }

    public boolean isXorEnabled() {
        return this.xorEnabled && this.isOpaque();
    }

    public void setXorEnabled(boolean flag) {
        this.xorEnabled = flag;
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean flag) {
        this.dragEnabled = flag;
    }

    public boolean isMoveable() {
        return this.moveable;
    }

    public void setMoveable(boolean flag) {
        this.moveable = flag;
    }

    public boolean isBendable() {
        return this.bendable;
    }

    public void setBendable(boolean flag) {
        this.bendable = flag;
    }

    public boolean isConnectable() {
        return this.connectable;
    }

    public void setConnectable(boolean flag) {
        this.connectable = flag;
    }

    public boolean isDisconnectable() {
        return this.disconnectable;
    }

    public void setDisconnectable(boolean flag) {
        this.disconnectable = flag;
    }

    public boolean isCloneable() {
        return this.cloneable;
    }

    public void setCloneable(boolean flag) {
        this.cloneable = flag;
    }

    public boolean isSizeable() {
        return this.sizeable;
    }

    public void setSizeable(boolean flag) {
        this.sizeable = flag;
    }

    public void setDisconnectOnMove(boolean flag) {
        this.disconnectOnMove = flag;
    }

    public boolean isDisconnectOnMove() {
        return this.disconnectOnMove && this.disconnectable;
    }

    public void setJumpToDefaultPort(boolean flag) {
        this.isJumpToDefaultPort = flag;
    }

    public boolean isJumpToDefaultPort() {
        return this.isJumpToDefaultPort;
    }

    public void setMoveIntoGroups(boolean flag) {
        this.isMoveIntoGroups = flag;
    }

    public boolean isMoveIntoGroups() {
        return this.isMoveIntoGroups;
    }

    public void setMoveOutOfGroups(boolean flag) {
        this.isMoveOutOfGroups = flag;
    }

    public boolean isMoveOutOfGroups() {
        return this.isMoveOutOfGroups;
    }

    public boolean isGridEnabled() {
        return this.gridEnabled;
    }

    public void setGridEnabled(boolean flag) {
        this.gridEnabled = flag;
    }

    public boolean isMoveBelowZero() {
        return this.moveBelowZero;
    }

    public void setMoveBelowZero(boolean moveBelowZero) {
        this.moveBelowZero = moveBelowZero;
    }

    public boolean isMoveBeyondGraphBounds() {
        return this.moveBeyondGraphBounds;
    }

    public void setMoveBeyondGraphBounds(boolean moveBeyondGraphBounds) {
        this.moveBeyondGraphBounds = moveBeyondGraphBounds;
    }

    public boolean getEdgeLabelsMovable() {
        return this.edgeLabelsMovable;
    }

    public void setEdgeLabelsMovable(boolean edgeLabelsMovable) {
        this.edgeLabelsMovable = edgeLabelsMovable;
    }

    public boolean isAutoResizeGraph() {
        if (!this.moveBeyondGraphBounds) {
            return false;
        }
        return this.autoResizeGraph;
    }

    public void setAutoResizeGraph(boolean autoResizeGraph) {
        this.autoResizeGraph = autoResizeGraph;
    }

    public int getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(int size) {
        if (size < 1) {
            size = 1;
        }
        this.tolerance = size;
    }

    public int getHandleSize() {
        return this.handleSize;
    }

    public void setHandleSize(int size) {
        int oldValue = this.handleSize;
        this.handleSize = size;
        this.firePropertyChange(HANDLE_SIZE_PROPERTY, oldValue, size);
    }

    public int getMinimumMove() {
        return this.minimumMove;
    }

    public void setMinimumMove(int pixels) {
        this.minimumMove = pixels;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color newColor) {
        Color oldValue = this.gridColor;
        this.gridColor = newColor;
        this.firePropertyChange(GRID_COLOR_PROPERTY, oldValue, newColor);
    }

    public Color getHandleColor() {
        return this.handleColor;
    }

    public void setHandleColor(Color newColor) {
        Color oldValue = this.handleColor;
        this.handleColor = newColor;
        this.firePropertyChange(HANDLE_COLOR_PROPERTY, oldValue, newColor);
    }

    public Color getLockedHandleColor() {
        return this.lockedHandleColor;
    }

    public void setLockedHandleColor(Color newColor) {
        Color oldValue = this.lockedHandleColor;
        this.lockedHandleColor = newColor;
        this.firePropertyChange(LOCKED_HANDLE_COLOR_PROPERTY, oldValue, newColor);
    }

    public Color getMarqueeColor() {
        return this.marqueeColor;
    }

    public void setMarqueeColor(Color newColor) {
        this.marqueeColor = newColor;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color newColor) {
        this.highlightColor = newColor;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double newValue) {
        Point2D centerPoint = this.getCenterPoint();
        this.setScale(newValue, centerPoint);
    }

    public void setScale(double newValue, Point2D center) {
        if (newValue > 0.0 && newValue != this.scale) {
            Rectangle2D view = this.getViewPortBounds();
            double oldValue = this.scale;
            this.scale = newValue;
            boolean zoomIn = true;
            Rectangle newView = null;
            this.clearOffscreen();
            if (view != null) {
                double scaleRatio = newValue / oldValue;
                int newCenterX = (int)(center.getX() * scaleRatio);
                int newCenterY = (int)(center.getY() * scaleRatio);
                int newX = (int)((double)newCenterX - view.getWidth() / 2.0);
                int newY = (int)((double)newCenterY - view.getHeight() / 2.0);
                newView = new Rectangle(newX, newY, (int)view.getWidth(), (int)view.getHeight());
                if (scaleRatio < 1.0) {
                    this.scrollRectToVisible(newView);
                    zoomIn = false;
                }
            }
            this.firePropertyChange(SCALE_PROPERTY, oldValue, newValue);
            if (zoomIn && newView != null) {
                this.scrollRectToVisible(newView);
            }
        }
    }

    public void clearOffscreen() {
        if (this.offscreen != null) {
            int h = this.offscreen.getHeight(this);
            int w = this.offscreen.getWidth(this);
            Rectangle2D.Double dirtyRegion = new Rectangle2D.Double(0.0, 0.0, w, h);
            this.fromScreen(dirtyRegion);
            this.addOffscreenDirty(dirtyRegion);
        }
    }

    public Point2D getCenterPoint() {
        Rectangle2D viewBounds = this.getViewPortBounds();
        if (viewBounds != null) {
            return new Point2D.Double(viewBounds.getCenterX(), viewBounds.getCenterY());
        }
        viewBounds = this.getBounds();
        return new Point2D.Double(viewBounds.getCenterX(), viewBounds.getCenterY());
    }

    public Rectangle2D getViewPortBounds() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getViewRect();
        }
        return null;
    }

    public double getGridSize() {
        return this.gridSize;
    }

    public int getGridMode() {
        return this.gridMode;
    }

    public void setGridSize(double newSize) {
        double oldValue = this.gridSize;
        this.gridSize = newSize;
        this.firePropertyChange(GRID_SIZE_PROPERTY, oldValue, newSize);
    }

    public void setGridMode(int mode) {
        if (mode == 0 || mode == 1 || mode == 2) {
            this.gridMode = mode;
            this.repaint();
        }
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public void setGridVisible(boolean flag) {
        boolean oldValue = this.gridVisible;
        this.gridVisible = flag;
        if (flag != oldValue) {
            this.clearOffscreen();
        }
        this.firePropertyChange(GRID_VISIBLE_PROPERTY, oldValue, flag);
    }

    public boolean isPortsVisible() {
        return this.portsVisible;
    }

    public void setPortsVisible(boolean flag) {
        boolean oldValue = this.portsVisible;
        this.portsVisible = flag;
        if (flag != oldValue) {
            this.clearOffscreen();
        }
        this.firePropertyChange(PORTS_VISIBLE_PROPERTY, oldValue, flag);
    }

    public boolean isPortsScaled() {
        return this.portsScaled;
    }

    public void setPortsScaled(boolean flag) {
        boolean oldValue = this.portsScaled;
        this.portsScaled = flag;
        this.firePropertyChange(PORTS_SCALED_PROPERTY, oldValue, flag);
    }

    public boolean isPortsOnTop() {
        return this.portsOnTop;
    }

    public void setPortsOnTop(boolean portsOnTop) {
        this.portsOnTop = portsOnTop;
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public void setAntiAliased(boolean newValue) {
        boolean oldValue = this.antiAliased;
        this.antiAliased = newValue;
        this.firePropertyChange(ANTIALIASED_PROPERTY, oldValue, newValue);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean flag) {
        boolean oldValue = this.editable;
        this.editable = flag;
        this.firePropertyChange(EDITABLE_PROPERTY, oldValue, flag);
    }

    public boolean isGroupsEditable() {
        return this.groupsEditable;
    }

    public void setGroupsEditable(boolean groupsEditable) {
        this.groupsEditable = groupsEditable;
    }

    public boolean isSelectionEnabled() {
        return this.selectionEnabled;
    }

    public void setSelectionEnabled(boolean flag) {
        boolean oldValue = this.selectionEnabled;
        this.selectionEnabled = flag;
        this.firePropertyChange(SELECTIONENABLED_PROPERTY, oldValue, flag);
    }

    public boolean isPreviewInvalidNullPorts() {
        return this.previewInvalidNullPorts;
    }

    public void setPreviewInvalidNullPorts(boolean flag) {
        this.previewInvalidNullPorts = flag;
    }

    public Graphics getOffgraphics() {
        if (!this.isDoubleBuffered()) {
            return null;
        }
        Rectangle graphBounds = this.getBounds();
        int x = Math.max(0, (int)((RectangularShape)graphBounds).getX());
        int y = Math.max(0, (int)((RectangularShape)graphBounds).getY());
        int width = (int)((RectangularShape)graphBounds).getWidth();
        int height = (int)((RectangularShape)graphBounds).getHeight();
        boolean offScreenNeedsExtending = true;
        Rectangle2D.Double newOffscreenBuffer = new Rectangle2D.Double(0.0, 0.0, width, height);
        if (this.offscreenBounds != null) {
            boolean bl = offScreenNeedsExtending = !this.offscreenBounds.contains(newOffscreenBuffer);
            if (offScreenNeedsExtending) {
                newOffscreenBuffer = new Rectangle2D.Double(0.0, 0.0, width += this.offscreenBuffer, height += this.offscreenBuffer);
            }
        }
        if (this.offscreen == null || this.offgraphics == null || this.offscreenBounds == null || offScreenNeedsExtending) {
            if (this.offscreen != null) {
                this.offscreen.flush();
            }
            if (this.offgraphics != null) {
                this.offgraphics.dispose();
            }
            this.offscreen = null;
            this.offgraphics = null;
            Runtime runtime = Runtime.getRuntime();
            long maxMemory = runtime.maxMemory();
            long allocatedMemory = runtime.totalMemory();
            long memoryRequired = width * height * 4 / 1024;
            long freeMemory = runtime.freeMemory();
            long totalFreeMemory = (freeMemory + (maxMemory - allocatedMemory)) / 1024L;
            if (memoryRequired > totalFreeMemory) {
                if (this.lastBufferAllocated) {
                    System.gc();
                }
                this.lastBufferAllocated = false;
                return null;
            }
            if (this.offscreen == null && this.volatileOffscreen) {
                try {
                    this.offscreen = this.createVolatileImage(width, height);
                }
                catch (OutOfMemoryError e) {
                    this.offscreen = null;
                    this.offgraphics = null;
                }
            }
            if (this.offscreen == null) {
                this.createBufferedImage(width, height);
            }
            if (this.offscreen == null) {
                this.lastBufferAllocated = false;
                return null;
            }
            this.lastBufferAllocated = true;
            this.setupOffScreen(x, y, width, height, newOffscreenBuffer);
        } else if (this.offscreen instanceof VolatileImage) {
            int valCode = ((VolatileImage)this.offscreen).validate(this.getGraphicsConfiguration());
            if (!this.volatileOffscreen) {
                this.offscreen.flush();
                this.offgraphics.dispose();
                this.offscreen = null;
                this.offgraphics = null;
                this.createBufferedImage(width, height);
                this.setupOffScreen(x, y, width, height, newOffscreenBuffer);
            } else if (valCode == 2) {
                this.offscreen.flush();
                this.offgraphics.dispose();
                try {
                    this.offscreen = this.createVolatileImage(width, height);
                }
                catch (OutOfMemoryError e) {
                    this.offscreen = null;
                    this.offgraphics = null;
                    return null;
                }
                this.setupOffScreen(x, y, width, height, newOffscreenBuffer);
            } else if (valCode == 1) {
                this.addOffscreenDirty(new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()));
            }
        }
        Rectangle2D offscreenDirty = this.getOffscreenDirty();
        if (offscreenDirty != null) {
            if (this.isOpaque()) {
                this.offgraphics.setColor(this.getBackground());
                this.offgraphics.setPaintMode();
            } else {
                ((Graphics2D)this.offgraphics).setComposite(AlphaComposite.getInstance(1, 0.0f));
            }
            this.toScreen(offscreenDirty);
            offscreenDirty.setRect(offscreenDirty.getX() - (double)(this.getHandleSize() + 1), offscreenDirty.getY() - (double)(this.getHandleSize() + 1), offscreenDirty.getWidth() + (double)((this.getHandleSize() + 1) * 2), offscreenDirty.getHeight() + (double)((this.getHandleSize() + 1) * 2));
            this.offgraphics.fillRect((int)offscreenDirty.getX(), (int)offscreenDirty.getY(), (int)offscreenDirty.getWidth(), (int)offscreenDirty.getHeight());
            if (!this.isOpaque()) {
                ((Graphics2D)this.offgraphics).setComposite(AlphaComposite.SrcOver);
            }
            ((BasicGraphUI)this.getUI()).drawGraph(this.offgraphics, offscreenDirty);
            this.clearOffscreenDirty();
        }
        return this.offgraphics;
    }

    protected void createBufferedImage(int width, int height) {
        GraphicsConfiguration graphicsConfig = this.getGraphicsConfiguration();
        if (graphicsConfig != null) {
            try {
                this.offscreen = graphicsConfig.createCompatibleImage(width, height, this.isOpaque() ? 1 : 3);
            }
            catch (OutOfMemoryError e) {
                this.offscreen = null;
                this.offgraphics = null;
            }
            catch (NegativeArraySizeException e) {
                this.offscreen = null;
                this.offgraphics = null;
            }
        } else {
            try {
                this.offscreen = new BufferedImage(width, height, this.isOpaque() ? 1 : 2);
            }
            catch (OutOfMemoryError e) {
                this.offscreen = null;
                this.offgraphics = null;
            }
        }
    }

    protected void setupOffScreen(int x, int y, int width, int height, Rectangle2D newOffscreenBuffer) {
        this.offgraphics = this.offscreen.getGraphics();
        if (this.isOpaque()) {
            this.offgraphics.setColor(this.getBackground());
            this.offgraphics.setPaintMode();
        } else {
            ((Graphics2D)this.offgraphics).setComposite(AlphaComposite.getInstance(1, 0.0f));
        }
        this.offgraphics.fillRect(0, 0, width, height);
        if (!this.isOpaque()) {
            ((Graphics2D)this.offgraphics).setComposite(AlphaComposite.SrcOver);
        }
        ((BasicGraphUI)this.getUI()).drawGraph(this.offgraphics, null);
        this.offscreenBounds = newOffscreenBuffer;
        this.offscreenOffset = new Point2D.Double(x, y);
        this.clearOffscreenDirty();
    }

    public Image getOffscreen() {
        return this.offscreen;
    }

    public Rectangle2D getOffscreenDirty() {
        return this.offscreenDirty;
    }

    public void addOffscreenDirty(Rectangle2D offscreenDirty) {
        if (this.offscreenDirty == null && offscreenDirty != null) {
            this.offscreenDirty = (Rectangle2D)offscreenDirty.clone();
        } else if (offscreenDirty != null) {
            this.offscreenDirty.add(offscreenDirty);
        }
    }

    public void clearOffscreenDirty() {
        this.offscreenDirty = null;
    }

    public void releaseOffscreenResources() {
        this.offscreen.flush();
        this.offgraphics.dispose();
        this.offscreen = null;
        this.offgraphics = null;
    }

    public boolean drawImage(int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        this.getOffgraphics();
        return this.getGraphics().drawImage(this.offscreen, sx1, sy1, sx2, sy2, sx1, sy1, sx2, sy2, this);
    }

    public boolean drawImage(Graphics g) {
        Rectangle rect = this.getBounds();
        return this.getGraphics().drawImage(this.offscreen, rect.x, rect.y, rect.x + rect.width, rect.y + rect.height, rect.x, rect.y, rect.x + rect.width, rect.y + rect.height, this);
    }

    public ImageIcon getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(ImageIcon backgroundImage) {
        ImageIcon oldValue = this.backgroundImage;
        this.backgroundImage = backgroundImage;
        this.clearOffscreen();
        this.firePropertyChange(PROPERTY_BACKGROUNDIMAGE, oldValue, backgroundImage);
    }

    @Override
    public void setBackground(Color bg) {
        this.clearOffscreen();
        super.setBackground(bg);
    }

    public boolean isBackgroundScaled() {
        return this.backgroundScaled;
    }

    public Point2D getOffscreenOffset() {
        return this.offscreenOffset;
    }

    public void setOffscreenOffset(Point2D offscreenOffset) {
        this.offscreenOffset = offscreenOffset;
    }

    public boolean isVolatileOffscreen() {
        return this.volatileOffscreen;
    }

    public void setVolatileOffscreen(boolean volatileOffscreen) {
        this.volatileOffscreen = volatileOffscreen;
    }

    public void setBackgroundScaled(boolean backgroundScaled) {
        this.backgroundScaled = backgroundScaled;
    }

    public Component getBackgroundComponent() {
        return this.backgroundComponent;
    }

    public void setBackgroundComponent(Component backgroundComponent) {
        this.clearOffscreen();
        this.backgroundComponent = backgroundComponent;
    }

    @Override
    public void setOpaque(boolean opaque) {
        if (!opaque) {
            this.setXorEnabled(false);
        }
        super.setOpaque(opaque);
    }

    public GraphModel getModel() {
        return this.graphModel;
    }

    public void setModel(GraphModel newModel) {
        GraphModel oldModel = this.graphModel;
        this.graphModel = newModel;
        this.clearOffscreen();
        this.firePropertyChange(GRAPH_MODEL_PROPERTY, oldModel, this.graphModel);
        if (this.graphLayoutCache != null && this.graphLayoutCache.getModel() != this.graphModel) {
            this.graphLayoutCache.setModel(this.graphModel);
        }
        this.clearSelection();
        this.invalidate();
    }

    public GraphLayoutCache getGraphLayoutCache() {
        return this.graphLayoutCache;
    }

    public void setGraphLayoutCache(GraphLayoutCache newLayoutCache) {
        if (!this.isSelectionEmpty()) {
            this.clearSelection();
        }
        GraphLayoutCache oldLayoutCache = this.graphLayoutCache;
        this.graphLayoutCache = newLayoutCache;
        this.clearOffscreen();
        this.firePropertyChange(GRAPH_LAYOUT_CACHE_PROPERTY, oldLayoutCache, this.graphLayoutCache);
        if (this.graphLayoutCache != null && this.graphLayoutCache.getModel() != this.getModel()) {
            this.setModel(this.graphLayoutCache.getModel());
        } else {
            this.graphLayoutCache.update();
        }
        this.invalidate();
    }

    public BasicMarqueeHandler getMarqueeHandler() {
        return this.marquee;
    }

    public void setMarqueeHandler(BasicMarqueeHandler newMarquee) {
        BasicMarqueeHandler oldMarquee = this.marquee;
        this.marquee = newMarquee;
        this.firePropertyChange(MARQUEE_HANDLER_PROPERTY, oldMarquee, newMarquee);
        this.invalidate();
    }

    public void setInvokesStopCellEditing(boolean newValue) {
        boolean oldValue = this.invokesStopCellEditing;
        this.invokesStopCellEditing = newValue;
        this.firePropertyChange(INVOKES_STOP_CELL_EDITING_PROPERTY, oldValue, newValue);
    }

    public boolean getInvokesStopCellEditing() {
        return this.invokesStopCellEditing;
    }

    public boolean isCellEditable(Object cell) {
        CellView view;
        if (cell != null && (view = this.graphLayoutCache.getMapping(cell, false)) != null) {
            return this.isEditable() && GraphConstants.isEditable(view.getAllAttributes());
        }
        return false;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (e != null) {
            Component c;
            Object cell = this.getFirstCellForLocation(e.getX(), e.getY());
            CellView view = this.getGraphLayoutCache().getMapping(cell, false);
            if (view != null && (c = view.getRendererComponent(this, false, false, false)) instanceof JComponent) {
                Rectangle2D rect = this.getCellBounds(cell);
                Point2D where = this.fromScreen(e.getPoint());
                e = new MouseEvent(c, e.getID(), e.getWhen(), e.getModifiers(), (int)(where.getX() - rect.getX()), (int)(where.getY() - rect.getY()), e.getClickCount(), e.isPopupTrigger());
                return ((JComponent)c).getToolTipText(e);
            }
        }
        return super.getToolTipText(e);
    }

    public void setSelectionModel(GraphSelectionModel selectionModel) {
        if (selectionModel == null) {
            selectionModel = EmptySelectionModel.sharedInstance();
        }
        GraphSelectionModel oldValue = this.selectionModel;
        if (this.selectionModel != null && this.selectionRedirector != null) {
            this.selectionModel.removeGraphSelectionListener(this.selectionRedirector);
        }
        this.selectionModel = selectionModel;
        if (this.selectionRedirector != null) {
            this.selectionModel.addGraphSelectionListener(this.selectionRedirector);
        }
        this.firePropertyChange(SELECTION_MODEL_PROPERTY, oldValue, this.selectionModel);
    }

    public GraphSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void clearSelection() {
        this.getSelectionModel().clearSelection();
    }

    public boolean isSelectionEmpty() {
        return this.getSelectionModel().isSelectionEmpty();
    }

    public void addGraphSelectionListener(GraphSelectionListener tsl) {
        this.listenerList.add(GraphSelectionListener.class, tsl);
        if (this.listenerList.getListenerCount(GraphSelectionListener.class) != 0 && this.selectionRedirector == null) {
            this.selectionRedirector = new GraphSelectionRedirector();
            this.selectionModel.addGraphSelectionListener(this.selectionRedirector);
        }
    }

    public void removeGraphSelectionListener(GraphSelectionListener tsl) {
        this.listenerList.remove(GraphSelectionListener.class, tsl);
        if (this.listenerList.getListenerCount(GraphSelectionListener.class) == 0 && this.selectionRedirector != null) {
            this.selectionModel.removeGraphSelectionListener(this.selectionRedirector);
            this.selectionRedirector = null;
        }
    }

    protected void fireValueChanged(GraphSelectionEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != GraphSelectionListener.class) continue;
            ((GraphSelectionListener)listeners[i + 1]).valueChanged(e);
        }
    }

    public void setSelectionCell(Object cell) {
        this.getSelectionModel().setSelectionCell(cell);
    }

    public void setSelectionCells(Object[] cells) {
        this.getSelectionModel().setSelectionCells(cells);
    }

    public void addSelectionCell(Object cell) {
        this.getSelectionModel().addSelectionCell(cell);
    }

    public void addSelectionCells(Object[] cells) {
        this.getSelectionModel().addSelectionCells(cells);
    }

    public void removeSelectionCell(Object cell) {
        this.getSelectionModel().removeSelectionCell(cell);
    }

    public Object getSelectionCell() {
        return this.getSelectionModel().getSelectionCell();
    }

    public Object[] getSelectionCells() {
        return this.getSelectionModel().getSelectionCells();
    }

    public Object[] getSelectionCells(Object[] cells) {
        if (cells != null) {
            ArrayList<Object> selected = new ArrayList<Object>(cells.length);
            for (int i = 0; i < cells.length; ++i) {
                if (!this.isCellSelected(cells[i])) continue;
                selected.add(cells[i]);
            }
            return selected.toArray();
        }
        return null;
    }

    public Object getSelectionCellAt(Point2D pt) {
        pt = this.fromScreen((Point2D)pt.clone());
        Object[] cells = this.getSelectionCells();
        if (cells != null) {
            for (int i = 0; i < cells.length; ++i) {
                if (!this.getCellBounds(cells[i]).contains(pt.getX(), pt.getY())) continue;
                return cells[i];
            }
        }
        return null;
    }

    public int getSelectionCount() {
        return this.getSelectionModel().getSelectionCount();
    }

    public boolean isCellSelected(Object cell) {
        return this.getSelectionModel().isCellSelected(cell);
    }

    public void scrollCellToVisible(Object cell) {
        Rectangle2D bounds = this.getCellBounds(cell);
        if (bounds != null) {
            Rectangle2D b2 = this.toScreen((Rectangle2D)bounds.clone());
            this.scrollRectToVisible(new Rectangle((int)b2.getX(), (int)b2.getY(), (int)b2.getWidth(), (int)b2.getHeight()));
        }
    }

    public void scrollPointToVisible(Point2D p) {
        if (p != null) {
            this.scrollRectToVisible(new Rectangle((int)p.getX(), (int)p.getY(), 1, 1));
        }
    }

    public boolean isEditing() {
        GraphUI graph = this.getUI();
        if (graph != null) {
            return graph.isEditing(this);
        }
        return false;
    }

    public boolean stopEditing() {
        GraphUI graph = this.getUI();
        if (graph != null) {
            return graph.stopEditing(this);
        }
        return false;
    }

    public void cancelEditing() {
        GraphUI graph = this.getUI();
        if (graph != null) {
            graph.cancelEditing(this);
        }
    }

    public void startEditingAtCell(Object cell) {
        GraphUI graph = this.getUI();
        if (graph != null) {
            graph.startEditingAtCell(this, cell);
        }
    }

    public Object getEditingCell() {
        GraphUI graph = this.getUI();
        if (graph != null) {
            return graph.getEditingCell(this);
        }
        return null;
    }

    public void graphDidChange() {
        this.revalidate();
        this.repaint();
    }

    public void refresh() {
        this.clearOffscreen();
        this.repaint();
    }

    public BufferedImage getImage(Color bg, int inset) {
        Object[] cells = this.getRoots();
        Rectangle2D bounds = this.getCellBounds(cells);
        if (bounds != null) {
            this.toScreen(bounds);
            GraphicsConfiguration graphicsConfig = this.getGraphicsConfiguration();
            BufferedImage img = null;
            img = graphicsConfig != null ? this.getGraphicsConfiguration().createCompatibleImage((int)bounds.getWidth() + 2 * inset, (int)bounds.getHeight() + 2 * inset, bg != null ? 1 : 2) : new BufferedImage((int)bounds.getWidth() + 2 * inset, (int)bounds.getHeight() + 2 * inset, bg != null ? 1 : 2);
            Graphics2D graphics = img.createGraphics();
            if (bg != null) {
                graphics.setColor(bg);
                graphics.fillRect(0, 0, img.getWidth(), img.getHeight());
            } else {
                graphics.setComposite(AlphaComposite.getInstance(1, 0.0f));
                graphics.fillRect(0, 0, img.getWidth(), img.getHeight());
                graphics.setComposite(AlphaComposite.SrcOver);
            }
            graphics.translate((int)(-bounds.getX() + (double)inset), (int)(-bounds.getY() + (double)inset));
            this.print(graphics);
            graphics.dispose();
            return img;
        }
        return null;
    }

    public Rectangle2D getClipRectangle(GraphLayoutCacheEvent.GraphLayoutCacheChange change) {
        List removed = DefaultGraphModel.getDescendants(this.getModel(), change.getRemoved());
        Rectangle2D removedBounds = removed != null && !removed.isEmpty() ? this.getCellBounds(removed.toArray()) : null;
        List inserted = DefaultGraphModel.getDescendants(this.getModel(), change.getInserted());
        Rectangle2D insertedBounds = inserted != null && !inserted.isEmpty() ? this.getCellBounds(inserted.toArray()) : null;
        List changed = DefaultGraphModel.getDescendants(this.getModel(), change.getChanged());
        Rectangle2D changedBounds = changed != null && !changed.isEmpty() ? this.getCellBounds(changed.toArray()) : null;
        List context = DefaultGraphModel.getDescendants(this.getModel(), change.getContext());
        Rectangle2D contextBounds = context != null && !context.isEmpty() ? this.getCellBounds(context.toArray()) : null;
        Rectangle2D clip = removedBounds;
        if (clip == null) {
            clip = insertedBounds;
        } else if (insertedBounds != null) {
            clip.add(insertedBounds);
        }
        if (clip == null) {
            clip = changedBounds;
        } else if (changedBounds != null) {
            clip.add(changedBounds);
        }
        if (clip == null) {
            clip = contextBounds;
        } else if (contextBounds != null) {
            clip.add(contextBounds);
        }
        return clip;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Vector<Object> values = new Vector<Object>();
        s.defaultWriteObject();
        if (this.graphModel instanceof Serializable) {
            values.addElement("graphModel");
            values.addElement(this.graphModel);
        }
        values.addElement("graphLayoutCache");
        values.addElement(this.graphLayoutCache);
        if (this.selectionModel instanceof Serializable) {
            values.addElement(SELECTION_MODEL_PROPERTY);
            values.addElement(this.selectionModel);
        }
        if (this.marquee instanceof Serializable) {
            values.addElement(MARQUEE_HANDLER_PROPERTY);
            values.addElement(this.marquee);
        }
        s.writeObject(values);
        if (this.getUIClassID().equals(uiClassID) && this.ui != null) {
            this.ui.installUI(this);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Vector values = (Vector)s.readObject();
        int indexCounter = 0;
        int maxCounter = values.size();
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals("graphModel")) {
            this.graphModel = (GraphModel)values.elementAt(++indexCounter);
            ++indexCounter;
        }
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals("graphLayoutCache")) {
            this.graphLayoutCache = (GraphLayoutCache)values.elementAt(++indexCounter);
            ++indexCounter;
        }
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals(SELECTION_MODEL_PROPERTY)) {
            this.selectionModel = (GraphSelectionModel)values.elementAt(++indexCounter);
            ++indexCounter;
        }
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals(MARQUEE_HANDLER_PROPERTY)) {
            this.marquee = (BasicMarqueeHandler)values.elementAt(++indexCounter);
            ++indexCounter;
        }
        if (this.listenerList.getListenerCount(GraphSelectionListener.class) != 0) {
            this.selectionRedirector = new GraphSelectionRedirector();
            this.selectionModel.addGraphSelectionListener(this.selectionRedirector);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return 2;
        }
        return 4;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return orientation == 1 ? visibleRect.height : visibleRect.width;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    @Override
    protected String paramString() {
        String editableString = this.editable ? "true" : "false";
        String invokesStopCellEditingString = this.invokesStopCellEditing ? "true" : "false";
        return super.paramString() + ",editable=" + editableString + ",invokesStopCellEditing=" + invokesStopCellEditingString;
    }

    public static void main(String[] args) {
        System.out.println(VERSION);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        try {
            String javaVersion;
            String osName = System.getProperty("os.name");
            if (osName != null) {
                IS_MAC = osName.toLowerCase().startsWith("mac os x");
            }
            if (!(javaVersion = System.getProperty("java.version")).startsWith("1.4") && !javaVersion.startsWith("1.5")) return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected class GraphSelectionRedirector
    implements Serializable,
    GraphSelectionListener {
        protected GraphSelectionRedirector() {
        }

        @Override
        public void valueChanged(GraphSelectionEvent e) {
            GraphSelectionEvent newE = (GraphSelectionEvent)e.cloneWithSource(JGraph.this);
            JGraph.this.fireValueChanged(newE);
        }
    }

    public static class EmptySelectionModel
    extends DefaultGraphSelectionModel {
        protected static final EmptySelectionModel sharedInstance = new EmptySelectionModel();

        public EmptySelectionModel() {
            super(null);
        }

        public static EmptySelectionModel sharedInstance() {
            return sharedInstance;
        }

        @Override
        public void setSelectionCells(Object[] cells) {
        }

        @Override
        public void addSelectionCells(Object[] cells) {
        }

        @Override
        public void removeSelectionCells(Object[] cells) {
        }
    }
}

