/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.fft;

import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public strictfp class FloatFFT_2D {
    private int rows;
    private int columns;
    private float[] t;
    private FloatFFT_1D fftColumns;
    private FloatFFT_1D fftRows;
    private int oldNthreads;
    private int nt;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public FloatFFT_2D(int n, int n2) {
        if (n <= 1 || n2 <= 1) {
            throw new IllegalArgumentException("rows and columns must be greater than 1");
        }
        this.rows = n;
        this.columns = n2;
        if (n * n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.useThreads = true;
        }
        if (ConcurrencyUtils.isPowerOf2(n) && ConcurrencyUtils.isPowerOf2(n2)) {
            this.isPowerOfTwo = true;
            this.oldNthreads = ConcurrencyUtils.getNumberOfThreads();
            this.nt = 8 * this.oldNthreads * n;
            if (2 * n2 == 4 * this.oldNthreads) {
                this.nt >>= 1;
            } else if (2 * n2 < 4 * this.oldNthreads) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
        }
        this.fftRows = new FloatFFT_1D(n);
        this.fftColumns = n == n2 ? this.fftRows : new FloatFFT_1D(n2);
    }

    public void complexForward(final float[] fArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int n2 = this.columns;
            this.columns = 2 * this.columns;
            if (n != this.oldNthreads) {
                this.nt = 8 * n * this.rows;
                if (this.columns == 4 * n) {
                    this.nt >>= 1;
                } else if (this.columns < 4 * n) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth1(0, -1, fArray, true);
                this.cdft2d_subth(-1, fArray, true);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.complexForward(fArray, i * this.columns);
                }
                this.cdft2d_sub(-1, fArray, true);
            }
            this.columns = n2;
        } else {
            final int n3 = 2 * this.columns;
            if (n > 1 && this.useThreads && this.rows >= n && this.columns >= n) {
                int n4;
                int n5;
                int n6;
                Future[] futureArray = new Future[n];
                int n7 = this.rows / n;
                for (n6 = 0; n6 < n; ++n6) {
                    n5 = n6 * n7;
                    n4 = n6 == n - 1 ? this.rows : n5 + n7;
                    futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = n5; i < n4; ++i) {
                                FloatFFT_2D.this.fftColumns.complexForward(fArray, i * n3);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                n7 = this.columns / n;
                for (n6 = 0; n6 < n; ++n6) {
                    n5 = n6 * n7;
                    n4 = n6 == n - 1 ? this.columns : n5 + n7;
                    futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] fArray2 = new float[2 * FloatFFT_2D.this.rows];
                            for (int i = n5; i < n4; ++i) {
                                int n;
                                int n2;
                                int n32;
                                int n42 = 2 * i;
                                for (n32 = 0; n32 < FloatFFT_2D.this.rows; ++n32) {
                                    n2 = 2 * n32;
                                    n = n32 * n3 + n42;
                                    fArray2[n2] = fArray[n];
                                    fArray2[n2 + 1] = fArray[n + 1];
                                }
                                FloatFFT_2D.this.fftRows.complexForward(fArray2);
                                for (n32 = 0; n32 < FloatFFT_2D.this.rows; ++n32) {
                                    n2 = 2 * n32;
                                    n = n32 * n3 + n42;
                                    fArray[n] = fArray2[n2];
                                    fArray[n + 1] = fArray2[n2 + 1];
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.complexForward(fArray, i * n3);
                }
                float[] fArray2 = new float[2 * this.rows];
                for (int i = 0; i < this.columns; ++i) {
                    int n8;
                    int n9;
                    int n10;
                    int n11 = 2 * i;
                    for (n10 = 0; n10 < this.rows; ++n10) {
                        n9 = 2 * n10;
                        n8 = n10 * n3 + n11;
                        fArray2[n9] = fArray[n8];
                        fArray2[n9 + 1] = fArray[n8 + 1];
                    }
                    this.fftRows.complexForward(fArray2);
                    for (n10 = 0; n10 < this.rows; ++n10) {
                        n9 = 2 * n10;
                        n8 = n10 * n3 + n11;
                        fArray[n8] = fArray2[n9];
                        fArray[n8 + 1] = fArray2[n9 + 1];
                    }
                }
            }
        }
    }

    public void complexForward(final float[][] fArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int n2 = this.columns;
            this.columns = 2 * this.columns;
            if (n != this.oldNthreads) {
                this.nt = 8 * n * this.rows;
                if (this.columns == 4 * n) {
                    this.nt >>= 1;
                } else if (this.columns < 4 * n) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth1(0, -1, fArray, true);
                this.cdft2d_subth(-1, fArray, true);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.complexForward(fArray[i]);
                }
                this.cdft2d_sub(-1, fArray, true);
            }
            this.columns = n2;
        } else if (n > 1 && this.useThreads && this.rows >= n && this.columns >= n) {
            int n3;
            int n4;
            int n5;
            Future[] futureArray = new Future[n];
            int n6 = this.rows / n;
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n - 1 ? this.rows : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            FloatFFT_2D.this.fftColumns.complexForward(fArray[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n6 = this.columns / n;
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n - 1 ? this.columns : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[2 * FloatFFT_2D.this.rows];
                        for (int i = n4; i < n3; ++i) {
                            int n;
                            int n2;
                            int n32 = 2 * i;
                            for (n2 = 0; n2 < FloatFFT_2D.this.rows; ++n2) {
                                n = 2 * n2;
                                fArray2[n] = fArray[n2][n32];
                                fArray2[n + 1] = fArray[n2][n32 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexForward(fArray2);
                            for (n2 = 0; n2 < FloatFFT_2D.this.rows; ++n2) {
                                n = 2 * n2;
                                fArray[n2][n32] = fArray2[n];
                                fArray[n2][n32 + 1] = fArray2[n + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.fftColumns.complexForward(fArray[i]);
            }
            float[] fArray2 = new float[2 * this.rows];
            for (int i = 0; i < this.columns; ++i) {
                int n7;
                int n8;
                int n9 = 2 * i;
                for (n8 = 0; n8 < this.rows; ++n8) {
                    n7 = 2 * n8;
                    fArray2[n7] = fArray[n8][n9];
                    fArray2[n7 + 1] = fArray[n8][n9 + 1];
                }
                this.fftRows.complexForward(fArray2);
                for (n8 = 0; n8 < this.rows; ++n8) {
                    n7 = 2 * n8;
                    fArray[n8][n9] = fArray2[n7];
                    fArray[n8][n9 + 1] = fArray2[n7 + 1];
                }
            }
        }
    }

    public void complexInverse(final float[] fArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int n2 = this.columns;
            this.columns = 2 * this.columns;
            if (n != this.oldNthreads) {
                this.nt = 8 * n * this.rows;
                if (this.columns == 4 * n) {
                    this.nt >>= 1;
                } else if (this.columns < 4 * n) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth1(0, 1, fArray, bl);
                this.cdft2d_subth(1, fArray, bl);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.complexInverse(fArray, i * this.columns, bl);
                }
                this.cdft2d_sub(1, fArray, bl);
            }
            this.columns = n2;
        } else {
            final int n3 = 2 * this.columns;
            if (n > 1 && this.useThreads && this.rows >= n && this.columns >= n) {
                int n4;
                int n5;
                int n6;
                Future[] futureArray = new Future[n];
                int n7 = this.rows / n;
                for (n6 = 0; n6 < n; ++n6) {
                    n5 = n6 * n7;
                    n4 = n6 == n - 1 ? this.rows : n5 + n7;
                    futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = n5; i < n4; ++i) {
                                FloatFFT_2D.this.fftColumns.complexInverse(fArray, i * n3, bl);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                n7 = this.columns / n;
                for (n6 = 0; n6 < n; ++n6) {
                    n5 = n6 * n7;
                    n4 = n6 == n - 1 ? this.columns : n5 + n7;
                    futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] fArray2 = new float[2 * FloatFFT_2D.this.rows];
                            for (int i = n5; i < n4; ++i) {
                                int n;
                                int n2;
                                int n32;
                                int n42 = 2 * i;
                                for (n32 = 0; n32 < FloatFFT_2D.this.rows; ++n32) {
                                    n2 = 2 * n32;
                                    n = n32 * n3 + n42;
                                    fArray2[n2] = fArray[n];
                                    fArray2[n2 + 1] = fArray[n + 1];
                                }
                                FloatFFT_2D.this.fftRows.complexInverse(fArray2, bl);
                                for (n32 = 0; n32 < FloatFFT_2D.this.rows; ++n32) {
                                    n2 = 2 * n32;
                                    n = n32 * n3 + n42;
                                    fArray[n] = fArray2[n2];
                                    fArray[n + 1] = fArray2[n2 + 1];
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.complexInverse(fArray, i * n3, bl);
                }
                float[] fArray2 = new float[2 * this.rows];
                for (int i = 0; i < this.columns; ++i) {
                    int n8;
                    int n9;
                    int n10;
                    int n11 = 2 * i;
                    for (n10 = 0; n10 < this.rows; ++n10) {
                        n9 = 2 * n10;
                        n8 = n10 * n3 + n11;
                        fArray2[n9] = fArray[n8];
                        fArray2[n9 + 1] = fArray[n8 + 1];
                    }
                    this.fftRows.complexInverse(fArray2, bl);
                    for (n10 = 0; n10 < this.rows; ++n10) {
                        n9 = 2 * n10;
                        n8 = n10 * n3 + n11;
                        fArray[n8] = fArray2[n9];
                        fArray[n8 + 1] = fArray2[n9 + 1];
                    }
                }
            }
        }
    }

    public void complexInverse(final float[][] fArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int n2 = this.columns;
            this.columns = 2 * this.columns;
            if (n != this.oldNthreads) {
                this.nt = 8 * n * this.rows;
                if (this.columns == 4 * n) {
                    this.nt >>= 1;
                } else if (this.columns < 4 * n) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth1(0, 1, fArray, bl);
                this.cdft2d_subth(1, fArray, bl);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.complexInverse(fArray[i], bl);
                }
                this.cdft2d_sub(1, fArray, bl);
            }
            this.columns = n2;
        } else if (n > 1 && this.useThreads && this.rows >= n && this.columns >= n) {
            int n3;
            int n4;
            int n5;
            Future[] futureArray = new Future[n];
            int n6 = this.rows / n;
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n - 1 ? this.rows : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            FloatFFT_2D.this.fftColumns.complexInverse(fArray[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n6 = this.columns / n;
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n - 1 ? this.columns : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[2 * FloatFFT_2D.this.rows];
                        for (int i = n4; i < n3; ++i) {
                            int n;
                            int n2;
                            int n32 = 2 * i;
                            for (n2 = 0; n2 < FloatFFT_2D.this.rows; ++n2) {
                                n = 2 * n2;
                                fArray2[n] = fArray[n2][n32];
                                fArray2[n + 1] = fArray[n2][n32 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(fArray2, bl);
                            for (n2 = 0; n2 < FloatFFT_2D.this.rows; ++n2) {
                                n = 2 * n2;
                                fArray[n2][n32] = fArray2[n];
                                fArray[n2][n32 + 1] = fArray2[n + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.fftColumns.complexInverse(fArray[i], bl);
            }
            float[] fArray2 = new float[2 * this.rows];
            for (int i = 0; i < this.columns; ++i) {
                int n7;
                int n8;
                int n9 = 2 * i;
                for (n8 = 0; n8 < this.rows; ++n8) {
                    n7 = 2 * n8;
                    fArray2[n7] = fArray[n8][n9];
                    fArray2[n7 + 1] = fArray[n8][n9 + 1];
                }
                this.fftRows.complexInverse(fArray2, bl);
                for (n8 = 0; n8 < this.rows; ++n8) {
                    n7 = 2 * n8;
                    fArray[n8][n9] = fArray2[n7];
                    fArray[n8][n9 + 1] = fArray2[n7 + 1];
                }
            }
        }
    }

    public void realForward(float[] fArray) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n != this.oldNthreads) {
            this.nt = 8 * n * this.rows;
            if (this.columns == 4 * n) {
                this.nt >>= 1;
            } else if (this.columns < 4 * n) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthreads = n;
        }
        if (n > 1 && this.useThreads) {
            this.xdft2d0_subth1(1, 1, fArray, true);
            this.cdft2d_subth(-1, fArray, true);
            this.rdft2d_sub(1, fArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.fftColumns.realForward(fArray, i * this.columns);
            }
            this.cdft2d_sub(-1, fArray, true);
            this.rdft2d_sub(1, fArray);
        }
    }

    public void realForward(float[][] fArray) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n != this.oldNthreads) {
            this.nt = 8 * n * this.rows;
            if (this.columns == 4 * n) {
                this.nt >>= 1;
            } else if (this.columns < 4 * n) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthreads = n;
        }
        if (n > 1 && this.useThreads) {
            this.xdft2d0_subth1(1, 1, fArray, true);
            this.cdft2d_subth(-1, fArray, true);
            this.rdft2d_sub(1, fArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.fftColumns.realForward(fArray[i]);
            }
            this.cdft2d_sub(-1, fArray, true);
            this.rdft2d_sub(1, fArray);
        }
    }

    public void realForwardFull(float[] fArray) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n != this.oldNthreads) {
                this.nt = 8 * n * this.rows;
                if (this.columns == 4 * n) {
                    this.nt >>= 1;
                } else if (this.columns < 4 * n) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth1(1, 1, fArray, true);
                this.cdft2d_subth(-1, fArray, true);
                this.rdft2d_sub(1, fArray);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.realForward(fArray, i * this.columns);
                }
                this.cdft2d_sub(-1, fArray, true);
                this.rdft2d_sub(1, fArray);
            }
            this.fillSymmetric(fArray);
        } else {
            this.mixedRadixRealForwardFull(fArray);
        }
    }

    public void realForwardFull(float[][] fArray) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n != this.oldNthreads) {
                this.nt = 8 * n * this.rows;
                if (this.columns == 4 * n) {
                    this.nt >>= 1;
                } else if (this.columns < 4 * n) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth1(1, 1, fArray, true);
                this.cdft2d_subth(-1, fArray, true);
                this.rdft2d_sub(1, fArray);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.realForward(fArray[i]);
                }
                this.cdft2d_sub(-1, fArray, true);
                this.rdft2d_sub(1, fArray);
            }
            this.fillSymmetric(fArray);
        } else {
            this.mixedRadixRealForwardFull(fArray);
        }
    }

    public void realInverse(float[] fArray, boolean bl) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n != this.oldNthreads) {
            this.nt = 8 * n * this.rows;
            if (this.columns == 4 * n) {
                this.nt >>= 1;
            } else if (this.columns < 4 * n) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthreads = n;
        }
        if (n > 1 && this.useThreads) {
            this.rdft2d_sub(-1, fArray);
            this.cdft2d_subth(1, fArray, bl);
            this.xdft2d0_subth1(1, -1, fArray, bl);
        } else {
            this.rdft2d_sub(-1, fArray);
            this.cdft2d_sub(1, fArray, bl);
            for (int i = 0; i < this.rows; ++i) {
                this.fftColumns.realInverse(fArray, i * this.columns, bl);
            }
        }
    }

    public void realInverse(float[][] fArray, boolean bl) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n != this.oldNthreads) {
            this.nt = 8 * n * this.rows;
            if (this.columns == 4 * n) {
                this.nt >>= 1;
            } else if (this.columns < 4 * n) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
            this.oldNthreads = n;
        }
        if (n > 1 && this.useThreads) {
            this.rdft2d_sub(-1, fArray);
            this.cdft2d_subth(1, fArray, bl);
            this.xdft2d0_subth1(1, -1, fArray, bl);
        } else {
            this.rdft2d_sub(-1, fArray);
            this.cdft2d_sub(1, fArray, bl);
            for (int i = 0; i < this.rows; ++i) {
                this.fftColumns.realInverse(fArray[i], bl);
            }
        }
    }

    public void realInverseFull(float[] fArray, boolean bl) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n != this.oldNthreads) {
                this.nt = 8 * n * this.rows;
                if (this.columns == 4 * n) {
                    this.nt >>= 1;
                } else if (this.columns < 4 * n) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth2(1, -1, fArray, bl);
                this.cdft2d_subth(1, fArray, bl);
                this.rdft2d_sub(1, fArray);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.realInverse2(fArray, i * this.columns, bl);
                }
                this.cdft2d_sub(1, fArray, bl);
                this.rdft2d_sub(1, fArray);
            }
            this.fillSymmetric(fArray);
        } else {
            this.mixedRadixRealInverseFull(fArray, bl);
        }
    }

    public void realInverseFull(float[][] fArray, boolean bl) {
        if (this.isPowerOfTwo) {
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n != this.oldNthreads) {
                this.nt = 8 * n * this.rows;
                if (this.columns == 4 * n) {
                    this.nt >>= 1;
                } else if (this.columns < 4 * n) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = n;
            }
            if (n > 1 && this.useThreads) {
                this.xdft2d0_subth2(1, -1, fArray, bl);
                this.cdft2d_subth(1, fArray, bl);
                this.rdft2d_sub(1, fArray);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.fftColumns.realInverse2(fArray[i], 0, bl);
                }
                this.cdft2d_sub(1, fArray, bl);
                this.rdft2d_sub(1, fArray);
            }
            this.fillSymmetric(fArray);
        } else {
            this.mixedRadixRealInverseFull(fArray, bl);
        }
    }

    private void mixedRadixRealForwardFull(final float[][] fArray) {
        final int n = this.columns / 2 + 1;
        final float[][] fArray2 = new float[n][2 * this.rows];
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.useThreads && this.rows >= n2 && n >= n2) {
            int n3;
            int n4;
            int n5;
            Future[] futureArray = new Future[n2];
            int n6 = this.rows / n2;
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n2 - 1 ? this.rows : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            FloatFFT_2D.this.fftColumns.realForward(fArray[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n5 = 0; n5 < this.rows; ++n5) {
                fArray2[0][n5] = fArray[n5][0];
            }
            this.fftRows.realForwardFull(fArray2[0]);
            n6 = n / n2;
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = 1 + n5 * n6;
                n3 = n5 == n2 - 1 ? n - 1 : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            int n = 2 * i;
                            for (int j = 0; j < FloatFFT_2D.this.rows; ++j) {
                                int n2 = 2 * j;
                                fArray2[i][n2] = fArray[j][n];
                                fArray2[i][n2 + 1] = fArray[j][n + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexForward(fArray2[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            if (this.columns % 2 == 0) {
                for (n5 = 0; n5 < this.rows; ++n5) {
                    fArray2[n - 1][n5] = fArray[n5][1];
                }
                this.fftRows.realForwardFull(fArray2[n - 1]);
            } else {
                for (n5 = 0; n5 < this.rows; ++n5) {
                    n4 = 2 * n5;
                    n3 = n - 1;
                    fArray2[n3][n4] = fArray[n5][2 * n3];
                    fArray2[n3][n4 + 1] = fArray[n5][1];
                }
                this.fftRows.complexForward(fArray2[n - 1]);
            }
            n6 = this.rows / n2;
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n2 - 1 ? this.rows : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            int n5 = 2 * i;
                            for (int j = 0; j < n; ++j) {
                                int n2 = 2 * j;
                                fArray[i][n2] = fArray2[j][n5];
                                fArray[i][n2 + 1] = fArray2[j][n5 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = 1 + n5 * n6;
                n3 = n5 == n2 - 1 ? this.rows : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            int n5 = FloatFFT_2D.this.rows - i;
                            for (int j = n; j < FloatFFT_2D.this.columns; ++j) {
                                int n2 = 2 * j;
                                int n32 = 2 * (FloatFFT_2D.this.columns - j);
                                fArray[0][n2] = fArray[0][n32];
                                fArray[0][n2 + 1] = -fArray[0][n32 + 1];
                                fArray[i][n2] = fArray[n5][n32];
                                fArray[i][n2 + 1] = -fArray[n5][n32 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7;
            int n8;
            int n9;
            int n10;
            for (n10 = 0; n10 < this.rows; ++n10) {
                this.fftColumns.realForward(fArray[n10]);
            }
            for (n10 = 0; n10 < this.rows; ++n10) {
                fArray2[0][n10] = fArray[n10][0];
            }
            this.fftRows.realForwardFull(fArray2[0]);
            for (n10 = 1; n10 < n - 1; ++n10) {
                n9 = 2 * n10;
                for (n8 = 0; n8 < this.rows; ++n8) {
                    n7 = 2 * n8;
                    fArray2[n10][n7] = fArray[n8][n9];
                    fArray2[n10][n7 + 1] = fArray[n8][n9 + 1];
                }
                this.fftRows.complexForward(fArray2[n10]);
            }
            if (this.columns % 2 == 0) {
                for (n10 = 0; n10 < this.rows; ++n10) {
                    fArray2[n - 1][n10] = fArray[n10][1];
                }
                this.fftRows.realForwardFull(fArray2[n - 1]);
            } else {
                for (n10 = 0; n10 < this.rows; ++n10) {
                    n9 = 2 * n10;
                    n8 = n - 1;
                    fArray2[n8][n9] = fArray[n10][2 * n8];
                    fArray2[n8][n9 + 1] = fArray[n10][1];
                }
                this.fftRows.complexForward(fArray2[n - 1]);
            }
            for (n10 = 0; n10 < this.rows; ++n10) {
                n9 = 2 * n10;
                for (n8 = 0; n8 < n; ++n8) {
                    n7 = 2 * n8;
                    fArray[n10][n7] = fArray2[n8][n9];
                    fArray[n10][n7 + 1] = fArray2[n8][n9 + 1];
                }
            }
            for (n10 = 1; n10 < this.rows; ++n10) {
                n9 = this.rows - n10;
                for (n8 = n; n8 < this.columns; ++n8) {
                    n7 = 2 * n8;
                    int n11 = 2 * (this.columns - n8);
                    fArray[0][n7] = fArray[0][n11];
                    fArray[0][n7 + 1] = -fArray[0][n11 + 1];
                    fArray[n10][n7] = fArray[n9][n11];
                    fArray[n10][n7 + 1] = -fArray[n9][n11 + 1];
                }
            }
        }
    }

    private void mixedRadixRealForwardFull(final float[] fArray) {
        final int n = 2 * this.columns;
        final int n2 = this.columns / 2 + 1;
        final float[][] fArray2 = new float[n2][2 * this.rows];
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.useThreads && this.rows >= n3 && n2 >= n3) {
            int n4;
            int n5;
            int n6;
            Future[] futureArray = new Future[n3];
            int n7 = this.rows / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = n6 * n7;
                n4 = n6 == n3 - 1 ? this.rows : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n5; i < n4; ++i) {
                            FloatFFT_2D.this.fftColumns.realForward(fArray, i * FloatFFT_2D.this.columns);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n6 = 0; n6 < this.rows; ++n6) {
                fArray2[0][n6] = fArray[n6 * this.columns];
            }
            this.fftRows.realForwardFull(fArray2[0]);
            n7 = n2 / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = 1 + n6 * n7;
                n4 = n6 == n3 - 1 ? n2 - 1 : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n5; i < n4; ++i) {
                            int n = 2 * i;
                            for (int j = 0; j < FloatFFT_2D.this.rows; ++j) {
                                int n2 = 2 * j;
                                int n3 = j * FloatFFT_2D.this.columns + n;
                                fArray2[i][n2] = fArray[n3];
                                fArray2[i][n2 + 1] = fArray[n3 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexForward(fArray2[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            if (this.columns % 2 == 0) {
                for (n6 = 0; n6 < this.rows; ++n6) {
                    fArray2[n2 - 1][n6] = fArray[n6 * this.columns + 1];
                }
                this.fftRows.realForwardFull(fArray2[n2 - 1]);
            } else {
                for (n6 = 0; n6 < this.rows; ++n6) {
                    n5 = 2 * n6;
                    n4 = n6 * this.columns;
                    int n8 = n2 - 1;
                    fArray2[n8][n5] = fArray[n4 + 2 * n8];
                    fArray2[n8][n5 + 1] = fArray[n4 + 1];
                }
                this.fftRows.complexForward(fArray2[n2 - 1]);
            }
            n7 = this.rows / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = n6 * n7;
                n4 = n6 == n3 - 1 ? this.rows : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n5; i < n4; ++i) {
                            int n6 = 2 * i;
                            for (int j = 0; j < n2; ++j) {
                                int n22 = 2 * j;
                                int n3 = i * n + n22;
                                fArray[n3] = fArray2[j][n6];
                                fArray[n3 + 1] = fArray2[j][n6 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = 1 + n6 * n7;
                n4 = n6 == n3 - 1 ? this.rows : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n5; i < n4; ++i) {
                            int n7 = i * n;
                            int n22 = (FloatFFT_2D.this.rows - i + 1) * n;
                            for (int j = n2; j < FloatFFT_2D.this.columns; ++j) {
                                int n3 = 2 * j;
                                int n42 = 2 * (FloatFFT_2D.this.columns - j);
                                fArray[n3] = fArray[n42];
                                fArray[n3 + 1] = -fArray[n42 + 1];
                                int n52 = n7 + n3;
                                int n6 = n22 - n3;
                                fArray[n52] = fArray[n6];
                                fArray[n52 + 1] = -fArray[n6 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            for (n13 = 0; n13 < this.rows; ++n13) {
                this.fftColumns.realForward(fArray, n13 * this.columns);
            }
            for (n13 = 0; n13 < this.rows; ++n13) {
                fArray2[0][n13] = fArray[n13 * this.columns];
            }
            this.fftRows.realForwardFull(fArray2[0]);
            for (n13 = 1; n13 < n2 - 1; ++n13) {
                n12 = 2 * n13;
                for (n11 = 0; n11 < this.rows; ++n11) {
                    n10 = 2 * n11;
                    n9 = n11 * this.columns + n12;
                    fArray2[n13][n10] = fArray[n9];
                    fArray2[n13][n10 + 1] = fArray[n9 + 1];
                }
                this.fftRows.complexForward(fArray2[n13]);
            }
            if (this.columns % 2 == 0) {
                for (n13 = 0; n13 < this.rows; ++n13) {
                    fArray2[n2 - 1][n13] = fArray[n13 * this.columns + 1];
                }
                this.fftRows.realForwardFull(fArray2[n2 - 1]);
            } else {
                for (n13 = 0; n13 < this.rows; ++n13) {
                    n12 = 2 * n13;
                    n11 = n13 * this.columns;
                    n10 = n2 - 1;
                    fArray2[n10][n12] = fArray[n11 + 2 * n10];
                    fArray2[n10][n12 + 1] = fArray[n11 + 1];
                }
                this.fftRows.complexForward(fArray2[n2 - 1]);
            }
            for (n13 = 0; n13 < this.rows; ++n13) {
                n12 = 2 * n13;
                for (n11 = 0; n11 < n2; ++n11) {
                    n10 = 2 * n11;
                    n9 = n13 * n + n10;
                    fArray[n9] = fArray2[n11][n12];
                    fArray[n9 + 1] = fArray2[n11][n12 + 1];
                }
            }
            for (n13 = 1; n13 < this.rows; ++n13) {
                n12 = n13 * n;
                n11 = (this.rows - n13 + 1) * n;
                for (n10 = n2; n10 < this.columns; ++n10) {
                    n9 = 2 * n10;
                    int n14 = 2 * (this.columns - n10);
                    fArray[n9] = fArray[n14];
                    fArray[n9 + 1] = -fArray[n14 + 1];
                    int n15 = n12 + n9;
                    int n16 = n11 - n9;
                    fArray[n15] = fArray[n16];
                    fArray[n15 + 1] = -fArray[n16 + 1];
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final float[][] fArray, final boolean bl) {
        final int n = this.columns / 2 + 1;
        final float[][] fArray2 = new float[n][2 * this.rows];
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.useThreads && this.rows >= n2 && n >= n2) {
            int n3;
            int n4;
            int n5;
            Future[] futureArray = new Future[n2];
            int n6 = this.rows / n2;
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n2 - 1 ? this.rows : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            FloatFFT_2D.this.fftColumns.realInverse2(fArray[i], 0, bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n5 = 0; n5 < this.rows; ++n5) {
                fArray2[0][n5] = fArray[n5][0];
            }
            this.fftRows.realInverseFull(fArray2[0], bl);
            n6 = n / n2;
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = 1 + n5 * n6;
                n3 = n5 == n2 - 1 ? n - 1 : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            int n = 2 * i;
                            for (int j = 0; j < FloatFFT_2D.this.rows; ++j) {
                                int n2 = 2 * j;
                                fArray2[i][n2] = fArray[j][n];
                                fArray2[i][n2 + 1] = fArray[j][n + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(fArray2[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            if (this.columns % 2 == 0) {
                for (n5 = 0; n5 < this.rows; ++n5) {
                    fArray2[n - 1][n5] = fArray[n5][1];
                }
                this.fftRows.realInverseFull(fArray2[n - 1], bl);
            } else {
                for (n5 = 0; n5 < this.rows; ++n5) {
                    n4 = 2 * n5;
                    n3 = n - 1;
                    fArray2[n3][n4] = fArray[n5][2 * n3];
                    fArray2[n3][n4 + 1] = fArray[n5][1];
                }
                this.fftRows.complexInverse(fArray2[n - 1], bl);
            }
            n6 = this.rows / n2;
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = n5 * n6;
                n3 = n5 == n2 - 1 ? this.rows : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            int n5 = 2 * i;
                            for (int j = 0; j < n; ++j) {
                                int n2 = 2 * j;
                                fArray[i][n2] = fArray2[j][n5];
                                fArray[i][n2 + 1] = fArray2[j][n5 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = 1 + n5 * n6;
                n3 = n5 == n2 - 1 ? this.rows : n4 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n4; i < n3; ++i) {
                            int n5 = FloatFFT_2D.this.rows - i;
                            for (int j = n; j < FloatFFT_2D.this.columns; ++j) {
                                int n2 = 2 * j;
                                int n32 = 2 * (FloatFFT_2D.this.columns - j);
                                fArray[0][n2] = fArray[0][n32];
                                fArray[0][n2 + 1] = -fArray[0][n32 + 1];
                                fArray[i][n2] = fArray[n5][n32];
                                fArray[i][n2 + 1] = -fArray[n5][n32 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7;
            int n8;
            int n9;
            int n10;
            for (n10 = 0; n10 < this.rows; ++n10) {
                this.fftColumns.realInverse2(fArray[n10], 0, bl);
            }
            for (n10 = 0; n10 < this.rows; ++n10) {
                fArray2[0][n10] = fArray[n10][0];
            }
            this.fftRows.realInverseFull(fArray2[0], bl);
            for (n10 = 1; n10 < n - 1; ++n10) {
                n9 = 2 * n10;
                for (n8 = 0; n8 < this.rows; ++n8) {
                    n7 = 2 * n8;
                    fArray2[n10][n7] = fArray[n8][n9];
                    fArray2[n10][n7 + 1] = fArray[n8][n9 + 1];
                }
                this.fftRows.complexInverse(fArray2[n10], bl);
            }
            if (this.columns % 2 == 0) {
                for (n10 = 0; n10 < this.rows; ++n10) {
                    fArray2[n - 1][n10] = fArray[n10][1];
                }
                this.fftRows.realInverseFull(fArray2[n - 1], bl);
            } else {
                for (n10 = 0; n10 < this.rows; ++n10) {
                    n9 = 2 * n10;
                    n8 = n - 1;
                    fArray2[n8][n9] = fArray[n10][2 * n8];
                    fArray2[n8][n9 + 1] = fArray[n10][1];
                }
                this.fftRows.complexInverse(fArray2[n - 1], bl);
            }
            for (n10 = 0; n10 < this.rows; ++n10) {
                n9 = 2 * n10;
                for (n8 = 0; n8 < n; ++n8) {
                    n7 = 2 * n8;
                    fArray[n10][n7] = fArray2[n8][n9];
                    fArray[n10][n7 + 1] = fArray2[n8][n9 + 1];
                }
            }
            for (n10 = 1; n10 < this.rows; ++n10) {
                n9 = this.rows - n10;
                for (n8 = n; n8 < this.columns; ++n8) {
                    n7 = 2 * n8;
                    int n11 = 2 * (this.columns - n8);
                    fArray[0][n7] = fArray[0][n11];
                    fArray[0][n7 + 1] = -fArray[0][n11 + 1];
                    fArray[n10][n7] = fArray[n9][n11];
                    fArray[n10][n7 + 1] = -fArray[n9][n11 + 1];
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final float[] fArray, final boolean bl) {
        final int n = 2 * this.columns;
        final int n2 = this.columns / 2 + 1;
        final float[][] fArray2 = new float[n2][2 * this.rows];
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.useThreads && this.rows >= n3 && n2 >= n3) {
            int n4;
            int n5;
            int n6;
            Future[] futureArray = new Future[n3];
            int n7 = this.rows / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = n6 * n7;
                n4 = n6 == n3 - 1 ? this.rows : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n5; i < n4; ++i) {
                            FloatFFT_2D.this.fftColumns.realInverse2(fArray, i * FloatFFT_2D.this.columns, bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n6 = 0; n6 < this.rows; ++n6) {
                fArray2[0][n6] = fArray[n6 * this.columns];
            }
            this.fftRows.realInverseFull(fArray2[0], bl);
            n7 = n2 / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = 1 + n6 * n7;
                n4 = n6 == n3 - 1 ? n2 - 1 : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n5; i < n4; ++i) {
                            int n = 2 * i;
                            for (int j = 0; j < FloatFFT_2D.this.rows; ++j) {
                                int n2 = 2 * j;
                                int n3 = j * FloatFFT_2D.this.columns + n;
                                fArray2[i][n2] = fArray[n3];
                                fArray2[i][n2 + 1] = fArray[n3 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(fArray2[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            if (this.columns % 2 == 0) {
                for (n6 = 0; n6 < this.rows; ++n6) {
                    fArray2[n2 - 1][n6] = fArray[n6 * this.columns + 1];
                }
                this.fftRows.realInverseFull(fArray2[n2 - 1], bl);
            } else {
                for (n6 = 0; n6 < this.rows; ++n6) {
                    n5 = 2 * n6;
                    n4 = n6 * this.columns;
                    int n8 = n2 - 1;
                    fArray2[n8][n5] = fArray[n4 + 2 * n8];
                    fArray2[n8][n5 + 1] = fArray[n4 + 1];
                }
                this.fftRows.complexInverse(fArray2[n2 - 1], bl);
            }
            n7 = this.rows / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = n6 * n7;
                n4 = n6 == n3 - 1 ? this.rows : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n5; i < n4; ++i) {
                            int n6 = 2 * i;
                            for (int j = 0; j < n2; ++j) {
                                int n22 = 2 * j;
                                int n3 = i * n + n22;
                                fArray[n3] = fArray2[j][n6];
                                fArray[n3 + 1] = fArray2[j][n6 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = 1 + n6 * n7;
                n4 = n6 == n3 - 1 ? this.rows : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n5; i < n4; ++i) {
                            int n7 = i * n;
                            int n22 = (FloatFFT_2D.this.rows - i + 1) * n;
                            for (int j = n2; j < FloatFFT_2D.this.columns; ++j) {
                                int n3 = 2 * j;
                                int n42 = 2 * (FloatFFT_2D.this.columns - j);
                                fArray[n3] = fArray[n42];
                                fArray[n3 + 1] = -fArray[n42 + 1];
                                int n52 = n7 + n3;
                                int n6 = n22 - n3;
                                fArray[n52] = fArray[n6];
                                fArray[n52 + 1] = -fArray[n6 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            for (n13 = 0; n13 < this.rows; ++n13) {
                this.fftColumns.realInverse2(fArray, n13 * this.columns, bl);
            }
            for (n13 = 0; n13 < this.rows; ++n13) {
                fArray2[0][n13] = fArray[n13 * this.columns];
            }
            this.fftRows.realInverseFull(fArray2[0], bl);
            for (n13 = 1; n13 < n2 - 1; ++n13) {
                n12 = 2 * n13;
                for (n11 = 0; n11 < this.rows; ++n11) {
                    n10 = 2 * n11;
                    n9 = n11 * this.columns + n12;
                    fArray2[n13][n10] = fArray[n9];
                    fArray2[n13][n10 + 1] = fArray[n9 + 1];
                }
                this.fftRows.complexInverse(fArray2[n13], bl);
            }
            if (this.columns % 2 == 0) {
                for (n13 = 0; n13 < this.rows; ++n13) {
                    fArray2[n2 - 1][n13] = fArray[n13 * this.columns + 1];
                }
                this.fftRows.realInverseFull(fArray2[n2 - 1], bl);
            } else {
                for (n13 = 0; n13 < this.rows; ++n13) {
                    n12 = 2 * n13;
                    n11 = n13 * this.columns;
                    n10 = n2 - 1;
                    fArray2[n10][n12] = fArray[n11 + 2 * n10];
                    fArray2[n10][n12 + 1] = fArray[n11 + 1];
                }
                this.fftRows.complexInverse(fArray2[n2 - 1], bl);
            }
            for (n13 = 0; n13 < this.rows; ++n13) {
                n12 = 2 * n13;
                for (n11 = 0; n11 < n2; ++n11) {
                    n10 = 2 * n11;
                    n9 = n13 * n + n10;
                    fArray[n9] = fArray2[n11][n12];
                    fArray[n9 + 1] = fArray2[n11][n12 + 1];
                }
            }
            for (n13 = 1; n13 < this.rows; ++n13) {
                n12 = n13 * n;
                n11 = (this.rows - n13 + 1) * n;
                for (n10 = n2; n10 < this.columns; ++n10) {
                    n9 = 2 * n10;
                    int n14 = 2 * (this.columns - n10);
                    fArray[n9] = fArray[n14];
                    fArray[n9 + 1] = -fArray[n14 + 1];
                    int n15 = n12 + n9;
                    int n16 = n11 - n9;
                    fArray[n15] = fArray[n16];
                    fArray[n15 + 1] = -fArray[n16 + 1];
                }
            }
        }
    }

    private void rdft2d_sub(int n, float[] fArray) {
        int n2 = this.rows >> 1;
        if (n < 0) {
            for (int i = 1; i < n2; ++i) {
                int n3 = this.rows - i;
                int n4 = i * this.columns;
                int n5 = n3 * this.columns;
                float f = fArray[n4] - fArray[n5];
                int n6 = n4;
                fArray[n6] = fArray[n6] + fArray[n5];
                fArray[n5] = f;
                f = fArray[n5 + 1] - fArray[n4 + 1];
                int n7 = n4 + 1;
                fArray[n7] = fArray[n7] + fArray[n5 + 1];
                fArray[n5 + 1] = f;
            }
        } else {
            for (int i = 1; i < n2; ++i) {
                int n8 = this.rows - i;
                int n9 = i * this.columns;
                int n10 = n8 * this.columns;
                fArray[n10] = 0.5f * (fArray[n9] - fArray[n10]);
                int n11 = n9;
                fArray[n11] = fArray[n11] - fArray[n10];
                fArray[n10 + 1] = 0.5f * (fArray[n9 + 1] + fArray[n10 + 1]);
                int n12 = n9 + 1;
                fArray[n12] = fArray[n12] - fArray[n10 + 1];
            }
        }
    }

    private void rdft2d_sub(int n, float[][] fArray) {
        int n2 = this.rows >> 1;
        if (n < 0) {
            for (int i = 1; i < n2; ++i) {
                int n3 = this.rows - i;
                float f = fArray[i][0] - fArray[n3][0];
                float[] fArray2 = fArray[i];
                fArray2[0] = fArray2[0] + fArray[n3][0];
                fArray[n3][0] = f;
                f = fArray[n3][1] - fArray[i][1];
                float[] fArray3 = fArray[i];
                fArray3[1] = fArray3[1] + fArray[n3][1];
                fArray[n3][1] = f;
            }
        } else {
            for (int i = 1; i < n2; ++i) {
                int n4 = this.rows - i;
                fArray[n4][0] = 0.5f * (fArray[i][0] - fArray[n4][0]);
                float[] fArray4 = fArray[i];
                fArray4[0] = fArray4[0] - fArray[n4][0];
                fArray[n4][1] = 0.5f * (fArray[i][1] + fArray[n4][1]);
                float[] fArray5 = fArray[i];
                fArray5[1] = fArray5[1] - fArray[n4][1];
            }
        }
    }

    private void cdft2d_sub(int n, float[] fArray, boolean bl) {
        block21: {
            block19: {
                int n2;
                int n3;
                int n4;
                block22: {
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    block20: {
                        if (n != -1) break block19;
                        if (this.columns <= 4) break block20;
                        for (int i = 0; i < this.columns; i += 8) {
                            int n9;
                            int n10;
                            int n11;
                            int n12;
                            int n13;
                            int n14;
                            for (n14 = 0; n14 < this.rows; ++n14) {
                                n13 = n14 * this.columns + i;
                                n12 = 2 * n14;
                                n11 = 2 * this.rows + 2 * n14;
                                n10 = n11 + 2 * this.rows;
                                n9 = n10 + 2 * this.rows;
                                this.t[n12] = fArray[n13];
                                this.t[n12 + 1] = fArray[n13 + 1];
                                this.t[n11] = fArray[n13 + 2];
                                this.t[n11 + 1] = fArray[n13 + 3];
                                this.t[n10] = fArray[n13 + 4];
                                this.t[n10 + 1] = fArray[n13 + 5];
                                this.t[n9] = fArray[n13 + 6];
                                this.t[n9 + 1] = fArray[n13 + 7];
                            }
                            this.fftRows.complexForward(this.t, 0);
                            this.fftRows.complexForward(this.t, 2 * this.rows);
                            this.fftRows.complexForward(this.t, 4 * this.rows);
                            this.fftRows.complexForward(this.t, 6 * this.rows);
                            for (n14 = 0; n14 < this.rows; ++n14) {
                                n13 = n14 * this.columns + i;
                                n12 = 2 * n14;
                                n11 = 2 * this.rows + 2 * n14;
                                n10 = n11 + 2 * this.rows;
                                n9 = n10 + 2 * this.rows;
                                fArray[n13] = this.t[n12];
                                fArray[n13 + 1] = this.t[n12 + 1];
                                fArray[n13 + 2] = this.t[n11];
                                fArray[n13 + 3] = this.t[n11 + 1];
                                fArray[n13 + 4] = this.t[n10];
                                fArray[n13 + 5] = this.t[n10 + 1];
                                fArray[n13 + 6] = this.t[n9];
                                fArray[n13 + 7] = this.t[n9 + 1];
                            }
                        }
                        break block21;
                    }
                    if (this.columns != 4) break block22;
                    for (n8 = 0; n8 < this.rows; ++n8) {
                        n7 = n8 * this.columns;
                        n6 = 2 * n8;
                        n5 = 2 * this.rows + 2 * n8;
                        this.t[n6] = fArray[n7];
                        this.t[n6 + 1] = fArray[n7 + 1];
                        this.t[n5] = fArray[n7 + 2];
                        this.t[n5 + 1] = fArray[n7 + 3];
                    }
                    this.fftRows.complexForward(this.t, 0);
                    this.fftRows.complexForward(this.t, 2 * this.rows);
                    for (n8 = 0; n8 < this.rows; ++n8) {
                        n7 = n8 * this.columns;
                        n6 = 2 * n8;
                        n5 = 2 * this.rows + 2 * n8;
                        fArray[n7] = this.t[n6];
                        fArray[n7 + 1] = this.t[n6 + 1];
                        fArray[n7 + 2] = this.t[n5];
                        fArray[n7 + 3] = this.t[n5 + 1];
                    }
                    break block21;
                }
                if (this.columns != 2) break block21;
                for (n4 = 0; n4 < this.rows; ++n4) {
                    n3 = n4 * this.columns;
                    n2 = 2 * n4;
                    this.t[n2] = fArray[n3];
                    this.t[n2 + 1] = fArray[n3 + 1];
                }
                this.fftRows.complexForward(this.t, 0);
                for (n4 = 0; n4 < this.rows; ++n4) {
                    n3 = n4 * this.columns;
                    n2 = 2 * n4;
                    fArray[n3] = this.t[n2];
                    fArray[n3 + 1] = this.t[n2 + 1];
                }
                break block21;
            }
            if (this.columns > 4) {
                for (int i = 0; i < this.columns; i += 8) {
                    int n15;
                    int n16;
                    int n17;
                    int n18;
                    int n19;
                    int n20;
                    for (n20 = 0; n20 < this.rows; ++n20) {
                        n19 = n20 * this.columns + i;
                        n18 = 2 * n20;
                        n17 = 2 * this.rows + 2 * n20;
                        n16 = n17 + 2 * this.rows;
                        n15 = n16 + 2 * this.rows;
                        this.t[n18] = fArray[n19];
                        this.t[n18 + 1] = fArray[n19 + 1];
                        this.t[n17] = fArray[n19 + 2];
                        this.t[n17 + 1] = fArray[n19 + 3];
                        this.t[n16] = fArray[n19 + 4];
                        this.t[n16 + 1] = fArray[n19 + 5];
                        this.t[n15] = fArray[n19 + 6];
                        this.t[n15 + 1] = fArray[n19 + 7];
                    }
                    this.fftRows.complexInverse(this.t, 0, bl);
                    this.fftRows.complexInverse(this.t, 2 * this.rows, bl);
                    this.fftRows.complexInverse(this.t, 4 * this.rows, bl);
                    this.fftRows.complexInverse(this.t, 6 * this.rows, bl);
                    for (n20 = 0; n20 < this.rows; ++n20) {
                        n19 = n20 * this.columns + i;
                        n18 = 2 * n20;
                        n17 = 2 * this.rows + 2 * n20;
                        n16 = n17 + 2 * this.rows;
                        n15 = n16 + 2 * this.rows;
                        fArray[n19] = this.t[n18];
                        fArray[n19 + 1] = this.t[n18 + 1];
                        fArray[n19 + 2] = this.t[n17];
                        fArray[n19 + 3] = this.t[n17 + 1];
                        fArray[n19 + 4] = this.t[n16];
                        fArray[n19 + 5] = this.t[n16 + 1];
                        fArray[n19 + 6] = this.t[n15];
                        fArray[n19 + 7] = this.t[n15 + 1];
                    }
                }
            } else if (this.columns == 4) {
                int n21;
                int n22;
                int n23;
                int n24;
                for (n24 = 0; n24 < this.rows; ++n24) {
                    n23 = n24 * this.columns;
                    n22 = 2 * n24;
                    n21 = 2 * this.rows + 2 * n24;
                    this.t[n22] = fArray[n23];
                    this.t[n22 + 1] = fArray[n23 + 1];
                    this.t[n21] = fArray[n23 + 2];
                    this.t[n21 + 1] = fArray[n23 + 3];
                }
                this.fftRows.complexInverse(this.t, 0, bl);
                this.fftRows.complexInverse(this.t, 2 * this.rows, bl);
                for (n24 = 0; n24 < this.rows; ++n24) {
                    n23 = n24 * this.columns;
                    n22 = 2 * n24;
                    n21 = 2 * this.rows + 2 * n24;
                    fArray[n23] = this.t[n22];
                    fArray[n23 + 1] = this.t[n22 + 1];
                    fArray[n23 + 2] = this.t[n21];
                    fArray[n23 + 3] = this.t[n21 + 1];
                }
            } else if (this.columns == 2) {
                int n25;
                int n26;
                int n27;
                for (n27 = 0; n27 < this.rows; ++n27) {
                    n26 = n27 * this.columns;
                    n25 = 2 * n27;
                    this.t[n25] = fArray[n26];
                    this.t[n25 + 1] = fArray[n26 + 1];
                }
                this.fftRows.complexInverse(this.t, 0, bl);
                for (n27 = 0; n27 < this.rows; ++n27) {
                    n26 = n27 * this.columns;
                    n25 = 2 * n27;
                    fArray[n26] = this.t[n25];
                    fArray[n26 + 1] = this.t[n25 + 1];
                }
            }
        }
    }

    private void cdft2d_sub(int n, float[][] fArray, boolean bl) {
        block21: {
            block19: {
                int n2;
                int n3;
                block22: {
                    int n4;
                    int n5;
                    int n6;
                    block20: {
                        if (n != -1) break block19;
                        if (this.columns <= 4) break block20;
                        for (int i = 0; i < this.columns; i += 8) {
                            int n7;
                            int n8;
                            int n9;
                            int n10;
                            int n11;
                            for (n11 = 0; n11 < this.rows; ++n11) {
                                n10 = 2 * n11;
                                n9 = 2 * this.rows + 2 * n11;
                                n8 = n9 + 2 * this.rows;
                                n7 = n8 + 2 * this.rows;
                                this.t[n10] = fArray[n11][i];
                                this.t[n10 + 1] = fArray[n11][i + 1];
                                this.t[n9] = fArray[n11][i + 2];
                                this.t[n9 + 1] = fArray[n11][i + 3];
                                this.t[n8] = fArray[n11][i + 4];
                                this.t[n8 + 1] = fArray[n11][i + 5];
                                this.t[n7] = fArray[n11][i + 6];
                                this.t[n7 + 1] = fArray[n11][i + 7];
                            }
                            this.fftRows.complexForward(this.t, 0);
                            this.fftRows.complexForward(this.t, 2 * this.rows);
                            this.fftRows.complexForward(this.t, 4 * this.rows);
                            this.fftRows.complexForward(this.t, 6 * this.rows);
                            for (n11 = 0; n11 < this.rows; ++n11) {
                                n10 = 2 * n11;
                                n9 = 2 * this.rows + 2 * n11;
                                n8 = n9 + 2 * this.rows;
                                n7 = n8 + 2 * this.rows;
                                fArray[n11][i] = this.t[n10];
                                fArray[n11][i + 1] = this.t[n10 + 1];
                                fArray[n11][i + 2] = this.t[n9];
                                fArray[n11][i + 3] = this.t[n9 + 1];
                                fArray[n11][i + 4] = this.t[n8];
                                fArray[n11][i + 5] = this.t[n8 + 1];
                                fArray[n11][i + 6] = this.t[n7];
                                fArray[n11][i + 7] = this.t[n7 + 1];
                            }
                        }
                        break block21;
                    }
                    if (this.columns != 4) break block22;
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        n5 = 2 * n6;
                        n4 = 2 * this.rows + 2 * n6;
                        this.t[n5] = fArray[n6][0];
                        this.t[n5 + 1] = fArray[n6][1];
                        this.t[n4] = fArray[n6][2];
                        this.t[n4 + 1] = fArray[n6][3];
                    }
                    this.fftRows.complexForward(this.t, 0);
                    this.fftRows.complexForward(this.t, 2 * this.rows);
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        n5 = 2 * n6;
                        n4 = 2 * this.rows + 2 * n6;
                        fArray[n6][0] = this.t[n5];
                        fArray[n6][1] = this.t[n5 + 1];
                        fArray[n6][2] = this.t[n4];
                        fArray[n6][3] = this.t[n4 + 1];
                    }
                    break block21;
                }
                if (this.columns != 2) break block21;
                for (n3 = 0; n3 < this.rows; ++n3) {
                    n2 = 2 * n3;
                    this.t[n2] = fArray[n3][0];
                    this.t[n2 + 1] = fArray[n3][1];
                }
                this.fftRows.complexForward(this.t, 0);
                for (n3 = 0; n3 < this.rows; ++n3) {
                    n2 = 2 * n3;
                    fArray[n3][0] = this.t[n2];
                    fArray[n3][1] = this.t[n2 + 1];
                }
                break block21;
            }
            if (this.columns > 4) {
                for (int i = 0; i < this.columns; i += 8) {
                    int n12;
                    int n13;
                    int n14;
                    int n15;
                    int n16;
                    for (n16 = 0; n16 < this.rows; ++n16) {
                        n15 = 2 * n16;
                        n14 = 2 * this.rows + 2 * n16;
                        n13 = n14 + 2 * this.rows;
                        n12 = n13 + 2 * this.rows;
                        this.t[n15] = fArray[n16][i];
                        this.t[n15 + 1] = fArray[n16][i + 1];
                        this.t[n14] = fArray[n16][i + 2];
                        this.t[n14 + 1] = fArray[n16][i + 3];
                        this.t[n13] = fArray[n16][i + 4];
                        this.t[n13 + 1] = fArray[n16][i + 5];
                        this.t[n12] = fArray[n16][i + 6];
                        this.t[n12 + 1] = fArray[n16][i + 7];
                    }
                    this.fftRows.complexInverse(this.t, 0, bl);
                    this.fftRows.complexInverse(this.t, 2 * this.rows, bl);
                    this.fftRows.complexInverse(this.t, 4 * this.rows, bl);
                    this.fftRows.complexInverse(this.t, 6 * this.rows, bl);
                    for (n16 = 0; n16 < this.rows; ++n16) {
                        n15 = 2 * n16;
                        n14 = 2 * this.rows + 2 * n16;
                        n13 = n14 + 2 * this.rows;
                        n12 = n13 + 2 * this.rows;
                        fArray[n16][i] = this.t[n15];
                        fArray[n16][i + 1] = this.t[n15 + 1];
                        fArray[n16][i + 2] = this.t[n14];
                        fArray[n16][i + 3] = this.t[n14 + 1];
                        fArray[n16][i + 4] = this.t[n13];
                        fArray[n16][i + 5] = this.t[n13 + 1];
                        fArray[n16][i + 6] = this.t[n12];
                        fArray[n16][i + 7] = this.t[n12 + 1];
                    }
                }
            } else if (this.columns == 4) {
                int n17;
                int n18;
                int n19;
                for (n19 = 0; n19 < this.rows; ++n19) {
                    n18 = 2 * n19;
                    n17 = 2 * this.rows + 2 * n19;
                    this.t[n18] = fArray[n19][0];
                    this.t[n18 + 1] = fArray[n19][1];
                    this.t[n17] = fArray[n19][2];
                    this.t[n17 + 1] = fArray[n19][3];
                }
                this.fftRows.complexInverse(this.t, 0, bl);
                this.fftRows.complexInverse(this.t, 2 * this.rows, bl);
                for (n19 = 0; n19 < this.rows; ++n19) {
                    n18 = 2 * n19;
                    n17 = 2 * this.rows + 2 * n19;
                    fArray[n19][0] = this.t[n18];
                    fArray[n19][1] = this.t[n18 + 1];
                    fArray[n19][2] = this.t[n17];
                    fArray[n19][3] = this.t[n17 + 1];
                }
            } else if (this.columns == 2) {
                int n20;
                int n21;
                for (n21 = 0; n21 < this.rows; ++n21) {
                    n20 = 2 * n21;
                    this.t[n20] = fArray[n21][0];
                    this.t[n20 + 1] = fArray[n21][1];
                }
                this.fftRows.complexInverse(this.t, 0, bl);
                for (n21 = 0; n21 < this.rows; ++n21) {
                    n20 = 2 * n21;
                    fArray[n21][0] = this.t[n20];
                    fArray[n21][1] = this.t[n20 + 1];
                }
            }
        }
    }

    private void xdft2d0_subth1(final int n, final int n2, final float[] fArray, final boolean bl) {
        final int n3 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            final int n4 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (n == 0) {
                        if (n2 == -1) {
                            for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                                FloatFFT_2D.this.fftColumns.complexForward(fArray, i * FloatFFT_2D.this.columns);
                            }
                        } else {
                            for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                                FloatFFT_2D.this.fftColumns.complexInverse(fArray, i * FloatFFT_2D.this.columns, bl);
                            }
                        }
                    } else if (n2 == 1) {
                        for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                            FloatFFT_2D.this.fftColumns.realForward(fArray, i * FloatFFT_2D.this.columns);
                        }
                    } else {
                        for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                            FloatFFT_2D.this.fftColumns.realInverse(fArray, i * FloatFFT_2D.this.columns, bl);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void xdft2d0_subth2(final int n, final int n2, final float[] fArray, final boolean bl) {
        final int n3 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            final int n4 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (n == 0) {
                        if (n2 == -1) {
                            for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                                FloatFFT_2D.this.fftColumns.complexForward(fArray, i * FloatFFT_2D.this.columns);
                            }
                        } else {
                            for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                                FloatFFT_2D.this.fftColumns.complexInverse(fArray, i * FloatFFT_2D.this.columns, bl);
                            }
                        }
                    } else if (n2 == 1) {
                        for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                            FloatFFT_2D.this.fftColumns.realForward(fArray, i * FloatFFT_2D.this.columns);
                        }
                    } else {
                        for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                            FloatFFT_2D.this.fftColumns.realInverse2(fArray, i * FloatFFT_2D.this.columns, bl);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void xdft2d0_subth1(final int n, final int n2, final float[][] fArray, final boolean bl) {
        final int n3 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            final int n4 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (n == 0) {
                        if (n2 == -1) {
                            for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                                FloatFFT_2D.this.fftColumns.complexForward(fArray[i]);
                            }
                        } else {
                            for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                                FloatFFT_2D.this.fftColumns.complexInverse(fArray[i], bl);
                            }
                        }
                    } else if (n2 == 1) {
                        for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                            FloatFFT_2D.this.fftColumns.realForward(fArray[i]);
                        }
                    } else {
                        for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                            FloatFFT_2D.this.fftColumns.realInverse(fArray[i], bl);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void xdft2d0_subth2(final int n, final int n2, final float[][] fArray, final boolean bl) {
        final int n3 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            final int n4 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (n == 0) {
                        if (n2 == -1) {
                            for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                                FloatFFT_2D.this.fftColumns.complexForward(fArray[i]);
                            }
                        } else {
                            for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                                FloatFFT_2D.this.fftColumns.complexInverse(fArray[i], bl);
                            }
                        }
                    } else if (n2 == 1) {
                        for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                            FloatFFT_2D.this.fftColumns.realForward(fArray[i]);
                        }
                    } else {
                        for (int i = n4; i < FloatFFT_2D.this.rows; i += n3) {
                            FloatFFT_2D.this.fftColumns.realInverse2(fArray[i], 0, bl);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void cdft2d_subth(final int n, final float[] fArray, final boolean bl) {
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        int n3 = 8 * this.rows;
        if (this.columns == 4 * n2) {
            n3 >>= 1;
        } else if (this.columns < 4 * n2) {
            n2 = this.columns >> 1;
            n3 >>= 2;
        }
        Future[] futureArray = new Future[n2];
        final int n4 = n2;
        for (int i = 0; i < n2; ++i) {
            final int n5 = i;
            final int n6 = n3 * i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block21: {
                        block19: {
                            int n24;
                            int n2;
                            int n3;
                            block22: {
                                int n42;
                                int n52;
                                int n62;
                                int n7;
                                block20: {
                                    if (n != -1) break block19;
                                    if (FloatFFT_2D.this.columns <= 4 * n4) break block20;
                                    for (int i = 8 * n5; i < FloatFFT_2D.this.columns; i += 8 * n4) {
                                        int n8;
                                        int n9;
                                        int n10;
                                        int n11;
                                        int n12;
                                        int n13;
                                        for (n13 = 0; n13 < FloatFFT_2D.this.rows; ++n13) {
                                            n12 = n13 * FloatFFT_2D.this.columns + i;
                                            n11 = n6 + 2 * n13;
                                            n10 = n6 + 2 * FloatFFT_2D.this.rows + 2 * n13;
                                            n9 = n10 + 2 * FloatFFT_2D.this.rows;
                                            n8 = n9 + 2 * FloatFFT_2D.this.rows;
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n11] = fArray[n12];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n11 + 1] = fArray[n12 + 1];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n10] = fArray[n12 + 2];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n10 + 1] = fArray[n12 + 3];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n9] = fArray[n12 + 4];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n9 + 1] = fArray[n12 + 5];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n8] = fArray[n12 + 6];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n8 + 1] = fArray[n12 + 7];
                                        }
                                        FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, n6);
                                        FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, n6 + 2 * FloatFFT_2D.this.rows);
                                        FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, n6 + 4 * FloatFFT_2D.this.rows);
                                        FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, n6 + 6 * FloatFFT_2D.this.rows);
                                        for (n13 = 0; n13 < FloatFFT_2D.this.rows; ++n13) {
                                            n12 = n13 * FloatFFT_2D.this.columns + i;
                                            n11 = n6 + 2 * n13;
                                            n10 = n6 + 2 * FloatFFT_2D.this.rows + 2 * n13;
                                            n9 = n10 + 2 * FloatFFT_2D.this.rows;
                                            n8 = n9 + 2 * FloatFFT_2D.this.rows;
                                            fArray[n12] = FloatFFT_2D.this.t[n11];
                                            fArray[n12 + 1] = FloatFFT_2D.this.t[n11 + 1];
                                            fArray[n12 + 2] = FloatFFT_2D.this.t[n10];
                                            fArray[n12 + 3] = FloatFFT_2D.this.t[n10 + 1];
                                            fArray[n12 + 4] = FloatFFT_2D.this.t[n9];
                                            fArray[n12 + 5] = FloatFFT_2D.this.t[n9 + 1];
                                            fArray[n12 + 6] = FloatFFT_2D.this.t[n8];
                                            fArray[n12 + 7] = FloatFFT_2D.this.t[n8 + 1];
                                        }
                                    }
                                    break block21;
                                }
                                if (FloatFFT_2D.this.columns != 4 * n4) break block22;
                                for (n7 = 0; n7 < FloatFFT_2D.this.rows; ++n7) {
                                    n62 = n7 * FloatFFT_2D.this.columns + 4 * n5;
                                    n52 = n6 + 2 * n7;
                                    n42 = n6 + 2 * FloatFFT_2D.this.rows + 2 * n7;
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n52] = fArray[n62];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n52 + 1] = fArray[n62 + 1];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n42] = fArray[n62 + 2];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n42 + 1] = fArray[n62 + 3];
                                }
                                FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, n6);
                                FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, n6 + 2 * FloatFFT_2D.this.rows);
                                for (n7 = 0; n7 < FloatFFT_2D.this.rows; ++n7) {
                                    n62 = n7 * FloatFFT_2D.this.columns + 4 * n5;
                                    n52 = n6 + 2 * n7;
                                    n42 = n6 + 2 * FloatFFT_2D.this.rows + 2 * n7;
                                    fArray[n62] = FloatFFT_2D.this.t[n52];
                                    fArray[n62 + 1] = FloatFFT_2D.this.t[n52 + 1];
                                    fArray[n62 + 2] = FloatFFT_2D.this.t[n42];
                                    fArray[n62 + 3] = FloatFFT_2D.this.t[n42 + 1];
                                }
                                break block21;
                            }
                            if (FloatFFT_2D.this.columns != 2 * n4) break block21;
                            for (n3 = 0; n3 < FloatFFT_2D.this.rows; ++n3) {
                                n2 = n3 * FloatFFT_2D.this.columns + 2 * n5;
                                n24 = n6 + 2 * n3;
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n24] = fArray[n2];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n24 + 1] = fArray[n2 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, n6);
                            for (n3 = 0; n3 < FloatFFT_2D.this.rows; ++n3) {
                                n2 = n3 * FloatFFT_2D.this.columns + 2 * n5;
                                n24 = n6 + 2 * n3;
                                fArray[n2] = FloatFFT_2D.this.t[n24];
                                fArray[n2 + 1] = FloatFFT_2D.this.t[n24 + 1];
                            }
                            break block21;
                        }
                        if (FloatFFT_2D.this.columns > 4 * n4) {
                            for (int i = 8 * n5; i < FloatFFT_2D.this.columns; i += 8 * n4) {
                                int n25;
                                int n14;
                                int n15;
                                int n16;
                                int n17;
                                int n18;
                                for (n18 = 0; n18 < FloatFFT_2D.this.rows; ++n18) {
                                    n17 = n18 * FloatFFT_2D.this.columns + i;
                                    n16 = n6 + 2 * n18;
                                    n15 = n6 + 2 * FloatFFT_2D.this.rows + 2 * n18;
                                    n14 = n15 + 2 * FloatFFT_2D.this.rows;
                                    n25 = n14 + 2 * FloatFFT_2D.this.rows;
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n16] = fArray[n17];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n16 + 1] = fArray[n17 + 1];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n15] = fArray[n17 + 2];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n15 + 1] = fArray[n17 + 3];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n14] = fArray[n17 + 4];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n14 + 1] = fArray[n17 + 5];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n25] = fArray[n17 + 6];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n25 + 1] = fArray[n17 + 7];
                                }
                                FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, n6, bl);
                                FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, n6 + 2 * FloatFFT_2D.this.rows, bl);
                                FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, n6 + 4 * FloatFFT_2D.this.rows, bl);
                                FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, n6 + 6 * FloatFFT_2D.this.rows, bl);
                                for (n18 = 0; n18 < FloatFFT_2D.this.rows; ++n18) {
                                    n17 = n18 * FloatFFT_2D.this.columns + i;
                                    n16 = n6 + 2 * n18;
                                    n15 = n6 + 2 * FloatFFT_2D.this.rows + 2 * n18;
                                    n14 = n15 + 2 * FloatFFT_2D.this.rows;
                                    n25 = n14 + 2 * FloatFFT_2D.this.rows;
                                    fArray[n17] = FloatFFT_2D.this.t[n16];
                                    fArray[n17 + 1] = FloatFFT_2D.this.t[n16 + 1];
                                    fArray[n17 + 2] = FloatFFT_2D.this.t[n15];
                                    fArray[n17 + 3] = FloatFFT_2D.this.t[n15 + 1];
                                    fArray[n17 + 4] = FloatFFT_2D.this.t[n14];
                                    fArray[n17 + 5] = FloatFFT_2D.this.t[n14 + 1];
                                    fArray[n17 + 6] = FloatFFT_2D.this.t[n25];
                                    fArray[n17 + 7] = FloatFFT_2D.this.t[n25 + 1];
                                }
                            }
                        } else if (FloatFFT_2D.this.columns == 4 * n4) {
                            int n26;
                            int n19;
                            int n20;
                            int n21;
                            for (n21 = 0; n21 < FloatFFT_2D.this.rows; ++n21) {
                                n20 = n21 * FloatFFT_2D.this.columns + 4 * n5;
                                n19 = n6 + 2 * n21;
                                n26 = n6 + 2 * FloatFFT_2D.this.rows + 2 * n21;
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n19] = fArray[n20];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n19 + 1] = fArray[n20 + 1];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n26] = fArray[n20 + 2];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n26 + 1] = fArray[n20 + 3];
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, n6, bl);
                            FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, n6 + 2 * FloatFFT_2D.this.rows, bl);
                            for (n21 = 0; n21 < FloatFFT_2D.this.rows; ++n21) {
                                n20 = n21 * FloatFFT_2D.this.columns + 4 * n5;
                                n19 = n6 + 2 * n21;
                                n26 = n6 + 2 * FloatFFT_2D.this.rows + 2 * n21;
                                fArray[n20] = FloatFFT_2D.this.t[n19];
                                fArray[n20 + 1] = FloatFFT_2D.this.t[n19 + 1];
                                fArray[n20 + 2] = FloatFFT_2D.this.t[n26];
                                fArray[n20 + 3] = FloatFFT_2D.this.t[n26 + 1];
                            }
                        } else if (FloatFFT_2D.this.columns == 2 * n4) {
                            int n27;
                            int n22;
                            int n23;
                            for (n23 = 0; n23 < FloatFFT_2D.this.rows; ++n23) {
                                n22 = n23 * FloatFFT_2D.this.columns + 2 * n5;
                                n27 = n6 + 2 * n23;
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n27] = fArray[n22];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n27 + 1] = fArray[n22 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, n6, bl);
                            for (n23 = 0; n23 < FloatFFT_2D.this.rows; ++n23) {
                                n22 = n23 * FloatFFT_2D.this.columns + 2 * n5;
                                n27 = n6 + 2 * n23;
                                fArray[n22] = FloatFFT_2D.this.t[n27];
                                fArray[n22 + 1] = FloatFFT_2D.this.t[n27 + 1];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void cdft2d_subth(final int n, final float[][] fArray, final boolean bl) {
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        int n3 = 8 * this.rows;
        if (this.columns == 4 * n2) {
            n3 >>= 1;
        } else if (this.columns < 4 * n2) {
            n2 = this.columns >> 1;
            n3 >>= 2;
        }
        Future[] futureArray = new Future[n2];
        final int n4 = n2;
        for (int i = 0; i < n4; ++i) {
            final int n5 = i;
            final int n6 = n3 * i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block21: {
                        block19: {
                            int n18;
                            int n2;
                            block22: {
                                int n3;
                                int n42;
                                int n52;
                                block20: {
                                    if (n != -1) break block19;
                                    if (FloatFFT_2D.this.columns <= 4 * n4) break block20;
                                    for (int i = 8 * n5; i < FloatFFT_2D.this.columns; i += 8 * n4) {
                                        int n62;
                                        int n7;
                                        int n8;
                                        int n9;
                                        int n10;
                                        for (n10 = 0; n10 < FloatFFT_2D.this.rows; ++n10) {
                                            n9 = n6 + 2 * n10;
                                            n8 = n6 + 2 * FloatFFT_2D.this.rows + 2 * n10;
                                            n7 = n8 + 2 * FloatFFT_2D.this.rows;
                                            n62 = n7 + 2 * FloatFFT_2D.this.rows;
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n9] = fArray[n10][i];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n9 + 1] = fArray[n10][i + 1];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n8] = fArray[n10][i + 2];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n8 + 1] = fArray[n10][i + 3];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n7] = fArray[n10][i + 4];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n7 + 1] = fArray[n10][i + 5];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n62] = fArray[n10][i + 6];
                                            ((FloatFFT_2D)FloatFFT_2D.this).t[n62 + 1] = fArray[n10][i + 7];
                                        }
                                        FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, n6);
                                        FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, n6 + 2 * FloatFFT_2D.this.rows);
                                        FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, n6 + 4 * FloatFFT_2D.this.rows);
                                        FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, n6 + 6 * FloatFFT_2D.this.rows);
                                        for (n10 = 0; n10 < FloatFFT_2D.this.rows; ++n10) {
                                            n9 = n6 + 2 * n10;
                                            n8 = n6 + 2 * FloatFFT_2D.this.rows + 2 * n10;
                                            n7 = n8 + 2 * FloatFFT_2D.this.rows;
                                            n62 = n7 + 2 * FloatFFT_2D.this.rows;
                                            fArray[n10][i] = FloatFFT_2D.this.t[n9];
                                            fArray[n10][i + 1] = FloatFFT_2D.this.t[n9 + 1];
                                            fArray[n10][i + 2] = FloatFFT_2D.this.t[n8];
                                            fArray[n10][i + 3] = FloatFFT_2D.this.t[n8 + 1];
                                            fArray[n10][i + 4] = FloatFFT_2D.this.t[n7];
                                            fArray[n10][i + 5] = FloatFFT_2D.this.t[n7 + 1];
                                            fArray[n10][i + 6] = FloatFFT_2D.this.t[n62];
                                            fArray[n10][i + 7] = FloatFFT_2D.this.t[n62 + 1];
                                        }
                                    }
                                    break block21;
                                }
                                if (FloatFFT_2D.this.columns != 4 * n4) break block22;
                                for (n52 = 0; n52 < FloatFFT_2D.this.rows; ++n52) {
                                    n42 = n6 + 2 * n52;
                                    n3 = n6 + 2 * FloatFFT_2D.this.rows + 2 * n52;
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n42] = fArray[n52][4 * n5];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n42 + 1] = fArray[n52][4 * n5 + 1];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n3] = fArray[n52][4 * n5 + 2];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n3 + 1] = fArray[n52][4 * n5 + 3];
                                }
                                FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, n6);
                                FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, n6 + 2 * FloatFFT_2D.this.rows);
                                for (n52 = 0; n52 < FloatFFT_2D.this.rows; ++n52) {
                                    n42 = n6 + 2 * n52;
                                    n3 = n6 + 2 * FloatFFT_2D.this.rows + 2 * n52;
                                    fArray[n52][4 * n5] = FloatFFT_2D.this.t[n42];
                                    fArray[n52][4 * n5 + 1] = FloatFFT_2D.this.t[n42 + 1];
                                    fArray[n52][4 * n5 + 2] = FloatFFT_2D.this.t[n3];
                                    fArray[n52][4 * n5 + 3] = FloatFFT_2D.this.t[n3 + 1];
                                }
                                break block21;
                            }
                            if (FloatFFT_2D.this.columns != 2 * n4) break block21;
                            for (n2 = 0; n2 < FloatFFT_2D.this.rows; ++n2) {
                                n18 = n6 + 2 * n2;
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n18] = fArray[n2][2 * n5];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n18 + 1] = fArray[n2][2 * n5 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexForward(FloatFFT_2D.this.t, n6);
                            for (n2 = 0; n2 < FloatFFT_2D.this.rows; ++n2) {
                                n18 = n6 + 2 * n2;
                                fArray[n2][2 * n5] = FloatFFT_2D.this.t[n18];
                                fArray[n2][2 * n5 + 1] = FloatFFT_2D.this.t[n18 + 1];
                            }
                            break block21;
                        }
                        if (FloatFFT_2D.this.columns > 4 * n4) {
                            for (int i = 8 * n5; i < FloatFFT_2D.this.columns; i += 8 * n4) {
                                int n19;
                                int n11;
                                int n12;
                                int n13;
                                int n14;
                                for (n14 = 0; n14 < FloatFFT_2D.this.rows; ++n14) {
                                    n13 = n6 + 2 * n14;
                                    n12 = n6 + 2 * FloatFFT_2D.this.rows + 2 * n14;
                                    n11 = n12 + 2 * FloatFFT_2D.this.rows;
                                    n19 = n11 + 2 * FloatFFT_2D.this.rows;
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n13] = fArray[n14][i];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n13 + 1] = fArray[n14][i + 1];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n12] = fArray[n14][i + 2];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n12 + 1] = fArray[n14][i + 3];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n11] = fArray[n14][i + 4];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n11 + 1] = fArray[n14][i + 5];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n19] = fArray[n14][i + 6];
                                    ((FloatFFT_2D)FloatFFT_2D.this).t[n19 + 1] = fArray[n14][i + 7];
                                }
                                FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, n6, bl);
                                FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, n6 + 2 * FloatFFT_2D.this.rows, bl);
                                FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, n6 + 4 * FloatFFT_2D.this.rows, bl);
                                FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, n6 + 6 * FloatFFT_2D.this.rows, bl);
                                for (n14 = 0; n14 < FloatFFT_2D.this.rows; ++n14) {
                                    n13 = n6 + 2 * n14;
                                    n12 = n6 + 2 * FloatFFT_2D.this.rows + 2 * n14;
                                    n11 = n12 + 2 * FloatFFT_2D.this.rows;
                                    n19 = n11 + 2 * FloatFFT_2D.this.rows;
                                    fArray[n14][i] = FloatFFT_2D.this.t[n13];
                                    fArray[n14][i + 1] = FloatFFT_2D.this.t[n13 + 1];
                                    fArray[n14][i + 2] = FloatFFT_2D.this.t[n12];
                                    fArray[n14][i + 3] = FloatFFT_2D.this.t[n12 + 1];
                                    fArray[n14][i + 4] = FloatFFT_2D.this.t[n11];
                                    fArray[n14][i + 5] = FloatFFT_2D.this.t[n11 + 1];
                                    fArray[n14][i + 6] = FloatFFT_2D.this.t[n19];
                                    fArray[n14][i + 7] = FloatFFT_2D.this.t[n19 + 1];
                                }
                            }
                        } else if (FloatFFT_2D.this.columns == 4 * n4) {
                            int n20;
                            int n15;
                            int n16;
                            for (n16 = 0; n16 < FloatFFT_2D.this.rows; ++n16) {
                                n15 = n6 + 2 * n16;
                                n20 = n6 + 2 * FloatFFT_2D.this.rows + 2 * n16;
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n15] = fArray[n16][4 * n5];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n15 + 1] = fArray[n16][4 * n5 + 1];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n20] = fArray[n16][4 * n5 + 2];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n20 + 1] = fArray[n16][4 * n5 + 3];
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, n6, bl);
                            FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, n6 + 2 * FloatFFT_2D.this.rows, bl);
                            for (n16 = 0; n16 < FloatFFT_2D.this.rows; ++n16) {
                                n15 = n6 + 2 * n16;
                                n20 = n6 + 2 * FloatFFT_2D.this.rows + 2 * n16;
                                fArray[n16][4 * n5] = FloatFFT_2D.this.t[n15];
                                fArray[n16][4 * n5 + 1] = FloatFFT_2D.this.t[n15 + 1];
                                fArray[n16][4 * n5 + 2] = FloatFFT_2D.this.t[n20];
                                fArray[n16][4 * n5 + 3] = FloatFFT_2D.this.t[n20 + 1];
                            }
                        } else if (FloatFFT_2D.this.columns == 2 * n4) {
                            int n21;
                            int n17;
                            for (n17 = 0; n17 < FloatFFT_2D.this.rows; ++n17) {
                                n21 = n6 + 2 * n17;
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n21] = fArray[n17][2 * n5];
                                ((FloatFFT_2D)FloatFFT_2D.this).t[n21 + 1] = fArray[n17][2 * n5 + 1];
                            }
                            FloatFFT_2D.this.fftRows.complexInverse(FloatFFT_2D.this.t, n6, bl);
                            for (n17 = 0; n17 < FloatFFT_2D.this.rows; ++n17) {
                                n21 = n6 + 2 * n17;
                                fArray[n17][2 * n5] = FloatFFT_2D.this.t[n21];
                                fArray[n17][2 * n5 + 1] = FloatFFT_2D.this.t[n21 + 1];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void fillSymmetric(final float[] fArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 2 * this.columns;
        int n6 = this.rows / 2;
        for (n4 = this.rows - 1; n4 >= 1; --n4) {
            n3 = n4 * this.columns;
            n2 = 2 * n3;
            for (n = 0; n < this.columns; n += 2) {
                fArray[n2 + n] = fArray[n3 + n];
                fArray[n3 + n] = 0.0f;
                fArray[n2 + n + 1] = fArray[n3 + n + 1];
                fArray[n3 + n + 1] = 0.0f;
            }
        }
        n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.useThreads && n6 >= n4) {
            Future[] futureArray = new Future[n4];
            int n7 = n6 / n4;
            final int n8 = 2 * this.columns;
            for (int i = 0; i < n4; ++i) {
                final int n9 = i == 0 ? i * n7 + 1 : i * n7;
                final int n10 = i * n7 + n7;
                final int n11 = i * n7;
                final int n12 = i == n4 - 1 ? i * n7 + n7 + 1 : i * n7 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int n;
                        int n2;
                        int n3;
                        int n4;
                        int n5;
                        int n6;
                        for (n6 = n9; n6 < n10; ++n6) {
                            n5 = n6 * n8;
                            n4 = (FloatFFT_2D.this.rows - n6) * n8;
                            n3 = n5 + FloatFFT_2D.this.columns;
                            fArray[n3] = fArray[n4 + 1];
                            fArray[n3 + 1] = -fArray[n4];
                        }
                        for (n6 = n9; n6 < n10; ++n6) {
                            n5 = n6 * n8;
                            n3 = (FloatFFT_2D.this.rows - n6 + 1) * n8;
                            for (n2 = FloatFFT_2D.this.columns + 2; n2 < n8; n2 += 2) {
                                n4 = n3 - n2;
                                n = n5 + n2;
                                fArray[n] = fArray[n4];
                                fArray[n + 1] = -fArray[n4 + 1];
                            }
                        }
                        for (n6 = n11; n6 < n12; ++n6) {
                            n3 = (FloatFFT_2D.this.rows - n6) % FloatFFT_2D.this.rows * n8;
                            n = n6 * n8;
                            for (n2 = 0; n2 < n8; n2 += 2) {
                                n5 = n3 + (n8 - n2) % n8;
                                n4 = n + n2;
                                fArray[n5] = fArray[n4];
                                fArray[n5 + 1] = -fArray[n4 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n13;
            int n14;
            for (n = 1; n < n6; ++n) {
                n2 = n * n5;
                n14 = (this.rows - n) * n5;
                fArray[n2 + this.columns] = fArray[n14 + 1];
                fArray[n2 + this.columns + 1] = -fArray[n14];
            }
            for (n = 1; n < n6; ++n) {
                n2 = n * n5;
                n14 = (this.rows - n + 1) * n5;
                for (n13 = this.columns + 2; n13 < n5; n13 += 2) {
                    fArray[n2 + n13] = fArray[n14 - n13];
                    fArray[n2 + n13 + 1] = -fArray[n14 - n13 + 1];
                }
            }
            for (n = 0; n <= this.rows / 2; ++n) {
                n3 = n * n5;
                int n15 = (this.rows - n) % this.rows * n5;
                for (n13 = 0; n13 < n5; n13 += 2) {
                    n2 = n3 + n13;
                    n14 = n15 + (n5 - n13) % n5;
                    fArray[n14] = fArray[n2];
                    fArray[n14 + 1] = -fArray[n2 + 1];
                }
            }
        }
        fArray[this.columns] = -fArray[1];
        fArray[1] = 0.0f;
        n3 = n6 * n5;
        fArray[n3 + this.columns] = -fArray[n3 + 1];
        fArray[n3 + 1] = 0.0f;
        fArray[n3 + this.columns + 1] = 0.0f;
    }

    private void fillSymmetric(final float[][] fArray) {
        final int n = 2 * this.columns;
        int n2 = this.rows / 2;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.useThreads && n2 >= n3) {
            Future[] futureArray = new Future[n3];
            int n4 = n2 / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i == 0 ? i * n4 + 1 : i * n4;
                final int n6 = i * n4 + n4;
                final int n7 = i * n4;
                final int n8 = i == n3 - 1 ? i * n4 + n4 + 1 : i * n4 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int n9;
                        int n2;
                        int n3;
                        int n4;
                        for (n4 = n5; n4 < n6; ++n4) {
                            n3 = FloatFFT_2D.this.rows - n4;
                            fArray[n4][((FloatFFT_2D)FloatFFT_2D.this).columns] = fArray[n3][1];
                            fArray[n4][((FloatFFT_2D)FloatFFT_2D.this).columns + 1] = -fArray[n3][0];
                        }
                        for (n4 = n5; n4 < n6; ++n4) {
                            n3 = FloatFFT_2D.this.rows - n4;
                            for (n2 = FloatFFT_2D.this.columns + 2; n2 < n; n2 += 2) {
                                n9 = n - n2;
                                fArray[n4][n2] = fArray[n3][n9];
                                fArray[n4][n2 + 1] = -fArray[n3][n9 + 1];
                            }
                        }
                        for (n4 = n7; n4 < n8; ++n4) {
                            n3 = (FloatFFT_2D.this.rows - n4) % FloatFFT_2D.this.rows;
                            for (n2 = 0; n2 < n; n2 += 2) {
                                n9 = (n - n2) % n;
                                fArray[n3][n9] = fArray[n4][n2];
                                fArray[n3][n9 + 1] = -fArray[n4][n2 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9;
            int n10;
            int n11;
            int n12;
            for (n12 = 1; n12 < n2; ++n12) {
                n11 = this.rows - n12;
                fArray[n12][this.columns] = fArray[n11][1];
                fArray[n12][this.columns + 1] = -fArray[n11][0];
            }
            for (n12 = 1; n12 < n2; ++n12) {
                n11 = this.rows - n12;
                for (n10 = this.columns + 2; n10 < n; n10 += 2) {
                    n9 = n - n10;
                    fArray[n12][n10] = fArray[n11][n9];
                    fArray[n12][n10 + 1] = -fArray[n11][n9 + 1];
                }
            }
            for (n12 = 0; n12 <= this.rows / 2; ++n12) {
                n11 = (this.rows - n12) % this.rows;
                for (n10 = 0; n10 < n; n10 += 2) {
                    n9 = (n - n10) % n;
                    fArray[n11][n9] = fArray[n12][n10];
                    fArray[n11][n9 + 1] = -fArray[n12][n10 + 1];
                }
            }
        }
        fArray[0][this.columns] = -fArray[0][1];
        fArray[0][1] = 0.0f;
        fArray[n2][this.columns] = -fArray[n2][1];
        fArray[n2][1] = 0.0f;
        fArray[n2][this.columns + 1] = 0.0f;
    }
}

