/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.fft;

import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public strictfp class FloatFFT_1D {
    private int n;
    private int nBluestein;
    private int[] ip;
    private float[] w;
    private int nw;
    private int nc;
    private float[] wtable;
    private float[] wtable_r;
    private float[] bk1;
    private float[] bk2;
    private Plans plan;
    private static final int[] factors = new int[]{4, 2, 3, 5};
    private static final float PI = (float)Math.PI;
    private static final float TWO_PI = (float)Math.PI * 2;

    public FloatFFT_1D(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("n must be greater than 0");
        }
        this.n = n;
        if (!ConcurrencyUtils.isPowerOf2(n)) {
            if (FloatFFT_1D.getReminder(n, factors) >= 211) {
                this.plan = Plans.BLUESTEIN;
                this.nBluestein = ConcurrencyUtils.nextPow2(n * 2 - 1);
                this.bk1 = new float[2 * this.nBluestein];
                this.bk2 = new float[2 * this.nBluestein];
                this.ip = new int[2 + (int)Math.ceil(2 + (1 << (int)(Math.log((double)this.nBluestein + 0.5) / Math.log(2.0)) / 2))];
                this.w = new float[this.nBluestein];
                int n2 = 2 * this.nBluestein;
                this.nw = this.ip[0];
                if (n2 > this.nw << 2) {
                    this.nw = n2 >> 2;
                    this.makewt(this.nw);
                }
                this.nc = this.ip[1];
                if (this.nBluestein > this.nc << 2) {
                    this.nc = this.nBluestein >> 2;
                    this.makect(this.nc, this.w, this.nw);
                }
                this.bluesteini();
            } else {
                this.plan = Plans.MIXED_RADIX;
                this.wtable = new float[4 * n + 15];
                this.wtable_r = new float[2 * n + 15];
                this.cffti();
                this.rffti();
            }
        } else {
            this.plan = Plans.SPLIT_RADIX;
            this.ip = new int[2 + (int)Math.ceil(2 + (1 << (int)(Math.log((double)n + 0.5) / Math.log(2.0)) / 2))];
            this.w = new float[n];
            int n3 = 2 * n;
            this.nw = this.ip[0];
            if (n3 > this.nw << 2) {
                this.nw = n3 >> 2;
                this.makewt(this.nw);
            }
            this.nc = this.ip[1];
            if (n > this.nc << 2) {
                this.nc = n >> 2;
                this.makect(this.nc, this.w, this.nw);
            }
        }
    }

    public void complexForward(float[] fArray) {
        this.complexForward(fArray, 0);
    }

    public void complexForward(float[] fArray, int n) {
        if (this.n == 1) {
            return;
        }
        switch (this.plan) {
            case SPLIT_RADIX: {
                this.cftbsub(2 * this.n, fArray, n, this.ip, this.nw, this.w);
                break;
            }
            case MIXED_RADIX: {
                this.cfftf(fArray, n, -1);
                break;
            }
            case BLUESTEIN: {
                this.bluestein_complex(fArray, n, -1);
            }
        }
    }

    public void complexInverse(float[] fArray, boolean bl) {
        this.complexInverse(fArray, 0, bl);
    }

    public void complexInverse(float[] fArray, int n, boolean bl) {
        if (this.n == 1) {
            return;
        }
        switch (this.plan) {
            case SPLIT_RADIX: {
                this.cftfsub(2 * this.n, fArray, n, this.ip, this.nw, this.w);
                break;
            }
            case MIXED_RADIX: {
                this.cfftf(fArray, n, 1);
                break;
            }
            case BLUESTEIN: {
                this.bluestein_complex(fArray, n, 1);
            }
        }
        if (bl) {
            this.scale(this.n, fArray, n, true);
        }
    }

    public void realForward(float[] fArray) {
        this.realForward(fArray, 0);
    }

    public void realForward(float[] fArray, int n) {
        if (this.n == 1) {
            return;
        }
        switch (this.plan) {
            case SPLIT_RADIX: {
                if (this.n > 4) {
                    this.cftfsub(this.n, fArray, n, this.ip, this.nw, this.w);
                    this.rftfsub(this.n, fArray, n, this.nc, this.w, this.nw);
                } else if (this.n == 4) {
                    this.cftx020(fArray, n);
                }
                float f = fArray[n] - fArray[n + 1];
                int n2 = n;
                fArray[n2] = fArray[n2] + fArray[n + 1];
                fArray[n + 1] = f;
                break;
            }
            case MIXED_RADIX: {
                this.rfftf(fArray, n);
                for (int i = this.n - 1; i >= 2; --i) {
                    int n3 = n + i;
                    float f = fArray[n3];
                    fArray[n3] = fArray[n3 - 1];
                    fArray[n3 - 1] = f;
                }
                break;
            }
            case BLUESTEIN: {
                this.bluestein_real_forward(fArray, n);
            }
        }
    }

    public void realForwardFull(float[] fArray) {
        this.realForwardFull(fArray, 0);
    }

    public void realForwardFull(final float[] fArray, final int n) {
        final int n2 = 2 * this.n;
        switch (this.plan) {
            case SPLIT_RADIX: {
                this.realForward(fArray, n);
                int n3 = ConcurrencyUtils.getNumberOfThreads();
                if (n3 > 1 && this.n / 2 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    Future[] futureArray = new Future[n3];
                    int n4 = this.n / 2 / n3;
                    for (int i = 0; i < n3; ++i) {
                        final int n5 = i * n4;
                        final int n6 = i == n3 - 1 ? this.n / 2 : n5 + n4;
                        futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                            @Override
                            public void run() {
                                for (int i = n5; i < n6; ++i) {
                                    int n3 = 2 * i;
                                    int n22 = n + (n2 - n3) % n2;
                                    fArray[n22] = fArray[n + n3];
                                    fArray[n22 + 1] = -fArray[n + n3 + 1];
                                }
                            }
                        });
                    }
                    ConcurrencyUtils.waitForCompletion(futureArray);
                } else {
                    for (int i = 0; i < this.n / 2; ++i) {
                        int n7 = 2 * i;
                        int n8 = n + (n2 - n7) % n2;
                        fArray[n8] = fArray[n + n7];
                        fArray[n8 + 1] = -fArray[n + n7 + 1];
                    }
                }
                fArray[n + this.n] = -fArray[n + 1];
                fArray[n + 1] = 0.0f;
                break;
            }
            case MIXED_RADIX: {
                int n9;
                int n10;
                this.rfftf(fArray, n);
                int n11 = this.n % 2 == 0 ? this.n / 2 : (this.n + 1) / 2;
                for (n10 = 1; n10 < n11; ++n10) {
                    n9 = n + n2 - 2 * n10;
                    int n12 = n + 2 * n10;
                    fArray[n9 + 1] = -fArray[n12];
                    fArray[n9] = fArray[n12 - 1];
                }
                for (n10 = 1; n10 < this.n; ++n10) {
                    n9 = n + this.n - n10;
                    float f = fArray[n9 + 1];
                    fArray[n9 + 1] = fArray[n9];
                    fArray[n9] = f;
                }
                fArray[n + 1] = 0.0f;
                break;
            }
            case BLUESTEIN: {
                this.bluestein_real_full(fArray, n, -1);
            }
        }
    }

    public void realInverse(float[] fArray, boolean bl) {
        this.realInverse(fArray, 0, bl);
    }

    public void realInverse(float[] fArray, int n, boolean bl) {
        if (this.n == 1) {
            return;
        }
        switch (this.plan) {
            case SPLIT_RADIX: {
                fArray[n + 1] = (float)(0.5 * (double)(fArray[n] - fArray[n + 1]));
                int n2 = n;
                fArray[n2] = fArray[n2] - fArray[n + 1];
                if (this.n > 4) {
                    this.rftfsub(this.n, fArray, n, this.nc, this.w, this.nw);
                    this.cftbsub(this.n, fArray, n, this.ip, this.nw, this.w);
                } else if (this.n == 4) {
                    this.cftxc020(fArray, n);
                }
                if (!bl) break;
                this.scale(this.n / 2, fArray, n, false);
                break;
            }
            case MIXED_RADIX: {
                for (int i = 2; i < this.n; ++i) {
                    int n3 = n + i;
                    float f = fArray[n3 - 1];
                    fArray[n3 - 1] = fArray[n3];
                    fArray[n3] = f;
                }
                this.rfftb(fArray, n);
                if (!bl) break;
                this.scale(this.n, fArray, n, false);
                break;
            }
            case BLUESTEIN: {
                this.bluestein_real_inverse(fArray, n);
                if (!bl) break;
                this.scale(this.n, fArray, n, false);
            }
        }
    }

    public void realInverseFull(float[] fArray, boolean bl) {
        this.realInverseFull(fArray, 0, bl);
    }

    public void realInverseFull(final float[] fArray, final int n, boolean bl) {
        final int n2 = 2 * this.n;
        switch (this.plan) {
            case SPLIT_RADIX: {
                this.realInverse2(fArray, n, bl);
                int n3 = ConcurrencyUtils.getNumberOfThreads();
                if (n3 > 1 && this.n / 2 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    Future[] futureArray = new Future[n3];
                    int n4 = this.n / 2 / n3;
                    for (int i = 0; i < n3; ++i) {
                        final int n5 = i * n4;
                        final int n6 = i == n3 - 1 ? this.n / 2 : n5 + n4;
                        futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                            @Override
                            public void run() {
                                for (int i = n5; i < n6; ++i) {
                                    int n3 = 2 * i;
                                    int n22 = n + (n2 - n3) % n2;
                                    fArray[n22] = fArray[n + n3];
                                    fArray[n22 + 1] = -fArray[n + n3 + 1];
                                }
                            }
                        });
                    }
                    ConcurrencyUtils.waitForCompletion(futureArray);
                } else {
                    for (int i = 0; i < this.n / 2; ++i) {
                        int n7 = 2 * i;
                        int n8 = n + (n2 - n7) % n2;
                        fArray[n8] = fArray[n + n7];
                        fArray[n8 + 1] = -fArray[n + n7 + 1];
                    }
                }
                fArray[n + this.n] = -fArray[n + 1];
                fArray[n + 1] = 0.0f;
                break;
            }
            case MIXED_RADIX: {
                int n9;
                int n10;
                this.rfftf(fArray, n);
                if (bl) {
                    this.scale(this.n, fArray, n, false);
                }
                int n11 = this.n % 2 == 0 ? this.n / 2 : (this.n + 1) / 2;
                for (n10 = 1; n10 < n11; ++n10) {
                    n9 = n + 2 * n10;
                    int n12 = n + n2 - 2 * n10;
                    fArray[n9] = -fArray[n9];
                    fArray[n12 + 1] = -fArray[n9];
                    fArray[n12] = fArray[n9 - 1];
                }
                for (n10 = 1; n10 < this.n; ++n10) {
                    n9 = n + this.n - n10;
                    float f = fArray[n9 + 1];
                    fArray[n9 + 1] = fArray[n9];
                    fArray[n9] = f;
                }
                fArray[n + 1] = 0.0f;
                break;
            }
            case BLUESTEIN: {
                this.bluestein_real_full(fArray, n, 1);
                if (!bl) break;
                this.scale(this.n, fArray, n, true);
            }
        }
    }

    protected void realInverse2(float[] fArray, int n, boolean bl) {
        if (this.n == 1) {
            return;
        }
        switch (this.plan) {
            case SPLIT_RADIX: {
                if (this.n > 4) {
                    this.cftfsub(this.n, fArray, n, this.ip, this.nw, this.w);
                    this.rftbsub(this.n, fArray, n, this.nc, this.w, this.nw);
                } else if (this.n == 4) {
                    this.cftbsub(this.n, fArray, n, this.ip, this.nw, this.w);
                }
                float f = fArray[n] - fArray[n + 1];
                int n2 = n;
                fArray[n2] = fArray[n2] + fArray[n + 1];
                fArray[n + 1] = f;
                if (!bl) break;
                this.scale(this.n, fArray, n, false);
                break;
            }
            case MIXED_RADIX: {
                int n3;
                int n4;
                this.rfftf(fArray, n);
                for (n4 = this.n - 1; n4 >= 2; --n4) {
                    n3 = n + n4;
                    float f = fArray[n3];
                    fArray[n3] = fArray[n3 - 1];
                    fArray[n3 - 1] = f;
                }
                if (bl) {
                    this.scale(this.n, fArray, n, false);
                }
                if (this.n % 2 == 0) {
                    n4 = this.n / 2;
                    for (n3 = 1; n3 < n4; ++n3) {
                        int n5 = n + 2 * n3 + 1;
                        fArray[n5] = -fArray[n5];
                    }
                } else {
                    n4 = (this.n - 1) / 2;
                    for (n3 = 0; n3 < n4; ++n3) {
                        int n6 = n + 2 * n3 + 1;
                        fArray[n6] = -fArray[n6];
                    }
                }
                break;
            }
            case BLUESTEIN: {
                this.bluestein_real_inverse2(fArray, n);
                if (!bl) break;
                this.scale(this.n, fArray, n, false);
            }
        }
    }

    private static int getReminder(int n, int[] nArray) {
        int n2 = n;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive integer");
        }
        for (int i = 0; i < nArray.length && n2 != 1; ++i) {
            int n3 = nArray[i];
            while (n2 % n3 == 0) {
                n2 /= n3;
            }
        }
        return n2;
    }

    void cffti(int n, int n2) {
        int n3;
        int n4;
        if (n == 1) {
            return;
        }
        int n5 = 2 * n;
        int n6 = 4 * n;
        int n7 = 0;
        int n8 = n;
        int n9 = 0;
        int n10 = 0;
        block0: while (true) {
            n7 = ++n10 <= 4 ? factors[n10 - 1] : (n7 += 2);
            do {
                int n11;
                int n12;
                if ((n12 = n8 - n7 * (n11 = n8 / n7)) != 0) continue block0;
                this.wtable[n2 + ++n9 + 1 + n6] = n7;
                n8 = n11;
                if (n7 != 2 || n9 == 1) continue;
                for (n4 = 2; n4 <= n9; ++n4) {
                    int n13 = n9 - n4 + 2;
                    n3 = n13 + n6;
                    this.wtable[n2 + n3 + 1] = this.wtable[n2 + n3];
                }
                this.wtable[n2 + 2 + n6] = 2.0f;
            } while (n8 != 1);
            break;
        }
        this.wtable[n2 + n6] = n;
        this.wtable[n2 + 1 + n6] = n9;
        float f = (float)Math.PI * 2 / (float)n;
        n4 = 1;
        int n14 = 1;
        for (int i = 1; i <= n9; ++i) {
            int n15 = (int)this.wtable[n2 + i + 1 + n6];
            int n16 = 0;
            int n17 = n14 * n15;
            int n18 = n / n17;
            int n19 = n18 + n18 + 2;
            int n20 = n15 - 1;
            for (n10 = 1; n10 <= n20; ++n10) {
                int n21 = n4;
                this.wtable[n2 + n4 - 1 + n5] = 1.0f;
                this.wtable[n2 + n4 + n5] = 0.0f;
                float f2 = 0.0f;
                float f3 = (float)(n16 += n14) * f;
                for (int j = 4; j <= n19; j += 2) {
                    float f4 = (f2 += 1.0f) * f3;
                    n3 = (n4 += 2) + n5;
                    this.wtable[n2 + n3 - 1] = (float)Math.cos(f4);
                    this.wtable[n2 + n3] = (float)Math.sin(f4);
                }
                if (n15 <= 5) continue;
                n3 = n21 + n5;
                int n22 = n4 + n5;
                this.wtable[n2 + n3 - 1] = this.wtable[n2 + n22 - 1];
                this.wtable[n2 + n3] = this.wtable[n2 + n22];
            }
            n14 = n17;
        }
    }

    void cffti() {
        int n;
        int n2;
        if (this.n == 1) {
            return;
        }
        int n3 = 2 * this.n;
        int n4 = 4 * this.n;
        int n5 = 0;
        int n6 = this.n;
        int n7 = 0;
        int n8 = 0;
        block0: while (true) {
            n5 = ++n8 <= 4 ? factors[n8 - 1] : (n5 += 2);
            do {
                int n9;
                int n10;
                if ((n10 = n6 - n5 * (n9 = n6 / n5)) != 0) continue block0;
                this.wtable[++n7 + 1 + n4] = n5;
                n6 = n9;
                if (n5 != 2 || n7 == 1) continue;
                for (n2 = 2; n2 <= n7; ++n2) {
                    int n11 = n7 - n2 + 2;
                    n = n11 + n4;
                    this.wtable[n + 1] = this.wtable[n];
                }
                this.wtable[2 + n4] = 2.0f;
            } while (n6 != 1);
            break;
        }
        this.wtable[n4] = this.n;
        this.wtable[1 + n4] = n7;
        float f = (float)Math.PI * 2 / (float)this.n;
        n2 = 1;
        int n12 = 1;
        for (int i = 1; i <= n7; ++i) {
            int n13 = (int)this.wtable[i + 1 + n4];
            int n14 = 0;
            int n15 = n12 * n13;
            int n16 = this.n / n15;
            int n17 = n16 + n16 + 2;
            int n18 = n13 - 1;
            for (n8 = 1; n8 <= n18; ++n8) {
                int n19 = n2;
                this.wtable[n2 - 1 + n3] = 1.0f;
                this.wtable[n2 + n3] = 0.0f;
                float f2 = 0.0f;
                float f3 = (float)(n14 += n12) * f;
                for (int j = 4; j <= n17; j += 2) {
                    float f4 = (f2 += 1.0f) * f3;
                    n = (n2 += 2) + n3;
                    this.wtable[n - 1] = (float)Math.cos(f4);
                    this.wtable[n] = (float)Math.sin(f4);
                }
                if (n13 <= 5) continue;
                n = n19 + n3;
                int n20 = n2 + n3;
                this.wtable[n - 1] = this.wtable[n20 - 1];
                this.wtable[n] = this.wtable[n20];
            }
            n12 = n15;
        }
    }

    void rffti() {
        int n;
        int n2;
        if (this.n == 1) {
            return;
        }
        int n3 = 2 * this.n;
        int n4 = 0;
        int n5 = this.n;
        int n6 = 0;
        int n7 = 0;
        block0: while (true) {
            n4 = ++n7 <= 4 ? factors[n7 - 1] : (n4 += 2);
            do {
                int n8;
                int n9;
                if ((n9 = n5 - n4 * (n8 = n5 / n4)) != 0) continue block0;
                this.wtable_r[++n6 + 1 + n3] = n4;
                n5 = n8;
                if (n4 != 2 || n6 == 1) continue;
                for (n2 = 2; n2 <= n6; ++n2) {
                    int n10 = n6 - n2 + 2;
                    n = n10 + n3;
                    this.wtable_r[n + 1] = this.wtable_r[n];
                }
                this.wtable_r[2 + n3] = 2.0f;
            } while (n5 != 1);
            break;
        }
        this.wtable_r[n3] = this.n;
        this.wtable_r[1 + n3] = n6;
        float f = (float)Math.PI * 2 / (float)this.n;
        int n11 = 0;
        int n12 = n6 - 1;
        int n13 = 1;
        if (n12 == 0) {
            return;
        }
        for (int i = 1; i <= n12; ++i) {
            int n14 = (int)this.wtable_r[i + 1 + n3];
            int n15 = 0;
            int n16 = n13 * n14;
            int n17 = this.n / n16;
            int n18 = n14 - 1;
            for (n7 = 1; n7 <= n18; ++n7) {
                n2 = n11;
                float f2 = (float)(n15 += n13) * f;
                float f3 = 0.0f;
                for (int j = 3; j <= n17; j += 2) {
                    float f4 = (f3 += 1.0f) * f2;
                    n = (n2 += 2) + this.n;
                    this.wtable_r[n - 2] = (float)Math.cos(f4);
                    this.wtable_r[n - 1] = (float)Math.sin(f4);
                }
                n11 += n17;
            }
            n13 = n16;
        }
    }

    private void bluesteini() {
        int n = 0;
        float f = (float)Math.PI / (float)this.n;
        this.bk1[0] = 1.0f;
        this.bk1[1] = 0.0f;
        for (int i = 1; i < this.n; ++i) {
            if ((n += 2 * i - 1) >= 2 * this.n) {
                n -= 2 * this.n;
            }
            float f2 = f * (float)n;
            this.bk1[2 * i] = (float)Math.cos(f2);
            this.bk1[2 * i + 1] = (float)Math.sin(f2);
        }
        float f3 = (float)(1.0 / (double)this.nBluestein);
        this.bk2[0] = this.bk1[0] * f3;
        this.bk2[1] = this.bk1[1] * f3;
        for (int i = 2; i < 2 * this.n; i += 2) {
            this.bk2[i] = this.bk1[i] * f3;
            this.bk2[i + 1] = this.bk1[i + 1] * f3;
            this.bk2[2 * this.nBluestein - i] = this.bk2[i];
            this.bk2[2 * this.nBluestein - i + 1] = this.bk2[i + 1];
        }
        this.cftbsub(2 * this.nBluestein, this.bk2, 0, this.ip, this.nw, this.w);
    }

    private void makewt(int n) {
        this.ip[0] = n;
        this.ip[1] = 1;
        if (n > 2) {
            int n2;
            int n3 = n >> 1;
            float f = (float)(0.7853981633974483 / (double)n3);
            float f2 = f * 2.0f;
            float f3 = (float)Math.cos(f * (float)n3);
            this.w[0] = 1.0f;
            this.w[1] = f3;
            if (n3 == 4) {
                this.w[2] = (float)Math.cos(f2);
                this.w[3] = (float)Math.sin(f2);
            } else if (n3 > 4) {
                this.makeipt(n);
                this.w[2] = (float)(0.5 / Math.cos(f2));
                this.w[3] = (float)(0.5 / Math.cos(f * 6.0f));
                for (n2 = 4; n2 < n3; n2 += 4) {
                    float f4 = f * (float)n2;
                    float f5 = 3.0f * f4;
                    this.w[n2] = (float)Math.cos(f4);
                    this.w[n2 + 1] = (float)Math.sin(f4);
                    this.w[n2 + 2] = (float)Math.cos(f5);
                    this.w[n2 + 3] = (float)(-Math.sin(f5));
                }
            }
            int n4 = 0;
            while (n3 > 2) {
                float f6;
                float f7;
                int n5 = n4 + n3;
                this.w[n5] = 1.0f;
                this.w[n5 + 1] = f3;
                if ((n3 >>= 1) == 4) {
                    f7 = this.w[n4 + 4];
                    f6 = this.w[n4 + 5];
                    this.w[n5 + 2] = f7;
                    this.w[n5 + 3] = f6;
                } else if (n3 > 4) {
                    f7 = this.w[n4 + 4];
                    float f8 = this.w[n4 + 6];
                    this.w[n5 + 2] = (float)(0.5 / (double)f7);
                    this.w[n5 + 3] = (float)(0.5 / (double)f8);
                    for (n2 = 4; n2 < n3; n2 += 4) {
                        int n6 = n4 + 2 * n2;
                        int n7 = n5 + n2;
                        f7 = this.w[n6];
                        f6 = this.w[n6 + 1];
                        f8 = this.w[n6 + 2];
                        float f9 = this.w[n6 + 3];
                        this.w[n7] = f7;
                        this.w[n7 + 1] = f6;
                        this.w[n7 + 2] = f8;
                        this.w[n7 + 3] = f9;
                    }
                }
                n4 = n5;
            }
        }
    }

    private void makeipt(int n) {
        this.ip[2] = 0;
        this.ip[3] = 16;
        int n2 = 2;
        for (int i = n; i > 32; i >>= 2) {
            int n3 = n2 << 1;
            int n4 = n3 << 3;
            for (int j = n2; j < n3; ++j) {
                int n5;
                this.ip[n2 + j] = n5 = this.ip[j] << 2;
                this.ip[n3 + j] = n5 + n4;
            }
            n2 = n3;
        }
    }

    private void makect(int n, float[] fArray, int n2) {
        this.ip[1] = n;
        if (n > 1) {
            int n3 = n >> 1;
            float f = (float)(0.7853981633974483 / (double)n3);
            fArray[n2] = (float)Math.cos(f * (float)n3);
            fArray[n2 + n3] = (float)(0.5 * (double)fArray[n2]);
            for (int i = 1; i < n3; ++i) {
                float f2 = f * (float)i;
                fArray[n2 + i] = (float)(0.5 * Math.cos(f2));
                fArray[n2 + n - i] = (float)(0.5 * Math.sin(f2));
            }
        }
    }

    private void bluestein_complex(final float[] fArray, final int n, final int n2) {
        final float[] fArray2 = new float[2 * this.nBluestein];
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n4;
            int n5;
            int n6;
            n3 = 2;
            if (n3 >= 4 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n3 = 4;
            }
            Future[] futureArray = new Future[n3];
            int n7 = this.n / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = n6 * n7;
                n4 = n6 == n3 - 1 ? this.n : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (n2 > 0) {
                            for (int i = n5; i < n4; ++i) {
                                int n8 = 2 * i;
                                int n22 = n8 + 1;
                                int n3 = n + n8;
                                int n42 = n + n22;
                                fArray2[n8] = fArray[n3] * FloatFFT_1D.this.bk1[n8] - fArray[n42] * FloatFFT_1D.this.bk1[n22];
                                fArray2[n22] = fArray[n3] * FloatFFT_1D.this.bk1[n22] + fArray[n42] * FloatFFT_1D.this.bk1[n8];
                            }
                        } else {
                            for (int i = n5; i < n4; ++i) {
                                int n9 = 2 * i;
                                int n52 = n9 + 1;
                                int n6 = n + n9;
                                int n7 = n + n52;
                                fArray2[n9] = fArray[n6] * FloatFFT_1D.this.bk1[n9] + fArray[n7] * FloatFFT_1D.this.bk1[n52];
                                fArray2[n52] = -fArray[n6] * FloatFFT_1D.this.bk1[n52] + fArray[n7] * FloatFFT_1D.this.bk1[n9];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            this.cftbsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
            n7 = this.nBluestein / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = n6 * n7;
                n4 = n6 == n3 - 1 ? this.nBluestein : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (n2 > 0) {
                            for (int i = n5; i < n4; ++i) {
                                int n = 2 * i;
                                int n22 = n + 1;
                                float f = -fArray2[n] * FloatFFT_1D.this.bk2[n22] + fArray2[n22] * FloatFFT_1D.this.bk2[n];
                                fArray2[n] = fArray2[n] * FloatFFT_1D.this.bk2[n] + fArray2[n22] * FloatFFT_1D.this.bk2[n22];
                                fArray2[n22] = f;
                            }
                        } else {
                            for (int i = n5; i < n4; ++i) {
                                int n = 2 * i;
                                int n3 = n + 1;
                                float f = fArray2[n] * FloatFFT_1D.this.bk2[n3] + fArray2[n3] * FloatFFT_1D.this.bk2[n];
                                fArray2[n] = fArray2[n] * FloatFFT_1D.this.bk2[n] - fArray2[n3] * FloatFFT_1D.this.bk2[n3];
                                fArray2[n3] = f;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            this.cftfsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
            n7 = this.n / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = n6 * n7;
                n4 = n6 == n3 - 1 ? this.n : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (n2 > 0) {
                            for (int i = n5; i < n4; ++i) {
                                int n8 = 2 * i;
                                int n22 = n8 + 1;
                                int n3 = n + n8;
                                int n42 = n + n22;
                                fArray[n3] = FloatFFT_1D.this.bk1[n8] * fArray2[n8] - FloatFFT_1D.this.bk1[n22] * fArray2[n22];
                                fArray[n42] = FloatFFT_1D.this.bk1[n22] * fArray2[n8] + FloatFFT_1D.this.bk1[n8] * fArray2[n22];
                            }
                        } else {
                            for (int i = n5; i < n4; ++i) {
                                int n9 = 2 * i;
                                int n52 = n9 + 1;
                                int n6 = n + n9;
                                int n7 = n + n52;
                                fArray[n6] = FloatFFT_1D.this.bk1[n9] * fArray2[n9] + FloatFFT_1D.this.bk1[n52] * fArray2[n52];
                                fArray[n7] = -FloatFFT_1D.this.bk1[n52] * fArray2[n9] + FloatFFT_1D.this.bk1[n9] * fArray2[n52];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            if (n2 > 0) {
                for (n12 = 0; n12 < this.n; ++n12) {
                    n11 = 2 * n12;
                    n10 = n11 + 1;
                    n9 = n + n11;
                    n8 = n + n10;
                    fArray2[n11] = fArray[n9] * this.bk1[n11] - fArray[n8] * this.bk1[n10];
                    fArray2[n10] = fArray[n9] * this.bk1[n10] + fArray[n8] * this.bk1[n11];
                }
            } else {
                for (n12 = 0; n12 < this.n; ++n12) {
                    n11 = 2 * n12;
                    n10 = n11 + 1;
                    n9 = n + n11;
                    n8 = n + n10;
                    fArray2[n11] = fArray[n9] * this.bk1[n11] + fArray[n8] * this.bk1[n10];
                    fArray2[n10] = -fArray[n9] * this.bk1[n10] + fArray[n8] * this.bk1[n11];
                }
            }
            this.cftbsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
            if (n2 > 0) {
                for (n12 = 0; n12 < this.nBluestein; ++n12) {
                    n11 = 2 * n12;
                    n10 = n11 + 1;
                    float f = -fArray2[n11] * this.bk2[n10] + fArray2[n10] * this.bk2[n11];
                    fArray2[n11] = fArray2[n11] * this.bk2[n11] + fArray2[n10] * this.bk2[n10];
                    fArray2[n10] = f;
                }
            } else {
                for (n12 = 0; n12 < this.nBluestein; ++n12) {
                    n11 = 2 * n12;
                    n10 = n11 + 1;
                    float f = fArray2[n11] * this.bk2[n10] + fArray2[n10] * this.bk2[n11];
                    fArray2[n11] = fArray2[n11] * this.bk2[n11] - fArray2[n10] * this.bk2[n10];
                    fArray2[n10] = f;
                }
            }
            this.cftfsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
            if (n2 > 0) {
                for (n12 = 0; n12 < this.n; ++n12) {
                    n11 = 2 * n12;
                    n10 = n11 + 1;
                    int n13 = n + n11;
                    n8 = n + n10;
                    fArray[n13] = this.bk1[n11] * fArray2[n11] - this.bk1[n10] * fArray2[n10];
                    fArray[n8] = this.bk1[n10] * fArray2[n11] + this.bk1[n11] * fArray2[n10];
                }
            } else {
                for (n12 = 0; n12 < this.n; ++n12) {
                    n11 = 2 * n12;
                    n10 = n11 + 1;
                    int n14 = n + n11;
                    n8 = n + n10;
                    fArray[n14] = this.bk1[n11] * fArray2[n11] + this.bk1[n10] * fArray2[n10];
                    fArray[n8] = -this.bk1[n10] * fArray2[n11] + this.bk1[n11] * fArray2[n10];
                }
            }
        }
    }

    private void bluestein_real_full(final float[] fArray, final int n, final int n2) {
        final float[] fArray2 = new float[2 * this.nBluestein];
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n4;
            int n5;
            int n6;
            n3 = 2;
            if (n3 >= 4 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n3 = 4;
            }
            Future[] futureArray = new Future[n3];
            int n7 = this.n / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = n6 * n7;
                n4 = n6 == n3 - 1 ? this.n : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (n2 > 0) {
                            for (int i = n5; i < n4; ++i) {
                                int n6 = 2 * i;
                                int n22 = n6 + 1;
                                int n3 = n + i;
                                fArray2[n6] = fArray[n3] * FloatFFT_1D.this.bk1[n6];
                                fArray2[n22] = fArray[n3] * FloatFFT_1D.this.bk1[n22];
                            }
                        } else {
                            for (int i = n5; i < n4; ++i) {
                                int n7 = 2 * i;
                                int n42 = n7 + 1;
                                int n52 = n + i;
                                fArray2[n7] = fArray[n52] * FloatFFT_1D.this.bk1[n7];
                                fArray2[n42] = -fArray[n52] * FloatFFT_1D.this.bk1[n42];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            this.cftbsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
            n7 = this.nBluestein / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = n6 * n7;
                n4 = n6 == n3 - 1 ? this.nBluestein : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (n2 > 0) {
                            for (int i = n5; i < n4; ++i) {
                                int n = 2 * i;
                                int n22 = n + 1;
                                float f = -fArray2[n] * FloatFFT_1D.this.bk2[n22] + fArray2[n22] * FloatFFT_1D.this.bk2[n];
                                fArray2[n] = fArray2[n] * FloatFFT_1D.this.bk2[n] + fArray2[n22] * FloatFFT_1D.this.bk2[n22];
                                fArray2[n22] = f;
                            }
                        } else {
                            for (int i = n5; i < n4; ++i) {
                                int n = 2 * i;
                                int n3 = n + 1;
                                float f = fArray2[n] * FloatFFT_1D.this.bk2[n3] + fArray2[n3] * FloatFFT_1D.this.bk2[n];
                                fArray2[n] = fArray2[n] * FloatFFT_1D.this.bk2[n] - fArray2[n3] * FloatFFT_1D.this.bk2[n3];
                                fArray2[n3] = f;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            this.cftfsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
            n7 = this.n / n3;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = n6 * n7;
                n4 = n6 == n3 - 1 ? this.n : n5 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (n2 > 0) {
                            for (int i = n5; i < n4; ++i) {
                                int n6 = 2 * i;
                                int n22 = n6 + 1;
                                fArray[n + n6] = FloatFFT_1D.this.bk1[n6] * fArray2[n6] - FloatFFT_1D.this.bk1[n22] * fArray2[n22];
                                fArray[n + n22] = FloatFFT_1D.this.bk1[n22] * fArray2[n6] + FloatFFT_1D.this.bk1[n6] * fArray2[n22];
                            }
                        } else {
                            for (int i = n5; i < n4; ++i) {
                                int n7 = 2 * i;
                                int n3 = n7 + 1;
                                fArray[n + n7] = FloatFFT_1D.this.bk1[n7] * fArray2[n7] + FloatFFT_1D.this.bk1[n3] * fArray2[n3];
                                fArray[n + n3] = -FloatFFT_1D.this.bk1[n3] * fArray2[n7] + FloatFFT_1D.this.bk1[n7] * fArray2[n3];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n8;
            int n9;
            int n10;
            int n11;
            if (n2 > 0) {
                for (n11 = 0; n11 < this.n; ++n11) {
                    n10 = 2 * n11;
                    n9 = n10 + 1;
                    n8 = n + n11;
                    fArray2[n10] = fArray[n8] * this.bk1[n10];
                    fArray2[n9] = fArray[n8] * this.bk1[n9];
                }
            } else {
                for (n11 = 0; n11 < this.n; ++n11) {
                    n10 = 2 * n11;
                    n9 = n10 + 1;
                    n8 = n + n11;
                    fArray2[n10] = fArray[n8] * this.bk1[n10];
                    fArray2[n9] = -fArray[n8] * this.bk1[n9];
                }
            }
            this.cftbsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
            if (n2 > 0) {
                for (n11 = 0; n11 < this.nBluestein; ++n11) {
                    n10 = 2 * n11;
                    n9 = n10 + 1;
                    float f = -fArray2[n10] * this.bk2[n9] + fArray2[n9] * this.bk2[n10];
                    fArray2[n10] = fArray2[n10] * this.bk2[n10] + fArray2[n9] * this.bk2[n9];
                    fArray2[n9] = f;
                }
            } else {
                for (n11 = 0; n11 < this.nBluestein; ++n11) {
                    n10 = 2 * n11;
                    n9 = n10 + 1;
                    float f = fArray2[n10] * this.bk2[n9] + fArray2[n9] * this.bk2[n10];
                    fArray2[n10] = fArray2[n10] * this.bk2[n10] - fArray2[n9] * this.bk2[n9];
                    fArray2[n9] = f;
                }
            }
            this.cftfsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
            if (n2 > 0) {
                for (n11 = 0; n11 < this.n; ++n11) {
                    n10 = 2 * n11;
                    n9 = n10 + 1;
                    fArray[n + n10] = this.bk1[n10] * fArray2[n10] - this.bk1[n9] * fArray2[n9];
                    fArray[n + n9] = this.bk1[n9] * fArray2[n10] + this.bk1[n10] * fArray2[n9];
                }
            } else {
                for (n11 = 0; n11 < this.n; ++n11) {
                    n10 = 2 * n11;
                    n9 = n10 + 1;
                    fArray[n + n10] = this.bk1[n10] * fArray2[n10] + this.bk1[n9] * fArray2[n9];
                    fArray[n + n9] = -this.bk1[n9] * fArray2[n10] + this.bk1[n10] * fArray2[n9];
                }
            }
        }
    }

    private void bluestein_real_forward(final float[] fArray, final int n) {
        int n2;
        int n3;
        final float[] fArray2 = new float[2 * this.nBluestein];
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n5;
            int n6;
            n4 = 2;
            if (n4 >= 4 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n4 = 4;
            }
            Future[] futureArray = new Future[n4];
            n3 = this.n / n4;
            for (n2 = 0; n2 < n4; ++n2) {
                n6 = n2 * n3;
                n5 = n2 == n4 - 1 ? this.n : n6 + n3;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            int n4 = 2 * i;
                            int n2 = n4 + 1;
                            int n3 = n + i;
                            fArray2[n4] = fArray[n3] * FloatFFT_1D.this.bk1[n4];
                            fArray2[n2] = -fArray[n3] * FloatFFT_1D.this.bk1[n2];
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            this.cftbsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
            n3 = this.nBluestein / n4;
            for (n2 = 0; n2 < n4; ++n2) {
                n6 = n2 * n3;
                n5 = n2 == n4 - 1 ? this.nBluestein : n6 + n3;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            int n = 2 * i;
                            int n2 = n + 1;
                            float f = fArray2[n] * FloatFFT_1D.this.bk2[n2] + fArray2[n2] * FloatFFT_1D.this.bk2[n];
                            fArray2[n] = fArray2[n] * FloatFFT_1D.this.bk2[n] - fArray2[n2] * FloatFFT_1D.this.bk2[n2];
                            fArray2[n2] = f;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7;
            for (n7 = 0; n7 < this.n; ++n7) {
                n3 = 2 * n7;
                n2 = n3 + 1;
                int n8 = n + n7;
                fArray2[n3] = fArray[n8] * this.bk1[n3];
                fArray2[n2] = -fArray[n8] * this.bk1[n2];
            }
            this.cftbsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
            for (n7 = 0; n7 < this.nBluestein; ++n7) {
                n3 = 2 * n7;
                n2 = n3 + 1;
                float f = fArray2[n3] * this.bk2[n2] + fArray2[n2] * this.bk2[n3];
                fArray2[n3] = fArray2[n3] * this.bk2[n3] - fArray2[n2] * this.bk2[n2];
                fArray2[n2] = f;
            }
        }
        this.cftfsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
        if (this.n % 2 == 0) {
            fArray[n] = this.bk1[0] * fArray2[0] + this.bk1[1] * fArray2[1];
            fArray[n + 1] = this.bk1[this.n] * fArray2[this.n] + this.bk1[this.n + 1] * fArray2[this.n + 1];
            for (int i = 1; i < this.n / 2; ++i) {
                n3 = 2 * i;
                n2 = n3 + 1;
                fArray[n + n3] = this.bk1[n3] * fArray2[n3] + this.bk1[n2] * fArray2[n2];
                fArray[n + n2] = -this.bk1[n2] * fArray2[n3] + this.bk1[n3] * fArray2[n2];
            }
        } else {
            fArray[n] = this.bk1[0] * fArray2[0] + this.bk1[1] * fArray2[1];
            fArray[n + 1] = -this.bk1[this.n] * fArray2[this.n - 1] + this.bk1[this.n - 1] * fArray2[this.n];
            for (int i = 1; i < (this.n - 1) / 2; ++i) {
                n3 = 2 * i;
                n2 = n3 + 1;
                fArray[n + n3] = this.bk1[n3] * fArray2[n3] + this.bk1[n2] * fArray2[n2];
                fArray[n + n2] = -this.bk1[n2] * fArray2[n3] + this.bk1[n3] * fArray2[n2];
            }
            fArray[n + this.n - 1] = this.bk1[this.n - 1] * fArray2[this.n - 1] + this.bk1[this.n] * fArray2[this.n];
        }
    }

    private void bluestein_real_inverse(final float[] fArray, final int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        final float[] fArray2 = new float[2 * this.nBluestein];
        if (this.n % 2 == 0) {
            fArray2[0] = fArray[n] * this.bk1[0];
            fArray2[1] = fArray[n] * this.bk1[1];
            for (n6 = 1; n6 < this.n / 2; ++n6) {
                n5 = 2 * n6;
                n4 = n5 + 1;
                n3 = n + n5;
                n2 = n + n4;
                fArray2[n5] = fArray[n3] * this.bk1[n5] - fArray[n2] * this.bk1[n4];
                fArray2[n4] = fArray[n3] * this.bk1[n4] + fArray[n2] * this.bk1[n5];
            }
            fArray2[this.n] = fArray[n + 1] * this.bk1[this.n];
            fArray2[this.n + 1] = fArray[n + 1] * this.bk1[this.n + 1];
            for (n6 = this.n / 2 + 1; n6 < this.n; ++n6) {
                n5 = 2 * n6;
                n4 = n5 + 1;
                n3 = n + 2 * this.n - n5;
                n2 = n3 + 1;
                fArray2[n5] = fArray[n3] * this.bk1[n5] + fArray[n2] * this.bk1[n4];
                fArray2[n4] = fArray[n3] * this.bk1[n4] - fArray[n2] * this.bk1[n5];
            }
        } else {
            fArray2[0] = fArray[n] * this.bk1[0];
            fArray2[1] = fArray[n] * this.bk1[1];
            for (n6 = 1; n6 < (this.n - 1) / 2; ++n6) {
                n5 = 2 * n6;
                n4 = n5 + 1;
                n3 = n + n5;
                n2 = n + n4;
                fArray2[n5] = fArray[n3] * this.bk1[n5] - fArray[n2] * this.bk1[n4];
                fArray2[n4] = fArray[n3] * this.bk1[n4] + fArray[n2] * this.bk1[n5];
            }
            fArray2[this.n - 1] = fArray[n + this.n - 1] * this.bk1[this.n - 1] - fArray[n + 1] * this.bk1[this.n];
            fArray2[this.n] = fArray[n + this.n - 1] * this.bk1[this.n] + fArray[n + 1] * this.bk1[this.n - 1];
            fArray2[this.n + 1] = fArray[n + this.n - 1] * this.bk1[this.n + 1] + fArray[n + 1] * this.bk1[this.n + 2];
            fArray2[this.n + 2] = fArray[n + this.n - 1] * this.bk1[this.n + 2] - fArray[n + 1] * this.bk1[this.n + 1];
            for (n6 = (this.n - 1) / 2 + 2; n6 < this.n; ++n6) {
                n5 = 2 * n6;
                n4 = n5 + 1;
                n3 = n + 2 * this.n - n5;
                n2 = n3 + 1;
                fArray2[n5] = fArray[n3] * this.bk1[n5] + fArray[n2] * this.bk1[n4];
                fArray2[n4] = fArray[n3] * this.bk1[n4] - fArray[n2] * this.bk1[n5];
            }
        }
        this.cftbsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
        n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n7;
            n6 = 2;
            if (n6 >= 4 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n6 = 4;
            }
            Future[] futureArray = new Future[n6];
            n4 = this.nBluestein / n6;
            for (n3 = 0; n3 < n6; ++n3) {
                n2 = n3 * n4;
                n7 = n3 == n6 - 1 ? this.nBluestein : n2 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n2; i < n7; ++i) {
                            int n = 2 * i;
                            int n22 = n + 1;
                            float f = -fArray2[n] * FloatFFT_1D.this.bk2[n22] + fArray2[n22] * FloatFFT_1D.this.bk2[n];
                            fArray2[n] = fArray2[n] * FloatFFT_1D.this.bk2[n] + fArray2[n22] * FloatFFT_1D.this.bk2[n22];
                            fArray2[n22] = f;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            this.cftfsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
            n4 = this.n / n6;
            for (n3 = 0; n3 < n6; ++n3) {
                n2 = n3 * n4;
                n7 = n3 == n6 - 1 ? this.n : n2 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n2; i < n7; ++i) {
                            int n3 = 2 * i;
                            int n22 = n3 + 1;
                            fArray[n + i] = FloatFFT_1D.this.bk1[n3] * fArray2[n3] - FloatFFT_1D.this.bk1[n22] * fArray2[n22];
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (n5 = 0; n5 < this.nBluestein; ++n5) {
                n4 = 2 * n5;
                n3 = n4 + 1;
                float f = -fArray2[n4] * this.bk2[n3] + fArray2[n3] * this.bk2[n4];
                fArray2[n4] = fArray2[n4] * this.bk2[n4] + fArray2[n3] * this.bk2[n3];
                fArray2[n3] = f;
            }
            this.cftfsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
            for (n5 = 0; n5 < this.n; ++n5) {
                n4 = 2 * n5;
                n3 = n4 + 1;
                fArray[n + n5] = this.bk1[n4] * fArray2[n4] - this.bk1[n3] * fArray2[n3];
            }
        }
    }

    private void bluestein_real_inverse2(final float[] fArray, final int n) {
        int n2;
        int n3;
        final float[] fArray2 = new float[2 * this.nBluestein];
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n5;
            int n6;
            n4 = 2;
            if (n4 >= 4 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                n4 = 4;
            }
            Future[] futureArray = new Future[n4];
            n3 = this.n / n4;
            for (n2 = 0; n2 < n4; ++n2) {
                n6 = n2 * n3;
                n5 = n2 == n4 - 1 ? this.n : n6 + n3;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            int n4 = 2 * i;
                            int n2 = n4 + 1;
                            int n3 = n + i;
                            fArray2[n4] = fArray[n3] * FloatFFT_1D.this.bk1[n4];
                            fArray2[n2] = fArray[n3] * FloatFFT_1D.this.bk1[n2];
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            this.cftbsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
            n3 = this.nBluestein / n4;
            for (n2 = 0; n2 < n4; ++n2) {
                n6 = n2 * n3;
                n5 = n2 == n4 - 1 ? this.nBluestein : n6 + n3;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n6; i < n5; ++i) {
                            int n = 2 * i;
                            int n2 = n + 1;
                            float f = -fArray2[n] * FloatFFT_1D.this.bk2[n2] + fArray2[n2] * FloatFFT_1D.this.bk2[n];
                            fArray2[n] = fArray2[n] * FloatFFT_1D.this.bk2[n] + fArray2[n2] * FloatFFT_1D.this.bk2[n2];
                            fArray2[n2] = f;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7;
            for (n7 = 0; n7 < this.n; ++n7) {
                n3 = 2 * n7;
                n2 = n3 + 1;
                int n8 = n + n7;
                fArray2[n3] = fArray[n8] * this.bk1[n3];
                fArray2[n2] = fArray[n8] * this.bk1[n2];
            }
            this.cftbsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
            for (n7 = 0; n7 < this.nBluestein; ++n7) {
                n3 = 2 * n7;
                n2 = n3 + 1;
                float f = -fArray2[n3] * this.bk2[n2] + fArray2[n2] * this.bk2[n3];
                fArray2[n3] = fArray2[n3] * this.bk2[n3] + fArray2[n2] * this.bk2[n2];
                fArray2[n2] = f;
            }
        }
        this.cftfsub(2 * this.nBluestein, fArray2, 0, this.ip, this.nw, this.w);
        if (this.n % 2 == 0) {
            fArray[n] = this.bk1[0] * fArray2[0] - this.bk1[1] * fArray2[1];
            fArray[n + 1] = this.bk1[this.n] * fArray2[this.n] - this.bk1[this.n + 1] * fArray2[this.n + 1];
            for (int i = 1; i < this.n / 2; ++i) {
                n3 = 2 * i;
                n2 = n3 + 1;
                fArray[n + n3] = this.bk1[n3] * fArray2[n3] - this.bk1[n2] * fArray2[n2];
                fArray[n + n2] = this.bk1[n2] * fArray2[n3] + this.bk1[n3] * fArray2[n2];
            }
        } else {
            fArray[n] = this.bk1[0] * fArray2[0] - this.bk1[1] * fArray2[1];
            fArray[n + 1] = this.bk1[this.n] * fArray2[this.n - 1] + this.bk1[this.n - 1] * fArray2[this.n];
            for (int i = 1; i < (this.n - 1) / 2; ++i) {
                n3 = 2 * i;
                n2 = n3 + 1;
                fArray[n + n3] = this.bk1[n3] * fArray2[n3] - this.bk1[n2] * fArray2[n2];
                fArray[n + n2] = this.bk1[n2] * fArray2[n3] + this.bk1[n3] * fArray2[n2];
            }
            fArray[n + this.n - 1] = this.bk1[this.n - 1] * fArray2[this.n - 1] - this.bk1[this.n] * fArray2[this.n];
        }
    }

    void rfftf(float[] fArray, int n) {
        if (this.n == 1) {
            return;
        }
        float[] fArray2 = new float[this.n];
        int n2 = 2 * this.n;
        int n3 = (int)this.wtable_r[1 + n2];
        int n4 = 1;
        int n5 = this.n;
        int n6 = n2 - 1;
        for (int i = 1; i <= n3; ++i) {
            int n7 = n3 - i;
            int n8 = (int)this.wtable_r[n7 + 2 + n2];
            int n9 = n5 / n8;
            int n10 = this.n / n5;
            int n11 = n10 * n9;
            n6 -= (n8 - 1) * n10;
            n4 = 1 - n4;
            switch (n8) {
                case 2: {
                    if (n4 == 0) {
                        this.radf2(n10, n9, fArray, n, fArray2, 0, n6);
                        break;
                    }
                    this.radf2(n10, n9, fArray2, 0, fArray, n, n6);
                    break;
                }
                case 3: {
                    if (n4 == 0) {
                        this.radf3(n10, n9, fArray, n, fArray2, 0, n6);
                        break;
                    }
                    this.radf3(n10, n9, fArray2, 0, fArray, n, n6);
                    break;
                }
                case 4: {
                    if (n4 == 0) {
                        this.radf4(n10, n9, fArray, n, fArray2, 0, n6);
                        break;
                    }
                    this.radf4(n10, n9, fArray2, 0, fArray, n, n6);
                    break;
                }
                case 5: {
                    if (n4 == 0) {
                        this.radf5(n10, n9, fArray, n, fArray2, 0, n6);
                        break;
                    }
                    this.radf5(n10, n9, fArray2, 0, fArray, n, n6);
                    break;
                }
                default: {
                    if (n10 == 1) {
                        n4 = 1 - n4;
                    }
                    if (n4 == 0) {
                        this.radfg(n10, n8, n9, n11, fArray, n, fArray2, 0, n6);
                        n4 = 1;
                        break;
                    }
                    this.radfg(n10, n8, n9, n11, fArray2, 0, fArray, n, n6);
                    n4 = 0;
                }
            }
            n5 = n9;
        }
        if (n4 == 1) {
            return;
        }
        System.arraycopy(fArray2, 0, fArray, n, this.n);
    }

    void rfftb(float[] fArray, int n) {
        if (this.n == 1) {
            return;
        }
        float[] fArray2 = new float[this.n];
        int n2 = 2 * this.n;
        int n3 = (int)this.wtable_r[1 + n2];
        int n4 = 0;
        int n5 = 1;
        int n6 = this.n;
        for (int i = 1; i <= n3; ++i) {
            int n7 = (int)this.wtable_r[i + 1 + n2];
            int n8 = n7 * n5;
            int n9 = this.n / n8;
            int n10 = n9 * n5;
            switch (n7) {
                case 2: {
                    if (n4 == 0) {
                        this.radb2(n9, n5, fArray, n, fArray2, 0, n6);
                    } else {
                        this.radb2(n9, n5, fArray2, 0, fArray, n, n6);
                    }
                    n4 = 1 - n4;
                    break;
                }
                case 3: {
                    if (n4 == 0) {
                        this.radb3(n9, n5, fArray, n, fArray2, 0, n6);
                    } else {
                        this.radb3(n9, n5, fArray2, 0, fArray, n, n6);
                    }
                    n4 = 1 - n4;
                    break;
                }
                case 4: {
                    if (n4 == 0) {
                        this.radb4(n9, n5, fArray, n, fArray2, 0, n6);
                    } else {
                        this.radb4(n9, n5, fArray2, 0, fArray, n, n6);
                    }
                    n4 = 1 - n4;
                    break;
                }
                case 5: {
                    if (n4 == 0) {
                        this.radb5(n9, n5, fArray, n, fArray2, 0, n6);
                    } else {
                        this.radb5(n9, n5, fArray2, 0, fArray, n, n6);
                    }
                    n4 = 1 - n4;
                    break;
                }
                default: {
                    if (n4 == 0) {
                        this.radbg(n9, n7, n5, n10, fArray, n, fArray2, 0, n6);
                    } else {
                        this.radbg(n9, n7, n5, n10, fArray2, 0, fArray, n, n6);
                    }
                    if (n9 != 1) break;
                    n4 = 1 - n4;
                }
            }
            n5 = n8;
            n6 += (n7 - 1) * n9;
        }
        if (n4 == 0) {
            return;
        }
        System.arraycopy(fArray2, 0, fArray, n, this.n);
    }

    void radf2(int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int n5) {
        int n6;
        float f;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12 = n5;
        int n13 = n2 * n;
        int n14 = 2 * n;
        for (n11 = 0; n11 < n2; ++n11) {
            n10 = n4 + n11 * n14;
            n9 = n10 + n14 - 1;
            n8 = n3 + n11 * n;
            n7 = n8 + n13;
            float f2 = fArray[n8];
            f = fArray[n7];
            fArray2[n10] = f2 + f;
            fArray2[n9] = f2 - f;
        }
        if (n < 2) {
            return;
        }
        if (n != 2) {
            for (n11 = 0; n11 < n2; ++n11) {
                n14 = n11 * n;
                n6 = 2 * n14;
                int n15 = n6 + n;
                int n16 = n14 + n13;
                for (int i = 2; i < n; i += 2) {
                    int n17 = n - i;
                    n10 = i - 1 + n12;
                    n9 = n4 + i + n6;
                    n8 = n4 + n17 + n15;
                    n7 = n3 + i + n14;
                    int n18 = n3 + i + n16;
                    f = fArray[n7 - 1];
                    float f3 = fArray[n7];
                    float f4 = fArray[n18 - 1];
                    float f5 = fArray[n18];
                    float f6 = this.wtable_r[n10 - 1];
                    float f7 = this.wtable_r[n10];
                    float f8 = f6 * f4 + f7 * f5;
                    float f9 = f6 * f5 - f7 * f4;
                    fArray2[n9] = f3 + f9;
                    fArray2[n9 - 1] = f + f8;
                    fArray2[n8] = f9 - f3;
                    fArray2[n8 - 1] = f - f8;
                }
            }
            if (n % 2 == 1) {
                return;
            }
        }
        n6 = 2 * n14;
        for (n11 = 0; n11 < n2; ++n11) {
            n14 = n11 * n;
            n10 = n4 + n6 + n;
            n9 = n3 + n - 1 + n14;
            fArray2[n10] = -fArray[n9 + n13];
            fArray2[n10 - 1] = fArray[n9];
        }
    }

    void radb2(int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13 = n5;
        int n14 = n2 * n;
        for (n12 = 0; n12 < n2; ++n12) {
            n11 = n12 * n;
            n10 = 2 * n11;
            n9 = n10 + n;
            n8 = n4 + n11;
            n7 = n3 + n10;
            n6 = n3 + n - 1 + n9;
            float f = fArray[n7];
            float f2 = fArray[n6];
            fArray2[n8] = f + f2;
            fArray2[n8 + n14] = f - f2;
        }
        if (n < 2) {
            return;
        }
        if (n != 2) {
            for (n12 = 0; n12 < n2; ++n12) {
                n11 = n12 * n;
                n10 = 2 * n11;
                n9 = n10 + n;
                n8 = n11 + n14;
                for (int i = 2; i < n; i += 2) {
                    int n15 = n - i;
                    n7 = i - 1 + n13;
                    n6 = n4 + i;
                    int n16 = n3 + i;
                    int n17 = n3 + n15;
                    float f = this.wtable_r[n7 - 1];
                    float f3 = this.wtable_r[n7];
                    int n18 = n16 + n10;
                    int n19 = n17 + n9;
                    int n20 = n6 + n11;
                    int n21 = n6 + n8;
                    float f4 = fArray[n18 - 1] - fArray[n19 - 1];
                    float f5 = fArray[n18] + fArray[n19];
                    float f6 = fArray[n18];
                    float f7 = fArray[n18 - 1];
                    float f8 = fArray[n19];
                    float f9 = fArray[n19 - 1];
                    fArray2[n20 - 1] = f7 + f9;
                    fArray2[n20] = f6 - f8;
                    fArray2[n21 - 1] = f * f4 - f3 * f5;
                    fArray2[n21] = f * f5 + f3 * f4;
                }
            }
            if (n % 2 == 1) {
                return;
            }
        }
        for (n12 = 0; n12 < n2; ++n12) {
            n11 = n12 * n;
            n10 = 2 * n11;
            n9 = n4 + n - 1 + n11;
            n8 = n3 + n10 + n;
            fArray2[n9] = 2.0f * fArray[n8 - 1];
            fArray2[n9 + n14] = -2.0f * fArray[n8];
        }
    }

    void radf3(int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int n5) {
        float f;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13 = n5;
        int n14 = n13 + n;
        int n15 = n2 * n;
        for (n12 = 0; n12 < n2; ++n12) {
            n11 = n12 * n;
            n10 = 2 * n15;
            n9 = (3 * n12 + 1) * n;
            n8 = n3 + n11;
            n7 = n8 + n15;
            n6 = n8 + n10;
            float f2 = fArray[n8];
            float f3 = fArray[n7];
            float f4 = fArray[n6];
            f = f3 + f4;
            fArray2[n4 + 3 * n11] = f2 + f;
            fArray2[n4 + n9 + n] = 0.8660254f * (f4 - f3);
            fArray2[n4 + n - 1 + n9] = f2 + -0.5f * f;
        }
        if (n == 1) {
            return;
        }
        for (n12 = 0; n12 < n2; ++n12) {
            n11 = n12 * n;
            n10 = 3 * n11;
            n9 = n11 + n15;
            n8 = n9 + n15;
            n7 = n10 + n;
            n6 = n7 + n;
            for (int i = 2; i < n; i += 2) {
                int n16 = n - i;
                int n17 = i - 1 + n13;
                int n18 = i - 1 + n14;
                float f5 = this.wtable_r[n17 - 1];
                float f6 = this.wtable_r[n17];
                float f7 = this.wtable_r[n18 - 1];
                float f8 = this.wtable_r[n18];
                int n19 = n3 + i;
                int n20 = n4 + i;
                int n21 = n4 + n16;
                int n22 = n19 + n11;
                int n23 = n19 + n9;
                int n24 = n19 + n8;
                float f9 = fArray[n22 - 1];
                float f10 = fArray[n22];
                float f11 = fArray[n23 - 1];
                float f12 = fArray[n23];
                float f13 = fArray[n24 - 1];
                float f14 = fArray[n24];
                float f15 = f5 * f11 + f6 * f12;
                float f16 = f5 * f12 - f6 * f11;
                float f17 = f7 * f13 + f8 * f14;
                float f18 = f7 * f14 - f8 * f13;
                f = f15 + f17;
                float f19 = f16 + f18;
                float f20 = f9 + -0.5f * f;
                float f21 = f10 + -0.5f * f19;
                float f22 = 0.8660254f * (f16 - f18);
                float f23 = 0.8660254f * (f17 - f15);
                int n25 = n20 + n10;
                int n26 = n21 + n7;
                int n27 = n20 + n6;
                fArray2[n25 - 1] = f9 + f;
                fArray2[n25] = f10 + f19;
                fArray2[n26 - 1] = f20 - f22;
                fArray2[n26] = f23 - f21;
                fArray2[n27 - 1] = f20 + f22;
                fArray2[n27] = f21 + f23;
            }
        }
    }

    void radb3(int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int n5) {
        float f;
        float f2;
        float f3;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = n5;
        int n11 = n10 + n;
        for (n9 = 0; n9 < n2; ++n9) {
            n8 = n9 * n;
            n7 = n3 + 3 * n8;
            n6 = n7 + 2 * n;
            float f4 = fArray[n7];
            f3 = 2.0f * fArray[n6 - 1];
            f2 = f4 + -0.5f * f3;
            f = 1.7320508f * fArray[n6];
            fArray2[n4 + n8] = f4 + f3;
            fArray2[n4 + (n9 + n2) * n] = f2 - f;
            fArray2[n4 + (n9 + 2 * n2) * n] = f2 + f;
        }
        if (n == 1) {
            return;
        }
        n9 = n2 * n;
        for (n8 = 0; n8 < n2; ++n8) {
            n7 = n8 * n;
            n6 = 3 * n7;
            int n12 = n6 + n;
            int n13 = n12 + n;
            int n14 = n7 + n9;
            int n15 = n14 + n9;
            for (int i = 2; i < n; i += 2) {
                int n16 = n - i;
                int n17 = n3 + i;
                int n18 = n3 + n16;
                int n19 = n4 + i;
                int n20 = n17 + n6;
                int n21 = n17 + n13;
                int n22 = n18 + n12;
                float f5 = fArray[n20 - 1];
                float f6 = fArray[n20];
                float f7 = fArray[n21 - 1];
                float f8 = fArray[n21];
                float f9 = fArray[n22 - 1];
                float f10 = fArray[n22];
                f3 = f7 + f9;
                f2 = f5 + -0.5f * f3;
                float f11 = f8 - f10;
                float f12 = f6 + -0.5f * f11;
                float f13 = 0.8660254f * (f7 - f9);
                f = 0.8660254f * (f8 + f10);
                float f14 = f2 - f;
                float f15 = f2 + f;
                float f16 = f12 + f13;
                float f17 = f12 - f13;
                int n23 = i - 1 + n10;
                int n24 = i - 1 + n11;
                float f18 = this.wtable_r[n23 - 1];
                float f19 = this.wtable_r[n23];
                float f20 = this.wtable_r[n24 - 1];
                float f21 = this.wtable_r[n24];
                int n25 = n19 + n7;
                int n26 = n19 + n14;
                int n27 = n19 + n15;
                fArray2[n25 - 1] = f5 + f3;
                fArray2[n25] = f6 + f11;
                fArray2[n26 - 1] = f18 * f14 - f19 * f16;
                fArray2[n26] = f18 * f16 + f19 * f14;
                fArray2[n27 - 1] = f20 * f15 - f21 * f17;
                fArray2[n27] = f20 * f17 + f21 * f15;
            }
        }
    }

    void radf4(int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int n5) {
        float f;
        int n6;
        int n7;
        float f2;
        float f3;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15 = n5;
        int n16 = n5 + n;
        int n17 = n16 + n;
        int n18 = n2 * n;
        for (n14 = 0; n14 < n2; ++n14) {
            n13 = n14 * n;
            n12 = 4 * n13;
            n11 = n13 + n18;
            n10 = n11 + n18;
            n9 = n10 + n18;
            n8 = n12 + n;
            float f4 = fArray[n3 + n13];
            float f5 = fArray[n3 + n11];
            float f6 = fArray[n3 + n10];
            float f7 = fArray[n3 + n9];
            f3 = f5 + f7;
            f2 = f4 + f6;
            n7 = n4 + n12;
            n6 = n4 + n8 + n;
            fArray2[n7] = f3 + f2;
            fArray2[n6 - 1 + n + n] = f2 - f3;
            fArray2[n6 - 1] = f4 - f6;
            fArray2[n6] = f7 - f5;
        }
        if (n < 2) {
            return;
        }
        if (n != 2) {
            for (n14 = 0; n14 < n2; ++n14) {
                n13 = n14 * n;
                n12 = n13 + n18;
                n11 = n12 + n18;
                n10 = n11 + n18;
                n9 = 4 * n13;
                n8 = n9 + n;
                int n19 = n8 + n;
                int n20 = n19 + n;
                for (int i = 2; i < n; i += 2) {
                    int n21 = n - i;
                    int n22 = i - 1 + n15;
                    int n23 = i - 1 + n16;
                    n7 = i - 1 + n17;
                    float f8 = this.wtable_r[n22 - 1];
                    float f9 = this.wtable_r[n22];
                    float f10 = this.wtable_r[n23 - 1];
                    float f11 = this.wtable_r[n23];
                    float f12 = this.wtable_r[n7 - 1];
                    float f13 = this.wtable_r[n7];
                    n6 = n3 + i;
                    int n24 = n4 + i;
                    int n25 = n4 + n21;
                    int n26 = n6 + n13;
                    int n27 = n6 + n12;
                    int n28 = n6 + n11;
                    int n29 = n6 + n10;
                    float f14 = fArray[n26 - 1];
                    float f15 = fArray[n26];
                    float f16 = fArray[n27 - 1];
                    float f17 = fArray[n27];
                    float f18 = fArray[n28 - 1];
                    float f19 = fArray[n28];
                    float f20 = fArray[n29 - 1];
                    float f21 = fArray[n29];
                    float f22 = f8 * f16 + f9 * f17;
                    float f23 = f8 * f17 - f9 * f16;
                    float f24 = f10 * f18 + f11 * f19;
                    float f25 = f10 * f19 - f11 * f18;
                    float f26 = f12 * f20 + f13 * f21;
                    float f27 = f12 * f21 - f13 * f20;
                    f3 = f22 + f26;
                    float f28 = f26 - f22;
                    f = f23 + f27;
                    float f29 = f23 - f27;
                    float f30 = f15 + f25;
                    float f31 = f15 - f25;
                    f2 = f14 + f24;
                    float f32 = f14 - f24;
                    int n30 = n24 + n9;
                    int n31 = n25 + n8;
                    int n32 = n24 + n19;
                    int n33 = n25 + n20;
                    fArray2[n30 - 1] = f3 + f2;
                    fArray2[n33 - 1] = f2 - f3;
                    fArray2[n30] = f + f30;
                    fArray2[n33] = f - f30;
                    fArray2[n32 - 1] = f29 + f32;
                    fArray2[n31 - 1] = f32 - f29;
                    fArray2[n32] = f28 + f31;
                    fArray2[n31] = f28 - f31;
                }
            }
            if (n % 2 == 1) {
                return;
            }
        }
        for (n14 = 0; n14 < n2; ++n14) {
            n13 = n14 * n;
            n12 = 4 * n13;
            n11 = n13 + n18;
            n10 = n11 + n18;
            n9 = n10 + n18;
            n8 = n12 + n;
            int n34 = n8 + n;
            int n35 = n34 + n;
            int n36 = n3 + n;
            int n37 = n4 + n;
            float f33 = fArray[n36 - 1 + n13];
            float f34 = fArray[n36 - 1 + n11];
            float f35 = fArray[n36 - 1 + n10];
            float f36 = fArray[n36 - 1 + n9];
            f = -0.70710677f * (f34 + f36);
            f3 = 0.70710677f * (f34 - f36);
            fArray2[n37 - 1 + n12] = f3 + f33;
            fArray2[n37 - 1 + n34] = f33 - f3;
            fArray2[n4 + n8] = f - f35;
            fArray2[n4 + n35] = f + f35;
        }
    }

    void radb4(int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int n5) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15 = n5;
        int n16 = n15 + n;
        int n17 = n16 + n;
        int n18 = n2 * n;
        for (n14 = 0; n14 < n2; ++n14) {
            n13 = n14 * n;
            n12 = 4 * n13;
            n11 = n13 + n18;
            n10 = n11 + n18;
            n9 = n10 + n18;
            n8 = n12 + n;
            n7 = n8 + n;
            n6 = n7 + n;
            float f9 = fArray[n3 + n12];
            float f10 = fArray[n3 + n7];
            f8 = fArray[n3 + n - 1 + n6];
            f7 = fArray[n3 + n - 1 + n8];
            f6 = f9 - f8;
            f5 = f9 + f8;
            f4 = f7 + f7;
            f3 = f10 + f10;
            fArray2[n4 + n13] = f5 + f4;
            fArray2[n4 + n11] = f6 - f3;
            fArray2[n4 + n10] = f5 - f4;
            fArray2[n4 + n9] = f6 + f3;
        }
        if (n < 2) {
            return;
        }
        if (n != 2) {
            for (n14 = 0; n14 < n2; ++n14) {
                n13 = n14 * n;
                n12 = n13 + n18;
                n11 = n12 + n18;
                n10 = n11 + n18;
                n9 = 4 * n13;
                n8 = n9 + n;
                n7 = n8 + n;
                n6 = n7 + n;
                for (int i = 2; i < n; i += 2) {
                    int n19 = n - i;
                    int n20 = i - 1 + n15;
                    int n21 = i - 1 + n16;
                    int n22 = i - 1 + n17;
                    float f11 = this.wtable_r[n20 - 1];
                    float f12 = this.wtable_r[n20];
                    float f13 = this.wtable_r[n21 - 1];
                    float f14 = this.wtable_r[n21];
                    float f15 = this.wtable_r[n22 - 1];
                    float f16 = this.wtable_r[n22];
                    int n23 = n3 + i;
                    int n24 = n3 + n19;
                    int n25 = n4 + i;
                    int n26 = n23 + n9;
                    int n27 = n24 + n8;
                    int n28 = n23 + n7;
                    int n29 = n24 + n6;
                    float f17 = fArray[n26 - 1];
                    float f18 = fArray[n26];
                    float f19 = fArray[n27 - 1];
                    float f20 = fArray[n27];
                    float f21 = fArray[n28 - 1];
                    float f22 = fArray[n28];
                    float f23 = fArray[n29 - 1];
                    float f24 = fArray[n29];
                    f2 = f18 + f24;
                    f = f18 - f24;
                    float f25 = f22 - f20;
                    f3 = f22 + f20;
                    f6 = f17 - f23;
                    f5 = f17 + f23;
                    float f26 = f21 - f19;
                    f4 = f21 + f19;
                    float f27 = f5 - f4;
                    float f28 = f - f25;
                    float f29 = f6 - f3;
                    float f30 = f6 + f3;
                    float f31 = f2 + f26;
                    float f32 = f2 - f26;
                    int n30 = n25 + n13;
                    int n31 = n25 + n12;
                    int n32 = n25 + n11;
                    int n33 = n25 + n10;
                    fArray2[n30 - 1] = f5 + f4;
                    fArray2[n30] = f + f25;
                    fArray2[n31 - 1] = f11 * f29 - f12 * f31;
                    fArray2[n31] = f11 * f31 + f12 * f29;
                    fArray2[n32 - 1] = f13 * f27 - f14 * f28;
                    fArray2[n32] = f13 * f28 + f14 * f27;
                    fArray2[n33 - 1] = f15 * f30 - f16 * f32;
                    fArray2[n33] = f15 * f32 + f16 * f30;
                }
            }
            if (n % 2 == 1) {
                return;
            }
        }
        for (n14 = 0; n14 < n2; ++n14) {
            n13 = n14 * n;
            n12 = 4 * n13;
            n11 = n13 + n18;
            n10 = n11 + n18;
            n9 = n10 + n18;
            n8 = n12 + n;
            n7 = n8 + n;
            n6 = n7 + n;
            int n34 = n3 + n;
            int n35 = n4 + n;
            f8 = fArray[n34 - 1 + n12];
            f7 = fArray[n34 - 1 + n7];
            float f33 = fArray[n3 + n8];
            float f34 = fArray[n3 + n6];
            f2 = f33 + f34;
            f = f34 - f33;
            f6 = f8 - f7;
            f5 = f8 + f7;
            fArray2[n35 - 1 + n13] = f5 + f5;
            fArray2[n35 - 1 + n11] = 1.4142135f * (f6 - f2);
            fArray2[n35 - 1 + n10] = f + f;
            fArray2[n35 - 1 + n9] = -1.4142135f * (f6 + f2);
        }
    }

    void radf5(int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int n5) {
        float f;
        float f2;
        float f3;
        float f4;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18 = n5;
        int n19 = n18 + n;
        int n20 = n19 + n;
        int n21 = n20 + n;
        int n22 = n2 * n;
        for (n17 = 0; n17 < n2; ++n17) {
            n16 = n17 * n;
            n15 = 5 * n16;
            n14 = n15 + n;
            n13 = n14 + n;
            n12 = n13 + n;
            n11 = n12 + n;
            n10 = n16 + n22;
            n9 = n10 + n22;
            n8 = n9 + n22;
            n7 = n8 + n22;
            n6 = n4 + n - 1;
            float f5 = fArray[n3 + n16];
            float f6 = fArray[n3 + n10];
            float f7 = fArray[n3 + n9];
            float f8 = fArray[n3 + n8];
            float f9 = fArray[n3 + n7];
            f4 = f9 + f6;
            f3 = f9 - f6;
            f2 = f8 + f7;
            f = f8 - f7;
            fArray2[n4 + n15] = f5 + f4 + f2;
            fArray2[n6 + n14] = f5 + 0.309017f * f4 + -0.809017f * f2;
            fArray2[n4 + n13] = 0.95105654f * f3 + 0.58778524f * f;
            fArray2[n6 + n12] = f5 + -0.809017f * f4 + 0.309017f * f2;
            fArray2[n4 + n11] = 0.58778524f * f3 - 0.95105654f * f;
        }
        if (n == 1) {
            return;
        }
        for (n17 = 0; n17 < n2; ++n17) {
            n16 = n17 * n;
            n15 = 5 * n16;
            n14 = n15 + n;
            n13 = n14 + n;
            n12 = n13 + n;
            n11 = n12 + n;
            n10 = n16 + n22;
            n9 = n10 + n22;
            n8 = n9 + n22;
            n7 = n8 + n22;
            for (int i = 2; i < n; i += 2) {
                n6 = i - 1 + n18;
                int n23 = i - 1 + n19;
                int n24 = i - 1 + n20;
                int n25 = i - 1 + n21;
                float f10 = this.wtable_r[n6 - 1];
                float f11 = this.wtable_r[n6];
                float f12 = this.wtable_r[n23 - 1];
                float f13 = this.wtable_r[n23];
                float f14 = this.wtable_r[n24 - 1];
                float f15 = this.wtable_r[n24];
                float f16 = this.wtable_r[n25 - 1];
                float f17 = this.wtable_r[n25];
                int n26 = n - i;
                int n27 = n3 + i;
                int n28 = n4 + i;
                int n29 = n4 + n26;
                int n30 = n27 + n16;
                int n31 = n27 + n10;
                int n32 = n27 + n9;
                int n33 = n27 + n8;
                int n34 = n27 + n7;
                float f18 = fArray[n30 - 1];
                float f19 = fArray[n30];
                float f20 = fArray[n31 - 1];
                float f21 = fArray[n31];
                float f22 = fArray[n32 - 1];
                float f23 = fArray[n32];
                float f24 = fArray[n33 - 1];
                float f25 = fArray[n33];
                float f26 = fArray[n34 - 1];
                float f27 = fArray[n34];
                float f28 = f10 * f20 + f11 * f21;
                float f29 = f10 * f21 - f11 * f20;
                float f30 = f12 * f22 + f13 * f23;
                float f31 = f12 * f23 - f13 * f22;
                float f32 = f14 * f24 + f15 * f25;
                float f33 = f14 * f25 - f15 * f24;
                float f34 = f16 * f26 + f17 * f27;
                float f35 = f16 * f27 - f17 * f26;
                f4 = f28 + f34;
                f3 = f34 - f28;
                float f36 = f29 - f35;
                float f37 = f29 + f35;
                f2 = f30 + f32;
                f = f32 - f30;
                float f38 = f31 - f33;
                float f39 = f31 + f33;
                float f40 = f18 + 0.309017f * f4 + -0.809017f * f2;
                float f41 = f19 + 0.309017f * f37 + -0.809017f * f39;
                float f42 = f18 + -0.809017f * f4 + 0.309017f * f2;
                float f43 = f19 + -0.809017f * f37 + 0.309017f * f39;
                float f44 = 0.95105654f * f36 + 0.58778524f * f38;
                float f45 = 0.95105654f * f3 + 0.58778524f * f;
                float f46 = 0.58778524f * f36 - 0.95105654f * f38;
                float f47 = 0.58778524f * f3 - 0.95105654f * f;
                int n35 = n28 + n15;
                int n36 = n29 + n14;
                int n37 = n28 + n13;
                int n38 = n29 + n12;
                int n39 = n28 + n11;
                fArray2[n35 - 1] = f18 + f4 + f2;
                fArray2[n35] = f19 + f37 + f39;
                fArray2[n37 - 1] = f40 + f44;
                fArray2[n36 - 1] = f40 - f44;
                fArray2[n37] = f41 + f45;
                fArray2[n36] = f45 - f41;
                fArray2[n39 - 1] = f42 + f46;
                fArray2[n38 - 1] = f42 - f46;
                fArray2[n39] = f43 + f47;
                fArray2[n38] = f47 - f43;
            }
        }
    }

    void radb5(int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int n5) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18 = n5;
        int n19 = n18 + n;
        int n20 = n19 + n;
        int n21 = n20 + n;
        int n22 = n2 * n;
        for (n17 = 0; n17 < n2; ++n17) {
            n16 = n17 * n;
            n15 = 5 * n16;
            n14 = n15 + n;
            n13 = n14 + n;
            n12 = n13 + n;
            n11 = n12 + n;
            n10 = n16 + n22;
            n9 = n10 + n22;
            n8 = n9 + n22;
            n7 = n8 + n22;
            n6 = n3 + n - 1;
            float f9 = fArray[n3 + n15];
            f8 = 2.0f * fArray[n3 + n13];
            f7 = 2.0f * fArray[n3 + n11];
            f6 = 2.0f * fArray[n6 + n14];
            f5 = 2.0f * fArray[n6 + n12];
            f4 = f9 + 0.309017f * f6 + -0.809017f * f5;
            f3 = f9 + -0.809017f * f6 + 0.309017f * f5;
            f2 = 0.95105654f * f8 + 0.58778524f * f7;
            f = 0.58778524f * f8 - 0.95105654f * f7;
            fArray2[n4 + n16] = f9 + f6 + f5;
            fArray2[n4 + n10] = f4 - f2;
            fArray2[n4 + n9] = f3 - f;
            fArray2[n4 + n8] = f3 + f;
            fArray2[n4 + n7] = f4 + f2;
        }
        if (n == 1) {
            return;
        }
        for (n17 = 0; n17 < n2; ++n17) {
            n16 = n17 * n;
            n15 = 5 * n16;
            n14 = n15 + n;
            n13 = n14 + n;
            n12 = n13 + n;
            n11 = n12 + n;
            n10 = n16 + n22;
            n9 = n10 + n22;
            n8 = n9 + n22;
            n7 = n8 + n22;
            for (int i = 2; i < n; i += 2) {
                int n23 = n - i;
                n6 = i - 1 + n18;
                int n24 = i - 1 + n19;
                int n25 = i - 1 + n20;
                int n26 = i - 1 + n21;
                float f10 = this.wtable_r[n6 - 1];
                float f11 = this.wtable_r[n6];
                float f12 = this.wtable_r[n24 - 1];
                float f13 = this.wtable_r[n24];
                float f14 = this.wtable_r[n25 - 1];
                float f15 = this.wtable_r[n25];
                float f16 = this.wtable_r[n26 - 1];
                float f17 = this.wtable_r[n26];
                int n27 = n3 + i;
                int n28 = n3 + n23;
                int n29 = n4 + i;
                int n30 = n27 + n15;
                int n31 = n28 + n14;
                int n32 = n27 + n13;
                int n33 = n28 + n12;
                int n34 = n27 + n11;
                float f18 = fArray[n30 - 1];
                float f19 = fArray[n30];
                float f20 = fArray[n31 - 1];
                float f21 = fArray[n31];
                float f22 = fArray[n32 - 1];
                float f23 = fArray[n32];
                float f24 = fArray[n33 - 1];
                float f25 = fArray[n33];
                float f26 = fArray[n34 - 1];
                float f27 = fArray[n34];
                f8 = f23 + f21;
                float f28 = f23 - f21;
                f7 = f27 + f25;
                float f29 = f27 - f25;
                float f30 = f22 - f20;
                f6 = f22 + f20;
                float f31 = f26 - f24;
                f5 = f26 + f24;
                f4 = f18 + 0.309017f * f6 + -0.809017f * f5;
                float f32 = f19 + 0.309017f * f28 + -0.809017f * f29;
                f3 = f18 + -0.809017f * f6 + 0.309017f * f5;
                float f33 = f19 + -0.809017f * f28 + 0.309017f * f29;
                float f34 = 0.95105654f * f30 + 0.58778524f * f31;
                f2 = 0.95105654f * f8 + 0.58778524f * f7;
                float f35 = 0.58778524f * f30 - 0.95105654f * f31;
                f = 0.58778524f * f8 - 0.95105654f * f7;
                float f36 = f3 - f;
                float f37 = f3 + f;
                float f38 = f33 + f35;
                float f39 = f33 - f35;
                float f40 = f4 + f2;
                float f41 = f4 - f2;
                float f42 = f32 - f34;
                float f43 = f32 + f34;
                int n35 = n29 + n16;
                int n36 = n29 + n10;
                int n37 = n29 + n9;
                int n38 = n29 + n8;
                int n39 = n29 + n7;
                fArray2[n35 - 1] = f18 + f6 + f5;
                fArray2[n35] = f19 + f28 + f29;
                fArray2[n36 - 1] = f10 * f41 - f11 * f43;
                fArray2[n36] = f10 * f43 + f11 * f41;
                fArray2[n37 - 1] = f12 * f36 - f13 * f38;
                fArray2[n37] = f12 * f38 + f13 * f36;
                fArray2[n38 - 1] = f14 * f37 - f15 * f39;
                fArray2[n38] = f14 * f39 + f15 * f37;
                fArray2[n39 - 1] = f16 * f40 - f17 * f42;
                fArray2[n39] = f16 * f42 + f17 * f40;
            }
        }
    }

    void radfg(int n, int n2, int n3, int n4, float[] fArray, int n5, float[] fArray2, int n6, int n7) {
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19 = n7;
        float f = (float)Math.PI * 2 / (float)n2;
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        int n20 = (n2 + 1) / 2;
        int n21 = (n - 1) / 2;
        if (n != 1) {
            float f4;
            float f5;
            float f6;
            float f7;
            int n22;
            int n23;
            float f8;
            float f9;
            int n24;
            int n25;
            for (n18 = 0; n18 < n4; ++n18) {
                fArray2[n6 + n18] = fArray[n5 + n18];
            }
            for (n18 = 1; n18 < n2; ++n18) {
                n17 = n18 * n3 * n;
                for (n16 = 0; n16 < n3; ++n16) {
                    n15 = n16 * n + n17;
                    fArray2[n6 + n15] = fArray[n5 + n15];
                }
            }
            if (n21 <= n3) {
                n25 = -n;
                for (n18 = 1; n18 < n2; ++n18) {
                    n24 = (n25 += n) - 1;
                    n17 = n18 * n3 * n;
                    for (n16 = 2; n16 < n; n16 += 2) {
                        n15 = (n24 += 2) + n19;
                        n14 = n5 + n16;
                        n13 = n6 + n16;
                        f9 = this.wtable_r[n15 - 1];
                        f8 = this.wtable_r[n15];
                        for (n12 = 0; n12 < n3; ++n12) {
                            n11 = n12 * n + n17;
                            n23 = n13 + n11;
                            n22 = n14 + n11;
                            float f10 = fArray[n22 - 1];
                            float f11 = fArray[n22];
                            fArray2[n23 - 1] = f9 * f10 + f8 * f11;
                            fArray2[n23] = f9 * f11 - f8 * f10;
                        }
                    }
                }
            } else {
                n25 = -n;
                for (n18 = 1; n18 < n2; ++n18) {
                    n25 += n;
                    n17 = n18 * n3 * n;
                    for (n16 = 0; n16 < n3; ++n16) {
                        n24 = n25 - 1;
                        n15 = n16 * n + n17;
                        for (n14 = 2; n14 < n; n14 += 2) {
                            n13 = (n24 += 2) + n19;
                            f9 = this.wtable_r[n13 - 1];
                            f8 = this.wtable_r[n13];
                            n12 = n6 + n14 + n15;
                            n11 = n5 + n14 + n15;
                            float f12 = fArray[n11 - 1];
                            float f13 = fArray[n11];
                            fArray2[n12 - 1] = f9 * f12 + f8 * f13;
                            fArray2[n12] = f9 * f13 - f8 * f12;
                        }
                    }
                }
            }
            if (n21 >= n3) {
                for (n18 = 1; n18 < n20; ++n18) {
                    n10 = n2 - n18;
                    n17 = n18 * n3 * n;
                    n16 = n10 * n3 * n;
                    for (n15 = 0; n15 < n3; ++n15) {
                        n14 = n15 * n + n17;
                        n13 = n15 * n + n16;
                        for (n12 = 2; n12 < n; n12 += 2) {
                            n11 = n5 + n12;
                            n23 = n6 + n12;
                            n22 = n11 + n14;
                            int n26 = n11 + n13;
                            int n27 = n23 + n14;
                            n9 = n23 + n13;
                            f7 = fArray2[n27 - 1];
                            f6 = fArray2[n27];
                            f5 = fArray2[n9 - 1];
                            f4 = fArray2[n9];
                            fArray[n22 - 1] = f7 + f5;
                            fArray[n22] = f6 + f4;
                            fArray[n26 - 1] = f6 - f4;
                            fArray[n26] = f5 - f7;
                        }
                    }
                }
            } else {
                for (n18 = 1; n18 < n20; ++n18) {
                    n10 = n2 - n18;
                    n17 = n18 * n3 * n;
                    n16 = n10 * n3 * n;
                    for (n15 = 2; n15 < n; n15 += 2) {
                        n14 = n5 + n15;
                        n13 = n6 + n15;
                        for (n12 = 0; n12 < n3; ++n12) {
                            n11 = n12 * n + n17;
                            n23 = n12 * n + n16;
                            n22 = n14 + n11;
                            int n28 = n14 + n23;
                            int n29 = n13 + n11;
                            n9 = n13 + n23;
                            f7 = fArray2[n29 - 1];
                            f6 = fArray2[n29];
                            f5 = fArray2[n9 - 1];
                            f4 = fArray2[n9];
                            fArray[n22 - 1] = f7 + f5;
                            fArray[n22] = f6 + f4;
                            fArray[n28 - 1] = f6 - f4;
                            fArray[n28] = f5 - f7;
                        }
                    }
                }
            }
        } else {
            System.arraycopy(fArray2, n6, fArray, n5, n4);
        }
        for (n18 = 1; n18 < n20; ++n18) {
            n10 = n2 - n18;
            n17 = n18 * n3 * n;
            n16 = n10 * n3 * n;
            for (n15 = 0; n15 < n3; ++n15) {
                n14 = n15 * n + n17;
                n13 = n15 * n + n16;
                n12 = n6 + n14;
                n11 = n6 + n13;
                float f14 = fArray2[n12];
                float f15 = fArray2[n11];
                fArray[n5 + n14] = f14 + f15;
                fArray[n5 + n13] = f15 - f14;
            }
        }
        float f16 = 1.0f;
        float f17 = 0.0f;
        n18 = (n2 - 1) * n4;
        for (n17 = 1; n17 < n20; ++n17) {
            int n30 = n2 - n17;
            float f18 = f2 * f16 - f3 * f17;
            f17 = f2 * f17 + f3 * f16;
            f16 = f18;
            n16 = n17 * n4;
            n15 = n30 * n4;
            for (n14 = 0; n14 < n4; ++n14) {
                n13 = n6 + n14;
                n12 = n5 + n14;
                fArray2[n13 + n16] = fArray[n12] + f16 * fArray[n12 + n4];
                fArray2[n13 + n15] = f17 * fArray[n12 + n18];
            }
            float f19 = f16;
            float f20 = f17;
            float f21 = f16;
            float f22 = f17;
            for (n14 = 2; n14 < n20; ++n14) {
                n10 = n2 - n14;
                float f23 = f19 * f21 - f20 * f22;
                f22 = f19 * f22 + f20 * f21;
                f21 = f23;
                n13 = n14 * n4;
                n12 = n10 * n4;
                for (n11 = 0; n11 < n4; ++n11) {
                    int n31 = n6 + n11;
                    int n32 = n5 + n11;
                    int n33 = n31 + n16;
                    fArray2[n33] = fArray2[n33] + f21 * fArray[n32 + n13];
                    int n34 = n31 + n15;
                    fArray2[n34] = fArray2[n34] + f22 * fArray[n32 + n12];
                }
            }
        }
        for (n17 = 1; n17 < n20; ++n17) {
            n16 = n17 * n4;
            for (n15 = 0; n15 < n4; ++n15) {
                int n35 = n6 + n15;
                fArray2[n35] = fArray2[n35] + fArray[n5 + n15 + n16];
            }
        }
        if (n >= n3) {
            for (n17 = 0; n17 < n3; ++n17) {
                n16 = n17 * n;
                n15 = n16 * n2;
                for (n14 = 0; n14 < n; ++n14) {
                    fArray[n5 + n14 + n15] = fArray2[n6 + n14 + n16];
                }
            }
        } else {
            for (n17 = 0; n17 < n; ++n17) {
                for (n16 = 0; n16 < n3; ++n16) {
                    n15 = n16 * n;
                    fArray[n5 + n17 + n15 * n2] = fArray2[n6 + n17 + n15];
                }
            }
        }
        n17 = n2 * n;
        for (n16 = 1; n16 < n20; ++n16) {
            n10 = n2 - n16;
            n8 = 2 * n16;
            n15 = n16 * n3 * n;
            n14 = n10 * n3 * n;
            n13 = n8 * n;
            for (n12 = 0; n12 < n3; ++n12) {
                n11 = n12 * n;
                int n36 = n11 + n15;
                int n37 = n11 + n14;
                int n38 = n12 * n17;
                fArray[n5 + n - 1 + n13 - n + n38] = fArray2[n6 + n36];
                fArray[n5 + n13 + n38] = fArray2[n6 + n37];
            }
        }
        if (n == 1) {
            return;
        }
        if (n21 >= n3) {
            for (n16 = 1; n16 < n20; ++n16) {
                n10 = n2 - n16;
                n8 = 2 * n16;
                n15 = n16 * n3 * n;
                n14 = n10 * n3 * n;
                n13 = n8 * n;
                for (n12 = 0; n12 < n3; ++n12) {
                    n11 = n12 * n17;
                    int n39 = n12 * n;
                    for (int i = 2; i < n; i += 2) {
                        int n40 = n - i;
                        int n41 = n5 + i;
                        int n42 = n5 + n40;
                        n9 = n6 + i;
                        int n43 = n41 + n13 + n11;
                        int n44 = n42 + n13 - n + n11;
                        int n45 = n9 + n39 + n15;
                        int n46 = n9 + n39 + n14;
                        float f24 = fArray2[n45 - 1];
                        float f25 = fArray2[n45];
                        float f26 = fArray2[n46 - 1];
                        float f27 = fArray2[n46];
                        fArray[n43 - 1] = f24 + f26;
                        fArray[n44 - 1] = f24 - f26;
                        fArray[n43] = f25 + f27;
                        fArray[n44] = f27 - f25;
                    }
                }
            }
        } else {
            for (n16 = 1; n16 < n20; ++n16) {
                n10 = n2 - n16;
                n8 = 2 * n16;
                n15 = n16 * n3 * n;
                n14 = n10 * n3 * n;
                n13 = n8 * n;
                for (n12 = 2; n12 < n; n12 += 2) {
                    int n47 = n - n12;
                    n11 = n5 + n12;
                    int n48 = n5 + n47;
                    int n49 = n6 + n12;
                    for (int i = 0; i < n3; ++i) {
                        int n50 = i * n17;
                        n9 = i * n;
                        int n51 = n11 + n13 + n50;
                        int n52 = n48 + n13 - n + n50;
                        int n53 = n49 + n9 + n15;
                        int n54 = n49 + n9 + n14;
                        float f28 = fArray2[n53 - 1];
                        float f29 = fArray2[n53];
                        float f30 = fArray2[n54 - 1];
                        float f31 = fArray2[n54];
                        fArray[n51 - 1] = f28 + f30;
                        fArray[n52 - 1] = f28 - f30;
                        fArray[n51] = f29 + f31;
                        fArray[n52] = f31 - f29;
                    }
                }
            }
        }
    }

    void radbg(int n, int n2, int n3, int n4, float[] fArray, int n5, float[] fArray2, int n6, int n7) {
        float f;
        int n8;
        int n9;
        float f2;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        int n21 = n7;
        float f3 = (float)Math.PI * 2 / (float)n2;
        float f4 = (float)Math.cos(f3);
        float f5 = (float)Math.sin(f3);
        int n22 = (n - 1) / 2;
        int n23 = (n2 + 1) / 2;
        int n24 = n2 * n;
        if (n >= n3) {
            for (n20 = 0; n20 < n3; ++n20) {
                n19 = n20 * n;
                n18 = n20 * n24;
                for (n17 = 0; n17 < n; ++n17) {
                    fArray2[n6 + n17 + n19] = fArray[n5 + n17 + n18];
                }
            }
        } else {
            for (n20 = 0; n20 < n; ++n20) {
                n19 = n6 + n20;
                n18 = n5 + n20;
                for (n17 = 0; n17 < n3; ++n17) {
                    fArray2[n19 + n17 * n] = fArray[n18 + n17 * n24];
                }
            }
        }
        n20 = n5 + n - 1;
        for (n19 = 1; n19 < n23; ++n19) {
            n16 = n2 - n19;
            int n25 = 2 * n19;
            n18 = n19 * n3 * n;
            n17 = n16 * n3 * n;
            n15 = n25 * n;
            for (n14 = 0; n14 < n3; ++n14) {
                n13 = n14 * n;
                n12 = n13 * n2;
                n11 = n20 + n15 + n12 - n;
                n10 = n5 + n15 + n12;
                float f6 = fArray[n11];
                f2 = fArray[n10];
                fArray2[n6 + n13 + n18] = f6 + f6;
                fArray2[n6 + n13 + n17] = f2 + f2;
            }
        }
        if (n != 1) {
            float f7;
            float f8;
            float f9;
            int n26;
            int n27;
            int n28;
            int n29;
            if (n22 >= n3) {
                for (n19 = 1; n19 < n23; ++n19) {
                    n16 = n2 - n19;
                    n18 = n19 * n3 * n;
                    n17 = n16 * n3 * n;
                    n15 = 2 * n19 * n;
                    for (n14 = 0; n14 < n3; ++n14) {
                        n13 = n14 * n + n18;
                        n12 = n14 * n + n17;
                        n11 = n14 * n2 * n + n15;
                        for (n10 = 2; n10 < n; n10 += 2) {
                            n29 = n - n10;
                            int n30 = n6 + n10;
                            int n31 = n5 + n29;
                            n9 = n5 + n10;
                            n8 = n30 + n13;
                            n28 = n30 + n12;
                            n27 = n9 + n11;
                            n26 = n31 + n11 - n;
                            f = fArray[n27 - 1];
                            f9 = fArray[n27];
                            f8 = fArray[n26 - 1];
                            f7 = fArray[n26];
                            fArray2[n8 - 1] = f + f8;
                            fArray2[n28 - 1] = f - f8;
                            fArray2[n8] = f9 - f7;
                            fArray2[n28] = f9 + f7;
                        }
                    }
                }
            } else {
                for (n19 = 1; n19 < n23; ++n19) {
                    n16 = n2 - n19;
                    n18 = n19 * n3 * n;
                    n17 = n16 * n3 * n;
                    n15 = 2 * n19 * n;
                    for (n14 = 2; n14 < n; n14 += 2) {
                        n29 = n - n14;
                        n13 = n6 + n14;
                        n12 = n5 + n29;
                        n11 = n5 + n14;
                        for (n10 = 0; n10 < n3; ++n10) {
                            int n32 = n10 * n + n18;
                            int n33 = n10 * n + n17;
                            n9 = n10 * n2 * n + n15;
                            n8 = n13 + n32;
                            n28 = n13 + n33;
                            n27 = n11 + n9;
                            n26 = n12 + n9 - n;
                            f = fArray[n27 - 1];
                            f9 = fArray[n27];
                            f8 = fArray[n26 - 1];
                            f7 = fArray[n26];
                            fArray2[n8 - 1] = f + f8;
                            fArray2[n28 - 1] = f - f8;
                            fArray2[n8] = f9 - f7;
                            fArray2[n28] = f9 + f7;
                        }
                    }
                }
            }
        }
        float f10 = 1.0f;
        float f11 = 0.0f;
        n19 = (n2 - 1) * n4;
        for (n18 = 1; n18 < n23; ++n18) {
            int n34 = n2 - n18;
            float f12 = f4 * f10 - f5 * f11;
            f11 = f4 * f11 + f5 * f10;
            f10 = f12;
            n17 = n18 * n4;
            n15 = n34 * n4;
            for (n14 = 0; n14 < n4; ++n14) {
                n13 = n5 + n14;
                n12 = n6 + n14;
                fArray[n13 + n17] = fArray2[n12] + f10 * fArray2[n12 + n4];
                fArray[n13 + n15] = f11 * fArray2[n12 + n19];
            }
            float f13 = f10;
            float f14 = f11;
            float f15 = f10;
            float f16 = f11;
            for (n14 = 2; n14 < n23; ++n14) {
                n16 = n2 - n14;
                float f17 = f13 * f15 - f14 * f16;
                f16 = f13 * f16 + f14 * f15;
                f15 = f17;
                n13 = n14 * n4;
                n12 = n16 * n4;
                for (n11 = 0; n11 < n4; ++n11) {
                    n10 = n5 + n11;
                    int n35 = n6 + n11;
                    int n36 = n10 + n17;
                    fArray[n36] = fArray[n36] + f15 * fArray2[n35 + n13];
                    int n37 = n10 + n15;
                    fArray[n37] = fArray[n37] + f16 * fArray2[n35 + n12];
                }
            }
        }
        for (n18 = 1; n18 < n23; ++n18) {
            n17 = n18 * n4;
            for (n15 = 0; n15 < n4; ++n15) {
                int n38 = n14 = n6 + n15;
                fArray2[n38] = fArray2[n38] + fArray2[n14 + n17];
            }
        }
        for (n18 = 1; n18 < n23; ++n18) {
            n16 = n2 - n18;
            n17 = n18 * n3 * n;
            n15 = n16 * n3 * n;
            for (n14 = 0; n14 < n3; ++n14) {
                n13 = n14 * n;
                n12 = n6 + n13;
                n11 = n5 + n13 + n17;
                n10 = n5 + n13 + n15;
                float f18 = fArray[n11];
                f2 = fArray[n10];
                fArray2[n12 + n17] = f18 - f2;
                fArray2[n12 + n15] = f18 + f2;
            }
        }
        if (n == 1) {
            return;
        }
        if (n22 >= n3) {
            for (n18 = 1; n18 < n23; ++n18) {
                n16 = n2 - n18;
                n17 = n18 * n3 * n;
                n15 = n16 * n3 * n;
                for (n14 = 0; n14 < n3; ++n14) {
                    n13 = n14 * n;
                    for (n12 = 2; n12 < n; n12 += 2) {
                        n11 = n6 + n12;
                        n10 = n5 + n12;
                        int n39 = n11 + n13 + n17;
                        int n40 = n11 + n13 + n15;
                        n9 = n10 + n13 + n17;
                        n8 = n10 + n13 + n15;
                        float f19 = fArray[n9 - 1];
                        float f20 = fArray[n9];
                        float f21 = fArray[n8 - 1];
                        f = fArray[n8];
                        fArray2[n39 - 1] = f19 - f;
                        fArray2[n40 - 1] = f19 + f;
                        fArray2[n39] = f20 + f21;
                        fArray2[n40] = f20 - f21;
                    }
                }
            }
        } else {
            for (n18 = 1; n18 < n23; ++n18) {
                n16 = n2 - n18;
                n17 = n18 * n3 * n;
                n15 = n16 * n3 * n;
                for (n14 = 2; n14 < n; n14 += 2) {
                    n13 = n6 + n14;
                    n12 = n5 + n14;
                    for (n11 = 0; n11 < n3; ++n11) {
                        n10 = n11 * n;
                        int n41 = n13 + n10 + n17;
                        int n42 = n13 + n10 + n15;
                        n9 = n12 + n10 + n17;
                        n8 = n12 + n10 + n15;
                        float f22 = fArray[n9 - 1];
                        float f23 = fArray[n9];
                        float f24 = fArray[n8 - 1];
                        f = fArray[n8];
                        fArray2[n41 - 1] = f22 - f;
                        fArray2[n42 - 1] = f22 + f;
                        fArray2[n41] = f23 + f24;
                        fArray2[n42] = f23 - f24;
                    }
                }
            }
        }
        System.arraycopy(fArray2, n6, fArray, n5, n4);
        for (n18 = 1; n18 < n2; ++n18) {
            n17 = n18 * n3 * n;
            for (n15 = 0; n15 < n3; ++n15) {
                n14 = n15 * n + n17;
                fArray[n5 + n14] = fArray2[n6 + n14];
            }
        }
        if (n22 <= n3) {
            int n43 = -n;
            for (n18 = 1; n18 < n2; ++n18) {
                int n44 = (n43 += n) - 1;
                n17 = n18 * n3 * n;
                for (n15 = 2; n15 < n; n15 += 2) {
                    n14 = (n44 += 2) + n21;
                    float f25 = this.wtable_r[n14 - 1];
                    float f26 = this.wtable_r[n14];
                    n13 = n5 + n15;
                    n12 = n6 + n15;
                    for (n11 = 0; n11 < n3; ++n11) {
                        n10 = n11 * n + n17;
                        int n45 = n13 + n10;
                        int n46 = n12 + n10;
                        float f27 = fArray2[n46 - 1];
                        float f28 = fArray2[n46];
                        fArray[n45 - 1] = f25 * f27 - f26 * f28;
                        fArray[n45] = f25 * f28 + f26 * f27;
                    }
                }
            }
        } else {
            int n47 = -n;
            for (n18 = 1; n18 < n2; ++n18) {
                n47 += n;
                n17 = n18 * n3 * n;
                for (n15 = 0; n15 < n3; ++n15) {
                    int n48 = n47 - 1;
                    n14 = n15 * n + n17;
                    for (n13 = 2; n13 < n; n13 += 2) {
                        n12 = (n48 += 2) + n21;
                        float f29 = this.wtable_r[n12 - 1];
                        float f30 = this.wtable_r[n12];
                        n11 = n5 + n13;
                        n10 = n6 + n13;
                        int n49 = n11 + n14;
                        int n50 = n10 + n14;
                        float f31 = fArray2[n50 - 1];
                        float f32 = fArray2[n50];
                        fArray[n49 - 1] = f29 * f31 - f30 * f32;
                        fArray[n49] = f29 * f32 + f30 * f31;
                    }
                }
            }
        }
    }

    void cfftf(float[] fArray, int n, int n2) {
        int[] nArray = new int[1];
        int n3 = 2 * this.n;
        float[] fArray2 = new float[n3];
        int n4 = n3;
        int n5 = 4 * this.n;
        nArray[0] = 0;
        int n6 = (int)this.wtable[1 + n5];
        int n7 = 0;
        int n8 = 1;
        int n9 = n4;
        for (int i = 2; i <= n6 + 1; ++i) {
            int n10 = (int)this.wtable[i + n5];
            int n11 = n10 * n8;
            int n12 = this.n / n11;
            int n13 = n12 + n12;
            int n14 = n13 * n8;
            switch (n10) {
                case 4: {
                    if (n7 == 0) {
                        this.passf4(n13, n8, fArray, n, fArray2, 0, n9, n2);
                    } else {
                        this.passf4(n13, n8, fArray2, 0, fArray, n, n9, n2);
                    }
                    n7 = 1 - n7;
                    break;
                }
                case 2: {
                    if (n7 == 0) {
                        this.passf2(n13, n8, fArray, n, fArray2, 0, n9, n2);
                    } else {
                        this.passf2(n13, n8, fArray2, 0, fArray, n, n9, n2);
                    }
                    n7 = 1 - n7;
                    break;
                }
                case 3: {
                    if (n7 == 0) {
                        this.passf3(n13, n8, fArray, n, fArray2, 0, n9, n2);
                    } else {
                        this.passf3(n13, n8, fArray2, 0, fArray, n, n9, n2);
                    }
                    n7 = 1 - n7;
                    break;
                }
                case 5: {
                    if (n7 == 0) {
                        this.passf5(n13, n8, fArray, n, fArray2, 0, n9, n2);
                    } else {
                        this.passf5(n13, n8, fArray2, 0, fArray, n, n9, n2);
                    }
                    n7 = 1 - n7;
                    break;
                }
                default: {
                    if (n7 == 0) {
                        this.passfg(nArray, n13, n10, n8, n14, fArray, n, fArray2, 0, n9, n2);
                    } else {
                        this.passfg(nArray, n13, n10, n8, n14, fArray2, 0, fArray, n, n9, n2);
                    }
                    if (nArray[0] == 0) break;
                    n7 = 1 - n7;
                }
            }
            n8 = n11;
            n9 += (n10 - 1) * n13;
        }
        if (n7 == 0) {
            return;
        }
        System.arraycopy(fArray2, 0, fArray, n, n3);
    }

    void passf2(int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int n5, int n6) {
        int n7 = n5;
        int n8 = n * n2;
        if (n <= 2) {
            for (int i = 0; i < n2; ++i) {
                int n9 = i * n;
                int n10 = n3 + 2 * n9;
                int n11 = n10 + n;
                float f = fArray[n10];
                float f2 = fArray[n10 + 1];
                float f3 = fArray[n11];
                float f4 = fArray[n11 + 1];
                int n12 = n4 + n9;
                int n13 = n12 + n8;
                fArray2[n12] = f + f3;
                fArray2[n12 + 1] = f2 + f4;
                fArray2[n13] = f - f3;
                fArray2[n13 + 1] = f2 - f4;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n - 1; j += 2) {
                    int n14 = i * n;
                    int n15 = n3 + j + 2 * n14;
                    int n16 = n15 + n;
                    float f = fArray[n15];
                    float f5 = fArray[n15 + 1];
                    float f6 = fArray[n16];
                    float f7 = fArray[n16 + 1];
                    int n17 = j + n7;
                    float f8 = this.wtable[n17];
                    float f9 = (float)n6 * this.wtable[n17 + 1];
                    float f10 = f - f6;
                    float f11 = f5 - f7;
                    int n18 = n4 + j + n14;
                    int n19 = n18 + n8;
                    fArray2[n18] = f + f6;
                    fArray2[n18 + 1] = f5 + f7;
                    fArray2[n19] = f8 * f10 - f9 * f11;
                    fArray2[n19 + 1] = f8 * f11 + f9 * f10;
                }
            }
        }
    }

    void passf3(int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int n5, int n6) {
        int n7 = n5;
        int n8 = n7 + n;
        int n9 = n2 * n;
        if (n == 2) {
            for (int i = 1; i <= n2; ++i) {
                int n10 = n3 + (3 * i - 2) * n;
                int n11 = n10 + n;
                int n12 = n10 - n;
                float f = fArray[n10];
                float f2 = fArray[n10 + 1];
                float f3 = fArray[n11];
                float f4 = fArray[n11 + 1];
                float f5 = fArray[n12];
                float f6 = fArray[n12 + 1];
                float f7 = f + f3;
                float f8 = f5 + -0.5f * f7;
                float f9 = f2 + f4;
                float f10 = f6 + -0.5f * f9;
                float f11 = (float)n6 * 0.8660254f * (f - f3);
                float f12 = (float)n6 * 0.8660254f * (f2 - f4);
                int n13 = n4 + (i - 1) * n;
                int n14 = n13 + n9;
                int n15 = n14 + n9;
                fArray2[n13] = fArray[n12] + f7;
                fArray2[n13 + 1] = f6 + f9;
                fArray2[n14] = f8 - f12;
                fArray2[n14 + 1] = f10 + f11;
                fArray2[n15] = f8 + f12;
                fArray2[n15 + 1] = f10 - f11;
            }
        } else {
            for (int i = 1; i <= n2; ++i) {
                int n16 = n3 + (3 * i - 2) * n;
                int n17 = n4 + (i - 1) * n;
                for (int j = 0; j < n - 1; j += 2) {
                    int n18 = j + n16;
                    int n19 = n18 + n;
                    int n20 = n18 - n;
                    float f = fArray[n18];
                    float f13 = fArray[n18 + 1];
                    float f14 = fArray[n19];
                    float f15 = fArray[n19 + 1];
                    float f16 = fArray[n20];
                    float f17 = fArray[n20 + 1];
                    float f18 = f + f14;
                    float f19 = f16 + -0.5f * f18;
                    float f20 = f13 + f15;
                    float f21 = f17 + -0.5f * f20;
                    float f22 = (float)n6 * 0.8660254f * (f - f14);
                    float f23 = (float)n6 * 0.8660254f * (f13 - f15);
                    float f24 = f19 - f23;
                    float f25 = f19 + f23;
                    float f26 = f21 + f22;
                    float f27 = f21 - f22;
                    int n21 = j + n7;
                    int n22 = j + n8;
                    float f28 = this.wtable[n21];
                    float f29 = (float)n6 * this.wtable[n21 + 1];
                    float f30 = this.wtable[n22];
                    float f31 = (float)n6 * this.wtable[n22 + 1];
                    int n23 = j + n17;
                    int n24 = n23 + n9;
                    int n25 = n24 + n9;
                    fArray2[n23] = f16 + f18;
                    fArray2[n23 + 1] = f17 + f20;
                    fArray2[n24] = f28 * f24 - f29 * f26;
                    fArray2[n24 + 1] = f28 * f26 + f29 * f24;
                    fArray2[n25] = f30 * f25 - f31 * f27;
                    fArray2[n25 + 1] = f30 * f27 + f31 * f25;
                }
            }
        }
    }

    void passf4(int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int n5, int n6) {
        int n7 = n5;
        int n8 = n7 + n;
        int n9 = n8 + n;
        int n10 = n2 * n;
        if (n == 2) {
            for (int i = 0; i < n2; ++i) {
                int n11 = i * n;
                int n12 = n3 + 4 * n11 + 1;
                int n13 = n12 + n;
                int n14 = n13 + n;
                int n15 = n14 + n;
                float f = fArray[n12 - 1];
                float f2 = fArray[n12];
                float f3 = fArray[n13 - 1];
                float f4 = fArray[n13];
                float f5 = fArray[n14 - 1];
                float f6 = fArray[n14];
                float f7 = fArray[n15 - 1];
                float f8 = fArray[n15];
                float f9 = f2 - f6;
                float f10 = f2 + f6;
                float f11 = f8 - f4;
                float f12 = f4 + f8;
                float f13 = f - f5;
                float f14 = f + f5;
                float f15 = f3 - f7;
                float f16 = f3 + f7;
                int n16 = n4 + n11;
                int n17 = n16 + n10;
                int n18 = n17 + n10;
                int n19 = n18 + n10;
                fArray2[n16] = f14 + f16;
                fArray2[n16 + 1] = f10 + f12;
                fArray2[n17] = f13 + (float)n6 * f11;
                fArray2[n17 + 1] = f9 + (float)n6 * f15;
                fArray2[n18] = f14 - f16;
                fArray2[n18 + 1] = f10 - f12;
                fArray2[n19] = f13 - (float)n6 * f11;
                fArray2[n19 + 1] = f9 - (float)n6 * f15;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                int n20 = i * n;
                int n21 = n3 + 1 + 4 * n20;
                for (int j = 0; j < n - 1; j += 2) {
                    int n22 = j + n21;
                    int n23 = n22 + n;
                    int n24 = n23 + n;
                    int n25 = n24 + n;
                    float f = fArray[n22 - 1];
                    float f17 = fArray[n22];
                    float f18 = fArray[n23 - 1];
                    float f19 = fArray[n23];
                    float f20 = fArray[n24 - 1];
                    float f21 = fArray[n24];
                    float f22 = fArray[n25 - 1];
                    float f23 = fArray[n25];
                    float f24 = f17 - f21;
                    float f25 = f17 + f21;
                    float f26 = f19 + f23;
                    float f27 = f23 - f19;
                    float f28 = f - f20;
                    float f29 = f + f20;
                    float f30 = f18 - f22;
                    float f31 = f18 + f22;
                    float f32 = f29 - f31;
                    float f33 = f25 - f26;
                    float f34 = f28 + (float)n6 * f27;
                    float f35 = f28 - (float)n6 * f27;
                    float f36 = f24 + (float)n6 * f30;
                    float f37 = f24 - (float)n6 * f30;
                    int n26 = j + n7;
                    int n27 = j + n8;
                    int n28 = j + n9;
                    float f38 = this.wtable[n26];
                    float f39 = (float)n6 * this.wtable[n26 + 1];
                    float f40 = this.wtable[n27];
                    float f41 = (float)n6 * this.wtable[n27 + 1];
                    float f42 = this.wtable[n28];
                    float f43 = (float)n6 * this.wtable[n28 + 1];
                    int n29 = n4 + j + n20;
                    int n30 = n29 + n10;
                    int n31 = n30 + n10;
                    int n32 = n31 + n10;
                    fArray2[n29] = f29 + f31;
                    fArray2[n29 + 1] = f25 + f26;
                    fArray2[n30] = f38 * f34 - f39 * f36;
                    fArray2[n30 + 1] = f38 * f36 + f39 * f34;
                    fArray2[n31] = f40 * f32 - f41 * f33;
                    fArray2[n31 + 1] = f40 * f33 + f41 * f32;
                    fArray2[n32] = f42 * f35 - f43 * f37;
                    fArray2[n32 + 1] = f42 * f37 + f43 * f35;
                }
            }
        }
    }

    void passf5(int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int n5, int n6) {
        int n7 = n5;
        int n8 = n7 + n;
        int n9 = n8 + n;
        int n10 = n9 + n;
        int n11 = n2 * n;
        if (n == 2) {
            for (int i = 1; i <= n2; ++i) {
                int n12 = n3 + (5 * i - 4) * n + 1;
                int n13 = n12 + n;
                int n14 = n12 - n;
                int n15 = n13 + n;
                int n16 = n15 + n;
                float f = fArray[n12 - 1];
                float f2 = fArray[n12];
                float f3 = fArray[n13 - 1];
                float f4 = fArray[n13];
                float f5 = fArray[n14 - 1];
                float f6 = fArray[n14];
                float f7 = fArray[n15 - 1];
                float f8 = fArray[n15];
                float f9 = fArray[n16 - 1];
                float f10 = fArray[n16];
                float f11 = f2 - f10;
                float f12 = f2 + f10;
                float f13 = f4 - f8;
                float f14 = f4 + f8;
                float f15 = f - f9;
                float f16 = f + f9;
                float f17 = f3 - f7;
                float f18 = f3 + f7;
                float f19 = f5 + 0.309017f * f16 + -0.809017f * f18;
                float f20 = f6 + 0.309017f * f12 + -0.809017f * f14;
                float f21 = f5 + -0.809017f * f16 + 0.309017f * f18;
                float f22 = f6 + -0.809017f * f12 + 0.309017f * f14;
                float f23 = (float)n6 * (0.95105654f * f15 + 0.58778524f * f17);
                float f24 = (float)n6 * (0.95105654f * f11 + 0.58778524f * f13);
                float f25 = (float)n6 * (0.58778524f * f15 - 0.95105654f * f17);
                float f26 = (float)n6 * (0.58778524f * f11 - 0.95105654f * f13);
                int n17 = n4 + (i - 1) * n;
                int n18 = n17 + n11;
                int n19 = n18 + n11;
                int n20 = n19 + n11;
                int n21 = n20 + n11;
                fArray2[n17] = f5 + f16 + f18;
                fArray2[n17 + 1] = f6 + f12 + f14;
                fArray2[n18] = f19 - f24;
                fArray2[n18 + 1] = f20 + f23;
                fArray2[n19] = f21 - f26;
                fArray2[n19 + 1] = f22 + f25;
                fArray2[n20] = f21 + f26;
                fArray2[n20 + 1] = f22 - f25;
                fArray2[n21] = f19 + f24;
                fArray2[n21 + 1] = f20 - f23;
            }
        } else {
            for (int i = 1; i <= n2; ++i) {
                int n22 = n3 + 1 + (i * 5 - 4) * n;
                int n23 = n4 + (i - 1) * n;
                for (int j = 0; j < n - 1; j += 2) {
                    int n24 = j + n22;
                    int n25 = n24 + n;
                    int n26 = n24 - n;
                    int n27 = n25 + n;
                    int n28 = n27 + n;
                    float f = fArray[n24 - 1];
                    float f27 = fArray[n24];
                    float f28 = fArray[n25 - 1];
                    float f29 = fArray[n25];
                    float f30 = fArray[n26 - 1];
                    float f31 = fArray[n26];
                    float f32 = fArray[n27 - 1];
                    float f33 = fArray[n27];
                    float f34 = fArray[n28 - 1];
                    float f35 = fArray[n28];
                    float f36 = f27 - f35;
                    float f37 = f27 + f35;
                    float f38 = f29 - f33;
                    float f39 = f29 + f33;
                    float f40 = f - f34;
                    float f41 = f + f34;
                    float f42 = f28 - f32;
                    float f43 = f28 + f32;
                    float f44 = f30 + 0.309017f * f41 + -0.809017f * f43;
                    float f45 = f31 + 0.309017f * f37 + -0.809017f * f39;
                    float f46 = f30 + -0.809017f * f41 + 0.309017f * f43;
                    float f47 = f31 + -0.809017f * f37 + 0.309017f * f39;
                    float f48 = (float)n6 * (0.95105654f * f40 + 0.58778524f * f42);
                    float f49 = (float)n6 * (0.95105654f * f36 + 0.58778524f * f38);
                    float f50 = (float)n6 * (0.58778524f * f40 - 0.95105654f * f42);
                    float f51 = (float)n6 * (0.58778524f * f36 - 0.95105654f * f38);
                    float f52 = f46 - f51;
                    float f53 = f46 + f51;
                    float f54 = f47 + f50;
                    float f55 = f47 - f50;
                    float f56 = f44 + f49;
                    float f57 = f44 - f49;
                    float f58 = f45 - f48;
                    float f59 = f45 + f48;
                    int n29 = j + n7;
                    int n30 = j + n8;
                    int n31 = j + n9;
                    int n32 = j + n10;
                    float f60 = this.wtable[n29];
                    float f61 = (float)n6 * this.wtable[n29 + 1];
                    float f62 = this.wtable[n30];
                    float f63 = (float)n6 * this.wtable[n30 + 1];
                    float f64 = this.wtable[n31];
                    float f65 = (float)n6 * this.wtable[n31 + 1];
                    float f66 = this.wtable[n32];
                    float f67 = (float)n6 * this.wtable[n32 + 1];
                    int n33 = j + n23;
                    int n34 = n33 + n11;
                    int n35 = n34 + n11;
                    int n36 = n35 + n11;
                    int n37 = n36 + n11;
                    fArray2[n33] = f30 + f41 + f43;
                    fArray2[n33 + 1] = f31 + f37 + f39;
                    fArray2[n34] = f60 * f57 - f61 * f59;
                    fArray2[n34 + 1] = f60 * f59 + f61 * f57;
                    fArray2[n35] = f62 * f52 - f63 * f54;
                    fArray2[n35 + 1] = f62 * f54 + f63 * f52;
                    fArray2[n36] = f64 * f53 - f65 * f55;
                    fArray2[n36 + 1] = f64 * f55 + f65 * f53;
                    fArray2[n37] = f66 * f56 - f67 * f58;
                    fArray2[n37 + 1] = f66 * f58 + f67 * f56;
                }
            }
        }
    }

    void passfg(int[] nArray, int n, int n2, int n3, int n4, float[] fArray, int n5, float[] fArray2, int n6, int n7, int n8) {
        float f;
        float f2;
        float f3;
        float f4;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20 = n7;
        int n21 = n / 2;
        int n22 = (n2 + 1) / 2;
        int n23 = n2 * n;
        if (n >= n3) {
            for (n19 = 1; n19 < n22; ++n19) {
                n18 = n2 - n19;
                n17 = n19 * n;
                n16 = n18 * n;
                for (n15 = 0; n15 < n3; ++n15) {
                    n14 = n15 * n;
                    n13 = n14 + n17 * n3;
                    n12 = n14 + n16 * n3;
                    n11 = n14 * n2;
                    for (n10 = 0; n10 < n; ++n10) {
                        n9 = n6 + n10;
                        float f5 = fArray[n5 + n10 + n17 + n11];
                        f4 = fArray[n5 + n10 + n16 + n11];
                        fArray2[n9 + n13] = f5 + f4;
                        fArray2[n9 + n12] = f5 - f4;
                    }
                }
            }
            for (n19 = 0; n19 < n3; ++n19) {
                n17 = n19 * n;
                n16 = n17 * n2;
                for (n15 = 0; n15 < n; ++n15) {
                    fArray2[n6 + n15 + n17] = fArray[n5 + n15 + n16];
                }
            }
        } else {
            for (n19 = 1; n19 < n22; ++n19) {
                n18 = n2 - n19;
                n17 = n19 * n3 * n;
                n16 = n18 * n3 * n;
                n15 = n19 * n;
                n14 = n18 * n;
                for (n13 = 0; n13 < n; ++n13) {
                    for (n12 = 0; n12 < n3; ++n12) {
                        n11 = n12 * n;
                        n10 = n11 * n2;
                        n9 = n6 + n13;
                        int n24 = n5 + n13;
                        f4 = fArray[n24 + n15 + n10];
                        f3 = fArray[n24 + n14 + n10];
                        fArray2[n9 + n11 + n17] = f4 + f3;
                        fArray2[n9 + n11 + n16] = f4 - f3;
                    }
                }
            }
            for (n19 = 0; n19 < n; ++n19) {
                for (n17 = 0; n17 < n3; ++n17) {
                    n16 = n17 * n;
                    fArray2[n6 + n19 + n16] = fArray[n5 + n19 + n16 * n2];
                }
            }
        }
        int n25 = 2 - n;
        int n26 = 0;
        n19 = (n2 - 1) * n4;
        for (int i = 1; i < n22; ++i) {
            int n27 = n2 - i;
            n17 = i * n4;
            n16 = n27 * n4;
            n15 = (n25 += n) + n20;
            f2 = this.wtable[n15 - 2];
            f = (float)n8 * this.wtable[n15 - 1];
            for (n14 = 0; n14 < n4; ++n14) {
                n13 = n5 + n14;
                n12 = n6 + n14;
                fArray[n13 + n17] = fArray2[n12] + f2 * fArray2[n12 + n4];
                fArray[n13 + n16] = f * fArray2[n12 + n19];
            }
            int n28 = n25;
            n26 += n;
            for (n14 = 2; n14 < n22; ++n14) {
                n18 = n2 - n14;
                if ((n28 += n26) > n23) {
                    n28 -= n23;
                }
                n13 = n28 + n20;
                float f6 = this.wtable[n13 - 2];
                float f7 = (float)n8 * this.wtable[n13 - 1];
                n12 = n14 * n4;
                n11 = n18 * n4;
                for (n10 = 0; n10 < n4; ++n10) {
                    n9 = n5 + n10;
                    int n29 = n6 + n10;
                    int n30 = n9 + n17;
                    fArray[n30] = fArray[n30] + f6 * fArray2[n29 + n12];
                    int n31 = n9 + n16;
                    fArray[n31] = fArray[n31] + f7 * fArray2[n29 + n11];
                }
            }
        }
        for (n17 = 1; n17 < n22; ++n17) {
            n16 = n17 * n4;
            for (n15 = 0; n15 < n4; ++n15) {
                int n32 = n14 = n6 + n15;
                fArray2[n32] = fArray2[n32] + fArray2[n14 + n16];
            }
        }
        for (n17 = 1; n17 < n22; ++n17) {
            n18 = n2 - n17;
            n16 = n17 * n4;
            n15 = n18 * n4;
            for (n14 = 1; n14 < n4; n14 += 2) {
                n13 = n6 + n14;
                n12 = n5 + n14;
                n11 = n12 + n16;
                n10 = n12 + n15;
                float f8 = fArray[n11 - 1];
                float f9 = fArray[n11];
                f4 = fArray[n10 - 1];
                f3 = fArray[n10];
                int n33 = n13 + n16;
                int n34 = n13 + n15;
                fArray2[n33 - 1] = f8 - f3;
                fArray2[n34 - 1] = f8 + f3;
                fArray2[n33] = f9 + f4;
                fArray2[n34] = f9 - f4;
            }
        }
        nArray[0] = 1;
        if (n == 2) {
            return;
        }
        nArray[0] = 0;
        System.arraycopy(fArray2, n6, fArray, n5, n4);
        n17 = n3 * n;
        for (n16 = 1; n16 < n2; ++n16) {
            n15 = n16 * n17;
            for (n14 = 0; n14 < n3; ++n14) {
                n13 = n14 * n;
                n12 = n6 + n13 + n15;
                n11 = n5 + n13 + n15;
                fArray[n11] = fArray2[n12];
                fArray[n11 + 1] = fArray2[n12 + 1];
            }
        }
        if (n21 <= n3) {
            int n35 = 0;
            for (n16 = 1; n16 < n2; ++n16) {
                n35 += 2;
                n15 = n16 * n3 * n;
                for (n14 = 3; n14 < n; n14 += 2) {
                    n13 = (n35 += 2) + n20 - 1;
                    f2 = this.wtable[n13 - 1];
                    f = (float)n8 * this.wtable[n13];
                    n12 = n5 + n14;
                    n11 = n6 + n14;
                    for (n10 = 0; n10 < n3; ++n10) {
                        int n36 = n10 * n + n15;
                        int n37 = n12 + n36;
                        int n38 = n11 + n36;
                        f3 = fArray2[n38 - 1];
                        float f10 = fArray2[n38];
                        fArray[n37 - 1] = f2 * f3 - f * f10;
                        fArray[n37] = f2 * f10 + f * f3;
                    }
                }
            }
        } else {
            int n39 = 2 - n;
            for (n16 = 1; n16 < n2; ++n16) {
                n39 += n;
                n15 = n16 * n3 * n;
                for (n14 = 0; n14 < n3; ++n14) {
                    int n40 = n39;
                    n13 = n14 * n + n15;
                    for (n12 = 3; n12 < n; n12 += 2) {
                        n11 = (n40 += 2) - 1 + n20;
                        f2 = this.wtable[n11 - 1];
                        f = (float)n8 * this.wtable[n11];
                        n10 = n5 + n12 + n13;
                        int n41 = n6 + n12 + n13;
                        float f11 = fArray2[n41 - 1];
                        f4 = fArray2[n41];
                        fArray[n10 - 1] = f2 * f11 - f * f4;
                        fArray[n10] = f2 * f4 + f * f11;
                    }
                }
            }
        }
    }

    private void cftfsub(int n, float[] fArray, int n2, int[] nArray, int n3, float[] fArray2) {
        if (n > 8) {
            if (n > 32) {
                this.cftf1st(n, fArray, n2, fArray2, n3 - (n >> 2));
                if (ConcurrencyUtils.getNumberOfThreads() > 1 && n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    this.cftrec4_th(n, fArray, n2, n3, fArray2);
                } else if (n > 512) {
                    this.cftrec4(n, fArray, n2, n3, fArray2);
                } else if (n > 128) {
                    this.cftleaf(n, 1, fArray, n2, n3, fArray2);
                } else {
                    this.cftfx41(n, fArray, n2, n3, fArray2);
                }
                this.bitrv2(n, nArray, fArray, n2);
            } else if (n == 32) {
                this.cftf161(fArray, n2, fArray2, n3 - 8);
                this.bitrv216(fArray, n2);
            } else {
                this.cftf081(fArray, n2, fArray2, 0);
                this.bitrv208(fArray, n2);
            }
        } else if (n == 8) {
            this.cftf040(fArray, n2);
        } else if (n == 4) {
            this.cftxb020(fArray, n2);
        }
    }

    private void cftbsub(int n, float[] fArray, int n2, int[] nArray, int n3, float[] fArray2) {
        if (n > 8) {
            if (n > 32) {
                this.cftb1st(n, fArray, n2, fArray2, n3 - (n >> 2));
                if (ConcurrencyUtils.getNumberOfThreads() > 1 && n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    this.cftrec4_th(n, fArray, n2, n3, fArray2);
                } else if (n > 512) {
                    this.cftrec4(n, fArray, n2, n3, fArray2);
                } else if (n > 128) {
                    this.cftleaf(n, 1, fArray, n2, n3, fArray2);
                } else {
                    this.cftfx41(n, fArray, n2, n3, fArray2);
                }
                this.bitrv2conj(n, nArray, fArray, n2);
            } else if (n == 32) {
                this.cftf161(fArray, n2, fArray2, n3 - 8);
                this.bitrv216neg(fArray, n2);
            } else {
                this.cftf081(fArray, n2, fArray2, 0);
                this.bitrv208neg(fArray, n2);
            }
        } else if (n == 8) {
            this.cftb040(fArray, n2);
        } else if (n == 4) {
            this.cftxb020(fArray, n2);
        }
    }

    private void bitrv2(int n, int[] nArray, float[] fArray, int n2) {
        int n3;
        int n4 = 1;
        for (n3 = n >> 2; n3 > 8; n3 >>= 2) {
            n4 <<= 1;
        }
        int n5 = n >> 1;
        int n6 = 4 * n4;
        if (n3 == 8) {
            for (int i = 0; i < n4; ++i) {
                float f;
                float f2;
                float f3;
                float f4;
                int n7;
                int n8;
                int n9;
                int n10;
                int n11 = 4 * i;
                for (int j = 0; j < i; ++j) {
                    n10 = 4 * j + 2 * nArray[n4 + i];
                    n9 = n11 + 2 * nArray[n4 + j];
                    n8 = n2 + n10;
                    n7 = n2 + n9;
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 -= n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n5);
                    n7 = n2 + (n9 += 2);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 += n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += 2);
                    n7 = n2 + (n9 += n5);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 -= n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n5);
                    n7 = n2 + (n9 -= 2);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 += n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    f4 = fArray[n8];
                    f3 = fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                }
                n9 = n11 + 2 * nArray[n4 + i];
                n10 = n9 + 2;
                n8 = n2 + n10;
                n7 = n2 + (n9 += n5);
                f4 = fArray[n8];
                f3 = fArray[n8 + 1];
                f2 = fArray[n7];
                f = fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                n8 = n2 + (n10 += n6);
                n7 = n2 + (n9 += 2 * n6);
                f4 = fArray[n8];
                f3 = fArray[n8 + 1];
                f2 = fArray[n7];
                f = fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                n8 = n2 + (n10 += n6);
                n7 = n2 + (n9 -= n6);
                f4 = fArray[n8];
                f3 = fArray[n8 + 1];
                f2 = fArray[n7];
                f = fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                n8 = n2 + (n10 -= 2);
                n7 = n2 + (n9 -= n5);
                f4 = fArray[n8];
                f3 = fArray[n8 + 1];
                f2 = fArray[n7];
                f = fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                n8 = n2 + (n10 += n5 + 2);
                n7 = n2 + (n9 += n5 + 2);
                f4 = fArray[n8];
                f3 = fArray[n8 + 1];
                f2 = fArray[n7];
                f = fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                n8 = n2 + (n10 -= n5 - n6);
                n7 = n2 + (n9 += 2 * n6 - 2);
                f4 = fArray[n8];
                f3 = fArray[n8 + 1];
                f2 = fArray[n7];
                f = fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                float f;
                float f5;
                float f6;
                float f7;
                int n12;
                int n13;
                int n14;
                int n15;
                int n16 = 4 * i;
                for (int j = 0; j < i; ++j) {
                    n15 = 4 * j + nArray[n4 + i];
                    n14 = n16 + nArray[n4 + j];
                    n13 = n2 + n15;
                    n12 = n2 + n14;
                    f7 = fArray[n13];
                    f6 = fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                    n13 = n2 + (n15 += n6);
                    n12 = n2 + (n14 += n6);
                    f7 = fArray[n13];
                    f6 = fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                    n13 = n2 + (n15 += n5);
                    n12 = n2 + (n14 += 2);
                    f7 = fArray[n13];
                    f6 = fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                    n13 = n2 + (n15 -= n6);
                    n12 = n2 + (n14 -= n6);
                    f7 = fArray[n13];
                    f6 = fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                    n13 = n2 + (n15 += 2);
                    n12 = n2 + (n14 += n5);
                    f7 = fArray[n13];
                    f6 = fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                    n13 = n2 + (n15 += n6);
                    n12 = n2 + (n14 += n6);
                    f7 = fArray[n13];
                    f6 = fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                    n13 = n2 + (n15 -= n5);
                    n12 = n2 + (n14 -= 2);
                    f7 = fArray[n13];
                    f6 = fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                    n13 = n2 + (n15 -= n6);
                    n12 = n2 + (n14 -= n6);
                    f7 = fArray[n13];
                    f6 = fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                }
                n14 = n16 + nArray[n4 + i];
                n15 = n14 + 2;
                n13 = n2 + n15;
                n12 = n2 + (n14 += n5);
                f7 = fArray[n13];
                f6 = fArray[n13 + 1];
                f5 = fArray[n12];
                f = fArray[n12 + 1];
                fArray[n13] = f5;
                fArray[n13 + 1] = f;
                fArray[n12] = f7;
                fArray[n12 + 1] = f6;
                n13 = n2 + (n15 += n6);
                n12 = n2 + (n14 += n6);
                f7 = fArray[n13];
                f6 = fArray[n13 + 1];
                f5 = fArray[n12];
                f = fArray[n12 + 1];
                fArray[n13] = f5;
                fArray[n13 + 1] = f;
                fArray[n12] = f7;
                fArray[n12 + 1] = f6;
            }
        }
    }

    private void bitrv2conj(int n, int[] nArray, float[] fArray, int n2) {
        int n3;
        int n4 = 1;
        for (n3 = n >> 2; n3 > 8; n3 >>= 2) {
            n4 <<= 1;
        }
        int n5 = n >> 1;
        int n6 = 4 * n4;
        if (n3 == 8) {
            for (int i = 0; i < n4; ++i) {
                float f;
                float f2;
                float f3;
                float f4;
                int n7;
                int n8;
                int n9;
                int n10;
                int n11 = 4 * i;
                for (int j = 0; j < i; ++j) {
                    n10 = 4 * j + 2 * nArray[n4 + i];
                    n9 = n11 + 2 * nArray[n4 + j];
                    n8 = n2 + n10;
                    n7 = n2 + n9;
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 -= n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n5);
                    n7 = n2 + (n9 += 2);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 += n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += 2);
                    n7 = n2 + (n9 += n5);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 -= n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 += n6);
                    n7 = n2 + (n9 += 2 * n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n5);
                    n7 = n2 + (n9 -= 2);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 += n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                    n8 = n2 + (n10 -= n6);
                    n7 = n2 + (n9 -= 2 * n6);
                    f4 = fArray[n8];
                    f3 = -fArray[n8 + 1];
                    f2 = fArray[n7];
                    f = -fArray[n7 + 1];
                    fArray[n8] = f2;
                    fArray[n8 + 1] = f;
                    fArray[n7] = f4;
                    fArray[n7 + 1] = f3;
                }
                n9 = n11 + 2 * nArray[n4 + i];
                n10 = n9 + 2;
                n8 = n2 + n10;
                n7 = n2 + (n9 += n5);
                fArray[n8 - 1] = -fArray[n8 - 1];
                f4 = fArray[n8];
                f3 = -fArray[n8 + 1];
                f2 = fArray[n7];
                f = -fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                fArray[n7 + 3] = -fArray[n7 + 3];
                n8 = n2 + (n10 += n6);
                n7 = n2 + (n9 += 2 * n6);
                f4 = fArray[n8];
                f3 = -fArray[n8 + 1];
                f2 = fArray[n7];
                f = -fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                n8 = n2 + (n10 += n6);
                n7 = n2 + (n9 -= n6);
                f4 = fArray[n8];
                f3 = -fArray[n8 + 1];
                f2 = fArray[n7];
                f = -fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                n8 = n2 + (n10 -= 2);
                n7 = n2 + (n9 -= n5);
                f4 = fArray[n8];
                f3 = -fArray[n8 + 1];
                f2 = fArray[n7];
                f = -fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                n8 = n2 + (n10 += n5 + 2);
                n7 = n2 + (n9 += n5 + 2);
                f4 = fArray[n8];
                f3 = -fArray[n8 + 1];
                f2 = fArray[n7];
                f = -fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                n8 = n2 + (n10 -= n5 - n6);
                n7 = n2 + (n9 += 2 * n6 - 2);
                fArray[n8 - 1] = -fArray[n8 - 1];
                f4 = fArray[n8];
                f3 = -fArray[n8 + 1];
                f2 = fArray[n7];
                f = -fArray[n7 + 1];
                fArray[n8] = f2;
                fArray[n8 + 1] = f;
                fArray[n7] = f4;
                fArray[n7 + 1] = f3;
                fArray[n7 + 3] = -fArray[n7 + 3];
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                float f;
                float f5;
                float f6;
                float f7;
                int n12;
                int n13;
                int n14;
                int n15;
                int n16 = 4 * i;
                for (int j = 0; j < i; ++j) {
                    n15 = 4 * j + nArray[n4 + i];
                    n14 = n16 + nArray[n4 + j];
                    n13 = n2 + n15;
                    n12 = n2 + n14;
                    f7 = fArray[n13];
                    f6 = -fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = -fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                    n13 = n2 + (n15 += n6);
                    n12 = n2 + (n14 += n6);
                    f7 = fArray[n13];
                    f6 = -fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = -fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                    n13 = n2 + (n15 += n5);
                    n12 = n2 + (n14 += 2);
                    f7 = fArray[n13];
                    f6 = -fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = -fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                    n13 = n2 + (n15 -= n6);
                    n12 = n2 + (n14 -= n6);
                    f7 = fArray[n13];
                    f6 = -fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = -fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                    n13 = n2 + (n15 += 2);
                    n12 = n2 + (n14 += n5);
                    f7 = fArray[n13];
                    f6 = -fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = -fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                    n13 = n2 + (n15 += n6);
                    n12 = n2 + (n14 += n6);
                    f7 = fArray[n13];
                    f6 = -fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = -fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                    n13 = n2 + (n15 -= n5);
                    n12 = n2 + (n14 -= 2);
                    f7 = fArray[n13];
                    f6 = -fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = -fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                    n13 = n2 + (n15 -= n6);
                    n12 = n2 + (n14 -= n6);
                    f7 = fArray[n13];
                    f6 = -fArray[n13 + 1];
                    f5 = fArray[n12];
                    f = -fArray[n12 + 1];
                    fArray[n13] = f5;
                    fArray[n13 + 1] = f;
                    fArray[n12] = f7;
                    fArray[n12 + 1] = f6;
                }
                n14 = n16 + nArray[n4 + i];
                n15 = n14 + 2;
                n13 = n2 + n15;
                n12 = n2 + (n14 += n5);
                fArray[n13 - 1] = -fArray[n13 - 1];
                f7 = fArray[n13];
                f6 = -fArray[n13 + 1];
                f5 = fArray[n12];
                f = -fArray[n12 + 1];
                fArray[n13] = f5;
                fArray[n13 + 1] = f;
                fArray[n12] = f7;
                fArray[n12 + 1] = f6;
                fArray[n12 + 3] = -fArray[n12 + 3];
                n13 = n2 + (n15 += n6);
                n12 = n2 + (n14 += n6);
                fArray[n13 - 1] = -fArray[n13 - 1];
                f7 = fArray[n13];
                f6 = -fArray[n13 + 1];
                f5 = fArray[n12];
                f = -fArray[n12 + 1];
                fArray[n13] = f5;
                fArray[n13 + 1] = f;
                fArray[n12] = f7;
                fArray[n12 + 1] = f6;
                fArray[n12 + 3] = -fArray[n12 + 3];
            }
        }
    }

    private void bitrv216(float[] fArray, int n) {
        float f = fArray[n + 2];
        float f2 = fArray[n + 3];
        float f3 = fArray[n + 4];
        float f4 = fArray[n + 5];
        float f5 = fArray[n + 6];
        float f6 = fArray[n + 7];
        float f7 = fArray[n + 8];
        float f8 = fArray[n + 9];
        float f9 = fArray[n + 10];
        float f10 = fArray[n + 11];
        float f11 = fArray[n + 14];
        float f12 = fArray[n + 15];
        float f13 = fArray[n + 16];
        float f14 = fArray[n + 17];
        float f15 = fArray[n + 20];
        float f16 = fArray[n + 21];
        float f17 = fArray[n + 22];
        float f18 = fArray[n + 23];
        float f19 = fArray[n + 24];
        float f20 = fArray[n + 25];
        float f21 = fArray[n + 26];
        float f22 = fArray[n + 27];
        float f23 = fArray[n + 28];
        float f24 = fArray[n + 29];
        fArray[n + 2] = f13;
        fArray[n + 3] = f14;
        fArray[n + 4] = f7;
        fArray[n + 5] = f8;
        fArray[n + 6] = f19;
        fArray[n + 7] = f20;
        fArray[n + 8] = f3;
        fArray[n + 9] = f4;
        fArray[n + 10] = f15;
        fArray[n + 11] = f16;
        fArray[n + 14] = f23;
        fArray[n + 15] = f24;
        fArray[n + 16] = f;
        fArray[n + 17] = f2;
        fArray[n + 20] = f9;
        fArray[n + 21] = f10;
        fArray[n + 22] = f21;
        fArray[n + 23] = f22;
        fArray[n + 24] = f5;
        fArray[n + 25] = f6;
        fArray[n + 26] = f17;
        fArray[n + 27] = f18;
        fArray[n + 28] = f11;
        fArray[n + 29] = f12;
    }

    private void bitrv216neg(float[] fArray, int n) {
        float f = fArray[n + 2];
        float f2 = fArray[n + 3];
        float f3 = fArray[n + 4];
        float f4 = fArray[n + 5];
        float f5 = fArray[n + 6];
        float f6 = fArray[n + 7];
        float f7 = fArray[n + 8];
        float f8 = fArray[n + 9];
        float f9 = fArray[n + 10];
        float f10 = fArray[n + 11];
        float f11 = fArray[n + 12];
        float f12 = fArray[n + 13];
        float f13 = fArray[n + 14];
        float f14 = fArray[n + 15];
        float f15 = fArray[n + 16];
        float f16 = fArray[n + 17];
        float f17 = fArray[n + 18];
        float f18 = fArray[n + 19];
        float f19 = fArray[n + 20];
        float f20 = fArray[n + 21];
        float f21 = fArray[n + 22];
        float f22 = fArray[n + 23];
        float f23 = fArray[n + 24];
        float f24 = fArray[n + 25];
        float f25 = fArray[n + 26];
        float f26 = fArray[n + 27];
        float f27 = fArray[n + 28];
        float f28 = fArray[n + 29];
        float f29 = fArray[n + 30];
        float f30 = fArray[n + 31];
        fArray[n + 2] = f29;
        fArray[n + 3] = f30;
        fArray[n + 4] = f13;
        fArray[n + 5] = f14;
        fArray[n + 6] = f21;
        fArray[n + 7] = f22;
        fArray[n + 8] = f5;
        fArray[n + 9] = f6;
        fArray[n + 10] = f25;
        fArray[n + 11] = f26;
        fArray[n + 12] = f9;
        fArray[n + 13] = f10;
        fArray[n + 14] = f17;
        fArray[n + 15] = f18;
        fArray[n + 16] = f;
        fArray[n + 17] = f2;
        fArray[n + 18] = f27;
        fArray[n + 19] = f28;
        fArray[n + 20] = f11;
        fArray[n + 21] = f12;
        fArray[n + 22] = f19;
        fArray[n + 23] = f20;
        fArray[n + 24] = f3;
        fArray[n + 25] = f4;
        fArray[n + 26] = f23;
        fArray[n + 27] = f24;
        fArray[n + 28] = f7;
        fArray[n + 29] = f8;
        fArray[n + 30] = f15;
        fArray[n + 31] = f16;
    }

    private void bitrv208(float[] fArray, int n) {
        float f = fArray[n + 2];
        float f2 = fArray[n + 3];
        float f3 = fArray[n + 6];
        float f4 = fArray[n + 7];
        float f5 = fArray[n + 8];
        float f6 = fArray[n + 9];
        float f7 = fArray[n + 12];
        float f8 = fArray[n + 13];
        fArray[n + 2] = f5;
        fArray[n + 3] = f6;
        fArray[n + 6] = f7;
        fArray[n + 7] = f8;
        fArray[n + 8] = f;
        fArray[n + 9] = f2;
        fArray[n + 12] = f3;
        fArray[n + 13] = f4;
    }

    private void bitrv208neg(float[] fArray, int n) {
        float f = fArray[n + 2];
        float f2 = fArray[n + 3];
        float f3 = fArray[n + 4];
        float f4 = fArray[n + 5];
        float f5 = fArray[n + 6];
        float f6 = fArray[n + 7];
        float f7 = fArray[n + 8];
        float f8 = fArray[n + 9];
        float f9 = fArray[n + 10];
        float f10 = fArray[n + 11];
        float f11 = fArray[n + 12];
        float f12 = fArray[n + 13];
        float f13 = fArray[n + 14];
        float f14 = fArray[n + 15];
        fArray[n + 2] = f13;
        fArray[n + 3] = f14;
        fArray[n + 4] = f5;
        fArray[n + 5] = f6;
        fArray[n + 6] = f9;
        fArray[n + 7] = f10;
        fArray[n + 8] = f;
        fArray[n + 9] = f2;
        fArray[n + 10] = f11;
        fArray[n + 11] = f12;
        fArray[n + 12] = f3;
        fArray[n + 13] = f4;
        fArray[n + 14] = f7;
        fArray[n + 15] = f8;
    }

    private void cftf1st(int n, float[] fArray, int n2, float[] fArray2, int n3) {
        int n4;
        int n5;
        float f;
        float f2;
        float f3;
        float f4;
        int n6;
        int n7 = n >> 3;
        int n8 = n6 = 2 * n7;
        int n9 = n8 + n6;
        int n10 = n9 + n6;
        int n11 = n2 + n8;
        int n12 = n2 + n9;
        int n13 = n2 + n10;
        float f5 = fArray[n2] + fArray[n12];
        float f6 = fArray[n2 + 1] + fArray[n12 + 1];
        float f7 = fArray[n2] - fArray[n12];
        float f8 = fArray[n2 + 1] - fArray[n12 + 1];
        float f9 = fArray[n11] + fArray[n13];
        float f10 = fArray[n11 + 1] + fArray[n13 + 1];
        float f11 = fArray[n11] - fArray[n13];
        float f12 = fArray[n11 + 1] - fArray[n13 + 1];
        fArray[n2] = f5 + f9;
        fArray[n2 + 1] = f6 + f10;
        fArray[n11] = f5 - f9;
        fArray[n11 + 1] = f6 - f10;
        fArray[n12] = f7 - f12;
        fArray[n12 + 1] = f8 + f11;
        fArray[n13] = f7 + f12;
        fArray[n13 + 1] = f8 - f11;
        float f13 = fArray2[n3 + 1];
        float f14 = fArray2[n3 + 2];
        float f15 = fArray2[n3 + 3];
        float f16 = 1.0f;
        float f17 = 0.0f;
        float f18 = 1.0f;
        float f19 = 0.0f;
        int n14 = 0;
        for (int i = 2; i < n7 - 2; i += 4) {
            int n15 = n3 + (n14 += 4);
            f4 = f14 * (f16 + fArray2[n15]);
            f3 = f14 * (f17 + fArray2[n15 + 1]);
            f2 = f15 * (f18 + fArray2[n15 + 2]);
            f = f15 * (f19 + fArray2[n15 + 3]);
            f16 = fArray2[n15];
            f17 = fArray2[n15 + 1];
            f18 = fArray2[n15 + 2];
            f19 = fArray2[n15 + 3];
            n8 = i + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            int n16 = n2 + i;
            f5 = fArray[n16] + fArray[n12];
            f6 = fArray[n16 + 1] + fArray[n12 + 1];
            f7 = fArray[n16] - fArray[n12];
            f8 = fArray[n16 + 1] - fArray[n12 + 1];
            float f20 = fArray[n16 + 2] + fArray[n12 + 2];
            float f21 = fArray[n16 + 3] + fArray[n12 + 3];
            float f22 = fArray[n16 + 2] - fArray[n12 + 2];
            float f23 = fArray[n16 + 3] - fArray[n12 + 3];
            f9 = fArray[n11] + fArray[n13];
            f10 = fArray[n11 + 1] + fArray[n13 + 1];
            f11 = fArray[n11] - fArray[n13];
            f12 = fArray[n11 + 1] - fArray[n13 + 1];
            float f24 = fArray[n11 + 2] + fArray[n13 + 2];
            float f25 = fArray[n11 + 3] + fArray[n13 + 3];
            float f26 = fArray[n11 + 2] - fArray[n13 + 2];
            float f27 = fArray[n11 + 3] - fArray[n13 + 3];
            fArray[n16] = f5 + f9;
            fArray[n16 + 1] = f6 + f10;
            fArray[n16 + 2] = f20 + f24;
            fArray[n16 + 3] = f21 + f25;
            fArray[n11] = f5 - f9;
            fArray[n11 + 1] = f6 - f10;
            fArray[n11 + 2] = f20 - f24;
            fArray[n11 + 3] = f21 - f25;
            f5 = f7 - f12;
            f6 = f8 + f11;
            fArray[n12] = f4 * f5 - f3 * f6;
            fArray[n12 + 1] = f4 * f6 + f3 * f5;
            f5 = f22 - f27;
            f6 = f23 + f26;
            fArray[n12 + 2] = f16 * f5 - f17 * f6;
            fArray[n12 + 3] = f16 * f6 + f17 * f5;
            f5 = f7 + f12;
            f6 = f8 - f11;
            fArray[n13] = f2 * f5 + f * f6;
            fArray[n13 + 1] = f2 * f6 - f * f5;
            f5 = f22 + f27;
            f6 = f23 - f26;
            fArray[n13 + 2] = f18 * f5 + f19 * f6;
            fArray[n13 + 3] = f18 * f6 - f19 * f5;
            n5 = n6 - i;
            n8 = n5 + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n4 = n2 + n5;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            f5 = fArray[n4] + fArray[n12];
            f6 = fArray[n4 + 1] + fArray[n12 + 1];
            f7 = fArray[n4] - fArray[n12];
            f8 = fArray[n4 + 1] - fArray[n12 + 1];
            f20 = fArray[n4 - 2] + fArray[n12 - 2];
            f21 = fArray[n4 - 1] + fArray[n12 - 1];
            f22 = fArray[n4 - 2] - fArray[n12 - 2];
            f23 = fArray[n4 - 1] - fArray[n12 - 1];
            f9 = fArray[n11] + fArray[n13];
            f10 = fArray[n11 + 1] + fArray[n13 + 1];
            f11 = fArray[n11] - fArray[n13];
            f12 = fArray[n11 + 1] - fArray[n13 + 1];
            f24 = fArray[n11 - 2] + fArray[n13 - 2];
            f25 = fArray[n11 - 1] + fArray[n13 - 1];
            f26 = fArray[n11 - 2] - fArray[n13 - 2];
            f27 = fArray[n11 - 1] - fArray[n13 - 1];
            fArray[n4] = f5 + f9;
            fArray[n4 + 1] = f6 + f10;
            fArray[n4 - 2] = f20 + f24;
            fArray[n4 - 1] = f21 + f25;
            fArray[n11] = f5 - f9;
            fArray[n11 + 1] = f6 - f10;
            fArray[n11 - 2] = f20 - f24;
            fArray[n11 - 1] = f21 - f25;
            f5 = f7 - f12;
            f6 = f8 + f11;
            fArray[n12] = f3 * f5 - f4 * f6;
            fArray[n12 + 1] = f3 * f6 + f4 * f5;
            f5 = f22 - f27;
            f6 = f23 + f26;
            fArray[n12 - 2] = f17 * f5 - f16 * f6;
            fArray[n12 - 1] = f17 * f6 + f16 * f5;
            f5 = f7 + f12;
            f6 = f8 - f11;
            fArray[n13] = f * f5 + f2 * f6;
            fArray[n13 + 1] = f * f6 - f2 * f5;
            f5 = f22 + f27;
            f6 = f23 - f26;
            fArray[n2 + n10 - 2] = f19 * f5 + f18 * f6;
            fArray[n2 + n10 - 1] = f19 * f6 - f18 * f5;
        }
        f4 = f14 * (f16 + f13);
        f3 = f14 * (f17 + f13);
        f2 = f15 * (f18 - f13);
        f = f15 * (f19 - f13);
        n5 = n7;
        n8 = n5 + n6;
        n9 = n8 + n6;
        n10 = n9 + n6;
        n4 = n2 + n5;
        n11 = n2 + n8;
        n12 = n2 + n9;
        n13 = n2 + n10;
        f5 = fArray[n4 - 2] + fArray[n12 - 2];
        f6 = fArray[n4 - 1] + fArray[n12 - 1];
        f7 = fArray[n4 - 2] - fArray[n12 - 2];
        f8 = fArray[n4 - 1] - fArray[n12 - 1];
        f9 = fArray[n11 - 2] + fArray[n13 - 2];
        f10 = fArray[n11 - 1] + fArray[n13 - 1];
        f11 = fArray[n11 - 2] - fArray[n13 - 2];
        f12 = fArray[n11 - 1] - fArray[n13 - 1];
        fArray[n4 - 2] = f5 + f9;
        fArray[n4 - 1] = f6 + f10;
        fArray[n11 - 2] = f5 - f9;
        fArray[n11 - 1] = f6 - f10;
        f5 = f7 - f12;
        f6 = f8 + f11;
        fArray[n12 - 2] = f4 * f5 - f3 * f6;
        fArray[n12 - 1] = f4 * f6 + f3 * f5;
        f5 = f7 + f12;
        f6 = f8 - f11;
        fArray[n13 - 2] = f2 * f5 + f * f6;
        fArray[n13 - 1] = f2 * f6 - f * f5;
        f5 = fArray[n4] + fArray[n12];
        f6 = fArray[n4 + 1] + fArray[n12 + 1];
        f7 = fArray[n4] - fArray[n12];
        f8 = fArray[n4 + 1] - fArray[n12 + 1];
        f9 = fArray[n11] + fArray[n13];
        f10 = fArray[n11 + 1] + fArray[n13 + 1];
        f11 = fArray[n11] - fArray[n13];
        f12 = fArray[n11 + 1] - fArray[n13 + 1];
        fArray[n4] = f5 + f9;
        fArray[n4 + 1] = f6 + f10;
        fArray[n11] = f5 - f9;
        fArray[n11 + 1] = f6 - f10;
        f5 = f7 - f12;
        f6 = f8 + f11;
        fArray[n12] = f13 * (f5 - f6);
        fArray[n12 + 1] = f13 * (f6 + f5);
        f5 = f7 + f12;
        f6 = f8 - f11;
        fArray[n13] = -f13 * (f5 + f6);
        fArray[n13 + 1] = -f13 * (f6 - f5);
        f5 = fArray[n4 + 2] + fArray[n12 + 2];
        f6 = fArray[n4 + 3] + fArray[n12 + 3];
        f7 = fArray[n4 + 2] - fArray[n12 + 2];
        f8 = fArray[n4 + 3] - fArray[n12 + 3];
        f9 = fArray[n11 + 2] + fArray[n13 + 2];
        f10 = fArray[n11 + 3] + fArray[n13 + 3];
        f11 = fArray[n11 + 2] - fArray[n13 + 2];
        f12 = fArray[n11 + 3] - fArray[n13 + 3];
        fArray[n4 + 2] = f5 + f9;
        fArray[n4 + 3] = f6 + f10;
        fArray[n11 + 2] = f5 - f9;
        fArray[n11 + 3] = f6 - f10;
        f5 = f7 - f12;
        f6 = f8 + f11;
        fArray[n12 + 2] = f3 * f5 - f4 * f6;
        fArray[n12 + 3] = f3 * f6 + f4 * f5;
        f5 = f7 + f12;
        f6 = f8 - f11;
        fArray[n13 + 2] = f * f5 + f2 * f6;
        fArray[n13 + 3] = f * f6 - f2 * f5;
    }

    private void cftb1st(int n, float[] fArray, int n2, float[] fArray2, int n3) {
        int n4;
        int n5;
        float f;
        float f2;
        float f3;
        float f4;
        int n6;
        int n7 = n >> 3;
        int n8 = n6 = 2 * n7;
        int n9 = n8 + n6;
        int n10 = n9 + n6;
        int n11 = n2 + n8;
        int n12 = n2 + n9;
        int n13 = n2 + n10;
        float f5 = fArray[n2] + fArray[n12];
        float f6 = -fArray[n2 + 1] - fArray[n12 + 1];
        float f7 = fArray[n2] - fArray[n12];
        float f8 = -fArray[n2 + 1] + fArray[n12 + 1];
        float f9 = fArray[n11] + fArray[n13];
        float f10 = fArray[n11 + 1] + fArray[n13 + 1];
        float f11 = fArray[n11] - fArray[n13];
        float f12 = fArray[n11 + 1] - fArray[n13 + 1];
        fArray[n2] = f5 + f9;
        fArray[n2 + 1] = f6 - f10;
        fArray[n11] = f5 - f9;
        fArray[n11 + 1] = f6 + f10;
        fArray[n12] = f7 + f12;
        fArray[n12 + 1] = f8 + f11;
        fArray[n13] = f7 - f12;
        fArray[n13 + 1] = f8 - f11;
        float f13 = fArray2[n3 + 1];
        float f14 = fArray2[n3 + 2];
        float f15 = fArray2[n3 + 3];
        float f16 = 1.0f;
        float f17 = 0.0f;
        float f18 = 1.0f;
        float f19 = 0.0f;
        int n14 = 0;
        for (int i = 2; i < n7 - 2; i += 4) {
            int n15 = n3 + (n14 += 4);
            f4 = f14 * (f16 + fArray2[n15]);
            f3 = f14 * (f17 + fArray2[n15 + 1]);
            f2 = f15 * (f18 + fArray2[n15 + 2]);
            f = f15 * (f19 + fArray2[n15 + 3]);
            f16 = fArray2[n15];
            f17 = fArray2[n15 + 1];
            f18 = fArray2[n15 + 2];
            f19 = fArray2[n15 + 3];
            n8 = i + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            int n16 = n2 + i;
            f5 = fArray[n16] + fArray[n12];
            f6 = -fArray[n16 + 1] - fArray[n12 + 1];
            f7 = fArray[n16] - fArray[n2 + n9];
            f8 = -fArray[n16 + 1] + fArray[n12 + 1];
            float f20 = fArray[n16 + 2] + fArray[n12 + 2];
            float f21 = -fArray[n16 + 3] - fArray[n12 + 3];
            float f22 = fArray[n16 + 2] - fArray[n12 + 2];
            float f23 = -fArray[n16 + 3] + fArray[n12 + 3];
            f9 = fArray[n11] + fArray[n13];
            f10 = fArray[n11 + 1] + fArray[n13 + 1];
            f11 = fArray[n11] - fArray[n13];
            f12 = fArray[n11 + 1] - fArray[n13 + 1];
            float f24 = fArray[n11 + 2] + fArray[n13 + 2];
            float f25 = fArray[n11 + 3] + fArray[n13 + 3];
            float f26 = fArray[n11 + 2] - fArray[n13 + 2];
            float f27 = fArray[n11 + 3] - fArray[n13 + 3];
            fArray[n16] = f5 + f9;
            fArray[n16 + 1] = f6 - f10;
            fArray[n16 + 2] = f20 + f24;
            fArray[n16 + 3] = f21 - f25;
            fArray[n11] = f5 - f9;
            fArray[n11 + 1] = f6 + f10;
            fArray[n11 + 2] = f20 - f24;
            fArray[n11 + 3] = f21 + f25;
            f5 = f7 + f12;
            f6 = f8 + f11;
            fArray[n12] = f4 * f5 - f3 * f6;
            fArray[n12 + 1] = f4 * f6 + f3 * f5;
            f5 = f22 + f27;
            f6 = f23 + f26;
            fArray[n12 + 2] = f16 * f5 - f17 * f6;
            fArray[n12 + 3] = f16 * f6 + f17 * f5;
            f5 = f7 - f12;
            f6 = f8 - f11;
            fArray[n13] = f2 * f5 + f * f6;
            fArray[n13 + 1] = f2 * f6 - f * f5;
            f5 = f22 - f27;
            f6 = f23 - f26;
            fArray[n13 + 2] = f18 * f5 + f19 * f6;
            fArray[n13 + 3] = f18 * f6 - f19 * f5;
            n5 = n6 - i;
            n8 = n5 + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n4 = n2 + n5;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            f5 = fArray[n4] + fArray[n12];
            f6 = -fArray[n4 + 1] - fArray[n12 + 1];
            f7 = fArray[n4] - fArray[n12];
            f8 = -fArray[n4 + 1] + fArray[n12 + 1];
            f20 = fArray[n4 - 2] + fArray[n12 - 2];
            f21 = -fArray[n4 - 1] - fArray[n12 - 1];
            f22 = fArray[n4 - 2] - fArray[n12 - 2];
            f23 = -fArray[n4 - 1] + fArray[n12 - 1];
            f9 = fArray[n11] + fArray[n13];
            f10 = fArray[n11 + 1] + fArray[n13 + 1];
            f11 = fArray[n11] - fArray[n13];
            f12 = fArray[n11 + 1] - fArray[n13 + 1];
            f24 = fArray[n11 - 2] + fArray[n13 - 2];
            f25 = fArray[n11 - 1] + fArray[n13 - 1];
            f26 = fArray[n11 - 2] - fArray[n13 - 2];
            f27 = fArray[n11 - 1] - fArray[n13 - 1];
            fArray[n4] = f5 + f9;
            fArray[n4 + 1] = f6 - f10;
            fArray[n4 - 2] = f20 + f24;
            fArray[n4 - 1] = f21 - f25;
            fArray[n11] = f5 - f9;
            fArray[n11 + 1] = f6 + f10;
            fArray[n11 - 2] = f20 - f24;
            fArray[n11 - 1] = f21 + f25;
            f5 = f7 + f12;
            f6 = f8 + f11;
            fArray[n12] = f3 * f5 - f4 * f6;
            fArray[n12 + 1] = f3 * f6 + f4 * f5;
            f5 = f22 + f27;
            f6 = f23 + f26;
            fArray[n12 - 2] = f17 * f5 - f16 * f6;
            fArray[n12 - 1] = f17 * f6 + f16 * f5;
            f5 = f7 - f12;
            f6 = f8 - f11;
            fArray[n13] = f * f5 + f2 * f6;
            fArray[n13 + 1] = f * f6 - f2 * f5;
            f5 = f22 - f27;
            f6 = f23 - f26;
            fArray[n13 - 2] = f19 * f5 + f18 * f6;
            fArray[n13 - 1] = f19 * f6 - f18 * f5;
        }
        f4 = f14 * (f16 + f13);
        f3 = f14 * (f17 + f13);
        f2 = f15 * (f18 - f13);
        f = f15 * (f19 - f13);
        n5 = n7;
        n8 = n5 + n6;
        n9 = n8 + n6;
        n10 = n9 + n6;
        n4 = n2 + n5;
        n11 = n2 + n8;
        n12 = n2 + n9;
        n13 = n2 + n10;
        f5 = fArray[n4 - 2] + fArray[n12 - 2];
        f6 = -fArray[n4 - 1] - fArray[n12 - 1];
        f7 = fArray[n4 - 2] - fArray[n12 - 2];
        f8 = -fArray[n4 - 1] + fArray[n12 - 1];
        f9 = fArray[n11 - 2] + fArray[n13 - 2];
        f10 = fArray[n11 - 1] + fArray[n13 - 1];
        f11 = fArray[n11 - 2] - fArray[n13 - 2];
        f12 = fArray[n11 - 1] - fArray[n13 - 1];
        fArray[n4 - 2] = f5 + f9;
        fArray[n4 - 1] = f6 - f10;
        fArray[n11 - 2] = f5 - f9;
        fArray[n11 - 1] = f6 + f10;
        f5 = f7 + f12;
        f6 = f8 + f11;
        fArray[n12 - 2] = f4 * f5 - f3 * f6;
        fArray[n12 - 1] = f4 * f6 + f3 * f5;
        f5 = f7 - f12;
        f6 = f8 - f11;
        fArray[n13 - 2] = f2 * f5 + f * f6;
        fArray[n13 - 1] = f2 * f6 - f * f5;
        f5 = fArray[n4] + fArray[n12];
        f6 = -fArray[n4 + 1] - fArray[n12 + 1];
        f7 = fArray[n4] - fArray[n12];
        f8 = -fArray[n4 + 1] + fArray[n12 + 1];
        f9 = fArray[n11] + fArray[n13];
        f10 = fArray[n11 + 1] + fArray[n13 + 1];
        f11 = fArray[n11] - fArray[n13];
        f12 = fArray[n11 + 1] - fArray[n13 + 1];
        fArray[n4] = f5 + f9;
        fArray[n4 + 1] = f6 - f10;
        fArray[n11] = f5 - f9;
        fArray[n11 + 1] = f6 + f10;
        f5 = f7 + f12;
        f6 = f8 + f11;
        fArray[n12] = f13 * (f5 - f6);
        fArray[n12 + 1] = f13 * (f6 + f5);
        f5 = f7 - f12;
        f6 = f8 - f11;
        fArray[n13] = -f13 * (f5 + f6);
        fArray[n13 + 1] = -f13 * (f6 - f5);
        f5 = fArray[n4 + 2] + fArray[n12 + 2];
        f6 = -fArray[n4 + 3] - fArray[n12 + 3];
        f7 = fArray[n4 + 2] - fArray[n12 + 2];
        f8 = -fArray[n4 + 3] + fArray[n12 + 3];
        f9 = fArray[n11 + 2] + fArray[n13 + 2];
        f10 = fArray[n11 + 3] + fArray[n13 + 3];
        f11 = fArray[n11 + 2] - fArray[n13 + 2];
        f12 = fArray[n11 + 3] - fArray[n13 + 3];
        fArray[n4 + 2] = f5 + f9;
        fArray[n4 + 3] = f6 - f10;
        fArray[n11 + 2] = f5 - f9;
        fArray[n11 + 3] = f6 + f10;
        f5 = f7 + f12;
        f6 = f8 + f11;
        fArray[n12 + 2] = f3 * f5 - f4 * f6;
        fArray[n12 + 3] = f3 * f6 + f4 * f5;
        f5 = f7 - f12;
        f6 = f8 - f11;
        fArray[n13 + 2] = f * f5 + f2 * f6;
        fArray[n13 + 3] = f * f6 - f2 * f5;
    }

    private void cftrec4_th(final int n, final float[] fArray, int n2, final int n3, final float[] fArray2) {
        int n4 = 0;
        int n5 = 2;
        int n6 = 0;
        int n7 = n >> 1;
        if (n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
            n5 = 4;
            n6 = 1;
            n7 >>= 1;
        }
        Future[] futureArray = new Future[n5];
        final int n8 = n7;
        for (int i = 0; i < n5; ++i) {
            final int n9 = n2 + i * n7;
            futureArray[n4++] = i != n6 ? ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    int n6 = n9 + n8;
                    int n2 = n;
                    while (n2 > 512) {
                        FloatFFT_1D.this.cftmdl1(n2 >>= 2, fArray, n6 - n2, fArray2, n3 - (n2 >> 1));
                    }
                    FloatFFT_1D.this.cftleaf(n2, 1, fArray, n6 - n2, n3, fArray2);
                    int n32 = 0;
                    int n4 = n9 - n2;
                    for (int i = n8 - n2; i > 0; i -= n2) {
                        int n5 = FloatFFT_1D.this.cfttree(n2, i, ++n32, fArray, n9, n3, fArray2);
                        FloatFFT_1D.this.cftleaf(n2, n5, fArray, n4 + i, n3, fArray2);
                    }
                }
            }) : ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    int n6 = n9 + n8;
                    int n2 = 1;
                    int n32 = n;
                    while (n32 > 512) {
                        n2 <<= 2;
                        FloatFFT_1D.this.cftmdl2(n32 >>= 2, fArray, n6 - n32, fArray2, n3 - n32);
                    }
                    FloatFFT_1D.this.cftleaf(n32, 0, fArray, n6 - n32, n3, fArray2);
                    n2 >>= 1;
                    int n4 = n9 - n32;
                    for (int i = n8 - n32; i > 0; i -= n32) {
                        int n5 = FloatFFT_1D.this.cfttree(n32, i, ++n2, fArray, n9, n3, fArray2);
                        FloatFFT_1D.this.cftleaf(n32, n5, fArray, n4 + i, n3, fArray2);
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void cftrec4(int n, float[] fArray, int n2, int n3, float[] fArray2) {
        int n4 = n;
        int n5 = n2 + n;
        while (n4 > 512) {
            this.cftmdl1(n4 >>= 2, fArray, n5 - n4, fArray2, n3 - (n4 >> 1));
        }
        this.cftleaf(n4, 1, fArray, n5 - n4, n3, fArray2);
        int n6 = 0;
        int n7 = n2 - n4;
        for (int i = n - n4; i > 0; i -= n4) {
            int n8 = this.cfttree(n4, i, ++n6, fArray, n2, n3, fArray2);
            this.cftleaf(n4, n8, fArray, n7 + i, n3, fArray2);
        }
    }

    private int cfttree(int n, int n2, int n3, float[] fArray, int n4, int n5, float[] fArray2) {
        int n6;
        int n7 = n4 - n;
        if ((n3 & 3) != 0) {
            n6 = n3 & 1;
            if (n6 != 0) {
                this.cftmdl1(n, fArray, n7 + n2, fArray2, n5 - (n >> 1));
            } else {
                this.cftmdl2(n, fArray, n7 + n2, fArray2, n5 - n);
            }
        } else {
            int n8 = n;
            int n9 = n3;
            while ((n9 & 3) == 0) {
                n8 <<= 2;
                n9 >>= 2;
            }
            n6 = n9 & 1;
            int n10 = n4 + n2;
            if (n6 != 0) {
                while (n8 > 128) {
                    this.cftmdl1(n8, fArray, n10 - n8, fArray2, n5 - (n8 >> 1));
                    n8 >>= 2;
                }
            } else {
                while (n8 > 128) {
                    this.cftmdl2(n8, fArray, n10 - n8, fArray2, n5 - n8);
                    n8 >>= 2;
                }
            }
        }
        return n6;
    }

    private void cftleaf(int n, int n2, float[] fArray, int n3, int n4, float[] fArray2) {
        if (n == 512) {
            this.cftmdl1(128, fArray, n3, fArray2, n4 - 64);
            this.cftf161(fArray, n3, fArray2, n4 - 8);
            this.cftf162(fArray, n3 + 32, fArray2, n4 - 32);
            this.cftf161(fArray, n3 + 64, fArray2, n4 - 8);
            this.cftf161(fArray, n3 + 96, fArray2, n4 - 8);
            this.cftmdl2(128, fArray, n3 + 128, fArray2, n4 - 128);
            this.cftf161(fArray, n3 + 128, fArray2, n4 - 8);
            this.cftf162(fArray, n3 + 160, fArray2, n4 - 32);
            this.cftf161(fArray, n3 + 192, fArray2, n4 - 8);
            this.cftf162(fArray, n3 + 224, fArray2, n4 - 32);
            this.cftmdl1(128, fArray, n3 + 256, fArray2, n4 - 64);
            this.cftf161(fArray, n3 + 256, fArray2, n4 - 8);
            this.cftf162(fArray, n3 + 288, fArray2, n4 - 32);
            this.cftf161(fArray, n3 + 320, fArray2, n4 - 8);
            this.cftf161(fArray, n3 + 352, fArray2, n4 - 8);
            if (n2 != 0) {
                this.cftmdl1(128, fArray, n3 + 384, fArray2, n4 - 64);
                this.cftf161(fArray, n3 + 480, fArray2, n4 - 8);
            } else {
                this.cftmdl2(128, fArray, n3 + 384, fArray2, n4 - 128);
                this.cftf162(fArray, n3 + 480, fArray2, n4 - 32);
            }
            this.cftf161(fArray, n3 + 384, fArray2, n4 - 8);
            this.cftf162(fArray, n3 + 416, fArray2, n4 - 32);
            this.cftf161(fArray, n3 + 448, fArray2, n4 - 8);
        } else {
            this.cftmdl1(64, fArray, n3, fArray2, n4 - 32);
            this.cftf081(fArray, n3, fArray2, n4 - 8);
            this.cftf082(fArray, n3 + 16, fArray2, n4 - 8);
            this.cftf081(fArray, n3 + 32, fArray2, n4 - 8);
            this.cftf081(fArray, n3 + 48, fArray2, n4 - 8);
            this.cftmdl2(64, fArray, n3 + 64, fArray2, n4 - 64);
            this.cftf081(fArray, n3 + 64, fArray2, n4 - 8);
            this.cftf082(fArray, n3 + 80, fArray2, n4 - 8);
            this.cftf081(fArray, n3 + 96, fArray2, n4 - 8);
            this.cftf082(fArray, n3 + 112, fArray2, n4 - 8);
            this.cftmdl1(64, fArray, n3 + 128, fArray2, n4 - 32);
            this.cftf081(fArray, n3 + 128, fArray2, n4 - 8);
            this.cftf082(fArray, n3 + 144, fArray2, n4 - 8);
            this.cftf081(fArray, n3 + 160, fArray2, n4 - 8);
            this.cftf081(fArray, n3 + 176, fArray2, n4 - 8);
            if (n2 != 0) {
                this.cftmdl1(64, fArray, n3 + 192, fArray2, n4 - 32);
                this.cftf081(fArray, n3 + 240, fArray2, n4 - 8);
            } else {
                this.cftmdl2(64, fArray, n3 + 192, fArray2, n4 - 64);
                this.cftf082(fArray, n3 + 240, fArray2, n4 - 8);
            }
            this.cftf081(fArray, n3 + 192, fArray2, n4 - 8);
            this.cftf082(fArray, n3 + 208, fArray2, n4 - 8);
            this.cftf081(fArray, n3 + 224, fArray2, n4 - 8);
        }
    }

    private void cftmdl1(int n, float[] fArray, int n2, float[] fArray2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = n >> 3;
        int n8 = n6 = 2 * n7;
        int n9 = n8 + n6;
        int n10 = n9 + n6;
        int n11 = n2 + n8;
        int n12 = n2 + n9;
        int n13 = n2 + n10;
        float f = fArray[n2] + fArray[n12];
        float f2 = fArray[n2 + 1] + fArray[n12 + 1];
        float f3 = fArray[n2] - fArray[n12];
        float f4 = fArray[n2 + 1] - fArray[n12 + 1];
        float f5 = fArray[n11] + fArray[n13];
        float f6 = fArray[n11 + 1] + fArray[n13 + 1];
        float f7 = fArray[n11] - fArray[n13];
        float f8 = fArray[n11 + 1] - fArray[n13 + 1];
        fArray[n2] = f + f5;
        fArray[n2 + 1] = f2 + f6;
        fArray[n11] = f - f5;
        fArray[n11 + 1] = f2 - f6;
        fArray[n12] = f3 - f8;
        fArray[n12 + 1] = f4 + f7;
        fArray[n13] = f3 + f8;
        fArray[n13 + 1] = f4 - f7;
        float f9 = fArray2[n3 + 1];
        int n14 = 0;
        for (int i = 2; i < n7; i += 2) {
            int n15 = n3 + (n14 += 4);
            float f10 = fArray2[n15];
            float f11 = fArray2[n15 + 1];
            float f12 = fArray2[n15 + 2];
            float f13 = fArray2[n15 + 3];
            n8 = i + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            int n16 = n2 + i;
            f = fArray[n16] + fArray[n12];
            f2 = fArray[n16 + 1] + fArray[n12 + 1];
            f3 = fArray[n16] - fArray[n12];
            f4 = fArray[n16 + 1] - fArray[n12 + 1];
            f5 = fArray[n11] + fArray[n13];
            f6 = fArray[n11 + 1] + fArray[n13 + 1];
            f7 = fArray[n11] - fArray[n13];
            f8 = fArray[n11 + 1] - fArray[n13 + 1];
            fArray[n16] = f + f5;
            fArray[n16 + 1] = f2 + f6;
            fArray[n11] = f - f5;
            fArray[n11 + 1] = f2 - f6;
            f = f3 - f8;
            f2 = f4 + f7;
            fArray[n12] = f10 * f - f11 * f2;
            fArray[n12 + 1] = f10 * f2 + f11 * f;
            f = f3 + f8;
            f2 = f4 - f7;
            fArray[n13] = f12 * f + f13 * f2;
            fArray[n13 + 1] = f12 * f2 - f13 * f;
            n5 = n6 - i;
            n8 = n5 + n6;
            n9 = n8 + n6;
            n10 = n9 + n6;
            n4 = n2 + n5;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            f = fArray[n4] + fArray[n12];
            f2 = fArray[n4 + 1] + fArray[n12 + 1];
            f3 = fArray[n4] - fArray[n12];
            f4 = fArray[n4 + 1] - fArray[n12 + 1];
            f5 = fArray[n11] + fArray[n13];
            f6 = fArray[n11 + 1] + fArray[n13 + 1];
            f7 = fArray[n11] - fArray[n13];
            f8 = fArray[n11 + 1] - fArray[n13 + 1];
            fArray[n4] = f + f5;
            fArray[n4 + 1] = f2 + f6;
            fArray[n11] = f - f5;
            fArray[n11 + 1] = f2 - f6;
            f = f3 - f8;
            f2 = f4 + f7;
            fArray[n12] = f11 * f - f10 * f2;
            fArray[n12 + 1] = f11 * f2 + f10 * f;
            f = f3 + f8;
            f2 = f4 - f7;
            fArray[n13] = f13 * f + f12 * f2;
            fArray[n13 + 1] = f13 * f2 - f12 * f;
        }
        n5 = n7;
        n8 = n5 + n6;
        n9 = n8 + n6;
        n10 = n9 + n6;
        n4 = n2 + n5;
        n11 = n2 + n8;
        n12 = n2 + n9;
        n13 = n2 + n10;
        f = fArray[n4] + fArray[n12];
        f2 = fArray[n4 + 1] + fArray[n12 + 1];
        f3 = fArray[n4] - fArray[n12];
        f4 = fArray[n4 + 1] - fArray[n12 + 1];
        f5 = fArray[n11] + fArray[n13];
        f6 = fArray[n11 + 1] + fArray[n13 + 1];
        f7 = fArray[n11] - fArray[n13];
        f8 = fArray[n11 + 1] - fArray[n13 + 1];
        fArray[n4] = f + f5;
        fArray[n4 + 1] = f2 + f6;
        fArray[n11] = f - f5;
        fArray[n11 + 1] = f2 - f6;
        f = f3 - f8;
        f2 = f4 + f7;
        fArray[n12] = f9 * (f - f2);
        fArray[n12 + 1] = f9 * (f2 + f);
        f = f3 + f8;
        f2 = f4 - f7;
        fArray[n13] = -f9 * (f + f2);
        fArray[n13 + 1] = -f9 * (f2 - f);
    }

    private void cftmdl2(int n, float[] fArray, int n2, float[] fArray2, int n3) {
        int n4;
        int n5;
        float f;
        float f2;
        float f3;
        float f4;
        int n6 = n >> 3;
        int n7 = 2 * n6;
        float f5 = fArray2[n3 + 1];
        int n8 = n7;
        int n9 = n8 + n7;
        int n10 = n9 + n7;
        int n11 = n2 + n8;
        int n12 = n2 + n9;
        int n13 = n2 + n10;
        float f6 = fArray[n2] - fArray[n12 + 1];
        float f7 = fArray[n2 + 1] + fArray[n12];
        float f8 = fArray[n2] + fArray[n12 + 1];
        float f9 = fArray[n2 + 1] - fArray[n12];
        float f10 = fArray[n11] - fArray[n13 + 1];
        float f11 = fArray[n11 + 1] + fArray[n13];
        float f12 = fArray[n11] + fArray[n13 + 1];
        float f13 = fArray[n11 + 1] - fArray[n13];
        float f14 = f5 * (f10 - f11);
        float f15 = f5 * (f11 + f10);
        fArray[n2] = f6 + f14;
        fArray[n2 + 1] = f7 + f15;
        fArray[n11] = f6 - f14;
        fArray[n11 + 1] = f7 - f15;
        f14 = f5 * (f12 - f13);
        f15 = f5 * (f13 + f12);
        fArray[n12] = f8 - f15;
        fArray[n12 + 1] = f9 + f14;
        fArray[n13] = f8 + f15;
        fArray[n13 + 1] = f9 - f14;
        int n14 = 0;
        int n15 = 2 * n7;
        for (int i = 2; i < n6; i += 2) {
            int n16 = n3 + (n14 += 4);
            f4 = fArray2[n16];
            f3 = fArray2[n16 + 1];
            float f16 = fArray2[n16 + 2];
            float f17 = fArray2[n16 + 3];
            int n17 = n3 + (n15 -= 4);
            float f18 = fArray2[n17];
            float f19 = fArray2[n17 + 1];
            float f20 = fArray2[n17 + 2];
            float f21 = fArray2[n17 + 3];
            n8 = i + n7;
            n9 = n8 + n7;
            n10 = n9 + n7;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            int n18 = n2 + i;
            f6 = fArray[n18] - fArray[n12 + 1];
            f7 = fArray[n18 + 1] + fArray[n12];
            f8 = fArray[n18] + fArray[n12 + 1];
            f9 = fArray[n18 + 1] - fArray[n12];
            f10 = fArray[n11] - fArray[n13 + 1];
            f11 = fArray[n11 + 1] + fArray[n13];
            f12 = fArray[n11] + fArray[n13 + 1];
            f13 = fArray[n11 + 1] - fArray[n13];
            f14 = f4 * f6 - f3 * f7;
            f15 = f4 * f7 + f3 * f6;
            f2 = f19 * f10 - f18 * f11;
            f = f19 * f11 + f18 * f10;
            fArray[n18] = f14 + f2;
            fArray[n18 + 1] = f15 + f;
            fArray[n11] = f14 - f2;
            fArray[n11 + 1] = f15 - f;
            f14 = f16 * f8 + f17 * f9;
            f15 = f16 * f9 - f17 * f8;
            f2 = f21 * f12 + f20 * f13;
            f = f21 * f13 - f20 * f12;
            fArray[n12] = f14 + f2;
            fArray[n12 + 1] = f15 + f;
            fArray[n13] = f14 - f2;
            fArray[n13 + 1] = f15 - f;
            n5 = n7 - i;
            n8 = n5 + n7;
            n9 = n8 + n7;
            n10 = n9 + n7;
            n4 = n2 + n5;
            n11 = n2 + n8;
            n12 = n2 + n9;
            n13 = n2 + n10;
            f6 = fArray[n4] - fArray[n12 + 1];
            f7 = fArray[n4 + 1] + fArray[n12];
            f8 = fArray[n4] + fArray[n12 + 1];
            f9 = fArray[n4 + 1] - fArray[n12];
            f10 = fArray[n11] - fArray[n13 + 1];
            f11 = fArray[n11 + 1] + fArray[n13];
            f12 = fArray[n11] + fArray[n13 + 1];
            f13 = fArray[n11 + 1] - fArray[n13];
            f14 = f18 * f6 - f19 * f7;
            f15 = f18 * f7 + f19 * f6;
            f2 = f3 * f10 - f4 * f11;
            f = f3 * f11 + f4 * f10;
            fArray[n4] = f14 + f2;
            fArray[n4 + 1] = f15 + f;
            fArray[n11] = f14 - f2;
            fArray[n11 + 1] = f15 - f;
            f14 = f20 * f8 + f21 * f9;
            f15 = f20 * f9 - f21 * f8;
            f2 = f17 * f12 + f16 * f13;
            f = f17 * f13 - f16 * f12;
            fArray[n12] = f14 + f2;
            fArray[n12 + 1] = f15 + f;
            fArray[n13] = f14 - f2;
            fArray[n13 + 1] = f15 - f;
        }
        f4 = fArray2[n3 + n7];
        f3 = fArray2[n3 + n7 + 1];
        n5 = n6;
        n8 = n5 + n7;
        n9 = n8 + n7;
        n10 = n9 + n7;
        n4 = n2 + n5;
        n11 = n2 + n8;
        n12 = n2 + n9;
        n13 = n2 + n10;
        f6 = fArray[n4] - fArray[n12 + 1];
        f7 = fArray[n4 + 1] + fArray[n12];
        f8 = fArray[n4] + fArray[n12 + 1];
        f9 = fArray[n4 + 1] - fArray[n12];
        f10 = fArray[n11] - fArray[n13 + 1];
        f11 = fArray[n11 + 1] + fArray[n13];
        f12 = fArray[n11] + fArray[n13 + 1];
        f13 = fArray[n11 + 1] - fArray[n13];
        f14 = f4 * f6 - f3 * f7;
        f15 = f4 * f7 + f3 * f6;
        f2 = f3 * f10 - f4 * f11;
        f = f3 * f11 + f4 * f10;
        fArray[n4] = f14 + f2;
        fArray[n4 + 1] = f15 + f;
        fArray[n11] = f14 - f2;
        fArray[n11 + 1] = f15 - f;
        f14 = f3 * f8 - f4 * f9;
        f15 = f3 * f9 + f4 * f8;
        f2 = f4 * f12 - f3 * f13;
        f = f4 * f13 + f3 * f12;
        fArray[n12] = f14 - f2;
        fArray[n12 + 1] = f15 - f;
        fArray[n13] = f14 + f2;
        fArray[n13 + 1] = f15 + f;
    }

    private void cftfx41(int n, float[] fArray, int n2, int n3, float[] fArray2) {
        if (n == 128) {
            this.cftf161(fArray, n2, fArray2, n3 - 8);
            this.cftf162(fArray, n2 + 32, fArray2, n3 - 32);
            this.cftf161(fArray, n2 + 64, fArray2, n3 - 8);
            this.cftf161(fArray, n2 + 96, fArray2, n3 - 8);
        } else {
            this.cftf081(fArray, n2, fArray2, n3 - 8);
            this.cftf082(fArray, n2 + 16, fArray2, n3 - 8);
            this.cftf081(fArray, n2 + 32, fArray2, n3 - 8);
            this.cftf081(fArray, n2 + 48, fArray2, n3 - 8);
        }
    }

    private void cftf161(float[] fArray, int n, float[] fArray2, int n2) {
        float f = fArray2[n2 + 1];
        float f2 = fArray2[n2 + 2];
        float f3 = fArray2[n2 + 3];
        float f4 = fArray[n] + fArray[n + 16];
        float f5 = fArray[n + 1] + fArray[n + 17];
        float f6 = fArray[n] - fArray[n + 16];
        float f7 = fArray[n + 1] - fArray[n + 17];
        float f8 = fArray[n + 8] + fArray[n + 24];
        float f9 = fArray[n + 9] + fArray[n + 25];
        float f10 = fArray[n + 8] - fArray[n + 24];
        float f11 = fArray[n + 9] - fArray[n + 25];
        float f12 = f4 + f8;
        float f13 = f5 + f9;
        float f14 = f4 - f8;
        float f15 = f5 - f9;
        float f16 = f6 - f11;
        float f17 = f7 + f10;
        float f18 = f6 + f11;
        float f19 = f7 - f10;
        f4 = fArray[n + 2] + fArray[n + 18];
        f5 = fArray[n + 3] + fArray[n + 19];
        f6 = fArray[n + 2] - fArray[n + 18];
        f7 = fArray[n + 3] - fArray[n + 19];
        f8 = fArray[n + 10] + fArray[n + 26];
        f9 = fArray[n + 11] + fArray[n + 27];
        f10 = fArray[n + 10] - fArray[n + 26];
        f11 = fArray[n + 11] - fArray[n + 27];
        float f20 = f4 + f8;
        float f21 = f5 + f9;
        float f22 = f4 - f8;
        float f23 = f5 - f9;
        f4 = f6 - f11;
        f5 = f7 + f10;
        float f24 = f2 * f4 - f3 * f5;
        float f25 = f2 * f5 + f3 * f4;
        f4 = f6 + f11;
        f5 = f7 - f10;
        float f26 = f3 * f4 - f2 * f5;
        float f27 = f3 * f5 + f2 * f4;
        f4 = fArray[n + 4] + fArray[n + 20];
        f5 = fArray[n + 5] + fArray[n + 21];
        f6 = fArray[n + 4] - fArray[n + 20];
        f7 = fArray[n + 5] - fArray[n + 21];
        f8 = fArray[n + 12] + fArray[n + 28];
        f9 = fArray[n + 13] + fArray[n + 29];
        f10 = fArray[n + 12] - fArray[n + 28];
        f11 = fArray[n + 13] - fArray[n + 29];
        float f28 = f4 + f8;
        float f29 = f5 + f9;
        float f30 = f4 - f8;
        float f31 = f5 - f9;
        f4 = f6 - f11;
        f5 = f7 + f10;
        float f32 = f * (f4 - f5);
        float f33 = f * (f5 + f4);
        f4 = f6 + f11;
        f5 = f7 - f10;
        float f34 = f * (f4 + f5);
        float f35 = f * (f5 - f4);
        f4 = fArray[n + 6] + fArray[n + 22];
        f5 = fArray[n + 7] + fArray[n + 23];
        f6 = fArray[n + 6] - fArray[n + 22];
        f7 = fArray[n + 7] - fArray[n + 23];
        f8 = fArray[n + 14] + fArray[n + 30];
        f9 = fArray[n + 15] + fArray[n + 31];
        f10 = fArray[n + 14] - fArray[n + 30];
        f11 = fArray[n + 15] - fArray[n + 31];
        float f36 = f4 + f8;
        float f37 = f5 + f9;
        float f38 = f4 - f8;
        float f39 = f5 - f9;
        f4 = f6 - f11;
        f5 = f7 + f10;
        float f40 = f3 * f4 - f2 * f5;
        float f41 = f3 * f5 + f2 * f4;
        f4 = f6 + f11;
        f5 = f7 - f10;
        float f42 = f2 * f4 - f3 * f5;
        float f43 = f2 * f5 + f3 * f4;
        f4 = f18 - f34;
        f5 = f19 - f35;
        f6 = f18 + f34;
        f7 = f19 + f35;
        f8 = f26 - f42;
        f9 = f27 - f43;
        f10 = f26 + f42;
        f11 = f27 + f43;
        fArray[n + 24] = f4 + f8;
        fArray[n + 25] = f5 + f9;
        fArray[n + 26] = f4 - f8;
        fArray[n + 27] = f5 - f9;
        fArray[n + 28] = f6 - f11;
        fArray[n + 29] = f7 + f10;
        fArray[n + 30] = f6 + f11;
        fArray[n + 31] = f7 - f10;
        f4 = f16 + f32;
        f5 = f17 + f33;
        f6 = f16 - f32;
        f7 = f17 - f33;
        f8 = f24 + f40;
        f9 = f25 + f41;
        f10 = f24 - f40;
        f11 = f25 - f41;
        fArray[n + 16] = f4 + f8;
        fArray[n + 17] = f5 + f9;
        fArray[n + 18] = f4 - f8;
        fArray[n + 19] = f5 - f9;
        fArray[n + 20] = f6 - f11;
        fArray[n + 21] = f7 + f10;
        fArray[n + 22] = f6 + f11;
        fArray[n + 23] = f7 - f10;
        f4 = f22 - f39;
        f5 = f23 + f38;
        f8 = f * (f4 - f5);
        f9 = f * (f5 + f4);
        f4 = f22 + f39;
        f5 = f23 - f38;
        f10 = f * (f4 - f5);
        f11 = f * (f5 + f4);
        f4 = f14 - f31;
        f5 = f15 + f30;
        f6 = f14 + f31;
        f7 = f15 - f30;
        fArray[n + 8] = f4 + f8;
        fArray[n + 9] = f5 + f9;
        fArray[n + 10] = f4 - f8;
        fArray[n + 11] = f5 - f9;
        fArray[n + 12] = f6 - f11;
        fArray[n + 13] = f7 + f10;
        fArray[n + 14] = f6 + f11;
        fArray[n + 15] = f7 - f10;
        f4 = f12 + f28;
        f5 = f13 + f29;
        f6 = f12 - f28;
        f7 = f13 - f29;
        f8 = f20 + f36;
        f9 = f21 + f37;
        f10 = f20 - f36;
        f11 = f21 - f37;
        fArray[n] = f4 + f8;
        fArray[n + 1] = f5 + f9;
        fArray[n + 2] = f4 - f8;
        fArray[n + 3] = f5 - f9;
        fArray[n + 4] = f6 - f11;
        fArray[n + 5] = f7 + f10;
        fArray[n + 6] = f6 + f11;
        fArray[n + 7] = f7 - f10;
    }

    private void cftf162(float[] fArray, int n, float[] fArray2, int n2) {
        float f = fArray2[n2 + 1];
        float f2 = fArray2[n2 + 4];
        float f3 = fArray2[n2 + 5];
        float f4 = fArray2[n2 + 6];
        float f5 = -fArray2[n2 + 7];
        float f6 = fArray2[n2 + 8];
        float f7 = fArray2[n2 + 9];
        float f8 = fArray[n] - fArray[n + 17];
        float f9 = fArray[n + 1] + fArray[n + 16];
        float f10 = fArray[n + 8] - fArray[n + 25];
        float f11 = fArray[n + 9] + fArray[n + 24];
        float f12 = f * (f10 - f11);
        float f13 = f * (f11 + f10);
        float f14 = f8 + f12;
        float f15 = f9 + f13;
        float f16 = f8 - f12;
        float f17 = f9 - f13;
        f8 = fArray[n] + fArray[n + 17];
        f9 = fArray[n + 1] - fArray[n + 16];
        f10 = fArray[n + 8] + fArray[n + 25];
        f11 = fArray[n + 9] - fArray[n + 24];
        f12 = f * (f10 - f11);
        f13 = f * (f11 + f10);
        float f18 = f8 - f13;
        float f19 = f9 + f12;
        float f20 = f8 + f13;
        float f21 = f9 - f12;
        f10 = fArray[n + 2] - fArray[n + 19];
        f11 = fArray[n + 3] + fArray[n + 18];
        f8 = f2 * f10 - f3 * f11;
        f9 = f2 * f11 + f3 * f10;
        f10 = fArray[n + 10] - fArray[n + 27];
        f11 = fArray[n + 11] + fArray[n + 26];
        f12 = f5 * f10 - f4 * f11;
        f13 = f5 * f11 + f4 * f10;
        float f22 = f8 + f12;
        float f23 = f9 + f13;
        float f24 = f8 - f12;
        float f25 = f9 - f13;
        f10 = fArray[n + 2] + fArray[n + 19];
        f11 = fArray[n + 3] - fArray[n + 18];
        f8 = f4 * f10 - f5 * f11;
        f9 = f4 * f11 + f5 * f10;
        f10 = fArray[n + 10] + fArray[n + 27];
        f11 = fArray[n + 11] - fArray[n + 26];
        f12 = f2 * f10 + f3 * f11;
        f13 = f2 * f11 - f3 * f10;
        float f26 = f8 - f12;
        float f27 = f9 - f13;
        float f28 = f8 + f12;
        float f29 = f9 + f13;
        f10 = fArray[n + 4] - fArray[n + 21];
        f11 = fArray[n + 5] + fArray[n + 20];
        f8 = f6 * f10 - f7 * f11;
        f9 = f6 * f11 + f7 * f10;
        f10 = fArray[n + 12] - fArray[n + 29];
        f11 = fArray[n + 13] + fArray[n + 28];
        f12 = f7 * f10 - f6 * f11;
        f13 = f7 * f11 + f6 * f10;
        float f30 = f8 + f12;
        float f31 = f9 + f13;
        float f32 = f8 - f12;
        float f33 = f9 - f13;
        f10 = fArray[n + 4] + fArray[n + 21];
        f11 = fArray[n + 5] - fArray[n + 20];
        f8 = f7 * f10 - f6 * f11;
        f9 = f7 * f11 + f6 * f10;
        f10 = fArray[n + 12] + fArray[n + 29];
        f11 = fArray[n + 13] - fArray[n + 28];
        f12 = f6 * f10 - f7 * f11;
        f13 = f6 * f11 + f7 * f10;
        float f34 = f8 - f12;
        float f35 = f9 - f13;
        float f36 = f8 + f12;
        float f37 = f9 + f13;
        f10 = fArray[n + 6] - fArray[n + 23];
        f11 = fArray[n + 7] + fArray[n + 22];
        f8 = f4 * f10 - f5 * f11;
        f9 = f4 * f11 + f5 * f10;
        f10 = fArray[n + 14] - fArray[n + 31];
        f11 = fArray[n + 15] + fArray[n + 30];
        f12 = f3 * f10 - f2 * f11;
        f13 = f3 * f11 + f2 * f10;
        float f38 = f8 + f12;
        float f39 = f9 + f13;
        float f40 = f8 - f12;
        float f41 = f9 - f13;
        f10 = fArray[n + 6] + fArray[n + 23];
        f11 = fArray[n + 7] - fArray[n + 22];
        f8 = f3 * f10 + f2 * f11;
        f9 = f3 * f11 - f2 * f10;
        f10 = fArray[n + 14] + fArray[n + 31];
        f11 = fArray[n + 15] - fArray[n + 30];
        f12 = f5 * f10 - f4 * f11;
        f13 = f5 * f11 + f4 * f10;
        float f42 = f8 + f12;
        float f43 = f9 + f13;
        float f44 = f8 - f12;
        float f45 = f9 - f13;
        f8 = f14 + f30;
        f9 = f15 + f31;
        f12 = f22 + f38;
        f13 = f23 + f39;
        fArray[n] = f8 + f12;
        fArray[n + 1] = f9 + f13;
        fArray[n + 2] = f8 - f12;
        fArray[n + 3] = f9 - f13;
        f8 = f14 - f30;
        f9 = f15 - f31;
        f12 = f22 - f38;
        f13 = f23 - f39;
        fArray[n + 4] = f8 - f13;
        fArray[n + 5] = f9 + f12;
        fArray[n + 6] = f8 + f13;
        fArray[n + 7] = f9 - f12;
        f8 = f16 - f33;
        f9 = f17 + f32;
        f10 = f24 - f41;
        f11 = f25 + f40;
        f12 = f * (f10 - f11);
        f13 = f * (f11 + f10);
        fArray[n + 8] = f8 + f12;
        fArray[n + 9] = f9 + f13;
        fArray[n + 10] = f8 - f12;
        fArray[n + 11] = f9 - f13;
        f8 = f16 + f33;
        f9 = f17 - f32;
        f10 = f24 + f41;
        f11 = f25 - f40;
        f12 = f * (f10 - f11);
        f13 = f * (f11 + f10);
        fArray[n + 12] = f8 - f13;
        fArray[n + 13] = f9 + f12;
        fArray[n + 14] = f8 + f13;
        fArray[n + 15] = f9 - f12;
        f8 = f18 + f34;
        f9 = f19 + f35;
        f12 = f26 - f42;
        f13 = f27 - f43;
        fArray[n + 16] = f8 + f12;
        fArray[n + 17] = f9 + f13;
        fArray[n + 18] = f8 - f12;
        fArray[n + 19] = f9 - f13;
        f8 = f18 - f34;
        f9 = f19 - f35;
        f12 = f26 + f42;
        f13 = f27 + f43;
        fArray[n + 20] = f8 - f13;
        fArray[n + 21] = f9 + f12;
        fArray[n + 22] = f8 + f13;
        fArray[n + 23] = f9 - f12;
        f8 = f20 - f37;
        f9 = f21 + f36;
        f10 = f28 + f45;
        f11 = f29 - f44;
        f12 = f * (f10 - f11);
        f13 = f * (f11 + f10);
        fArray[n + 24] = f8 + f12;
        fArray[n + 25] = f9 + f13;
        fArray[n + 26] = f8 - f12;
        fArray[n + 27] = f9 - f13;
        f8 = f20 + f37;
        f9 = f21 - f36;
        f10 = f28 - f45;
        f11 = f29 + f44;
        f12 = f * (f10 - f11);
        f13 = f * (f11 + f10);
        fArray[n + 28] = f8 - f13;
        fArray[n + 29] = f9 + f12;
        fArray[n + 30] = f8 + f13;
        fArray[n + 31] = f9 - f12;
    }

    private void cftf081(float[] fArray, int n, float[] fArray2, int n2) {
        float f = fArray2[n2 + 1];
        float f2 = fArray[n] + fArray[n + 8];
        float f3 = fArray[n + 1] + fArray[n + 9];
        float f4 = fArray[n] - fArray[n + 8];
        float f5 = fArray[n + 1] - fArray[n + 9];
        float f6 = fArray[n + 4] + fArray[n + 12];
        float f7 = fArray[n + 5] + fArray[n + 13];
        float f8 = fArray[n + 4] - fArray[n + 12];
        float f9 = fArray[n + 5] - fArray[n + 13];
        float f10 = f2 + f6;
        float f11 = f3 + f7;
        float f12 = f2 - f6;
        float f13 = f3 - f7;
        float f14 = f4 - f9;
        float f15 = f5 + f8;
        float f16 = f4 + f9;
        float f17 = f5 - f8;
        f2 = fArray[n + 2] + fArray[n + 10];
        f3 = fArray[n + 3] + fArray[n + 11];
        f4 = fArray[n + 2] - fArray[n + 10];
        f5 = fArray[n + 3] - fArray[n + 11];
        f6 = fArray[n + 6] + fArray[n + 14];
        f7 = fArray[n + 7] + fArray[n + 15];
        f8 = fArray[n + 6] - fArray[n + 14];
        f9 = fArray[n + 7] - fArray[n + 15];
        float f18 = f2 + f6;
        float f19 = f3 + f7;
        float f20 = f2 - f6;
        float f21 = f3 - f7;
        f2 = f4 - f9;
        f3 = f5 + f8;
        f6 = f4 + f9;
        f7 = f5 - f8;
        float f22 = f * (f2 - f3);
        float f23 = f * (f2 + f3);
        float f24 = f * (f6 - f7);
        float f25 = f * (f6 + f7);
        fArray[n + 8] = f14 + f22;
        fArray[n + 9] = f15 + f23;
        fArray[n + 10] = f14 - f22;
        fArray[n + 11] = f15 - f23;
        fArray[n + 12] = f16 - f25;
        fArray[n + 13] = f17 + f24;
        fArray[n + 14] = f16 + f25;
        fArray[n + 15] = f17 - f24;
        fArray[n] = f10 + f18;
        fArray[n + 1] = f11 + f19;
        fArray[n + 2] = f10 - f18;
        fArray[n + 3] = f11 - f19;
        fArray[n + 4] = f12 - f21;
        fArray[n + 5] = f13 + f20;
        fArray[n + 6] = f12 + f21;
        fArray[n + 7] = f13 - f20;
    }

    private void cftf082(float[] fArray, int n, float[] fArray2, int n2) {
        float f = fArray2[n2 + 1];
        float f2 = fArray2[n2 + 2];
        float f3 = fArray2[n2 + 3];
        float f4 = fArray[n] - fArray[n + 9];
        float f5 = fArray[n + 1] + fArray[n + 8];
        float f6 = fArray[n] + fArray[n + 9];
        float f7 = fArray[n + 1] - fArray[n + 8];
        float f8 = fArray[n + 4] - fArray[n + 13];
        float f9 = fArray[n + 5] + fArray[n + 12];
        float f10 = f * (f8 - f9);
        float f11 = f * (f9 + f8);
        f8 = fArray[n + 4] + fArray[n + 13];
        f9 = fArray[n + 5] - fArray[n + 12];
        float f12 = f * (f8 - f9);
        float f13 = f * (f9 + f8);
        f8 = fArray[n + 2] - fArray[n + 11];
        f9 = fArray[n + 3] + fArray[n + 10];
        float f14 = f2 * f8 - f3 * f9;
        float f15 = f2 * f9 + f3 * f8;
        f8 = fArray[n + 2] + fArray[n + 11];
        f9 = fArray[n + 3] - fArray[n + 10];
        float f16 = f3 * f8 - f2 * f9;
        float f17 = f3 * f9 + f2 * f8;
        f8 = fArray[n + 6] - fArray[n + 15];
        f9 = fArray[n + 7] + fArray[n + 14];
        float f18 = f3 * f8 - f2 * f9;
        float f19 = f3 * f9 + f2 * f8;
        f8 = fArray[n + 6] + fArray[n + 15];
        f9 = fArray[n + 7] - fArray[n + 14];
        float f20 = f2 * f8 - f3 * f9;
        float f21 = f2 * f9 + f3 * f8;
        f8 = f4 + f10;
        f9 = f5 + f11;
        float f22 = f14 + f18;
        float f23 = f15 + f19;
        fArray[n] = f8 + f22;
        fArray[n + 1] = f9 + f23;
        fArray[n + 2] = f8 - f22;
        fArray[n + 3] = f9 - f23;
        f8 = f4 - f10;
        f9 = f5 - f11;
        f22 = f14 - f18;
        f23 = f15 - f19;
        fArray[n + 4] = f8 - f23;
        fArray[n + 5] = f9 + f22;
        fArray[n + 6] = f8 + f23;
        fArray[n + 7] = f9 - f22;
        f8 = f6 - f13;
        f9 = f7 + f12;
        f22 = f16 - f20;
        f23 = f17 - f21;
        fArray[n + 8] = f8 + f22;
        fArray[n + 9] = f9 + f23;
        fArray[n + 10] = f8 - f22;
        fArray[n + 11] = f9 - f23;
        f8 = f6 + f13;
        f9 = f7 - f12;
        f22 = f16 + f20;
        f23 = f17 + f21;
        fArray[n + 12] = f8 - f23;
        fArray[n + 13] = f9 + f22;
        fArray[n + 14] = f8 + f23;
        fArray[n + 15] = f9 - f22;
    }

    private void cftf040(float[] fArray, int n) {
        float f = fArray[n] + fArray[n + 4];
        float f2 = fArray[n + 1] + fArray[n + 5];
        float f3 = fArray[n] - fArray[n + 4];
        float f4 = fArray[n + 1] - fArray[n + 5];
        float f5 = fArray[n + 2] + fArray[n + 6];
        float f6 = fArray[n + 3] + fArray[n + 7];
        float f7 = fArray[n + 2] - fArray[n + 6];
        float f8 = fArray[n + 3] - fArray[n + 7];
        fArray[n] = f + f5;
        fArray[n + 1] = f2 + f6;
        fArray[n + 2] = f3 - f8;
        fArray[n + 3] = f4 + f7;
        fArray[n + 4] = f - f5;
        fArray[n + 5] = f2 - f6;
        fArray[n + 6] = f3 + f8;
        fArray[n + 7] = f4 - f7;
    }

    private void cftb040(float[] fArray, int n) {
        float f = fArray[n] + fArray[n + 4];
        float f2 = fArray[n + 1] + fArray[n + 5];
        float f3 = fArray[n] - fArray[n + 4];
        float f4 = fArray[n + 1] - fArray[n + 5];
        float f5 = fArray[n + 2] + fArray[n + 6];
        float f6 = fArray[n + 3] + fArray[n + 7];
        float f7 = fArray[n + 2] - fArray[n + 6];
        float f8 = fArray[n + 3] - fArray[n + 7];
        fArray[n] = f + f5;
        fArray[n + 1] = f2 + f6;
        fArray[n + 2] = f3 + f8;
        fArray[n + 3] = f4 - f7;
        fArray[n + 4] = f - f5;
        fArray[n + 5] = f2 - f6;
        fArray[n + 6] = f3 - f8;
        fArray[n + 7] = f4 + f7;
    }

    private void cftx020(float[] fArray, int n) {
        float f = fArray[n] - fArray[n + 2];
        float f2 = -fArray[n + 1] + fArray[n + 3];
        int n2 = n;
        fArray[n2] = fArray[n2] + fArray[n + 2];
        int n3 = n + 1;
        fArray[n3] = fArray[n3] + fArray[n + 3];
        fArray[n + 2] = f;
        fArray[n + 3] = f2;
    }

    private void cftxb020(float[] fArray, int n) {
        float f = fArray[n] - fArray[n + 2];
        float f2 = fArray[n + 1] - fArray[n + 3];
        int n2 = n;
        fArray[n2] = fArray[n2] + fArray[n + 2];
        int n3 = n + 1;
        fArray[n3] = fArray[n3] + fArray[n + 3];
        fArray[n + 2] = f;
        fArray[n + 3] = f2;
    }

    private void cftxc020(float[] fArray, int n) {
        float f = fArray[n] - fArray[n + 2];
        float f2 = fArray[n + 1] + fArray[n + 3];
        int n2 = n;
        fArray[n2] = fArray[n2] + fArray[n + 2];
        int n3 = n + 1;
        fArray[n3] = fArray[n3] - fArray[n + 3];
        fArray[n + 2] = f;
        fArray[n + 3] = f2;
    }

    private void rftfsub(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4) {
        int n5 = n >> 1;
        int n6 = 2 * n3 / n5;
        int n7 = 0;
        for (int i = 2; i < n5; i += 2) {
            int n8 = n - i;
            float f = (float)(0.5 - (double)fArray2[n4 + n3 - (n7 += n6)]);
            float f2 = fArray2[n4 + n7];
            int n9 = n2 + i;
            int n10 = n2 + n8;
            float f3 = fArray[n9] - fArray[n10];
            float f4 = fArray[n9 + 1] + fArray[n10 + 1];
            float f5 = f * f3 - f2 * f4;
            float f6 = f * f4 + f2 * f3;
            int n11 = n9;
            fArray[n11] = fArray[n11] - f5;
            fArray[n9 + 1] = f6 - fArray[n9 + 1];
            int n12 = n10;
            fArray[n12] = fArray[n12] + f5;
            fArray[n10 + 1] = f6 - fArray[n10 + 1];
        }
        fArray[n2 + n5 + 1] = -fArray[n2 + n5 + 1];
    }

    private void rftbsub(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4) {
        int n5 = n >> 1;
        int n6 = 2 * n3 / n5;
        int n7 = 0;
        for (int i = 2; i < n5; i += 2) {
            int n8 = n - i;
            float f = (float)(0.5 - (double)fArray2[n4 + n3 - (n7 += n6)]);
            float f2 = fArray2[n4 + n7];
            int n9 = n2 + i;
            int n10 = n2 + n8;
            float f3 = fArray[n9] - fArray[n10];
            float f4 = fArray[n9 + 1] + fArray[n10 + 1];
            float f5 = f * f3 - f2 * f4;
            float f6 = f * f4 + f2 * f3;
            int n11 = n9;
            fArray[n11] = fArray[n11] - f5;
            int n12 = n9 + 1;
            fArray[n12] = fArray[n12] - f6;
            int n13 = n10;
            fArray[n13] = fArray[n13] + f5;
            int n14 = n10 + 1;
            fArray[n14] = fArray[n14] - f6;
        }
    }

    private void scale(float f, final float[] fArray, int n, boolean bl) {
        final float f2 = (float)(1.0 / (double)f);
        int n2 = bl ? 2 * this.n : this.n;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && n2 >= ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int n4 = n2 / n3;
            Future[] futureArray = new Future[n3];
            for (int i = 0; i < n3; ++i) {
                final int n5 = n + i * n4;
                final int n6 = i == n3 - 1 ? n + n2 : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int n = n5;
                        while (n < n6) {
                            int n2 = n++;
                            fArray[n2] = fArray[n2] * f2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = n;
            while (n7 < n + n2) {
                int n8 = n7++;
                fArray[n8] = fArray[n8] * f2;
            }
        }
    }

    private strictfp static enum Plans {
        SPLIT_RADIX,
        MIXED_RADIX,
        BLUESTEIN;

    }
}

