/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.widget;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.Polygon;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import kcl.waterloo.widget.GJDial;
import org.jdesktop.swingx.painter.effects.ShadowPathEffect;

public class GJGauge
extends GJDial
implements ComponentListener {
    protected boolean useBuffer = true;
    protected boolean glassShown = true;
    protected boolean shadowShown = true;
    protected Color primaryColor = new Color(47, 79, 79);
    protected Color needleColor = new Color(255, 140, 0);
    protected double outerRimWidth = 10.0;
    protected double dialInset = 20.0;
    protected double dialWidth = 50.0;
    protected GradientPaint outerGradientPaint;
    protected GradientPaint innerGradientPaint;
    protected GradientPaint dialGradientPaint;
    protected ShadowPathEffect shadow = new ShadowPathEffect();
    protected Arc2D arc2;
    protected Arc2D arc4;
    protected BufferedImage buffer = null;

    public GJGauge() {
        this.setMinimum(0);
        this.setMaximum(100);
        this.setMajorTickSpacing(10);
        this.setMinorTickSpacing(1);
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.addComponentListener(this);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        if (this.buffer == null) {
            if (this.useBuffer) {
                this.buffer = g2.getDeviceConfiguration().createCompatibleImage(this.getWidth(), this.getHeight());
                g2 = this.buffer.createGraphics();
                g2.setClip(g.getClip());
            }
            if (this.isOpaque()) {
                g2.setPaint(this.getBackground());
                g2.fill(this.getBounds());
            }
            this.dialInset = (double)this.getWidth() / 50.0;
            this.dialWidth = (double)this.getWidth() / 10.0;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Rectangle r = this.getBounds();
            this.outerGradientPaint = new GradientPaint(this.getWidth() / 2, 0.0f, this.primaryColor.darker(), this.getWidth() / 2, this.getHeight(), Color.WHITE, true);
            Arc2D.Double arc0 = new Arc2D.Double(r.getX() + 1.0, r.getY() + 1.0, r.getWidth() - 2.0, r.getHeight() - 2.0, 0.0, 360.0, 1);
            Arc2D.Double arc1 = new Arc2D.Double(r.getX() + this.outerRimWidth / 2.0, r.getY() + this.outerRimWidth / 2.0, r.getWidth() - this.outerRimWidth, r.getHeight() - this.outerRimWidth, 0.0, 360.0, 1);
            Area area = new Area(arc0);
            area.subtract(new Area(arc1));
            g2.setPaint(this.outerGradientPaint);
            g2.fill(area);
            this.innerGradientPaint = new GradientPaint((int)arc1.getCenterX(), (int)((RectangularShape)arc1).getY(), this.primaryColor, (int)arc1.getCenterX(), (int)((RectangularShape)arc1).getHeight(), Color.WHITE, true);
            g2.setPaint(this.innerGradientPaint);
            g2.fill(arc1);
            this.arc2 = new Arc2D.Double(((RectangularShape)arc1).getX() + this.dialInset, ((RectangularShape)arc1).getY() + this.dialInset, ((RectangularShape)arc1).getWidth() - 2.0 * this.dialInset, ((RectangularShape)arc1).getHeight() - 2.0 * this.dialInset, 0.0, 360.0, 1);
            Arc2D.Double arc3 = new Arc2D.Double(this.arc2.getX() + this.dialWidth + this.dialInset, this.arc2.getY() + this.dialWidth + this.dialInset, this.arc2.getWidth() - 2.0 * this.dialWidth - 2.0 * this.dialInset, this.arc2.getHeight() - 2.0 * this.dialWidth - 2.0 * this.dialInset, 0.0, 360.0, 1);
            this.dialGradientPaint = new GradientPaint((int)this.arc2.getX(), (int)this.arc2.getY(), this.primaryColor.brighter(), (int)this.arc2.getWidth(), (int)this.arc2.getHeight(), Color.WHITE, true);
            Area area1 = new Area(this.arc2);
            area1.subtract(new Area(arc3));
            g2.setPaint(this.dialGradientPaint);
            g2.fill(area1);
            g2.setPaint(Color.BLACK);
            g2.draw(arc0);
            g2.draw(arc1);
            g2.draw(this.arc2);
            g2.setPaint(this.getForeground());
            double maxR = Math.max(((RectangularShape)arc0).getWidth(), ((RectangularShape)arc0).getHeight()) / 2.0;
            this.arc4 = new Arc2D.Double(this.arc2.getX() + (this.dialWidth + this.dialInset) / 2.0, this.arc2.getY() + (this.dialWidth + this.dialInset) / 2.0, this.arc2.getWidth() - this.dialWidth - this.dialInset, this.arc2.getHeight() - this.dialWidth - this.dialInset, 0.0, 360.0, 1);
            Area area2 = new Area(this.arc2);
            area2.subtract(new Area(this.arc4));
            g2.setStroke(new BasicStroke(1.5f));
            Area clip = new Area(g.getClip());
            area2.intersect(clip);
            g2.setClip(area2);
            for (double theta = -1.5707963267948966; theta < 4.71238898038469; theta += Math.PI * 2 / (double)((this.getMaximum() - this.getMinimum()) / this.getMajorTickSpacing())) {
                double x0 = this.arc2.getCenterX();
                double y0 = this.arc2.getCenterY();
                double x1 = this.arc2.getCenterX() + Math.cos(theta) * maxR;
                double y1 = this.arc2.getCenterY() + Math.sin(theta) * maxR;
                g2.drawLine((int)x0, (int)y0, (int)x1, (int)y1);
            }
            Arc2D.Double arc5 = new Arc2D.Double(this.arc2.getX() + (this.dialWidth + this.dialInset) / 4.0, this.arc2.getY() + (this.dialWidth + this.dialInset) / 4.0, this.arc2.getWidth() - (this.dialWidth + this.dialInset) / 2.0, this.arc2.getHeight() - (this.dialWidth + this.dialInset) / 2.0, 0.0, 360.0, 1);
            Area area3 = new Area(this.arc2);
            area3.subtract(new Area(arc5));
            g2.setStroke(new BasicStroke(1.2f));
            g2.draw(arc5);
            area3.intersect(clip);
            g2.setClip(area3);
            for (double theta = -1.5707963267948966; theta < 4.71238898038469; theta += Math.PI * 2 / (double)((this.getMaximum() - this.getMinimum()) / this.getMinorTickSpacing())) {
                double x0 = this.arc2.getCenterX();
                double y0 = this.arc2.getCenterY();
                double x1 = this.arc2.getCenterX() + Math.cos(theta) * maxR;
                double y1 = this.arc2.getCenterY() + Math.sin(theta) * maxR;
                g2.drawLine((int)x0, (int)y0, (int)x1, (int)y1);
            }
            g2.setClip(clip);
            double label = 0.0;
            FontMetrics metrics = g2.getFontMetrics();
            for (double theta = -1.5707963267948966; theta < 4.71238898038469; theta += Math.PI * 2 / (double)((this.getMaximum() - this.getMinimum()) / this.getMajorTickSpacing())) {
                double x1 = this.arc2.getCenterX();
                double y1 = this.arc2.getCenterY();
                double x2 = this.arc2.getCenterX() + Math.cos(theta) * this.arc4.getHeight();
                double y2 = this.arc2.getCenterY() + Math.sin(theta) * this.arc4.getWidth();
                double horzAngle = (Math.atan2(y2 - y1, x2 - x1) + Math.PI * 2) % (Math.PI * 2);
                double xc = this.arc4.getCenterX();
                double yc = this.arc4.getCenterY();
                double r1 = this.arc4.getWidth() / 2.0 - this.arc4.getWidth() / 30.0;
                double r2 = this.arc4.getHeight() / 2.0 - this.arc4.getHeight() / 30.0;
                double cot = Math.cos(0.0);
                double sit = Math.sin(0.0);
                double x = xc + r1 * Math.cos(horzAngle) * cot - r2 * Math.sin(horzAngle) * sit;
                double y = yc + r1 * Math.cos(horzAngle) * sit + r2 * Math.sin(horzAngle) * cot;
                String s = String.format("%2.0f", label);
                g2.drawString(s, (float)(x - (double)((float)metrics.stringWidth(s) / 2.0f)), (float)y);
                label += (double)this.getMajorTickSpacing();
            }
            g2.dispose();
            g2 = (Graphics2D)g.create();
        }
        if (this.useBuffer && this.buffer != null) {
            g2.drawImage(this.buffer, null, 0, 0);
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Arc2D.Double arc6 = new Arc2D.Double(this.arc2.getCenterX() - this.arc2.getWidth() / 40.0, this.arc2.getCenterY() - this.arc2.getWidth() / 40.0, this.arc2.getWidth() / 20.0, this.arc2.getWidth() / 20.0, 0.0, 360.0, 1);
        Area area4 = new Area(arc6);
        Rectangle2D.Double r1 = new Rectangle2D.Double(arc6.getCenterX() - ((RectangularShape)arc6).getWidth() / 4.0, arc6.getCenterY() - this.arc4.getHeight() / 2.0 + (double)this.getHeight() / 20.0, ((RectangularShape)arc6).getWidth() / 2.0, this.arc4.getHeight() / 2.0 - (double)this.getHeight() / 20.0);
        area4.add(new Area(r1));
        int[] tx = new int[]{(int)((RectangularShape)r1).getX(), (int)r1.getCenterX(), (int)(((RectangularShape)r1).getX() + ((RectangularShape)r1).getWidth())};
        int[] ty = new int[]{(int)((RectangularShape)r1).getY() + 1, (int)((RectangularShape)r1).getY() - 10, (int)((RectangularShape)r1).getY() + 1};
        area4.add(new Area(new Polygon(tx, ty, 3)));
        AffineTransform af = AffineTransform.getRotateInstance(-this.getTheta(), this.arc2.getCenterX(), this.arc2.getCenterY());
        area4 = area4.createTransformedArea(af);
        GradientPaint needlePaint = new GradientPaint((int)area4.getBounds().getCenterX(), area4.getBounds().y, this.needleColor, (int)area4.getBounds().getCenterX() + area4.getBounds().width / 2, area4.getBounds().y + area4.getBounds().height, this.needleColor.brighter(), true);
        g2.setPaint(needlePaint);
        g2.fill(area4);
        if (this.shadowShown) {
            this.shadow.apply(g2, (Shape)area4, 20, 20);
        }
        if (this.glassShown) {
            Arc2D.Double arc7 = new Arc2D.Double((double)this.getWidth() / 2.0 - (double)this.getWidth() / 4.0, (double)this.getHeight() / 4.0, (double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0, 5.0, 170.0, 1);
            float radius = (float)this.getWidth() / 4.0f;
            Point2D.Float center = new Point2D.Float((float)arc7.getCenterX(), (float)this.getHeight() / 2.0f);
            float[] dist = new float[]{0.0f, 1.0f};
            Color[] colors = new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.0f), new Color(1.0f, 1.0f, 1.0f, 0.4f)};
            RadialGradientPaint glass = new RadialGradientPaint(center, radius, center, dist, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
            g2.setPaint(glass);
            g2.setClip(new Rectangle2D.Double(0.0, 0.0, this.getWidth(), (double)this.getHeight() / 2.0));
            g2.fill(arc7);
        }
        g2.dispose();
    }

    public double getOuterRimWidth() {
        return this.outerRimWidth;
    }

    public void setOuterRimWidth(double outerRimWidth) {
        this.outerRimWidth = outerRimWidth;
    }

    public double getDialInset() {
        return this.dialInset;
    }

    public void setDialInset(double dialInset) {
        this.dialInset = dialInset;
    }

    public Color getPrimaryColor() {
        return this.primaryColor;
    }

    public void setPrimaryColor(Color primaryColor) {
        this.primaryColor = primaryColor;
    }

    public Color getNeedleColor() {
        return this.needleColor;
    }

    public void setNeedleColor(Color needleColor) {
        this.needleColor = needleColor;
    }

    public boolean isGlassShown() {
        return this.glassShown;
    }

    public boolean isShadowShown() {
        return this.shadowShown;
    }

    public void setShadowShown(boolean shadowShown) {
        this.shadowShown = shadowShown;
    }

    public void setGlassShown(boolean glassShown) {
        this.glassShown = glassShown;
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.buffer = null;
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public boolean isUseBuffer() {
        return this.useBuffer;
    }

    public void setUseBuffer(boolean useBuffer) {
        this.useBuffer = useBuffer;
    }
}

