/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.widget;

import java.awt.Color;
import java.awt.Component;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class GJColorComboBox
extends JComboBox<JLabel> {
    Map<String, Color> map;

    public GJColorComboBox() {
        this.setRenderer(new Renderer());
    }

    public GJColorComboBox(Map<String, Color> colormap) {
        this(colormap, null);
    }

    public GJColorComboBox(Map<String, Color> colormap, Color color) {
        this.setRenderer(new Renderer());
        this.setMap(colormap, color);
    }

    public final void setMap(Map<String, Color> colormap) {
        this.setMap(colormap, null);
    }

    public final void setMap(Map<String, Color> colormap, Color color) {
        this.map = colormap;
        for (String s : colormap.keySet()) {
            JLabel text = new JLabel(s);
            this.addItem(text);
        }
        if (color != null) {
            this.setSelectedColor(color);
        }
    }

    public void setSelectedColor(Color color) {
        if (this.map.containsValue(color)) {
            Color[] colors = new Color[this.map.size()];
            colors = this.map.values().toArray(colors);
            for (int k = 0; k < colors.length; ++k) {
                if (!colors[k].equals(color)) continue;
                this.setSelectedIndex(k);
                return;
            }
        } else {
            String s = "[R=" + color.getRed() + ",G=" + color.getGreen() + ",B=" + color.getBlue() + ",\u03b1=" + color.getAlpha() + "]";
            this.map.put(s, color);
            JLabel text = new JLabel(s);
            this.addItem(text);
            this.setSelectedItem(text);
        }
    }

    public String getSelectedColorDescription() {
        return ((JLabel)this.getSelectedItem()).getText();
    }

    public Color getSelectedColor() {
        return this.map.get(((JLabel)this.getSelectedItem()).getText());
    }

    private class Renderer
    extends JLabel
    implements ListCellRenderer<JLabel> {
        public Renderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends JLabel> list, JLabel value, int index, boolean isSelected, boolean cellHasFocus) {
            Color color = null;
            if (GJColorComboBox.this.map != null) {
                color = GJColorComboBox.this.map.get(value.getText());
            }
            if (color == null) {
                color = Color.WHITE;
            }
            if (value != null) {
                this.setText(value.getText());
                float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
                hsb[2] = (double)hsb[2] > 0.5 ? hsb[2] - 0.5f : hsb[2] + 0.5f;
                this.setForeground(isSelected ? color : Color.getHSBColor(hsb[0], hsb[1], hsb[2]));
                this.setBackground(isSelected ? Color.getHSBColor(hsb[0], hsb[1], hsb[2]) : color);
            }
            return this;
        }
    }
}

