/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.swing.layout;

import java.awt.Component;
import java.awt.Container;
import javax.swing.SpringLayout;
import kcl.waterloo.swing.GCGrid;
import kcl.waterloo.swing.GCGridElement;

public class SpringGridLayout
extends SpringLayout {
    @Override
    public final void layoutContainer(Container parent) {
        double[] dim = ((GCGrid)parent).getDimensions();
        double rowCount = dim[0];
        double columnCount = dim[1];
        double columnWidth = (double)parent.getWidth() / columnCount;
        double rowHeight = (double)parent.getHeight() / rowCount;
        int n = parent.getComponentCount();
        for (int k = 0; k < n; ++k) {
            if (!(parent.getComponent(k) instanceof GCGridElement)) continue;
            GCGridElement thisComp = (GCGridElement)parent.getComponent(k);
            double thisRow = thisComp.getProperties().getRow();
            double thisColumn = thisComp.getProperties().getColumn();
            double spanX = thisComp.getProperties().getColumnWidth();
            double spanY = thisComp.getProperties().getRowHeight();
            this.putConstraint("West", (Component)thisComp, (int)(thisColumn * columnWidth), "West", (Component)parent);
            this.putConstraint("East", (Component)thisComp, (int)(thisColumn * columnWidth + columnWidth * spanX), "West", (Component)parent);
            this.putConstraint("North", (Component)thisComp, (int)(thisRow * rowHeight), "North", (Component)parent);
            this.putConstraint("South", (Component)thisComp, (int)(thisRow * rowHeight + rowHeight * spanY), "North", (Component)parent);
        }
        super.layoutContainer(parent);
    }
}

