/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.swing;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import kcl.waterloo.swing.GCFrameInterface;
import kcl.waterloo.swing.MenuFactory;

public class FrameManager
implements WindowListener,
ActionListener {
    static final FrameManager instance = new FrameManager();
    private static final LinkedHashMap<Double, GCFrameInterface> frameMap = new LinkedHashMap();

    public static FrameManager getInstance() {
        return instance;
    }

    public static LinkedHashMap<Double, GCFrameInterface> getList() {
        return frameMap;
    }

    public static Window[] getWindows() {
        GCFrameInterface[] w = new GCFrameInterface[frameMap.size()];
        w = frameMap.values().toArray(w);
        return (Window[])w;
    }

    public static int getLowestAvailable() {
        for (int k = 0; k < frameMap.size(); ++k) {
            if (frameMap.containsKey(new Double(k))) continue;
            return k;
        }
        return frameMap.size();
    }

    public static void updateWindowMenu() {
        JMenuItem menuItem;
        JMenu menu;
        Object[] arr = new Double[]{};
        arr = frameMap.keySet().toArray(arr);
        Arrays.sort(arr);
        for (Object arr1 : arr) {
            menu = new JMenu("Window");
            for (Object arr2 : arr) {
                menuItem = menu.add(new JMenuItem(frameMap.get(arr2).getTitle()));
                menuItem.addActionListener(frameMap.get(arr2));
            }
            List<Component> mArray = Arrays.asList(frameMap.get(arr1).getJMenuBar().getComponents());
            for (Component c : mArray) {
                JMenu m = (JMenu)c;
                if (!m.getText().matches("Window")) continue;
                frameMap.get(arr1).getJMenuBar().remove(m);
                menu.addSeparator();
                menuItem = menu.add(new JMenuItem("Close All"));
                menuItem.addActionListener(instance);
                frameMap.get(arr1).getJMenuBar().add(menu);
            }
        }
        if (MenuFactory.getApplicationMenuBar() != null) {
            menu = new JMenu("Frame");
            for (Object arr1 : arr) {
                menuItem = menu.add(new JMenuItem(frameMap.get(arr1).getTitle()));
                menuItem.addActionListener(frameMap.get(arr1));
            }
            menu.addSeparator();
            menuItem = menu.add(new JMenuItem("Close All"));
            menuItem.addActionListener(instance);
            MenuFactory.getApplicationMenuBar().add(menu);
        }
    }

    @Override
    public void windowOpened(WindowEvent we) {
        FrameManager.updateWindowMenu();
    }

    @Override
    public void windowClosing(WindowEvent we) {
    }

    @Override
    public void windowClosed(WindowEvent we) {
        if (frameMap.containsValue(we.getWindow())) {
            for (Double index : frameMap.keySet()) {
                if (!frameMap.get(index).equals(we.getWindow())) continue;
                frameMap.remove(index);
                FrameManager.updateWindowMenu();
                return;
            }
        }
    }

    @Override
    public void windowIconified(WindowEvent we) {
    }

    @Override
    public void windowDeiconified(WindowEvent we) {
    }

    @Override
    public void windowActivated(WindowEvent we) {
    }

    @Override
    public void windowDeactivated(WindowEvent we) {
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        for (GCFrameInterface f : frameMap.values()) {
            f.dispose();
        }
        frameMap.clear();
    }
}

