/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.marker;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import kcl.waterloo.marker.GJPathSegmentInfo;
import kcl.waterloo.marker.ShapeUtils;
import kcl.waterloo.marker.String2D;
import kcl.waterloo.marker.Triangle2D;
import kcl.waterloo.plotmodel2D.GJCyclicArrayList;

public class GJMarker {
    private final Shape path;

    public static void reset() {
        maps.circleMarkers.clear();
        maps.squareMarkers.clear();
        maps.triangleMarkers.clear();
        maps.itriangleMarkers.clear();
        maps.ltriangleMarkers.clear();
        maps.rtriangleMarkers.clear();
        maps.diamondMarkers.clear();
        maps.circles.clear();
        maps.squares.clear();
        maps.triangles.clear();
        maps.itriangles.clear();
        maps.ltriangles.clear();
        maps.rtriangles.clear();
        maps.diamonds.clear();
        maps.strings.clear();
    }

    public GJMarker() {
        this.path = new Path2D.Double();
    }

    public GJMarker(Path2D p) {
        this.path = p;
    }

    public GJMarker(Path2D.Double p) {
        this.path = p;
    }

    public GJMarker(Shape s) {
        this();
        ArrayList<GJPathSegmentInfo> segments = new ArrayList<GJPathSegmentInfo>();
        double[] d = new double[6];
        PathIterator it = s.getPathIterator(null);
        while (!it.isDone()) {
            int type = it.currentSegment(d);
            segments.add(new GJPathSegmentInfo(type, d));
            it.next();
        }
        this.setSegments(segments);
    }

    public GJMarker(ArrayList<GJPathSegmentInfo> arr) {
        this();
        this.setSegments(arr);
    }

    public static GJMarker circle(double width) {
        if (!maps.circles.containsKey(width)) {
            maps.circles.put(width, GJMarker.makeCircle(width));
            maps.circleMarkers.put(width, new GJMarker((Shape)maps.circles.get(width)));
        }
        return (GJMarker)maps.circleMarkers.get(width);
    }

    public static GJMarker square(double width) {
        if (!maps.squares.containsKey(width)) {
            maps.squares.put(width, GJMarker.makeSquare(width));
            maps.squareMarkers.put(width, new GJMarker((Shape)maps.squares.get(width)));
        }
        return (GJMarker)maps.squareMarkers.get(width);
    }

    public static GJMarker triangle(double width) {
        if (!maps.triangles.containsKey(width)) {
            maps.triangles.put(width, GJMarker.makeTriangle(width));
            maps.triangleMarkers.put(width, new GJMarker((Shape)maps.triangles.get(width)));
        }
        return (GJMarker)maps.triangleMarkers.get(width);
    }

    public static GJMarker invertedTriangle(double width) {
        if (!maps.itriangles.containsKey(width)) {
            maps.itriangles.put(width, GJMarker.makeInvertedTriangle(width));
            maps.itriangleMarkers.put(width, new GJMarker((Shape)maps.itriangles.get(width)));
        }
        return (GJMarker)maps.itriangleMarkers.get(width);
    }

    public static GJMarker leftTriangle(double width) {
        if (!maps.ltriangles.containsKey(width)) {
            maps.ltriangles.put(width, GJMarker.makeLeftTriangle(width));
            maps.ltriangleMarkers.put(width, new GJMarker((Shape)maps.ltriangles.get(width)));
        }
        return (GJMarker)maps.ltriangleMarkers.get(width);
    }

    public static GJMarker rightTriangle(double width) {
        if (!maps.rtriangles.containsKey(width)) {
            maps.rtriangles.put(width, GJMarker.makeRightTriangle(width));
            maps.rtriangleMarkers.put(width, new GJMarker((Shape)maps.rtriangles.get(width)));
        }
        return (GJMarker)maps.rtriangleMarkers.get(width);
    }

    public static GJMarker diamond(double width) {
        if (!maps.diamonds.containsKey(width)) {
            maps.diamonds.put(width, GJMarker.makeDiamond(width));
            maps.diamondMarkers.put(width, new GJMarker((Shape)maps.diamonds.get(width)));
        }
        return (GJMarker)maps.diamondMarkers.get(width);
    }

    public static GJMarker dot(double width) {
        return maps.dot;
    }

    public static GJMarker fromString(String s) {
        if (!maps.strings.containsKey(s)) {
            String2D p = GJMarker.makeCharMarker(s, 18);
            Point2D.Double tr = ShapeUtils.getCentroid(p);
            p.transform(AffineTransform.getTranslateInstance(-((Point2D)tr).getX(), -((Point2D)tr).getY()));
            maps.strings.put(s, p);
        }
        return new GJMarker((Shape)maps.strings.get(s));
    }

    public static GJMarker fromString(String s, int pointSize) {
        return GJMarker.fromString(s, pointSize, "Sans Serif");
    }

    public static GJMarker fromString(String s, int pointSize, String font) {
        String2D p = GJMarker.makeMarkerFromFont(s, pointSize, font);
        Point2D.Double tr = ShapeUtils.getCentroid(p);
        ((Path2D)p).transform(AffineTransform.getTranslateInstance(-((Point2D)tr).getX(), -((Point2D)tr).getY()));
        return new GJMarker((Path2D)p);
    }

    public final Rectangle getBounds() {
        return this.path.getBounds();
    }

    public final Rectangle2D getBounds2D() {
        return this.path.getBounds2D();
    }

    public final double getWidth() {
        return this.path.getBounds2D().getWidth();
    }

    public final double getHeight() {
        return this.path.getBounds2D().getHeight();
    }

    public final Path2D getPath() {
        return new Path2D.Double(this.path);
    }

    public final void setPath(Shape p) {
        this.setSegments(ShapeUtils.getSegments(p));
    }

    public final Shape getShape() {
        return this.path;
    }

    public final void setShape(Shape s) {
        this.setSegments(ShapeUtils.getSegments(s));
    }

    public final PathIterator getPathIterator() {
        return this.path.getPathIterator(null);
    }

    public final PathIterator getPathIterator(AffineTransform af) {
        return this.path.getPathIterator(af);
    }

    public final PathIterator getPathIterator(AffineTransform af, double flatness) {
        return this.path.getPathIterator(af, flatness);
    }

    public static GJMarker getMarker(String s, double width) {
        if (s.equals("Circle")) {
            return GJMarker.circle(width);
        }
        if (s.equals("Square")) {
            return GJMarker.square(width);
        }
        if (s.equals("Triangle")) {
            return GJMarker.triangle(width);
        }
        if (s.equals("Diamond")) {
            return GJMarker.diamond(width);
        }
        if (s.equals("Inverted Triangle")) {
            return GJMarker.invertedTriangle(width);
        }
        if (s.equals("Left Triangle")) {
            return GJMarker.leftTriangle(width);
        }
        if (s.equals("Right Triangle")) {
            return GJMarker.rightTriangle(width);
        }
        return GJMarker.dot(width);
    }

    public static Path2D makeArrow(double x1, double y1, double sc) {
        Path2D.Double thisArrow = new Path2D.Double();
        ((Path2D)thisArrow).moveTo(x1 - x1 / sc, y1 - y1 / sc);
        ((Path2D)thisArrow).lineTo(x1, y1);
        ((Path2D)thisArrow).lineTo(x1 - x1 / sc, y1 + y1 / sc);
        return thisArrow;
    }

    public static Path2D makeArrow(double x1, double y1, double dx, double dy, boolean closeFlag) {
        Path2D.Double thisArrow = new Path2D.Double();
        ((Path2D)thisArrow).moveTo(x1 - dx, y1 - dy);
        ((Path2D)thisArrow).lineTo(x1, y1);
        ((Path2D)thisArrow).lineTo(x1 - dx, y1 + dy);
        if (closeFlag) {
            thisArrow.closePath();
        }
        return thisArrow;
    }

    private static GJMarker makeDot() {
        Path2D.Double instance = new Path2D.Double();
        Rectangle2D.Double temp = new Rectangle2D.Double(-0.5, -0.5, 1.0, 1.0);
        instance.append(temp, false);
        GJMarker dotMarker = new GJMarker((Path2D)instance);
        return dotMarker;
    }

    private static Rectangle2D makeRectangle(double x, double y, double w, double h) {
        return new Rectangle2D.Double(x, y, w, h);
    }

    private static Ellipse2D makeCircle(double r) {
        return new Ellipse2D.Double(-r, -r, 2.0 * r, 2.0 * r);
    }

    private static Rectangle2D makeSquare(double r) {
        return GJMarker.makeRectangle(-r, -r, 2.0 * r, 2.0 * r);
    }

    private static Triangle2D makeTriangle(double r) {
        return GJMarker.makeTriangle(r, 0.0);
    }

    private static Triangle2D makeTriangle(double r, double theta) {
        double[] x = new double[]{-r, 0.0, r, -r};
        double centroid = r / 3.0;
        double[] y = new double[]{r - centroid, -r - centroid, r - centroid, r - centroid};
        return new Triangle2D((Shape)GJMarker.makeMarker(x, y), theta);
    }

    private static Triangle2D makeInvertedTriangle(double r) {
        return GJMarker.makeTriangle(r, Math.PI);
    }

    private static Triangle2D makeLeftTriangle(double r) {
        return GJMarker.makeTriangle(r, 4.71238898038469);
    }

    private static Triangle2D makeRightTriangle(double r) {
        return GJMarker.makeTriangle(r, 1.5707963267948966);
    }

    private static Shape makeDiamond(double r) {
        Path2D.Double tr = new Path2D.Double(GJMarker.makeSquare(r));
        ((Path2D)tr).transform(AffineTransform.getRotateInstance(0.7853981633974483, 0.0, 0.0));
        return tr;
    }

    public static String2D makeStop(int size) {
        return GJMarker.makeCharMarker(".", size);
    }

    public static String2D makePlus(int size) {
        return GJMarker.makeCharMarker("+", size);
    }

    public static String2D makeCross(int size) {
        return GJMarker.makeCharMarker("x", size);
    }

    public static String2D makeCharMarker(String str, int size) {
        return GJMarker.makeMarkerFromFont(str, size, "Serif");
    }

    public static String2D makeMarkerFromFont(String str, int size, String fontname) {
        Font f = new Font(fontname, 0, size);
        FontRenderContext context = new FontRenderContext(null, true, false);
        GlyphVector vec = f.createGlyphVector(context, str);
        Shape s = vec.getOutline(0.0f, 0.0f);
        return new String2D(s, 0.0, str);
    }

    public static Path2D makeMarker(double[] x, double[] y) {
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(x[0], y[0]);
        for (int i = 1; i < x.length; ++i) {
            ((Path2D)path).lineTo(x[i], y[i]);
        }
        return path;
    }

    public static GJMarker getWidestMarker(GJCyclicArrayList<GJMarker> p) {
        int index = -1;
        double maxWidth = 0.0;
        for (GJMarker m : p) {
            if (!(m.getBounds2D().getWidth() > maxWidth)) continue;
            index = p.indexOf(m);
        }
        return p.get(index);
    }

    public static GJMarker getTallestMarker(GJCyclicArrayList<GJMarker> p) {
        int index = -1;
        double maxHeight = 0.0;
        for (GJMarker m : p) {
            if (!(m.getBounds2D().getHeight() > maxHeight)) continue;
            index = p.indexOf(m);
        }
        return p.get(index);
    }

    public final ArrayList<GJPathSegmentInfo> getSegments() {
        ArrayList<GJPathSegmentInfo> segments = new ArrayList<GJPathSegmentInfo>();
        double[] d = new double[6];
        PathIterator it = this.path.getPathIterator(null);
        while (!it.isDone()) {
            int type = it.currentSegment(d);
            segments.add(new GJPathSegmentInfo(type, d));
            it.next();
        }
        return segments;
    }

    public final void setSegments(ArrayList<GJPathSegmentInfo> arr) {
        ((Path2D)this.path).reset();
        Path2D p = (Path2D)this.path;
        for (GJPathSegmentInfo segment : arr) {
            switch (segment.getType()) {
                case 0: {
                    p.moveTo(segment.getData()[0], segment.getData()[1]);
                    break;
                }
                case 1: {
                    p.lineTo(segment.getData()[0], segment.getData()[1]);
                    break;
                }
                case 2: {
                    p.quadTo(segment.getData()[0], segment.getData()[1], segment.getData()[2], segment.getData()[3]);
                    break;
                }
                case 3: {
                    p.curveTo(segment.getData()[0], segment.getData()[1], segment.getData()[2], segment.getData()[3], segment.getData()[4], segment.getData()[5]);
                    break;
                }
                case 4: {
                    p.closePath();
                }
            }
        }
    }

    public static Path2D makePath(ArrayList<GJPathSegmentInfo> arr) {
        Path2D.Double p = new Path2D.Double();
        for (GJPathSegmentInfo segment : arr) {
            switch (segment.getType()) {
                case 0: {
                    ((Path2D)p).moveTo(segment.getData()[0], segment.getData()[1]);
                    break;
                }
                case 1: {
                    ((Path2D)p).lineTo(segment.getData()[0], segment.getData()[1]);
                    break;
                }
                case 2: {
                    ((Path2D)p).quadTo(segment.getData()[0], segment.getData()[1], segment.getData()[2], segment.getData()[3]);
                    break;
                }
                case 3: {
                    ((Path2D)p).curveTo(segment.getData()[0], segment.getData()[1], segment.getData()[2], segment.getData()[3], segment.getData()[4], segment.getData()[5]);
                    break;
                }
                case 4: {
                    p.closePath();
                }
            }
        }
        return p;
    }

    static /* synthetic */ GJMarker access$000() {
        return GJMarker.makeDot();
    }

    private static final class maps {
        private static final HashMap<Double, Shape> circles = new HashMap();
        private static final HashMap<Double, Shape> squares = new HashMap();
        private static final HashMap<Double, Shape> triangles = new HashMap();
        private static final HashMap<Double, Shape> itriangles = new HashMap();
        private static final HashMap<Double, Shape> ltriangles = new HashMap();
        private static final HashMap<Double, Shape> rtriangles = new HashMap();
        private static final HashMap<Double, Shape> diamonds = new HashMap();
        private static final HashMap<String, Shape> strings = new HashMap();
        private static final GJMarker dot = GJMarker.access$000();
        private static final HashMap<Double, GJMarker> circleMarkers = new HashMap();
        private static final HashMap<Double, GJMarker> squareMarkers = new HashMap();
        private static final HashMap<Double, GJMarker> triangleMarkers = new HashMap();
        private static final HashMap<Double, GJMarker> itriangleMarkers = new HashMap();
        private static final HashMap<Double, GJMarker> ltriangleMarkers = new HashMap();
        private static final HashMap<Double, GJMarker> rtriangleMarkers = new HashMap();
        private static final HashMap<Double, GJMarker> diamondMarkers = new HashMap();

        private maps() {
        }
    }
}

