/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.logging;

import java.awt.EventQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.JButton;
import kcl.waterloo.gui.images.Images;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class CommonLogger
implements Logger {
    private final Logger logger;
    private static final AtomicInteger taskCounter = new AtomicInteger(0);
    private static String lastMessage = "";
    private static final String tStr = "[TRACE] - ";
    private static final String iStr = "[INFO] - ";
    private static final String dStr = "[DEBUG] - ";
    private static final String wStr = "[WARN] - ";
    private static final String eStr = "[ERROR] - ";
    private static final CommonLogger commonLoggerLogger = new CommonLogger(CommonLogger.class);

    public CommonLogger(String clzz) {
        this.logger = LoggerFactory.getLogger((String)clzz);
        CommonLogger.update();
    }

    public CommonLogger(Class clzz) {
        this.logger = LoggerFactory.getLogger((String)clzz.getName());
        CommonLogger.update();
    }

    public static JButton getTaskMonitor() {
        return Singleton.taskMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incTaskCount() {
        Singleton singleton = Singleton.instance;
        synchronized (singleton) {
            taskCounter.incrementAndGet();
            CommonLogger.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decTaskCount() {
        Singleton singleton = Singleton.instance;
        synchronized (singleton) {
            int k = taskCounter.decrementAndGet();
            if (k < 0) {
                taskCounter.getAndSet(0);
            }
            CommonLogger.update();
            if (k < 0) {
                commonLoggerLogger.warn("Attempt to set task counter to <0 ignored");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTaskCount() {
        Singleton singleton = Singleton.instance;
        synchronized (singleton) {
            return taskCounter.get();
        }
    }

    private static void update() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CommonLogger.getTaskMonitor().setText(String.format("Scheduled Tasks ... %d", taskCounter.get()));
                if (taskCounter.get() <= 0) {
                    CommonLogger.getTaskMonitor().setIcon(null);
                } else {
                    CommonLogger.getTaskMonitor().setIcon(Singleton.icon);
                }
            }
        });
    }

    public String getName() {
        return "CommonLogger [".concat(this.logger.getName()).concat("]");
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void trace(String string) {
        lastMessage = tStr.concat(string);
        this.logger.trace(string);
    }

    public void trace(String string, Object o) {
        lastMessage = tStr.concat(string);
        this.logger.trace(string, o);
    }

    public void trace(String string, Object o, Object o1) {
        lastMessage = tStr.concat(string);
        this.logger.trace(string, o, o1);
    }

    public void trace(String string, Object ... os) {
        lastMessage = tStr.concat(string);
        this.logger.trace(string, os);
    }

    public void trace(String string, Throwable thrwbl) {
        lastMessage = tStr.concat(string);
        this.logger.trace(string, thrwbl);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.logger.isTraceEnabled(marker);
    }

    public void trace(Marker marker, String string) {
        lastMessage = tStr.concat(string);
        this.logger.trace(marker, string);
    }

    public void trace(Marker marker, String string, Object o) {
        lastMessage = tStr.concat(string);
        this.logger.trace(marker, string, o);
    }

    public void trace(Marker marker, String string, Object o, Object o1) {
        lastMessage = tStr.concat(string);
        this.logger.trace(marker, string, o, o1);
    }

    public void trace(Marker marker, String string, Object ... os) {
        lastMessage = tStr.concat(string);
        this.logger.trace(marker, string, os);
    }

    public void trace(Marker marker, String string, Throwable thrwbl) {
        lastMessage = tStr.concat(string);
        this.logger.trace(marker, string, thrwbl);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(String string) {
        lastMessage = dStr.concat(string);
        this.logger.debug(string);
    }

    public void debug(String string, Object o) {
        lastMessage = dStr.concat(string);
        this.logger.debug(string, o);
    }

    public void debug(String string, Object o, Object o1) {
        lastMessage = dStr.concat(string);
        this.logger.debug(string, o, o1);
    }

    public void debug(String string, Object ... os) {
        lastMessage = dStr.concat(string);
        this.logger.debug(string, os);
    }

    public void debug(String string, Throwable thrwbl) {
        lastMessage = dStr.concat(string);
        this.logger.debug(string, thrwbl);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.logger.isTraceEnabled(marker);
    }

    public void debug(Marker marker, String string) {
        lastMessage = dStr.concat(string);
        this.logger.debug(marker, string);
    }

    public void debug(Marker marker, String string, Object o) {
        lastMessage = dStr.concat(string);
        this.logger.debug(marker, string, o);
    }

    public void debug(Marker marker, String string, Object o, Object o1) {
        lastMessage = dStr.concat(string);
        this.logger.debug(marker, string, o, o1);
    }

    public void debug(Marker marker, String string, Object ... os) {
        lastMessage = dStr.concat(string);
        this.logger.debug(marker, string, os);
    }

    public void debug(Marker marker, String string, Throwable thrwbl) {
        lastMessage = dStr.concat(string);
        this.logger.debug(marker, string, thrwbl);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(String string) {
        lastMessage = iStr.concat(string);
        this.logger.info(string);
    }

    public void info(String string, Object o) {
        lastMessage = iStr.concat(string);
        this.logger.info(string, o);
    }

    public void info(String string, Object o, Object o1) {
        lastMessage = iStr.concat(string);
        this.logger.info(string, o, o1);
    }

    public void info(String string, Object ... os) {
        lastMessage = iStr.concat(string);
        this.logger.info(string, os);
    }

    public void info(String string, Throwable thrwbl) {
        lastMessage = iStr.concat(string);
        this.logger.info(string, thrwbl);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.logger.isTraceEnabled(marker);
    }

    public void info(Marker marker, String string) {
        lastMessage = iStr.concat(string);
        this.logger.info(marker, string);
    }

    public void info(Marker marker, String string, Object o) {
        lastMessage = iStr.concat(string);
        this.logger.info(marker, string, o);
    }

    public void info(Marker marker, String string, Object o, Object o1) {
        lastMessage = iStr.concat(string);
        this.logger.info(marker, string, o, o1);
    }

    public void info(Marker marker, String string, Object ... os) {
        lastMessage = iStr.concat(string);
        this.logger.info(marker, string, os);
    }

    public void info(Marker marker, String string, Throwable thrwbl) {
        lastMessage = iStr.concat(string);
        this.logger.info(marker, string, thrwbl);
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void warn(String string) {
        lastMessage = wStr.concat(string);
        this.logger.warn(string);
    }

    public void warn(String string, Object o) {
        lastMessage = wStr.concat(string);
        this.logger.warn(string, o);
    }

    public void warn(String string, Object o, Object o1) {
        lastMessage = wStr.concat(string);
        this.logger.warn(string, o, o1);
    }

    public void warn(String string, Object ... os) {
        lastMessage = wStr.concat(string);
        this.logger.warn(string, os);
    }

    public void warn(String string, Throwable thrwbl) {
        lastMessage = wStr.concat(string);
        this.logger.warn(string, thrwbl);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.logger.isTraceEnabled(marker);
    }

    public void warn(Marker marker, String string) {
        lastMessage = wStr.concat(string);
        this.logger.warn(marker, string);
    }

    public void warn(Marker marker, String string, Object o) {
        lastMessage = wStr.concat(string);
        this.logger.warn(marker, string, o);
    }

    public void warn(Marker marker, String string, Object o, Object o1) {
        lastMessage = wStr.concat(string);
        this.logger.warn(marker, string, o, o1);
    }

    public void warn(Marker marker, String string, Object ... os) {
        lastMessage = wStr.concat(string);
        this.logger.warn(marker, string, os);
    }

    public void warn(Marker marker, String string, Throwable thrwbl) {
        lastMessage = wStr.concat(string);
        this.logger.warn(marker, string, thrwbl);
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public void error(String string) {
        lastMessage = eStr.concat(string);
        this.logger.error(string);
    }

    public void error(String string, Object o) {
        lastMessage = eStr.concat(string);
        this.logger.error(string, o);
    }

    public void error(String string, Object o, Object o1) {
        lastMessage = eStr.concat(string);
        this.logger.error(string, o, o1);
    }

    public void error(String string, Object ... os) {
        lastMessage = eStr.concat(string);
        this.logger.error(string, os);
    }

    public void error(String string, Throwable thrwbl) {
        lastMessage = eStr.concat(string);
        this.logger.error(string, thrwbl);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.logger.isTraceEnabled(marker);
    }

    public void error(Marker marker, String string) {
        lastMessage = eStr.concat(string);
        this.logger.error(marker, string);
    }

    public void error(Marker marker, String string, Object o) {
        lastMessage = eStr.concat(string);
        this.logger.error(marker, string, o);
    }

    public void error(Marker marker, String string, Object o, Object o1) {
        lastMessage = eStr.concat(string);
        this.logger.error(marker, string, o, o1);
    }

    public void error(Marker marker, String string, Object ... os) {
        lastMessage = eStr.concat(string);
        this.logger.error(marker, string, os);
    }

    public void error(Marker marker, String string, Throwable thrwbl) {
        lastMessage = eStr.concat(string);
        this.logger.error(marker, string, thrwbl);
    }

    public static String getLastMessage() {
        return lastMessage;
    }

    private static class Singleton {
        private static final JButton taskMonitor = new JButton();
        private static final Singleton instance = new Singleton();
        private static final Icon icon = Images.getIcon("ajax-loader.gif");

        private Singleton() {
            taskMonitor.setHorizontalTextPosition(2);
            taskMonitor.setText("Scheduled Tasks ... 0");
        }
    }
}

