/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.gui.file;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ImageFileChooser
extends JFileChooser
implements ActionListener {
    private static ImageFileChooser instance;
    private static File currentSaveDirectory;
    private static File currentOpenDirectory;
    protected static ArrayList<String> targetExtension;

    protected ImageFileChooser(String str) {
        super(str);
        ImageFileChooser.setDefaultExtensions();
        this.setFileSelectionMode(2);
        for (int k = 0; k < targetExtension.size(); ++k) {
            String s = targetExtension.get(k);
            if (s.equals("bmp")) {
                this.addChoosableFileFilter(new FileNameExtensionFilter("Bitmap (." + s + ")", s.replace(".", "")));
                continue;
            }
            if (s.equals("tif") || s.equals("tiff")) {
                this.addChoosableFileFilter(new FileNameExtensionFilter("TIF Image (." + s + ")", s.replace(".", "")));
                continue;
            }
            if (s.equals("png")) {
                this.addChoosableFileFilter(new FileNameExtensionFilter("Portable Network Graphic (." + s + ")", s.replace(".", "")));
                continue;
            }
            if (s.equals("wbmp")) {
                this.addChoosableFileFilter(new FileNameExtensionFilter("Windows bitmap (." + s + ")", s.replace(".", "")));
                continue;
            }
            if (s.equals("jpg") || s.equals("jpeg")) {
                this.addChoosableFileFilter(new FileNameExtensionFilter("JPEG Image (." + s + ")", s.replace(".", "")));
                continue;
            }
            if (s.equals("svg")) {
                this.addChoosableFileFilter(new FileNameExtensionFilter("Scalable Vector Format (." + s + ")", s.replace(".", "")));
                continue;
            }
            if (s.equals("gz")) {
                this.addChoosableFileFilter(new FileNameExtensionFilter("GZIP Compressed SVG (.svg." + s + ")", s.replace(".", "")));
                continue;
            }
            if (s.equals("pdf")) {
                this.addChoosableFileFilter(new FileNameExtensionFilter("Portable Document Format (." + s + ")", s.replace(".", "")));
                continue;
            }
            if (s.equals("gif")) {
                this.addChoosableFileFilter(new FileNameExtensionFilter("GIF Image (." + s + ")", s.replace(".", "")));
                continue;
            }
            if (s.equals("html")) {
                this.addChoosableFileFilter(new FileNameExtensionFilter("HTML (." + s + ")", s.replace(".", "")));
                continue;
            }
            if (s.equals("pde")) {
                this.addChoosableFileFilter(new FileNameExtensionFilter("Processing (." + s + ")", s.replace(".", "")));
                continue;
            }
            if (s.equals("eps")) {
                this.addChoosableFileFilter(new FileNameExtensionFilter("Encapsulated PS (." + s + ")", s.replace(".", "")));
                continue;
            }
            this.addChoosableFileFilter(new FileNameExtensionFilter("Image (." + s + ")", s.replace(".", "")));
        }
    }

    public static ImageFileChooser getInstance() {
        if (instance == null) {
            instance = new ImageFileChooser("");
            instance.addActionListener(instance);
        }
        return instance;
    }

    @Override
    public boolean accept(File f) {
        return targetExtension.contains("." + ImageFileChooser.getExtension(f));
    }

    private static ArrayList<String> getTargetExtension() {
        return targetExtension;
    }

    private static void setDefaultExtensions() {
        targetExtension.clear();
        String[] s = ImageIO.getWriterFileSuffixes();
        targetExtension.add("eps");
        targetExtension.add("pde");
        targetExtension.add("pdf");
        targetExtension.add("svg");
        targetExtension.add("gz");
        for (int k = 0; k < s.length; ++k) {
            targetExtension.add(s[k].toLowerCase());
        }
    }

    private static void setCurrentDirectory(String s) {
        instance.setCurrentDirectory(new File(s));
    }

    public static int createSaveDialog() {
        return ImageFileChooser.createSaveDialog(null, "");
    }

    public static int createSaveDialog(Component parent, String str) {
        if (instance == null) {
            instance = new ImageFileChooser(str);
            instance.addActionListener(instance);
        } else {
            instance.setCurrentDirectory(new File(str));
        }
        instance.setCurrentDirectory(currentSaveDirectory);
        int value = instance.showSaveDialog(parent);
        currentSaveDirectory = instance.getCurrentDirectory();
        return value;
    }

    public static int createOpenDialog() {
        return ImageFileChooser.createOpenDialog("");
    }

    public static int createOpenDialog(String str) {
        if (instance == null) {
            instance = new ImageFileChooser(str);
            instance.addActionListener(instance);
        }
        instance.setCurrentDirectory(currentOpenDirectory);
        int value = instance.showOpenDialog(null);
        currentOpenDirectory = instance.getCurrentDirectory();
        return value;
    }

    private static boolean endsWith(String s) {
        for (String ext : ImageFileChooser.getTargetExtension()) {
            if (!s.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    private static String getExtension(String s) {
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            return s.substring(i + 1).toLowerCase();
        }
        return "";
    }

    private static String getExtension(File f) {
        return ImageFileChooser.getExtension(f.getName());
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("ApproveSelection") && this.getFileFilter() != null) {
            String s = this.getFileFilter().getDescription();
            int idx0 = s.indexOf("(");
            int idx1 = s.indexOf(")");
            s = s.substring(idx0 + 1, idx1);
            this.setSelectedFile(new File(this.getSelectedFile().getPath() + s));
        }
    }

    static {
        targetExtension = new ArrayList();
    }
}

