/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.transforms;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kcl.waterloo.graphics.transforms.GJAbstractDataTransform;
import kcl.waterloo.graphics.transforms.GJDataTransformInterface;
import kcl.waterloo.graphics.transforms.NOPTransform;

public class Services {
    private static final ArrayList<Class> clzz = Services.getClasses();

    public static void addClass(Class clz) {
        Class<?>[] arr = clz.getInterfaces();
        boolean ok = false;
        for (Class<?> arr1 : arr) {
            if (!arr1.equals(GJDataTransformInterface.class)) continue;
            ok = true;
        }
        if (!ok) {
            arr = clz.getSuperclass().getInterfaces();
        }
        for (Class<?> arr1 : arr) {
            if (!arr1.equals(GJDataTransformInterface.class)) continue;
            ok = true;
        }
        if (ok) {
            clzz.add(clz);
        }
    }

    public static LinkedHashMap<String, GJDataTransformInterface> getAvailable() {
        LinkedHashMap<String, GJDataTransformInterface> names = new LinkedHashMap<String, GJDataTransformInterface>();
        if (clzz == null) {
            return names;
        }
        for (Class clz : clzz) {
            Method m = null;
            try {
                m = clz.getMethod("getInstance", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (m == null) continue;
            try {
                GJDataTransformInterface tr = (GJDataTransformInterface)m.invoke(null, (Object[])null);
                names.put(tr.getName(), tr);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        return names;
    }

    public static GJDataTransformInterface getInstanceForName(String name) {
        for (Class clz : clzz) {
            Method m = null;
            try {
                m = clz.getMethod("getInstance", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (m == null) continue;
            GJDataTransformInterface tr = null;
            try {
                tr = (GJDataTransformInterface)m.invoke(null, (Object[])null);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            if (tr == null || !tr.getName().equals(name)) continue;
            return tr;
        }
        return NOPTransform.getInstance();
    }

    static ArrayList<Class> getClasses() {
        ArrayList<Class> classList = new ArrayList<Class>();
        try {
            String packageName = Services.class.getPackage().getName();
            String path = packageName.replace('.', '/');
            Enumeration<URL> resources = Services.class.getClassLoader().getResources(path);
            ArrayList<String> dirs = new ArrayList<String>();
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                dirs.add(resource.getFile());
            }
            TreeSet<String> classes = new TreeSet<String>();
            for (String directory : dirs) {
                TreeSet<String> tree = Services.findClasses(directory, packageName, null);
                classes.addAll(tree);
            }
            for (String clazz : classes) {
                try {
                    if (!GJDataTransformInterface.class.isAssignableFrom(Class.forName(clazz)) || Class.forName(clazz).isInterface() || Class.forName(clazz).equals(GJAbstractDataTransform.class)) continue;
                    classList.add(Class.forName(clazz));
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return classList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TreeSet<String> findClasses(String path, String packageName, Pattern regex) {
        File[] files;
        TreeSet<String> classes;
        block44: {
            classes = new TreeSet<String>();
            ZipInputStream zip = null;
            String[] split = path.split("!");
            InputStream in = null;
            try {
                URL jar;
                if (!path.startsWith("file:") || !path.contains("!")) break block44;
                try {
                    jar = new URL(split[0]);
                }
                catch (MalformedURLException ex) {
                    TreeSet<String> treeSet = classes;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    try {
                        if (zip != null) {
                            zip.close();
                        }
                    }
                    catch (IOException ex2) {
                        return classes;
                    }
                    return treeSet;
                }
                try {
                    in = jar.openStream();
                }
                catch (IOException ex) {
                    TreeSet<String> treeSet = classes;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ex2) {
                            // empty catch block
                        }
                    }
                    try {
                        if (zip != null) {
                            zip.close();
                        }
                    }
                    catch (IOException ex3) {
                        return classes;
                    }
                    return treeSet;
                }
                zip = new ZipInputStream(in);
                try {
                    ZipEntry entry;
                    while ((entry = zip.getNextEntry()) != null) {
                        String className;
                        if (!entry.getName().endsWith(".class") || !(className = entry.getName().replaceAll("[$].*", "").replaceAll("[.]class", "").replace('/', '.')).startsWith(packageName) || regex != null && !regex.matcher(className).matches()) continue;
                        classes.add(className);
                    }
                }
                catch (IOException ex) {
                    TreeSet<String> treeSet = classes;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    try {
                        if (zip != null) {
                            zip.close();
                        }
                    }
                    catch (IOException ex4) {
                        return classes;
                    }
                    return treeSet;
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException jar) {}
                }
                try {
                    if (zip != null) {
                        zip.close();
                    }
                }
                catch (IOException ex) {
                    return classes;
                }
            }
        }
        File dir = new File(path);
        if (!dir.exists()) {
            return classes;
        }
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(Services.findClasses(file.getAbsolutePath(), packageName + "." + file.getName(), regex));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String className = packageName + '.' + file.getName().substring(0, file.getName().length() - 6);
            if (regex != null && !regex.matcher(className).matches()) continue;
            classes.add(className);
        }
        return classes;
    }
}

