/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.transforms;

import java.util.ArrayList;
import kcl.waterloo.graphics.transforms.GJMultiAxisDataTransformInterface;

public class LogPolarTransform
implements GJMultiAxisDataTransformInterface {
    public String getName() {
        return "logPolar";
    }

    public double getRho(double x, double y) {
        return Math.log10(Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0)));
    }

    public double getTheta(double x, double y) {
        return Math.atan(y / x);
    }

    public double[] getData(double x, double y) {
        return new double[]{this.getTheta(x, y), this.getRho(x, y)};
    }

    public double[][] getData(double[] x, double[] y) {
        double[] rho = new double[x.length];
        double[] theta = new double[x.length];
        for (int k = 0; k < x.length; ++k) {
            rho[k] = this.getRho(x[k], y[k]);
            theta[k] = this.getTheta(x[k], y[k]);
        }
        return new double[][]{rho, theta};
    }

    public double getX(double theta, double rho) {
        return Math.pow(Math.E, rho) * Math.cos(theta);
    }

    public double getY(double theta, double rho) {
        return Math.pow(Math.E, rho) * Math.sin(theta);
    }

    public double[] getInverse(double theta, double rho) {
        return new double[]{this.getX(theta, rho), this.getY(theta, rho)};
    }

    public double[][] getInverse(double[] theta, double[] rho) {
        double[] x = new double[theta.length];
        double[] y = new double[theta.length];
        for (int k = 0; k < x.length; ++k) {
            x[k] = this.getX(x[k], y[k]);
            y[k] = this.getY(x[k], y[k]);
        }
        return new double[][]{x, y};
    }

    public Object getTickLabel(double val) {
        return null;
    }

    public ArrayList getAxisTickPositions(Object o, double start, double stop, double inc) {
        return null;
    }

    public ArrayList getMinorGridPositions(Object o, double start, double stop, double inc, int n) {
        return null;
    }
}

