/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.plots2D;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import kcl.waterloo.graphics.plots2D.GJAbstractPlot;
import kcl.waterloo.graphics.plots2D.GJPlotInterface;
import kcl.waterloo.graphics.plots2D.GJPolarPlotInterface;
import kcl.waterloo.graphics.plots2D.PolarExtra;
import kcl.waterloo.math.geom.Cartesian;
import kcl.waterloo.math.geom.Coordinates;

public class GJLine
extends GJAbstractPlot {
    public GJLine() {
    }

    public GJLine(GJAbstractPlot p) {
        super(p);
    }

    public static GJPlotInterface createInstance() {
        return GJAbstractPlot.createInstance(new GJLine());
    }

    @Override
    public final void paintPlot(Graphics2D g2) {
        double[] yposition;
        double[] xposition;
        if (this instanceof GJPolarPlotInterface && ((PolarExtra)this.getDataModel().getExtraObject()).getDataMode() == PolarExtra.DATAMODE.POLAR) {
            Cartesian cart = Coordinates.polarToCartesian(this.getXDataValues(), this.getYDataValues());
            xposition = this.getParentGraph().xPositionToPixeli(cart.getX());
            yposition = this.getParentGraph().yPositionToPixeli(cart.getY());
        } else {
            xposition = this.getParentGraph().xPositionToPixeli(this.getXDataValues());
            yposition = this.getParentGraph().yPositionToPixeli(this.getYDataValues());
        }
        if (xposition == null || yposition == null) {
            return;
        }
        super.paintPlot(g2);
        this.getScreenDataArray().clear();
        for (int idx = 0; idx < this.getMultiplexLength(); ++idx) {
            Path2D.Double path = new Path2D.Double();
            int idx2 = idx;
            while (Double.isNaN(xposition[idx2]) || Double.isNaN(yposition[idx2])) {
                idx2 += this.getMultiplexLength();
            }
            ((Path2D)path).moveTo(xposition[idx2], yposition[idx2]);
            boolean newSection = false;
            int N = this.getMultiplexLength();
            for (int i = idx2; i < xposition.length; i += N) {
                if (!(Double.isNaN(xposition[i]) || Double.isNaN(yposition[i]) || Double.isInfinite(xposition[i]) || Double.isInfinite(yposition[i]))) {
                    if (newSection) {
                        ((Path2D)path).moveTo(xposition[i], yposition[i]);
                    } else {
                        ((Path2D)path).lineTo(xposition[i], yposition[i]);
                    }
                    newSection = false;
                    continue;
                }
                newSection = true;
            }
            this.getScreenDataArray().add(path);
            g2.setStroke((Stroke)this.getVisualModel().getLineStroke().get(idx));
            g2.setPaint((Paint)this.getVisualModel().getLineColor().get(idx));
            g2.draw(path);
        }
    }
}

