/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.plots2D;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.util.Formatter;
import kcl.waterloo.graphics.plots2D.ErrorBarExtra;
import kcl.waterloo.graphics.plots2D.GJAbstractPlot;
import kcl.waterloo.graphics.plots2D.GJPlotInterface;
import kcl.waterloo.math.ArrayMath;

public final class GJErrorBar
extends GJAbstractPlot {
    public GJErrorBar() {
    }

    public GJErrorBar(GJAbstractPlot p) {
        super(p);
    }

    public static GJPlotInterface createInstance() {
        GJPlotInterface p = GJAbstractPlot.createInstance(new GJErrorBar());
        p.getDataModel().setExtraObject(new ErrorBarExtra());
        return p;
    }

    @Override
    public final void paintPlot(Graphics2D g2) {
        int i;
        int idx;
        boolean[] flag;
        if (this.getParentGraph() == null || this.getDataModel() == null) {
            return;
        }
        ErrorBarExtra extra = null;
        if (this.getDataModel().getExtraObject() != null) {
            extra = (ErrorBarExtra)this.getDataModel().getExtraObject();
        }
        double extent = 7.0;
        if (extra != null) {
            extent = extra.getExtent();
        }
        super.paintPlot(g2);
        double[] xposition = this.getParentGraph().xPositionToPixeli(this.getXDataValues());
        double[] yposition = this.getParentGraph().yPositionToPixeli(this.getYDataValues());
        this.getScreenDataArray().clear();
        Path2D.Double path = new Path2D.Double();
        int N = this.getMultiplexLength();
        double[] x = this.getXData().getRawDataValues();
        double[] y = this.getYData().getRawDataValues();
        if (this.getDataModel().getExtraData3() != null && this.getDataModel().getExtraData3().length > 0) {
            double[] lower = this.getParentGraph().yPositionToPixeli(this.getParentGraph().getYTransform().getData(ArrayMath.sub(y, this.getDataModel().getExtraData3())));
            flag = new boolean[lower.length];
            if (extra != null && extra.getMode() == ErrorBarExtra.MODE.DATASIGN) {
                flag = ArrayMath.isLT(this.getParentGraph().getYTransform().getData(y), 0.0);
            } else {
                ArrayMath.filli(flag, Boolean.TRUE);
            }
            for (idx = 0; idx < N; ++idx) {
                path.reset();
                for (i = idx; i < xposition.length; i += N) {
                    if (Double.isNaN(lower[i]) || !flag[i]) continue;
                    ((Path2D)path).moveTo(xposition[i] - extent, lower[i]);
                    ((Path2D)path).lineTo(xposition[i] + extent, lower[i]);
                    ((Path2D)path).moveTo(xposition[i], lower[i]);
                    ((Path2D)path).lineTo(xposition[i], yposition[i]);
                }
                g2.setPaint((Paint)this.getVisualModel().getLineColor().get(idx));
                g2.setStroke((Stroke)this.getVisualModel().getLineStroke().get(idx));
                g2.draw(path);
                this.getScreenDataArray().add(path);
            }
        }
        if (this.getDataModel().getExtraData1() != null && this.getDataModel().getExtraData1().length > 0) {
            double[] upper = this.getParentGraph().yPositionToPixeli(this.getParentGraph().getYTransform().getData(ArrayMath.add(y, this.getDataModel().getExtraData1())));
            flag = new boolean[upper.length];
            if (extra != null && extra.getMode() == ErrorBarExtra.MODE.DATASIGN) {
                flag = ArrayMath.isGE(this.getParentGraph().getYTransform().getData(y), 0.0);
            } else {
                ArrayMath.filli(flag, Boolean.TRUE);
            }
            for (idx = 0; idx < N; ++idx) {
                path.reset();
                for (i = idx; i < xposition.length; i += N) {
                    if (Double.isNaN(upper[i]) || !flag[i]) continue;
                    ((Path2D)path).moveTo(xposition[i] - extent, upper[i]);
                    ((Path2D)path).lineTo(xposition[i] + extent, upper[i]);
                    ((Path2D)path).moveTo(xposition[i], upper[i]);
                    ((Path2D)path).lineTo(xposition[i], yposition[i]);
                }
                g2.setPaint((Paint)this.getVisualModel().getLineColor().get(idx));
                g2.setStroke((Stroke)this.getVisualModel().getLineStroke().get(idx));
                g2.draw(path);
                this.getScreenDataArray().add(path);
            }
        }
        if (this.getDataModel().getExtraData2() != null && this.getDataModel().getExtraData2().length > 0) {
            path = new Path2D.Double();
            double[] left = this.getParentGraph().xPositionToPixeli(this.getParentGraph().getXTransform().getData(ArrayMath.sub(x, this.getDataModel().getExtraData2())));
            flag = new boolean[left.length];
            if (extra != null && extra.getMode() == ErrorBarExtra.MODE.DATASIGN) {
                flag = ArrayMath.isLT(this.getParentGraph().getYTransform().getData(y), 0.0);
            } else {
                ArrayMath.filli(flag, Boolean.TRUE);
            }
            for (idx = 0; idx < N; ++idx) {
                path.reset();
                for (i = idx; i < xposition.length; i += N) {
                    if (Double.isNaN(left[i]) || !flag[i]) continue;
                    ((Path2D)path).moveTo(xposition[i], yposition[i]);
                    ((Path2D)path).lineTo(left[i], yposition[i]);
                    ((Path2D)path).moveTo(left[i], yposition[i] - extent);
                    ((Path2D)path).lineTo(left[i], yposition[i] + extent);
                }
                g2.setPaint((Paint)this.getVisualModel().getLineColor().get(idx));
                g2.setStroke((Stroke)this.getVisualModel().getLineStroke().get(idx));
                g2.draw(path);
                this.getScreenDataArray().add(path);
            }
        }
        if (this.getDataModel().getExtraData0() != null && this.getDataModel().getExtraData0().length > 0) {
            double[] right = this.getParentGraph().xPositionToPixeli(this.getParentGraph().getXTransform().getData(ArrayMath.add(x, this.getDataModel().getExtraData0())));
            flag = new boolean[right.length];
            if (extra != null && extra.getMode() == ErrorBarExtra.MODE.DATASIGN) {
                flag = ArrayMath.isGE(this.getParentGraph().getYTransform().getData(y), 0.0);
            } else {
                ArrayMath.filli(flag, Boolean.TRUE);
            }
            for (idx = 0; idx < N; ++idx) {
                path.reset();
                for (i = idx; i < xposition.length; i += N) {
                    if (Double.isNaN(right[i]) || !flag[i]) continue;
                    ((Path2D)path).moveTo(xposition[i], yposition[i]);
                    ((Path2D)path).lineTo(right[i], yposition[i]);
                    ((Path2D)path).moveTo(right[i], yposition[i] - extent);
                    ((Path2D)path).lineTo(right[i], yposition[i] + extent);
                }
                g2.setPaint((Paint)this.getVisualModel().getLineColor().get(idx));
                g2.setStroke((Stroke)this.getVisualModel().getLineStroke().get(idx));
                g2.draw(path);
                this.getScreenDataArray().add(path);
            }
        }
    }

    @Override
    protected String stringSupplement() {
        String str = "";
        StringBuilder s = new StringBuilder();
        Formatter f = new Formatter(s);
        if (this.getDataModel().getExtraObject() != null) {
            switch (((ErrorBarExtra)this.getDataModel().getExtraObject()).getMode()) {
                case NORMAL: {
                    f.format("Mode:\tNORMAL", new Object[0]);
                }
                case DATASIGN: {
                    f.format("Mode:\tDATASIGN", new Object[0]);
                }
            }
        }
        if (this.getDataModel().getExtraData1() != null && this.getDataModel().getExtraData1().length > 0) {
            f.format("Upper\t", new Object[0]);
            GJErrorBar.printData(f, this.getDataModel().getExtraData1());
        }
        if (this.getDataModel().getExtraData3() != null && this.getDataModel().getExtraData3().length > 0) {
            f.format("Lower\t", new Object[0]);
            GJErrorBar.printData(f, this.getDataModel().getExtraData3());
        }
        if (this.getDataModel().getExtraData2() != null && this.getDataModel().getExtraData2().length > 0) {
            f.format("Left\t", new Object[0]);
            GJErrorBar.printData(f, this.getDataModel().getExtraData2());
        }
        if (this.getDataModel().getExtraData0() != null && this.getDataModel().getExtraData0().length > 0) {
            f.format("Right\t", new Object[0]);
            GJErrorBar.printData(f, this.getDataModel().getExtraData0());
        }
        str = str.concat(f.toString());
        return str;
    }
}

