/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.data;

import java.util.AbstractList;
import kcl.waterloo.graphics.data.GJAbstractDataVector;
import kcl.waterloo.graphics.transforms.GJDataTransformInterface;

public final class GJFloatDataVector
extends GJAbstractDataVector<Float[]> {
    private static final long serialVersionUID = 1L;

    public GJFloatDataVector() {
        super(new Float[0]);
    }

    @Override
    public final void setDataBufferData(double[] v) {
        if (v != null) {
            Float[] buffer = new Float[v.length];
            for (int k = 0; k < v.length; ++k) {
                buffer[k] = new Float(v[k]);
            }
            this.setDataBuffer(buffer);
        } else {
            this.clearDataBufferData();
        }
    }

    @Override
    public final void setDataBufferData(int[] v) {
        if (v != null) {
            Float[] v2 = new Float[v.length];
            for (int k = 0; k < v.length; ++k) {
                v2[k] = Float.valueOf(v[k]);
            }
            this.setDataBuffer(v2);
        } else {
            this.clearDataBufferData();
        }
    }

    @Override
    public final void setDataBufferData(AbstractList<? extends Number> v) {
        Object[] v2 = v.toArray();
        Float[] data = new Float[v2.length];
        for (int k = 0; k < v2.length; ++k) {
            data[k] = new Float(v2[k].toString());
        }
        this.setDataBuffer(data);
    }

    @Override
    public final void setEntry(int index, double val) {
        this.setEntry(index, new Float(val));
    }

    public final void setEntry(int index, Float val) {
        Float old = ((Float[])this.getDataBuffer())[index];
        ((Float[])this.getDataBuffer())[index] = val;
        this.getPCS().fireIndexedPropertyChange("databuffer", index, old, ((Float[])this.getDataBuffer())[index]);
    }

    @Override
    public final double[] getDataValues(GJDataTransformInterface transform) {
        if (this.getDataBuffer() == null) {
            return new double[0];
        }
        double[] arr = new double[((Float[])this.getDataBuffer()).length];
        for (int k = 0; k < arr.length; ++k) {
            arr[k] = ((Float[])this.getDataBuffer())[k].doubleValue();
        }
        return transform.getData(arr);
    }

    @Override
    public final double[] getRawDataValues() {
        if (this.getDataBuffer() == null) {
            return new double[0];
        }
        double[] arr = new double[((Float[])this.getDataBuffer()).length];
        for (int k = 0; k < arr.length; ++k) {
            arr[k] = ((Float[])this.getDataBuffer())[k].doubleValue();
        }
        return arr;
    }

    @Override
    public final int getDimension() {
        if (this.getDataBuffer() == null) {
            return 0;
        }
        return ((Float[])this.getDataBuffer()).length;
    }
}

