/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics.data;

import java.util.AbstractList;
import kcl.waterloo.graphics.data.GJAbstractDataVector;
import kcl.waterloo.graphics.transforms.GJDataTransformInterface;

public final class GJDoubleDataVector
extends GJAbstractDataVector<Double[]> {
    private static final long serialVersionUID = 1L;

    public GJDoubleDataVector() {
        super(new Double[0]);
    }

    @Override
    public final void setDataBufferData(double[] v) {
        if (v != null) {
            Double[] buffer = new Double[v.length];
            for (int k = 0; k < v.length; ++k) {
                buffer[k] = v[k];
            }
            this.setDataBuffer(buffer);
        } else {
            this.clearDataBufferData();
        }
    }

    @Override
    public final void setDataBufferData(int[] v) {
        if (v != null) {
            double[] v2 = new double[v.length];
            for (int k = 0; k < v.length; ++k) {
                v2[k] = v[k];
            }
            this.setDataBufferData(v2);
        } else {
            this.clearDataBufferData();
        }
    }

    @Override
    public final void setDataBufferData(AbstractList<? extends Number> v) {
        Double[] data = new Double[v.size()];
        for (int k = 0; k < v.size(); ++k) {
            data[k] = new Double(v.get(k).toString());
        }
        this.setDataBuffer(data);
    }

    @Override
    public final void setEntry(int index, double val) {
        this.setEntry(index, (Double)val);
    }

    public final void setEntry(int index, Double val) {
        Double old = ((Double[])this.getDataBuffer())[index];
        ((Double[])this.getDataBuffer())[index] = val;
        this.getPCS().fireIndexedPropertyChange("dataBuffer", index, old, ((Double[])this.getDataBuffer())[index]);
    }

    @Override
    public final double[] getDataValues(GJDataTransformInterface transform) {
        if (this.getDataBuffer() == null) {
            return new double[0];
        }
        double[] arr = new double[((Double[])this.getDataBuffer()).length];
        for (int k = 0; k < arr.length; ++k) {
            arr[k] = ((Double[])this.getDataBuffer())[k];
        }
        return transform.getData(arr);
    }

    @Override
    public final double[] getRawDataValues() {
        if (this.getDataBuffer() == null) {
            return new double[0];
        }
        double[] arr = new double[((Double[])this.getDataBuffer()).length];
        for (int k = 0; k < ((Double[])this.getDataBuffer()).length; ++k) {
            arr[k] = ((Double[])this.getDataBuffer())[k];
        }
        return arr;
    }

    @Override
    public final int getDimension() {
        if (this.getDataBuffer() == null) {
            return 0;
        }
        return ((Double[])this.getDataBuffer()).length;
    }
}

