/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.graphics;

import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import kcl.waterloo.graphics.GJAbstractGraph0;
import kcl.waterloo.graphics.GJAxisPanel;
import kcl.waterloo.graphics.plots2D.GJPlotInterface;
import kcl.waterloo.graphics.transforms.GJDataTransformInterface;
import kcl.waterloo.graphics.transforms.GJDataTransformList;
import kcl.waterloo.graphics.transforms.NOPTransform;
import kcl.waterloo.marker.GJPathSegmentInfo;

public abstract class GJAbstractGraph1
extends GJAbstractGraph0 {
    private final GJDataTransformList transforms = new GJDataTransformList(NOPTransform.getInstance(), NOPTransform.getInstance());

    @Override
    public final GJDataTransformInterface getXTransform() {
        return (GJDataTransformInterface)this.transforms.get(0);
    }

    @Override
    public final void setXTransform(GJDataTransformInterface tr) {
        GJDataTransformInterface old = this.getXTransform();
        if (tr == null) {
            tr = NOPTransform.getInstance();
        }
        if (tr.equals(old)) {
            return;
        }
        this.transforms.set(0, tr);
        this.firePropertyChange("XTransform", old, tr);
    }

    @Override
    public final GJDataTransformInterface getYTransform() {
        return (GJDataTransformInterface)this.transforms.get(1);
    }

    @Override
    public final void setYTransform(GJDataTransformInterface tr) {
        GJDataTransformInterface old = this.getYTransform();
        if (tr == null) {
            tr = NOPTransform.getInstance();
        }
        if (tr.equals(old)) {
            return;
        }
        this.transforms.set(1, tr);
        this.firePropertyChange("YTransform", old, tr);
    }

    public Path2D transformPositionToPixel(Shape s) {
        ArrayList<GJPathSegmentInfo> segments = new ArrayList<GJPathSegmentInfo>();
        double[] d = new double[6];
        PathIterator it = s.getPathIterator(null);
        while (!it.isDone()) {
            int type = it.currentSegment(d);
            segments.add(new GJPathSegmentInfo(type, d));
            it.next();
        }
        Path2D.Double p = new Path2D.Double();
        for (GJPathSegmentInfo segment : segments) {
            switch (segment.getType()) {
                case 0: {
                    ((Path2D)p).moveTo(this.xPositionToPixel(this.getXTransform().getData(segment.getData()[0])), this.yPositionToPixel(this.getYTransform().getData(segment.getData()[1])));
                    break;
                }
                case 1: {
                    ((Path2D)p).lineTo(this.xPositionToPixel(this.getXTransform().getData(segment.getData()[0])), this.yPositionToPixel(this.getYTransform().getData(segment.getData()[1])));
                    break;
                }
                case 2: {
                    ((Path2D)p).quadTo(this.xPositionToPixel(this.getXTransform().getData(segment.getData()[0])), this.yPositionToPixel(this.getYTransform().getData(segment.getData()[1])), this.xPositionToPixel(this.getXTransform().getData(segment.getData()[2])), this.yPositionToPixel(this.getYTransform().getData(segment.getData()[3])));
                    break;
                }
                case 3: {
                    ((Path2D)p).curveTo(this.xPositionToPixel(this.getXTransform().getData(segment.getData()[0])), this.yPositionToPixel(this.getYTransform().getData(segment.getData()[1])), this.xPositionToPixel(this.getXTransform().getData(segment.getData()[2])), this.yPositionToPixel(this.getYTransform().getData(segment.getData()[3])), this.xPositionToPixel(this.getXTransform().getData(segment.getData()[4])), this.yPositionToPixel(this.getYTransform().getData(segment.getData()[5])));
                    break;
                }
                case 4: {
                    p.closePath();
                }
            }
        }
        return p;
    }

    public Path2D transformPixelToPosition(Shape s) {
        ArrayList<GJPathSegmentInfo> segments = new ArrayList<GJPathSegmentInfo>();
        double[] d = new double[6];
        PathIterator it = s.getPathIterator(null);
        while (!it.isDone()) {
            int type = it.currentSegment(d);
            segments.add(new GJPathSegmentInfo(type, d));
            it.next();
        }
        Path2D.Double p = new Path2D.Double();
        for (GJPathSegmentInfo segment : segments) {
            switch (segment.getType()) {
                case 0: {
                    ((Path2D)p).moveTo(this.getXTransform().getData(this.xPositionToPixel(segment.getData()[0])), this.getYTransform().getData(this.yPositionToPixel(segment.getData()[1])));
                    break;
                }
                case 1: {
                    ((Path2D)p).lineTo(this.getXTransform().getData(this.xPositionToPixel(segment.getData()[0])), this.getYTransform().getData(this.yPositionToPixel(segment.getData()[1])));
                    break;
                }
                case 2: {
                    ((Path2D)p).quadTo(this.getXTransform().getData(this.xPositionToPixel(segment.getData()[0])), this.getYTransform().getData(this.yPositionToPixel(segment.getData()[1])), this.getXTransform().getData(this.xPositionToPixel(segment.getData()[2])), this.getYTransform().getData(this.yPositionToPixel(segment.getData()[3])));
                    break;
                }
                case 3: {
                    ((Path2D)p).curveTo(this.getXTransform().getData(this.xPositionToPixel(segment.getData()[0])), this.getYTransform().getData(this.yPositionToPixel(segment.getData()[1])), this.getXTransform().getData(this.xPositionToPixel(segment.getData()[2])), this.getYTransform().getData(this.yPositionToPixel(segment.getData()[3])), this.getXTransform().getData(this.xPositionToPixel(segment.getData()[4])), this.getYTransform().getData(this.yPositionToPixel(segment.getData()[5])));
                    break;
                }
                case 4: {
                    p.closePath();
                }
            }
        }
        return p;
    }

    public Rectangle2D.Double transformPositionToPixel(Rectangle2D r) {
        double x0 = this.xPositionToPixel(this.getXTransform().getData(r.getX()));
        double y0 = this.yPositionToPixel(this.getYTransform().getData(r.getY()));
        double x1 = this.xPositionToPixel(this.getXTransform().getData(r.getX() + r.getWidth()));
        double y1 = this.yPositionToPixel(this.getYTransform().getData(r.getY() + r.getHeight()));
        return this.reflectRectangleAsNeeded(new Rectangle2D.Double(x0, y0, x1 - x0, y0 - y1));
    }

    public Rectangle2D.Double transformPixelToPosition(Rectangle2D r) {
        double x0 = this.getXTransform().getInverse(this.xPixelToPosition(r.getX()));
        double y0 = this.getYTransform().getInverse(this.yPixelToPosition(r.getY()));
        double x1 = this.getXTransform().getInverse(this.xPixelToPosition(r.getX() + r.getWidth()));
        double y1 = this.getYTransform().getInverse(this.yPixelToPosition(r.getY() + r.getHeight()));
        return this.reflectRectangleAsNeeded(new Rectangle2D.Double(x0, y0, x1 - x0, y0 - y1));
    }

    private Rectangle2D.Double reflectRectangleAsNeeded(Rectangle2D.Double r) {
        if (r.getWidth() < 0.0) {
            r.setRect(r.x + r.width, r.y, -r.width, r.height);
        }
        if (r.getHeight() < 0.0) {
            r.setRect(r.x, r.y + r.height, r.width, -r.height);
        }
        return r;
    }

    @Override
    public final double getXAxisLabelRotation(double number) {
        number = this.getXTransform().getInverse(number);
        if (this.isCategorical(GJAxisPanel.Orientation.X)) {
            for (GJPlotInterface p : this.getPlots()) {
                if (p.getXData().getCategories() == null || !p.getXData().getCategories().containsKey(number)) continue;
                return p.getXData().getCategories().get(number).getRotation();
            }
            return 0.0;
        }
        return 0.0;
    }

    @Override
    public final double getYAxisLabelRotation(double number) {
        number = this.getYTransform().getInverse(number);
        if (this.isCategorical(GJAxisPanel.Orientation.X)) {
            for (GJPlotInterface p : this.getPlots()) {
                if (p.getYData().getCategories() == null || !p.getYData().getCategories().containsKey(number)) continue;
                return p.getYData().getCategories().get(number).getRotation();
            }
            return 0.0;
        }
        return 0.0;
    }

    @Override
    public final String formatXAxisLabel(double number) {
        if (this.isCategorical(GJAxisPanel.Orientation.X)) {
            for (GJPlotInterface p : this.getPlots()) {
                if (p.getXData().getCategories() == null || !p.getXData().getCategories().containsKey(this.getXTransform().getInverse(number))) continue;
                return p.getXData().getCategories().get(this.getXTransform().getInverse(number)).getText();
            }
            return "";
        }
        return (String)this.getXTransform().getTickLabel(number);
    }

    @Override
    public final String formatYAxisLabel(double number) {
        if (this.isCategorical(GJAxisPanel.Orientation.Y)) {
            for (GJPlotInterface p : this.getPlots()) {
                if (p.getYData().getCategories() == null || !p.getYData().getCategories().containsKey(this.getYTransform().getInverse(number))) continue;
                return p.getYData().getCategories().get(this.getYTransform().getInverse(number)).getText();
            }
            return "";
        }
        return (String)this.getYTransform().getTickLabel(number);
    }
}

