/*
 * Decompiled with CFR 0.152.
 */
package kcl.waterloo.deploy.gif;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import kcl.waterloo.common.deploy.GJSequencerInterface;
import kcl.waterloo.deploy.gif.GifSequenceWriter;
import kcl.waterloo.logging.CommonLogger;

public class GJGifSequencer
extends GifSequenceWriter
implements GJSequencerInterface,
ActionListener {
    private final Component component;
    private final BufferedImage img;
    private final ByteArrayOutputStream stream;
    private final ImageOutputStream cachedStream;
    private static final CommonLogger logger = new CommonLogger(GJGifSequencer.class);

    private GJGifSequencer(File f, ByteArrayOutputStream stream, ImageOutputStream cachedStream, Component c, int interval, boolean loopFlag) throws IOException {
        super(cachedStream, interval, loopFlag);
        this.stream = stream;
        this.cachedStream = cachedStream;
        this.component = c;
        this.img = new BufferedImage(this.component.getWidth(), this.component.getHeight(), 2);
    }

    public static GJGifSequencer createInstance(String fileName, Component comp, int interval, boolean loopFlag) throws FileNotFoundException, IIOException, IOException {
        File f = new File(fileName);
        FileImageOutputStream cachedStream = new FileImageOutputStream(f);
        return new GJGifSequencer(f, null, cachedStream, comp, interval, loopFlag);
    }

    public static GJGifSequencer createInstance(Component comp, int interval, boolean loopFlag) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream cachedStream = new MemoryCacheImageOutputStream(stream);
        return new GJGifSequencer(null, stream, cachedStream, comp, interval, loopFlag);
    }

    @Override
    public void add() throws IOException {
        try {
            this.component.paint(this.img.getGraphics());
            this.writeToSequence(this.img);
        }
        catch (IllegalStateException ex) {
            logger.error("IllegalStateException: has the writer been closed before stopping a timer?");
        }
        catch (IllegalArgumentException ex) {
            logger.error("IllegalArgumentException: no image data available?");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.cachedStream instanceof FileImageOutputStream) {
            super.close();
            this.cachedStream.close();
        } else {
            logger.error("Using a MemoryCacheImageOutputStream: use close(filename)");
        }
    }

    public void close(String filename) throws IOException {
        if (filename != null && !filename.isEmpty()) {
            if (this.stream != null) {
                super.close();
                this.cachedStream.close();
                FileOutputStream newStream = new FileOutputStream(new File(filename));
                this.stream.writeTo(newStream);
                this.stream.close();
                newStream.close();
            }
        } else {
            logger.debug("Filename must be specified");
        }
    }

    public boolean isMemoryCached() {
        return this.cachedStream instanceof MemoryCacheImageOutputStream;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.add();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

