/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.symbolic;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Random;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.SimpleLayout;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.GPFitnessFunction;
import org.jgap.gp.GPProblem;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.function.ADF;
import org.jgap.gp.function.Abs;
import org.jgap.gp.function.Add;
import org.jgap.gp.function.Add3;
import org.jgap.gp.function.Add4;
import org.jgap.gp.function.And;
import org.jgap.gp.function.ArcCosine;
import org.jgap.gp.function.ArcSine;
import org.jgap.gp.function.ArcTangent;
import org.jgap.gp.function.Ceil;
import org.jgap.gp.function.Cosine;
import org.jgap.gp.function.Divide;
import org.jgap.gp.function.Equals;
import org.jgap.gp.function.Exp;
import org.jgap.gp.function.Floor;
import org.jgap.gp.function.ForLoop;
import org.jgap.gp.function.ForXLoop;
import org.jgap.gp.function.GreaterThan;
import org.jgap.gp.function.If;
import org.jgap.gp.function.IfDyn;
import org.jgap.gp.function.IfElse;
import org.jgap.gp.function.Increment;
import org.jgap.gp.function.LesserThan;
import org.jgap.gp.function.Log;
import org.jgap.gp.function.Loop;
import org.jgap.gp.function.Max;
import org.jgap.gp.function.Min;
import org.jgap.gp.function.Modulo;
import org.jgap.gp.function.Multiply;
import org.jgap.gp.function.Multiply3;
import org.jgap.gp.function.Not;
import org.jgap.gp.function.Or;
import org.jgap.gp.function.Pop;
import org.jgap.gp.function.Pow;
import org.jgap.gp.function.Push;
import org.jgap.gp.function.Round;
import org.jgap.gp.function.Sine;
import org.jgap.gp.function.StoreTerminal;
import org.jgap.gp.function.SubProgram;
import org.jgap.gp.function.Subtract;
import org.jgap.gp.function.Tangent;
import org.jgap.gp.function.Tupel;
import org.jgap.gp.function.Xor;
import org.jgap.gp.impl.DeltaGPFitnessEvaluator;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.GPGenotype;
import org.jgap.gp.impl.GPPopulation;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.gp.impl.TournamentSelector;
import org.jgap.gp.terminal.Constant;
import org.jgap.gp.terminal.Terminal;
import org.jgap.gp.terminal.Variable;
import org.jgap.symbolic.AndD;
import org.jgap.symbolic.Cube;
import org.jgap.symbolic.DifferentD;
import org.jgap.symbolic.DivideIntD;
import org.jgap.symbolic.DivideProtected;
import org.jgap.symbolic.EqualsD;
import org.jgap.symbolic.ForLoopD;
import org.jgap.symbolic.Gamma;
import org.jgap.symbolic.Gaussian;
import org.jgap.symbolic.GreaterThanD;
import org.jgap.symbolic.GreaterThanOrEqualD;
import org.jgap.symbolic.Hill;
import org.jgap.symbolic.Id;
import org.jgap.symbolic.IfElseD;
import org.jgap.symbolic.IfLessThanOrEqualD;
import org.jgap.symbolic.IfLessThanOrEqualZeroD;
import org.jgap.symbolic.LesserThanD;
import org.jgap.symbolic.LesserThanOrEqualD;
import org.jgap.symbolic.Logistic;
import org.jgap.symbolic.LoopD;
import org.jgap.symbolic.ModuloD;
import org.jgap.symbolic.ModuloReplaceD;
import org.jgap.symbolic.NotD;
import org.jgap.symbolic.OrD;
import org.jgap.symbolic.RoundD;
import org.jgap.symbolic.Sigmoid;
import org.jgap.symbolic.Sign;
import org.jgap.symbolic.Sqrt;
import org.jgap.symbolic.Square;
import org.jgap.symbolic.Step;
import org.jgap.symbolic.XorD;
import org.jgap.util.NumberKit;
import org.jgap.util.SystemKit;

public class SymbolicRegression
extends GPProblem {
    private static transient Logger LOGGER = Logger.getLogger(SymbolicRegression.class);
    public static int numInputVariables;
    public static Variable[] variables;
    public static String[] variableNames;
    public static Integer outputVariable;
    public static int[] ignoreVariables;
    public static ArrayList<Double> constants;
    public static int numRows;
    protected static Double[][] data;
    public static boolean foundPerfect;
    public static int minInitDepth;
    public static int maxInitDepth;
    public static int populationSize;
    public static int maxCrossoverDepth;
    public static int programCreationMaxTries;
    public static int numEvolutions;
    public static boolean verboseOutput;
    public static int maxNodes;
    public static double functionProb;
    public static float reproductionProb;
    public static float mutationProb;
    public static float crossoverProb;
    public static float dynamizeArityProb;
    public static double newChromsPercent;
    public static int tournamentSelectorSize;
    public static boolean noCommandGeneCloning;
    public static boolean strictProgramCreation;
    public static boolean useProgramCache;
    public static double lowerRange;
    public static double upperRange;
    public static boolean terminalWholeNumbers;
    public static String returnType;
    public static String presentation;
    public static int adfArity;
    public static String adfType;
    public static boolean useADF;
    public static String[] functions;
    public static String[] adfFunctions;
    public static double scaleError;
    public static long startTime;
    public static long endTime;
    public static double stopCriteriaFitness;
    public static boolean showPopulation;
    public static boolean showSimiliar;
    public static String similiarSortMethod;
    public static boolean showProgression;
    public static boolean showAllGenerations;
    public static boolean showResults;
    public static int resultPrecision;
    public static double samplePCT;
    public static double hitsCriteria;
    public static double validationPCT;
    protected static Double[][] validationSet;
    public static Double[][] testData;
    public static int modReplace;
    public static boolean makeTimeSeries;
    public static boolean makeTimeSeriesWithIndex;
    public static String errorMethod;
    public static boolean noTerminals;
    public static int minNodes;
    public static double minNodesPenalty;
    public static boolean alldifferentVariables;
    public static double alldifferentVariablesPenalty;

    public SymbolicRegression(GPConfiguration a_conf) throws InvalidConfigurationException {
        super(a_conf);
    }

    @Override
    public GPGenotype create() throws InvalidConfigurationException {
        int i;
        int[] maxDepths;
        int[] minDepths;
        Class[][] argTypes;
        Class[] types;
        GPConfiguration conf = this.getGPConfiguration();
        if (useADF) {
            types = "boolean".equals(adfType) ? new Class[]{CommandGene.DoubleClass, CommandGene.BooleanClass} : ("integer".equals(adfType) ? new Class[]{CommandGene.DoubleClass, CommandGene.IntegerClass} : new Class[]{CommandGene.DoubleClass, CommandGene.DoubleClass});
            Class[] adfs = new Class[adfArity];
            for (int i2 = 0; i2 < adfArity; ++i2) {
                adfs[i2] = "boolean".equals(adfType) ? CommandGene.BooleanClass : ("integer".equals(adfType) ? CommandGene.IntegerClass : CommandGene.DoubleClass);
            }
            argTypes = new Class[][]{new Class[0], adfs};
        } else {
            types = new Class[]{CommandGene.DoubleClass};
            argTypes = new Class[][]{new Class[0]};
        }
        if (useADF) {
            minDepths = new int[]{1, 1};
            maxDepths = new int[]{9, 9};
        } else {
            minDepths = new int[]{1};
            maxDepths = new int[]{9};
        }
        CommandGene[] commands = SymbolicRegression.makeCommands(conf, functions, lowerRange, upperRange, "plain");
        int command_len = commands.length;
        CommandGene[][] nodeSets = new CommandGene[2][numInputVariables + command_len];
        variables = new Variable[numInputVariables];
        int variableIndex = 0;
        for (i = 0; i < numInputVariables + 1; ++i) {
            String variableName = variableNames[i];
            if (i == outputVariable) continue;
            if (variableNames != null && variableNames.length > 0) {
                variableName = variableNames[i];
            }
            SymbolicRegression.variables[variableIndex] = Variable.create(conf, variableName, CommandGene.DoubleClass);
            nodeSets[0][variableIndex] = variables[variableIndex];
            System.out.println("input variable: " + variables[variableIndex]);
            ++variableIndex;
        }
        for (i = 0; i < command_len; ++i) {
            System.out.println("function1: " + commands[i]);
            nodeSets[0][i + SymbolicRegression.numInputVariables] = commands[i];
        }
        if (useADF) {
            CommandGene[] adfCommands = SymbolicRegression.makeCommands(conf, adfFunctions, lowerRange, upperRange, "ADF");
            int adfLength = adfCommands.length;
            nodeSets[1] = new CommandGene[adfLength];
            for (int i3 = 0; i3 < adfLength; ++i3) {
                System.out.println("ADF function: " + adfCommands[i3]);
                nodeSets[1][i3] = adfCommands[i3];
            }
        }
        boolean[] full = useADF ? new boolean[]{true, true} : new boolean[]{true};
        boolean[] fullModeAllowed = full;
        return GPGenotype.randomInitialGenotype(conf, types, argTypes, nodeSets, maxNodes, verboseOutput);
    }

    public static void readFile(String file) {
        try {
            int j;
            Double[] this_row;
            int i;
            int r_v;
            int i2;
            String str;
            BufferedReader inr = new BufferedReader(new FileReader(file));
            int lineCount = 0;
            boolean gotData = false;
            ArrayList<Double[]> theData = new ArrayList<Double[]>();
            ArrayList<Double[]> theValidationSet = new ArrayList<Double[]>();
            ArrayList<Double[]> theTestData = new ArrayList<Double[]>();
            while ((str = inr.readLine()) != null) {
                ++lineCount;
                if ((str = str.trim()).startsWith("#") || str.startsWith("%") || str.length() == 0) continue;
                if ("data".equals(str)) {
                    gotData = true;
                    continue;
                }
                if (gotData) {
                    Random randomGenerator;
                    float rand;
                    String[] dataRowStr = str.split("[\\s,]+");
                    int len = dataRowStr.length;
                    Double[] dataRow = new Double[len];
                    boolean isTestData = false;
                    for (i2 = 0; i2 < len; ++i2) {
                        if ("?".equals(dataRowStr[i2])) {
                            isTestData = true;
                            dataRow[i2] = -1.0;
                            continue;
                        }
                        dataRow[i2] = Double.parseDouble(dataRowStr[i2]);
                    }
                    boolean inData = true;
                    if (isTestData) {
                        inData = false;
                        theTestData.add(dataRow);
                    }
                    if (!isTestData && samplePCT > 0.0 && (double)(rand = (randomGenerator = new Random()).nextFloat()) > samplePCT) {
                        inData = false;
                    }
                    if (!isTestData && validationPCT > 0.0 && (double)(rand = (randomGenerator = new Random()).nextFloat()) < validationPCT) {
                        inData = false;
                        theValidationSet.add(dataRow);
                    }
                    if (!inData) continue;
                    theData.add(dataRow);
                    continue;
                }
                if (!str.contains(":")) continue;
                String[] row = str.split(":\\s*");
                if ("return_type".equals(row[0])) {
                    returnType = row[1];
                    continue;
                }
                if ("presentation".equals(row[0])) {
                    presentation = row[1];
                    continue;
                }
                if ("num_input_variables".equals(row[0])) {
                    numInputVariables = Integer.parseInt(row[1]);
                    continue;
                }
                if ("num_rows".equals(row[0])) {
                    System.out.println("num_rows is not used anymore; it is calculated by the program.");
                    continue;
                }
                if ("terminal_range".equals(row[0])) {
                    String[] ranges = row[1].split("\\s+");
                    lowerRange = Double.parseDouble(ranges[0]);
                    upperRange = Double.parseDouble(ranges[1]);
                    continue;
                }
                if ("terminal_wholenumbers".equals(row[0])) {
                    terminalWholeNumbers = Boolean.parseBoolean(row[1]);
                    continue;
                }
                if ("max_init_depth".equals(row[0])) {
                    maxInitDepth = Integer.parseInt(row[1]);
                    continue;
                }
                if ("min_init_depth".equals(row[0])) {
                    minInitDepth = Integer.parseInt(row[1]);
                    continue;
                }
                if ("program_creation_max_tries".equals(row[0])) {
                    programCreationMaxTries = Integer.parseInt(row[1]);
                    continue;
                }
                if ("population_size".equals(row[0])) {
                    populationSize = Integer.parseInt(row[1]);
                    continue;
                }
                if ("max_crossover_depth".equals(row[0])) {
                    maxCrossoverDepth = Integer.parseInt(row[1]);
                    continue;
                }
                if ("function_prob".equals(row[0])) {
                    functionProb = Double.parseDouble(row[1]);
                    continue;
                }
                if ("reproduction_prob".equals(row[0])) {
                    reproductionProb = Float.parseFloat(row[1]);
                    continue;
                }
                if ("mutation_prob".equals(row[0])) {
                    mutationProb = Float.parseFloat(row[1]);
                    continue;
                }
                if ("crossover_prob".equals(row[0])) {
                    crossoverProb = Float.parseFloat(row[1]);
                    continue;
                }
                if ("dynamize_arity_prob".equals(row[0])) {
                    dynamizeArityProb = Float.parseFloat(row[1]);
                    continue;
                }
                if ("new_chroms_percent".equals(row[0])) {
                    newChromsPercent = Double.parseDouble(row[1]);
                    continue;
                }
                if ("num_evolutions".equals(row[0])) {
                    numEvolutions = Integer.parseInt(row[1]);
                    continue;
                }
                if ("max_nodes".equals(row[0])) {
                    maxNodes = Integer.parseInt(row[1]);
                    continue;
                }
                if ("functions".equals(row[0])) {
                    functions = row[1].split("[\\s,]+");
                    continue;
                }
                if ("adf_functions".equals(row[0])) {
                    adfFunctions = row[1].split("[\\s,]+");
                    continue;
                }
                if ("variable_names".equals(row[0])) {
                    variableNames = row[1].split("[\\s,]+");
                    continue;
                }
                if ("output_variable".equals(row[0])) {
                    outputVariable = Integer.parseInt(row[1]);
                    continue;
                }
                if ("ignore_variables".equals(row[0])) {
                    String[] ignoreVariablesS = row[1].split("[\\s,]+");
                    ignoreVariables = new int[ignoreVariablesS.length];
                    for (int i3 = 0; i3 < ignoreVariablesS.length; ++i3) {
                        SymbolicRegression.ignoreVariables[i3] = Integer.parseInt(ignoreVariablesS[i3]);
                    }
                    continue;
                }
                if ("constant".equals(row[0])) {
                    Double constant = Double.parseDouble(row[1]);
                    constants.add(constant);
                    continue;
                }
                if ("adf_arity".equals(row[0])) {
                    adfArity = Integer.parseInt(row[1]);
                    System.out.println("ADF arity " + adfArity);
                    if (adfArity <= 0) continue;
                    useADF = true;
                    continue;
                }
                if ("adf_type".equals(row[0])) {
                    adfType = row[1];
                    continue;
                }
                if ("tournament_selector_size".equals(row[0])) {
                    tournamentSelectorSize = Integer.parseInt(row[1]);
                    continue;
                }
                if ("scale_error".equals(row[0])) {
                    scaleError = Double.parseDouble(row[1]);
                    continue;
                }
                if ("stop_criteria_fitness".equals(row[0])) {
                    stopCriteriaFitness = Double.parseDouble(row[1]);
                    continue;
                }
                if ("show_population".equals(row[0])) {
                    showPopulation = Boolean.parseBoolean(row[1]);
                    continue;
                }
                if ("show_similiar".equals(row[0]) || "show_similar".equals(row[0])) {
                    showSimiliar = Boolean.parseBoolean(row[1]);
                    continue;
                }
                if ("similiar_sort_method".equals(row[0]) || "similar_sort_method".equals(row[0])) {
                    similiarSortMethod = row[1];
                    if ("length".equals(similiarSortMethod) || "occurrence".equals(similiarSortMethod)) continue;
                    System.out.println("Unknown similiar_sort_method: " + similiarSortMethod);
                    System.exit(1);
                    continue;
                }
                if ("show_progression".equals(row[0])) {
                    showProgression = Boolean.parseBoolean(row[1]);
                    continue;
                }
                if ("sample_pct".equals(row[0])) {
                    samplePCT = Float.parseFloat(row[1]);
                    continue;
                }
                if ("validation_pct".equals(row[0])) {
                    validationPCT = Float.parseFloat(row[1]);
                    continue;
                }
                if ("hits_criteria".equals(row[0])) {
                    hitsCriteria = Double.parseDouble(row[1]);
                    errorMethod = "hitsCriteria";
                    continue;
                }
                if ("show_all_generations".equals(row[0])) {
                    showAllGenerations = Boolean.parseBoolean(row[1]);
                    continue;
                }
                if ("strict_program_creation".equals(row[0])) {
                    strictProgramCreation = Boolean.parseBoolean(row[1]);
                    continue;
                }
                if ("no_command_gene_cloning".equals(row[0])) {
                    noCommandGeneCloning = Boolean.parseBoolean(row[1]);
                    continue;
                }
                if ("use_program_cache".equals(row[0])) {
                    useProgramCache = Boolean.parseBoolean(row[1]);
                    continue;
                }
                if ("mod_replace".equals(row[0])) {
                    modReplace = Integer.parseInt(row[1]);
                    continue;
                }
                if ("show_results".equals(row[0])) {
                    showResults = Boolean.parseBoolean(row[1]);
                    continue;
                }
                if ("result_precision".equals(row[0])) {
                    resultPrecision = Integer.parseInt(row[1]);
                    continue;
                }
                if ("error_method".equals(row[0])) {
                    errorMethod = row[1];
                    if ("maxError".equals(errorMethod) || "minError".equals(errorMethod) || "medianError".equals(errorMethod) || "meanError".equals(errorMethod) || "totalError".equals(errorMethod)) continue;
                    System.out.println("Unknown errorMethod: " + errorMethod);
                    System.exit(1);
                    continue;
                }
                if ("no_terminals".equals(row[0])) {
                    noTerminals = Boolean.parseBoolean(row[1]);
                    continue;
                }
                if ("make_time_series".equals(row[0])) {
                    makeTimeSeries = Boolean.parseBoolean(row[1]);
                    continue;
                }
                if ("make_time_series_with_index".equals(row[0])) {
                    makeTimeSeriesWithIndex = Boolean.parseBoolean(row[1]);
                    continue;
                }
                if ("min_nodes".equals(row[0])) {
                    String[] opt = row[1].split("[\\s,]+");
                    minNodes = Integer.parseInt(opt[0]);
                    if (minNodes > maxNodes) {
                        System.out.println("minNodes (" + minNodes + ") >  maxNodes (" + maxNodes + ") which is weird. Cannot continue. ");
                        System.exit(1);
                    }
                    minNodesPenalty = Integer.parseInt(opt[1]);
                    continue;
                }
                if ("alldifferent_variables".equals(row[0])) {
                    String[] opt = row[1].split("[\\s,]+");
                    alldifferentVariables = Boolean.parseBoolean(opt[0]);
                    alldifferentVariablesPenalty = Double.parseDouble(opt[1]);
                    continue;
                }
                System.out.println("Unknown keyword: " + row[0] + " on line " + lineCount);
                System.exit(1);
            }
            inr.close();
            if (makeTimeSeries || makeTimeSeriesWithIndex) {
                ArrayList<Double[]> theDataNew = new ArrayList<Double[]>();
                Double[] dat = (Double[])theData.get(0);
                int numElements = dat.length;
                System.out.println("Making timeseries, #elements: " + numElements);
                int cols = numInputVariables + 1;
                if (makeTimeSeriesWithIndex) {
                    ++cols;
                }
                for (i2 = 0; i2 < numElements - cols; ++i2) {
                    Double[] tmp = new Double[cols];
                    int jStart = 0;
                    if (makeTimeSeriesWithIndex) {
                        System.out.print(i2 + 1 + " ");
                        tmp[0] = (double)i2 + 1.0;
                        jStart = 1;
                    }
                    for (int j2 = jStart; j2 < cols; ++j2) {
                        System.out.print(dat[i2 + j2] + " ");
                        tmp[j2] = dat[i2 + j2];
                    }
                    System.out.println();
                    theDataNew.add(tmp);
                }
                theData = theDataNew;
            }
            int r = theData.size();
            int c = ((Double[])theData.get(0)).length;
            int numIgnore = 0;
            if (ignoreVariables != null) {
                numIgnore = ignoreVariables.length;
            }
            Double[][] dataTmp = new Double[r][c];
            for (i2 = 0; i2 < r; ++i2) {
                Double[] this_row2 = (Double[])theData.get(i2);
                for (int j3 = 0; j3 < c; ++j3) {
                    dataTmp[i2][j3] = this_row2[j3];
                }
            }
            data = SymbolicRegression.transposeMatrix(dataTmp);
            numRows = data[0].length;
            System.out.println("It was " + numRows + " data rows");
            if (validationPCT > 0.0 && theValidationSet != null && theValidationSet.size() > 0) {
                r_v = theValidationSet.size();
                int c_v = ((Double[])theValidationSet.get(0)).length;
                Double[][] dataTmp_v = new Double[r_v][c_v];
                for (i = 0; i < r_v; ++i) {
                    this_row = (Double[])theValidationSet.get(i);
                    for (j = 0; j < c_v; ++j) {
                        dataTmp_v[i][j] = this_row[j];
                    }
                }
                validationSet = SymbolicRegression.transposeMatrix(dataTmp_v);
                System.out.println("It was " + validationSet[0].length + " data rows in the validation data set");
            }
            if (theTestData.size() > 0) {
                r_v = theTestData.size();
                int c_v = ((Double[])theTestData.get(0)).length;
                Double[][] dataTmp_v = new Double[r_v][c_v];
                for (i = 0; i < r_v; ++i) {
                    this_row = (Double[])theTestData.get(i);
                    for (j = 0; j < c_v; ++j) {
                        dataTmp_v[i][j] = this_row[j];
                    }
                }
                testData = dataTmp_v;
                System.out.println("It was " + testData.length + " data rows in the user defined data set");
            }
        }
        catch (IOException e) {
            System.out.println(e);
            System.exit(1);
        }
    }

    public static Double[][] transposeMatrix(Double[][] m) {
        int r = m.length;
        int c = m[0].length;
        Double[][] t = new Double[c][r];
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                t[j][i] = m[i][j];
            }
        }
        return t;
    }

    static CommandGene[] makeCommands(GPConfiguration conf, String[] functions, Double lowerRange, Double upperRange, String type) {
        ArrayList<CommandGene> commandsList = new ArrayList<CommandGene>();
        int len = functions.length;
        boolean isADF = "ADF".equals(type);
        try {
            int i;
            for (i = 0; i < len; ++i) {
                if ("Multiply".equals(functions[i])) {
                    commandsList.add(new Multiply(conf, CommandGene.DoubleClass));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Multiply(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("Multiply3".equals(functions[i])) {
                    commandsList.add(new Multiply3(conf, CommandGene.DoubleClass));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Multiply3(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("Add".equals(functions[i])) {
                    commandsList.add(new Add(conf, CommandGene.DoubleClass));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Add(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("Divide".equals(functions[i])) {
                    commandsList.add(new Divide(conf, CommandGene.DoubleClass));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Divide(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("DivideIntD".equals(functions[i])) {
                    commandsList.add(new DivideIntD(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("DivideProtected".equals(functions[i])) {
                    commandsList.add(new DivideProtected(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Add3".equals(functions[i])) {
                    commandsList.add(new Add3(conf, CommandGene.DoubleClass));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Add3(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("Add4".equals(functions[i])) {
                    commandsList.add(new Add4(conf, CommandGene.DoubleClass));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Add4(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("Subtract".equals(functions[i])) {
                    commandsList.add(new Subtract(conf, CommandGene.DoubleClass));
                    if (!useADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Subtract(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("Sine".equals(functions[i])) {
                    commandsList.add(new Sine(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("ArcSine".equals(functions[i])) {
                    commandsList.add(new ArcSine(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Tangent".equals(functions[i])) {
                    commandsList.add(new Tangent(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("ArcTangent".equals(functions[i])) {
                    commandsList.add(new ArcTangent(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Cosine".equals(functions[i])) {
                    commandsList.add(new Cosine(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("ArcCosine".equals(functions[i])) {
                    commandsList.add(new ArcCosine(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Exp".equals(functions[i])) {
                    commandsList.add(new Exp(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Log".equals(functions[i])) {
                    commandsList.add(new Log(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Abs".equals(functions[i])) {
                    commandsList.add(new Abs(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Pow".equals(functions[i])) {
                    commandsList.add(new Pow(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Round".equals(functions[i])) {
                    commandsList.add(new Round(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("RoundD".equals(functions[i])) {
                    commandsList.add(new RoundD(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Ceil".equals(functions[i])) {
                    commandsList.add(new Ceil(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Floor".equals(functions[i])) {
                    commandsList.add(new Floor(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Modulo".equals(functions[i])) {
                    commandsList.add(new Modulo(conf, CommandGene.DoubleClass));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Modulo(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("ModuloD".equals(functions[i])) {
                    commandsList.add(new ModuloD(conf, CommandGene.DoubleClass));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new ModuloD(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("ModuloReplaceD".equals(functions[i])) {
                    commandsList.add(new ModuloReplaceD(conf, CommandGene.DoubleClass, modReplace));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new ModuloReplaceD(conf, CommandGene.BooleanClass, modReplace));
                    continue;
                }
                if ("Max".equals(functions[i])) {
                    commandsList.add(new Max(conf, CommandGene.DoubleClass));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Max(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("Min".equals(functions[i])) {
                    commandsList.add(new Min(conf, CommandGene.DoubleClass));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Min(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("Sqrt".equals(functions[i])) {
                    commandsList.add(new Sqrt(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Square".equals(functions[i])) {
                    commandsList.add(new Square(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Cube".equals(functions[i])) {
                    commandsList.add(new Cube(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Logistic".equals(functions[i])) {
                    commandsList.add(new Logistic(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Gaussian".equals(functions[i])) {
                    commandsList.add(new Gaussian(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Sigmoid".equals(functions[i])) {
                    commandsList.add(new Sigmoid(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Gamma".equals(functions[i])) {
                    commandsList.add(new Gamma(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Step".equals(functions[i])) {
                    commandsList.add(new Step(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Sign".equals(functions[i])) {
                    commandsList.add(new Sign(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("Hill".equals(functions[i])) {
                    commandsList.add(new Hill(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("LesserThan".equals(functions[i])) {
                    commandsList.add(new LesserThan(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("LesserThanD".equals(functions[i])) {
                    commandsList.add(new LesserThanD(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("LesserThanOrEqualD".equals(functions[i])) {
                    commandsList.add(new LesserThanOrEqualD(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("GreaterThan".equals(functions[i])) {
                    commandsList.add(new GreaterThan(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("GreaterThanD".equals(functions[i])) {
                    commandsList.add(new GreaterThanD(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("GreaterThanOrEqualD".equals(functions[i])) {
                    commandsList.add(new GreaterThanOrEqualD(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("DifferentD".equals(functions[i])) {
                    commandsList.add(new DifferentD(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("If".equals(functions[i])) {
                    commandsList.add(new If(conf, CommandGene.DoubleClass));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new If(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("IfElse".equals(functions[i])) {
                    commandsList.add(new IfElse(conf, CommandGene.DoubleClass));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new IfElse(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("IfElseD".equals(functions[i])) {
                    commandsList.add(new IfElseD(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("IfLessThanOrEqualD".equals(functions[i])) {
                    commandsList.add(new IfLessThanOrEqualD(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("IfLessThanOrEqualZeroD".equals(functions[i])) {
                    commandsList.add(new IfLessThanOrEqualZeroD(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("IfDyn".equals(functions[i])) {
                    commandsList.add(new IfDyn(conf, CommandGene.DoubleClass, 1, 1, 5));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new IfDyn(conf, CommandGene.DoubleClass, 1, 1, 5));
                    continue;
                }
                if ("Loop".equals(functions[i])) {
                    commandsList.add(new Loop(conf, CommandGene.DoubleClass, 3));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Loop(conf, CommandGene.BooleanClass, 3));
                    continue;
                }
                if ("LoopD".equals(functions[i])) {
                    commandsList.add(new LoopD(conf, CommandGene.DoubleClass, numInputVariables));
                    continue;
                }
                if ("Equals".equals(functions[i])) {
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Equals(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("EqualsD".equals(functions[i])) {
                    commandsList.add(new EqualsD(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("ForXLoop".equals(functions[i])) {
                    commandsList.add(new ForXLoop(conf, CommandGene.IntegerClass));
                    if (isADF && "boolean".equals(adfType)) {
                        commandsList.add(new ForXLoop(conf, CommandGene.BooleanClass));
                        continue;
                    }
                    if (!useADF || !"integer".equals(adfType)) continue;
                    commandsList.add(new ForXLoop(conf, CommandGene.IntegerClass));
                    continue;
                }
                if ("ForLoop".equals(functions[i])) {
                    commandsList.add(new ForLoop(conf, CommandGene.DoubleClass, 1, numInputVariables));
                    if (isADF && "boolean".equals(adfType)) {
                        commandsList.add(new ForLoop(conf, CommandGene.BooleanClass, 10));
                        continue;
                    }
                    if (!isADF || !"integer".equals(adfType)) continue;
                    commandsList.add(new ForLoop(conf, CommandGene.IntegerClass, 10));
                    continue;
                }
                if ("ForLoopD".equals(functions[i])) {
                    commandsList.add(new ForLoopD(conf, CommandGene.DoubleClass, numInputVariables * 2));
                    continue;
                }
                if ("Increment".equals(functions[i])) {
                    commandsList.add(new Increment(conf, CommandGene.DoubleClass));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Increment(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("Argument".equals(functions[i])) continue;
                if ("StoreTerminal".equals(functions[i])) {
                    commandsList.add(new StoreTerminal(conf, "dmem0", CommandGene.DoubleClass));
                    commandsList.add(new StoreTerminal(conf, "dmem1", CommandGene.DoubleClass));
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new StoreTerminal(conf, "bmem0", CommandGene.DoubleClass));
                    commandsList.add(new StoreTerminal(conf, "bmem1", CommandGene.DoubleClass));
                    continue;
                }
                if ("Pop".equals(functions[i])) {
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Pop(conf, CommandGene.BooleanClass));
                    continue;
                }
                if ("Push".equals(functions[i])) {
                    commandsList.add(new Push(conf, CommandGene.DoubleClass));
                    continue;
                }
                if ("And".equals(functions[i])) {
                    commandsList.add(new And(conf));
                    continue;
                }
                if ("Or".equals(functions[i])) {
                    commandsList.add(new Or(conf));
                    continue;
                }
                if ("Xor".equals(functions[i])) {
                    commandsList.add(new Xor(conf));
                    continue;
                }
                if ("Not".equals(functions[i])) {
                    commandsList.add(new Not(conf));
                    continue;
                }
                if ("AndD".equals(functions[i])) {
                    commandsList.add(new AndD(conf));
                    continue;
                }
                if ("OrD".equals(functions[i])) {
                    commandsList.add(new OrD(conf));
                    continue;
                }
                if ("XorD".equals(functions[i])) {
                    commandsList.add(new XorD(conf));
                    continue;
                }
                if ("NotD".equals(functions[i])) {
                    commandsList.add(new NotD(conf));
                    continue;
                }
                if ("Id".equals(functions[i])) {
                    commandsList.add(new Id(conf));
                    continue;
                }
                if ("SubProgram".equals(functions[i])) {
                    if (isADF && "boolean".equals(adfType)) {
                        commandsList.add(new SubProgram(conf, new Class[]{CommandGene.BooleanClass, CommandGene.BooleanClass}));
                        commandsList.add(new SubProgram(conf, new Class[]{CommandGene.BooleanClass, CommandGene.BooleanClass, CommandGene.BooleanClass}));
                    }
                    commandsList.add(new SubProgram(conf, new Class[]{CommandGene.DoubleClass, CommandGene.DoubleClass}));
                    commandsList.add(new SubProgram(conf, new Class[]{CommandGene.DoubleClass, CommandGene.DoubleClass, CommandGene.DoubleClass}));
                    continue;
                }
                if ("Tupel".equals(functions[i])) {
                    if (!isADF || !"boolean".equals(adfType)) continue;
                    commandsList.add(new Tupel(conf, new Class[]{CommandGene.BooleanClass, CommandGene.BooleanClass}));
                    continue;
                }
                System.out.println("Unkown function: " + functions[i]);
                System.exit(1);
            }
            if (!noTerminals) {
                commandsList.add(new Terminal(conf, CommandGene.DoubleClass, lowerRange, upperRange, terminalWholeNumbers));
            }
            if (useADF && !"ADF".equals(type)) {
                commandsList.add(new ADF(conf, 1, adfArity));
            }
            if (constants != null) {
                for (i = 0; i < constants.size(); ++i) {
                    Double constant = constants.get(i);
                    commandsList.add(new Constant(conf, CommandGene.DoubleClass, constant));
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        CommandGene[] commands = new CommandGene[commandsList.size()];
        commandsList.toArray(commands);
        return commands;
    }

    public static void main(String[] args) throws Exception {
        PropertyConfigurator.configure((String)"log4j.properties");
        LOGGER.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        if (args.length > 0) {
            SymbolicRegression.readFile(args[0]);
        } else {
            numRows = 21;
            numInputVariables = 3;
            int[][] indata = new int[][]{{1, 1, 2, 3, 5, 8, 13, 21, 34, 55, 89, 144, 233, 377, 610, 987, 1597, 2584, 4181, 6765, 10946}, {1, 2, 3, 5, 8, 13, 21, 34, 55, 89, 144, 233, 377, 610, 987, 1597, 2584, 4181, 6765, 10946, 17711}, {2, 3, 5, 8, 13, 21, 34, 55, 89, 144, 233, 377, 610, 987, 1597, 2584, 4181, 6765, 10946, 17711, 28657}, {3, 5, 8, 13, 21, 34, 55, 89, 144, 233, 377, 610, 987, 1597, 2584, 4181, 6765, 10946, 17711, 28657, 46368}};
            data = new Double[numInputVariables + 1][numRows];
            for (int i = 0; i < numInputVariables + 1; ++i) {
                for (int j = 0; j < numRows; ++j) {
                    SymbolicRegression.data[i][j] = new Double(indata[i][j]);
                }
            }
            populationSize = 100;
            numEvolutions = 100;
            functions = "Multiply,Divide,Add,Subtract".split(",");
            variableNames = "F1,F2,F3,F4".split(",");
            presentation = "Fibonacci series";
        }
        System.out.println("Presentation: " + presentation);
        if (outputVariable == null) {
            outputVariable = numInputVariables;
        }
        if (variableNames == null) {
            variableNames = new String[numInputVariables + 1];
            for (int i = 0; i < numInputVariables + 1; ++i) {
                SymbolicRegression.variableNames[i] = "V" + (i + 1);
            }
        }
        System.out.println("output_variable: " + variableNames[outputVariable] + " (index: " + outputVariable + ")");
        GPConfiguration config = new GPConfiguration();
        config.setGPFitnessEvaluator(new DeltaGPFitnessEvaluator());
        config.setMaxInitDepth(maxInitDepth);
        config.setPopulationSize(populationSize);
        if (tournamentSelectorSize > 0) {
            config.setSelectionMethod(new TournamentSelector(tournamentSelectorSize));
        }
        config.setMaxCrossoverDepth(maxCrossoverDepth);
        config.setFitnessFunction(new FormulaFitnessFunction());
        config.setStrictProgramCreation(strictProgramCreation);
        config.setNoCommandGeneCloning(noCommandGeneCloning);
        config.setUseProgramCache(useProgramCache);
        config.setFunctionProb(functionProb);
        config.setReproductionProb(reproductionProb);
        config.setCrossoverProb(crossoverProb);
        config.setMutationProb(mutationProb);
        config.setDynamizeArityProb(dynamizeArityProb);
        config.setNewChromsPercent(newChromsPercent);
        config.setMinInitDepth(minInitDepth);
        config.setProgramCreationMaxTries(programCreationMaxTries);
        SymbolicRegression problem = new SymbolicRegression(config);
        GPGenotype gp = ((GPProblem)problem).create();
        gp.setVerboseOutput(false);
        startTime = System.currentTimeMillis();
        System.out.println("Creating initial population");
        IGPProgram fittest = null;
        double bestFit = -1.0;
        String bestProgram = "";
        int bestGen = 0;
        HashMap<String, Integer> similiar = null;
        if (showSimiliar) {
            similiar = new HashMap<String, Integer>();
        }
        int numEvolutions2 = numEvolutions;
        if (stopCriteriaFitness >= 0.0) {
            numEvolutions2 = Integer.MAX_VALUE;
        }
        int gen = 0;
        for (gen = 0; gen < numEvolutions2; ++gen) {
            gp.evolve();
            gp.calcFitness();
            GPPopulation pop = gp.getGPPopulation();
            IGPProgram thisFittest = pop.determineFittestProgram();
            ProgramChromosome chrom = thisFittest.getChromosome(0);
            String program = chrom.toStringNorm(0);
            double fitness = thisFittest.getFitnessValue();
            if (showSimiliar || showPopulation || showAllGenerations) {
                if (showPopulation || showAllGenerations) {
                    System.out.println("Generation " + gen);
                }
                pop.sortByFitness();
                for (IGPProgram p : pop.getGPPrograms()) {
                    double fit = p.getFitnessValue();
                    if (showSimiliar && fit <= bestFit) {
                        String prog = p.toStringNorm(0);
                        if (!similiar.containsKey(prog)) {
                            similiar.put(prog, 1);
                        } else {
                            similiar.put(prog, (Integer)similiar.get(prog) + 1);
                        }
                    }
                    if (!showPopulation) continue;
                    String prg = p.toStringNorm(0);
                    int sz = p.size();
                    System.out.println("\tprogram: " + prg + " fitness: " + fit);
                }
            }
            if (bestFit < 0.0 || fitness < bestFit || showAllGenerations) {
                if (bestFit < 0.0 || fitness < bestFit) {
                    bestGen = gen;
                    bestFit = fitness;
                    bestProgram = program;
                    fittest = thisFittest;
                    if (showSimiliar) {
                        similiar.clear();
                        similiar.put(thisFittest.toStringNorm(0), 1);
                    }
                }
                SymbolicRegression.myOutputSolution(fittest, gen);
            } else if (showProgression) {
                String genStr = "" + (gen - 1);
                for (int i = 0; i <= genStr.length(); ++i) {
                    System.out.print("\b");
                }
                System.out.print("" + gen);
            }
            if (!(stopCriteriaFitness >= 0.0) || !(fitness <= stopCriteriaFitness)) continue;
            System.out.print("\nFitness stopping criteria (" + stopCriteriaFitness + ") reached with fitness " + fitness + " at generation " + gen + "\n");
            break;
        }
        System.out.println("\nAll time best (from generation " + bestGen + ")");
        SymbolicRegression.myOutputSolution(fittest, gen);
        endTime = System.currentTimeMillis();
        long elapsedTime = endTime - startTime;
        String elapsed = String.format("%5.2f", Float.valueOf((float)(endTime - startTime) / 1000.0f));
        System.out.println("\nTotal time " + elapsed + "s");
        if (showSimiliar) {
            System.out.println("\nAll solutions with the best fitness (" + bestFit + "):");
            System.out.println("Sort method: " + similiarSortMethod);
            ArrayList sorted = new ArrayList(similiar.keySet());
            final HashMap<String, Integer> sim = similiar;
            Collections.sort(sorted, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    if ("length".equals(similiarSortMethod)) {
                        return s1.length() - s2.length();
                    }
                    return (Integer)sim.get(s2) - (Integer)sim.get(s1);
                }
            });
            for (String p : sorted) {
                System.out.println(p + " [" + similiar.get(p) + "]");
            }
            System.out.println("It was " + similiar.size() + " different solutions with fitness " + bestFit);
        }
        if (testData != null && testData.length > 0) {
            System.out.println("\nTesting the fittest program with user defined test data: ");
            int testDataSize = testData.length;
            for (int i = 0; i < testDataSize; ++i) {
                for (int j = 0; j < testData[i].length; ++j) {
                    if (j == outputVariable) continue;
                    System.out.print(testData[i][j] + " ");
                }
                Double testResult = SymbolicRegression.evalData(fittest, testData[i]);
                System.out.println("   Result: " + testResult);
            }
        }
        if (validationSet != null && validationSet.length > 0) {
            System.out.println("\nTesting the fittest program with the validation set: ");
            int validationDataSize = validationSet.length;
            for (int i = 0; i < validationSet[0].length; ++i) {
                Double[] val = new Double[validationDataSize];
                for (int j = 0; j < validationDataSize; ++j) {
                    val[j] = validationSet[j][i];
                    System.out.print(val[j] + " ");
                }
                Double testResult = SymbolicRegression.evalData(fittest, val);
                double diff = Math.abs(testResult - val[outputVariable]);
                System.out.println("   Result: " + testResult + " should be " + val[outputVariable] + " diff: " + diff);
            }
        }
    }

    public static void myOutputSolution(IGPProgram a_best, int gen) {
        double[] results;
        String freeMB = SystemKit.niceMemory(SystemKit.getFreeMemoryMB());
        long now = System.currentTimeMillis();
        String elapsedNow = String.format("%5.2f", Float.valueOf((float)(now - startTime) / 1000.0f));
        if (showProgression) {
            System.out.println();
        }
        System.out.println("\nEvolving generation " + gen + "/" + numEvolutions + "(time from start: " + elapsedNow + "s)");
        if (a_best == null) {
            System.out.println("No best solution (null)");
            return;
        }
        double bestValue = a_best.getFitnessValue();
        if (Double.isInfinite(bestValue)) {
            System.out.println("No best solution (infinite)");
            return;
        }
        System.out.print("Best solution fitness: " + NumberKit.niceDecimalNumber(bestValue, 2) + " (error method: " + errorMethod + ")");
        if (validationPCT > 0.0 && validationSet != null) {
            double validationFitness = SymbolicRegression.validateData(a_best);
            System.out.print("    (validation fitness: " + validationFitness + ")");
        }
        System.out.println();
        System.out.println("Best solution: " + a_best.toStringNorm(0));
        String depths = "";
        int size = a_best.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                depths = depths + " / ";
            }
            depths = depths + a_best.getChromosome(i).getDepth(0);
        }
        if (size == 1) {
            System.out.print("Depth of chrom: " + depths);
        } else {
            System.out.print("Depths of chroms: " + depths);
        }
        ProgramChromosome chrom = a_best.getChromosome(0);
        int numFunctions = chrom.numFunctions();
        int numTerminals = chrom.numTerminals();
        int numTerms = numFunctions + numTerminals;
        System.out.println(". Number of functions+terminals: " + numTerms + " (" + numFunctions + " functions, " + numTerminals + " terminals)");
        ApplicationData appData = (ApplicationData)a_best.getApplicationData();
        System.out.println("Correlation coefficient: " + appData.getCorrelation());
        System.out.println("minError: " + appData.getMinError() + " meanError: " + appData.getMeanError() + " medianError: " + appData.getMedianError() + " maxError: " + appData.getMaxError() + " totalError: " + appData.getTotalError());
        if (hitsCriteria >= 0.0) {
            int numHits = appData.getNumHits();
            String hitsPct = String.format("%5.2f", (double)numHits / (double)numRows);
            System.out.println("Number of hits (<= " + hitsCriteria + "): " + numHits + " (of " + numRows + " = " + hitsPct + ")");
        }
        if (showResults && (results = appData.getResults()) != null) {
            System.out.println("Results for this program:");
            double sumAbsDiff = 0.0;
            double sumDiff = 0.0;
            String formatStr = "%5." + resultPrecision + "f";
            int thisNumHits = 0;
            for (int i = 0; i < results.length; ++i) {
                double d = data[outputVariable][i];
                double r = results[i];
                double diff = d - r;
                double absDiff = Math.abs(diff);
                String hitsStr = "";
                if (hitsCriteria >= 0.0 && absDiff > hitsCriteria) {
                    hitsStr = " > " + hitsCriteria + "!";
                } else {
                    ++thisNumHits;
                }
                System.out.println("(" + i + ") " + d + ": " + String.format(formatStr, r) + " (diff: " + String.format(formatStr, diff) + ")" + hitsStr);
                sumDiff += diff;
                sumAbsDiff += absDiff;
            }
            String numHitsStr = hitsCriteria >= 0.0 ? " #hits: " + thisNumHits + " (of " + numRows : "";
            System.out.println("total diff: " + sumAbsDiff + " (no abs diff: " + sumDiff + numHitsStr + ")\n");
        }
    }

    public static final double correlation(Double[] y1, double[] y2, int n) {
        int i;
        double av1 = 0.0;
        double av2 = 0.0;
        double y11 = 0.0;
        double y22 = 0.0;
        double y12 = 0.0;
        if (n <= 1) {
            return 1.0;
        }
        for (i = 0; i < n; ++i) {
            av1 += y1[i].doubleValue();
            av2 += y2[i];
        }
        av1 /= (double)n;
        av2 /= (double)n;
        for (i = 0; i < n; ++i) {
            y11 += (y1[i] - av1) * (y1[i] - av1);
            y22 += (y2[i] - av2) * (y2[i] - av2);
            y12 += (y1[i] - av1) * (y2[i] - av2);
        }
        double c = y11 * y22 == 0.0 ? 1.0 : y12 / Math.sqrt(Math.abs(y11 * y22));
        return c;
    }

    public static double validateData(IGPProgram ind) {
        double error = 0.0;
        double[] errors = new double[validationSet[0].length];
        Object[] noargs = new Object[]{};
        if (validationSet != null && validationSet.length > 0) {
            for (int j = 0; j < validationSet[0].length; ++j) {
                int variableIndex = 0;
                for (int i = 0; i < numInputVariables + 1; ++i) {
                    if (i == outputVariable) continue;
                    variables[variableIndex].set(validationSet[i][j]);
                    ++variableIndex;
                }
                try {
                    double err;
                    double result = ind.execute_double(0, noargs);
                    errors[j] = err = Math.abs(result - validationSet[outputVariable][j]);
                    if (!Double.isInfinite(error += err) && !Double.isNaN(error)) continue;
                    return Double.MAX_VALUE;
                }
                catch (ArithmeticException ex) {
                    System.out.println(ind);
                    throw ex;
                }
            }
        }
        double[] err = SymbolicRegression.calcAllErrors(error, errors);
        return err[0];
    }

    public static double[] calcAllErrors(double error, double[] errors) {
        double totalError = error;
        double[] minMaxErrors = SymbolicRegression.getMinMax(errors);
        double minError = minMaxErrors[0];
        double maxError = minMaxErrors[1];
        double medianError = minMaxErrors[2];
        double meanError = error / (double)errors.length;
        if ("meanError".equals(errorMethod)) {
            error = meanError;
        } else if ("minError".equals(errorMethod)) {
            error = minError;
        } else if ("maxError".equals(errorMethod)) {
            error = maxError;
        } else if ("medianError".equals(errorMethod)) {
            error = medianError;
        }
        double[] err = new double[]{error, totalError, minError, maxError, meanError, medianError};
        return err;
    }

    public static Double evalData(IGPProgram ind, Double[] data) {
        Double result = 0.0;
        Object[] noargs = new Object[]{};
        int variableIndex = 0;
        for (int i = 0; i < numInputVariables + 1; ++i) {
            if (i == outputVariable) continue;
            variables[variableIndex].set(data[i]);
            ++variableIndex;
        }
        try {
            result = ind.execute_double(0, noargs);
        }
        catch (ArithmeticException ex) {
            System.out.println(ind);
            throw ex;
        }
        return result;
    }

    public static double[] getMinMax(double[] arr) {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            if (arr[i] < min) {
                min = arr[i];
            }
            if (!(arr[i] > max)) continue;
            max = arr[i];
        }
        double median = Double.MIN_VALUE;
        int len2 = len / 2;
        median = len == 1 ? arr[0] : (len == 2 ? (arr[0] + arr[1]) / 2.0 : (len % 2 == 1 ? arr[len2] : (arr[len2] + arr[len2 + 1]) / 2.0));
        return new double[]{min, max, median};
    }

    static {
        constants = new ArrayList();
        foundPerfect = false;
        minInitDepth = 2;
        maxInitDepth = 4;
        populationSize = 1000;
        maxCrossoverDepth = 8;
        programCreationMaxTries = 5;
        numEvolutions = 1800;
        verboseOutput = true;
        maxNodes = 21;
        functionProb = 0.9;
        reproductionProb = 0.1f;
        mutationProb = 0.1f;
        crossoverProb = 0.9f;
        dynamizeArityProb = 0.08f;
        newChromsPercent = 0.3;
        tournamentSelectorSize = 0;
        noCommandGeneCloning = true;
        strictProgramCreation = false;
        useProgramCache = true;
        lowerRange = -10.0;
        upperRange = -10.0;
        terminalWholeNumbers = true;
        returnType = "DoubleClass";
        presentation = "";
        adfArity = 0;
        adfType = "double";
        useADF = false;
        functions = new String[]{"Multiply", "Divide", "Add", "Subtract"};
        adfFunctions = new String[]{"Multiply3", "Divide", "Add3", "Subtract"};
        scaleError = -1.0;
        stopCriteriaFitness = -1.0;
        showPopulation = false;
        showSimiliar = false;
        similiarSortMethod = "occurrence";
        showProgression = false;
        showAllGenerations = false;
        showResults = false;
        resultPrecision = 5;
        samplePCT = 0.0;
        hitsCriteria = -1.0;
        validationPCT = 0.0;
        modReplace = 0;
        makeTimeSeries = false;
        makeTimeSeriesWithIndex = false;
        errorMethod = "totalError";
        noTerminals = false;
        minNodes = -1;
        minNodesPenalty = 0.0;
        alldifferentVariables = false;
        alldifferentVariablesPenalty = 0.0;
    }

    protected static class ApplicationData {
        double error = 1000.0;
        int numHits = 0;
        double correlation = 0.0;
        double[] results;
        double minError = Double.MIN_VALUE;
        double maxError = Double.MAX_VALUE;
        double meanError = Double.MAX_VALUE;
        double medianError = Double.MAX_VALUE;
        double totalError = Double.MAX_VALUE;

        ApplicationData(double _error, double _correlation, int _numHits, double _minError, double _maxError, double _meanError, double _medianError, double _totalError) {
            this.error = _error;
            this.correlation = _correlation;
            this.numHits = _numHits;
            this.minError = _minError;
            this.meanError = _meanError;
            this.maxError = _maxError;
            this.medianError = _medianError;
            this.totalError = _totalError;
        }

        ApplicationData(double _error, double _correlation, int _numHits, double _minError, double _maxError, double _meanError, double _medianError, double _totalError, double[] _results) {
            this.error = _error;
            this.correlation = _correlation;
            this.numHits = _numHits;
            this.minError = _minError;
            this.meanError = _meanError;
            this.maxError = _maxError;
            this.medianError = _medianError;
            this.totalError = _totalError;
            this.results = _results;
        }

        private void setError(double _error) {
            this.error = _error;
        }

        private void setCorrelation(double _correlation) {
            this.correlation = _correlation;
        }

        private void setNumHits(int _numHits) {
            this.numHits = _numHits;
        }

        private void setResults(double[] _results) {
            this.results = _results;
        }

        private void setMinError(double _minError) {
            this.minError = _minError;
        }

        private void setMeanError(double _meanError) {
            this.meanError = _meanError;
        }

        private void setMaxError(double _maxError) {
            this.maxError = _maxError;
        }

        private void setMedianError(double _medianError) {
            this.medianError = _medianError;
        }

        private void setTotalError(double _totalError) {
            this.totalError = _totalError;
        }

        private double getError() {
            return this.error;
        }

        private double getCorrelation() {
            return this.correlation;
        }

        private int getNumHits() {
            return this.numHits;
        }

        private double[] getResults() {
            return this.results;
        }

        private double getMinError() {
            return this.minError;
        }

        private double getMeanError() {
            return this.meanError;
        }

        private double getMaxError() {
            return this.maxError;
        }

        private double getMedianError() {
            return this.medianError;
        }

        private double getTotalError() {
            return this.totalError;
        }
    }

    public static class FormulaFitnessFunction
    extends GPFitnessFunction {
        @Override
        protected double evaluate(IGPProgram a_subject) {
            return this.computeRawFitness(a_subject);
        }

        public double computeRawFitness(IGPProgram ind) {
            double error = 0.0;
            Object[] noargs = new Object[]{};
            double penalty = 0.0;
            ProgramChromosome chrom = ind.getChromosome(0);
            int numTerms = chrom.numFunctions() + chrom.numTerminals();
            if (minNodes >= 0 && numTerms < minNodes) {
                penalty += (double)Math.abs(numTerms - minNodes) * minNodesPenalty;
            }
            if (alldifferentVariables) {
                CommandGene[] functions = chrom.getFunctions();
                HashMap<String, Integer> countVariables = new HashMap<String, Integer>();
                for (int i = 0; i < functions.length; ++i) {
                    CommandGene func = functions[i];
                    if (func == null) continue;
                    int arity = func.getArity(ind);
                    String funcStr = func.toString();
                    if (arity != 0) continue;
                    Class returnType = func.getReturnType();
                    int subReturnType = func.getSubReturnType();
                    if (!countVariables.containsKey(funcStr)) {
                        countVariables.put(funcStr, 1);
                        continue;
                    }
                    penalty += alldifferentVariablesPenalty;
                    countVariables.put(funcStr, (Integer)countVariables.get(funcStr) + 1);
                }
            }
            int thisNumHits = 0;
            double[] results = new double[numRows];
            double[] errors = new double[numRows];
            for (int j = 0; j < numRows; ++j) {
                int variableIndex = 0;
                for (int i = 0; i < numInputVariables + 1; ++i) {
                    if (i == outputVariable) continue;
                    variables[variableIndex].set(data[i][j]);
                    ++variableIndex;
                }
                try {
                    double diff;
                    double result;
                    results[j] = result = ind.execute_double(0, noargs);
                    double res = data[outputVariable][j];
                    errors[j] = diff = Math.abs(result - res) + penalty;
                    if (hitsCriteria >= 0.0) {
                        if (Double.isInfinite(result) || Double.isNaN(result) || Double.isInfinite(diff) || Double.isNaN(diff) || diff > hitsCriteria) {
                            error += 1.0 + penalty;
                        }
                    } else {
                        error += diff;
                    }
                    if (diff <= hitsCriteria) {
                        ++thisNumHits;
                    }
                    if (!Double.isInfinite(error) && !Double.isNaN(error)) continue;
                    return Double.MAX_VALUE;
                }
                catch (ArithmeticException ex) {
                    System.out.println(ind);
                    throw ex;
                }
            }
            double[] errs = SymbolicRegression.calcAllErrors(error, errors);
            if (hitsCriteria < 0.0) {
                error = errs[0];
            }
            double totalError = errs[1];
            double minError = errs[2];
            double maxError = errs[3];
            double meanError = errs[4];
            double medianError = errs[5];
            double correlation = SymbolicRegression.correlation(data[outputVariable], results, results.length);
            ApplicationData appData = showResults ? new ApplicationData(error, correlation, thisNumHits, minError, maxError, meanError, medianError, totalError, results) : new ApplicationData(error, correlation, thisNumHits, minError, maxError, meanError, medianError, totalError);
            ind.setApplicationData(appData);
            if (scaleError > 0.0) {
                return error * scaleError;
            }
            return error;
        }
    }
}

