/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl.job;

import java.util.List;
import org.jgap.Configuration;
import org.jgap.GeneticOperator;
import org.jgap.IBreeder;
import org.jgap.InvalidConfigurationException;
import org.jgap.NaturalSelector;
import org.jgap.Population;
import org.jgap.impl.job.EvolveData;
import org.jgap.impl.job.EvolveResult;
import org.jgap.impl.job.IEvolveJob;
import org.jgap.impl.job.JobBase;
import org.jgap.impl.job.JobData;
import org.jgap.impl.job.JobResult;

public class EvolveJob
extends JobBase
implements IEvolveJob {
    private static final String CVS_REVISION = "$Revision: 1.12 $";

    public EvolveJob(JobData a_data) {
        super(a_data);
    }

    @Override
    public JobResult execute(JobData a_data) throws Exception {
        EvolveData data = (EvolveData)a_data;
        return this.evolve(data);
    }

    public EvolveResult evolve(EvolveData a_evolveData) {
        EvolveResult result = new EvolveResult();
        Configuration config = a_evolveData.getConfiguration();
        result.setConfiguration(config);
        Population pop = a_evolveData.getPopulation();
        IBreeder breeder = a_evolveData.getBreeder();
        pop = breeder.evolve(pop, config);
        result.setPopulation(pop);
        return result;
    }

    protected Population applyNaturalSelectors(Configuration a_config, Population a_pop, boolean a_processBeforeGeneticOperators) {
        try {
            int selectorSize = a_config.getNaturalSelectorsSize(a_processBeforeGeneticOperators);
            if (selectorSize > 0) {
                int m_population_size = a_config.getPopulationSize();
                Population new_population = new Population(a_config, m_population_size);
                for (int i = 0; i < selectorSize; ++i) {
                    NaturalSelector selector = a_config.getNaturalSelector(a_processBeforeGeneticOperators, i);
                    int m_single_selection_size = i == selectorSize - 1 && i > 0 ? m_population_size - a_pop.size() : m_population_size / selectorSize;
                    selector.select(m_single_selection_size, a_pop, new_population);
                    selector.empty();
                }
                return new_population;
            }
            return a_pop;
        }
        catch (InvalidConfigurationException iex) {
            throw new IllegalStateException(iex.getMessage());
        }
    }

    protected void applyGeneticOperators(Configuration a_config, Population a_pop) {
        List geneticOperators = a_config.getGeneticOperators();
        for (GeneticOperator operator : geneticOperators) {
            operator.operate(a_pop, a_pop.getChromosomes());
        }
    }
}

