/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.util.List;
import org.jgap.BaseGeneticOperator;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.IChromosome;
import org.jgap.ICompositeGene;
import org.jgap.InvalidConfigurationException;
import org.jgap.Population;
import org.jgap.RandomGenerator;
import org.jgap.impl.CompositeGene;

public class GaussianMutationOperator
extends BaseGeneticOperator {
    private static final String CVS_REVISION = "$Revision: 1.25 $";
    private double m_deviation;
    private RandomGenerator m_rg;

    public GaussianMutationOperator() throws InvalidConfigurationException {
        this(Genotype.getStaticConfiguration());
    }

    public GaussianMutationOperator(Configuration a_config) throws InvalidConfigurationException {
        this(a_config, 0.05);
    }

    public GaussianMutationOperator(Configuration a_configuration, double a_deviation) throws InvalidConfigurationException {
        super(a_configuration);
        this.m_deviation = a_deviation;
    }

    @Override
    public void operate(Population a_population, List a_candidateChromosomes) {
        int size = Math.min(this.getConfiguration().getPopulationSize(), a_population.size());
        if (this.m_rg == null) {
            RandomGenerator rn;
            this.m_rg = rn = this.getConfiguration().getRandomGenerator();
        }
        for (int i = 0; i < size; ++i) {
            Gene[] genes = a_population.getChromosome(i).getGenes();
            IChromosome originalChrom = a_population.getChromosome(i);
            IChromosome copyOfChromosome = null;
            for (int j = 0; j < genes.length; ++j) {
                double nextGaussian = this.m_rg.nextDouble();
                double diff = nextGaussian * this.m_deviation;
                if (copyOfChromosome == null) {
                    copyOfChromosome = (IChromosome)originalChrom.clone();
                    a_candidateChromosomes.add(copyOfChromosome);
                    genes = copyOfChromosome.getGenes();
                    if (this.m_monitorActive) {
                        copyOfChromosome.setUniqueIDTemplate(originalChrom.getUniqueID(), 1);
                    }
                }
                if (genes[j] instanceof CompositeGene) {
                    CompositeGene compositeGene = (CompositeGene)genes[j];
                    if (this.m_monitorActive) {
                        compositeGene.setUniqueIDTemplate(originalChrom.getGene(j).getUniqueID(), 1);
                    }
                    for (int k = 0; k < compositeGene.size(); ++k) {
                        this.mutateGene(compositeGene.geneAt(k), diff);
                        if (!this.m_monitorActive) continue;
                        compositeGene.geneAt(k).setUniqueIDTemplate(((ICompositeGene)originalChrom.getGene(j)).geneAt(k).getUniqueID(), 1);
                    }
                    continue;
                }
                this.mutateGene(genes[j], diff);
                if (!this.m_monitorActive) continue;
                genes[j].setUniqueIDTemplate(originalChrom.getGene(j).getUniqueID(), 1);
            }
        }
    }

    private void mutateGene(Gene a_gene, double a_percentage) {
        for (int k = 0; k < a_gene.size(); ++k) {
            a_gene.applyMutation(k, a_percentage);
        }
    }

    public int compareTo(Object a_other) {
        if (a_other == null) {
            return 1;
        }
        GaussianMutationOperator op = (GaussianMutationOperator)a_other;
        if (this.m_deviation != op.m_deviation) {
            if (this.m_deviation > op.m_deviation) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    public double getDeviation() {
        return this.m_deviation;
    }
}

