/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.util.StringTokenizer;
import org.jgap.BaseGene;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.IPersistentRepresentation;
import org.jgap.InvalidConfigurationException;
import org.jgap.RandomGenerator;
import org.jgap.UnsupportedRepresentationException;

public class FixedBinaryGene
extends BaseGene
implements IPersistentRepresentation {
    private static final String CVS_REVISION = "$Revision: 1.40 $";
    private int m_length;
    private int[] m_value;
    private static final int WORD_LEN_BITS = 32;

    public FixedBinaryGene(Configuration a_config, int a_length) throws InvalidConfigurationException {
        super(a_config);
        if (a_length < 1) {
            throw new IllegalArgumentException("Length must be greater than zero!");
        }
        this.m_length = a_length;
        int bufSize = this.m_length / 32;
        if (0 != this.m_length % 32) {
            ++bufSize;
        }
        this.m_value = new int[bufSize];
        for (int i = 0; i < bufSize; ++i) {
            this.m_value[i] = 0;
        }
    }

    @Override
    protected Gene newGeneInternal() {
        try {
            FixedBinaryGene result = new FixedBinaryGene(this.getConfiguration(), this.m_length);
            return result;
        }
        catch (InvalidConfigurationException iex) {
            throw new IllegalStateException(iex.getMessage());
        }
    }

    public FixedBinaryGene(Configuration a_config, FixedBinaryGene a_toCopy) throws InvalidConfigurationException {
        super(a_config);
        this.m_length = a_toCopy.getLength();
        int bufSize = this.m_length / 32;
        if (0 != this.m_length % 32) {
            ++bufSize;
        }
        this.m_value = new int[bufSize];
        System.arraycopy(a_toCopy.getValue(), 0, this.m_value, 0, this.m_value.length);
    }

    protected int[] getValue() {
        return this.m_value;
    }

    public int getLength() {
        return this.m_length;
    }

    public Object clone() {
        try {
            return new FixedBinaryGene(this.getConfiguration(), this);
        }
        catch (InvalidConfigurationException iex) {
            throw new IllegalStateException(iex.getMessage());
        }
    }

    @Override
    public void setAllele(Object a_newValue) {
        if (a_newValue == null) {
            throw new IllegalArgumentException("Allele must not be null!");
        }
        if (((int[])a_newValue).length != this.getLength()) {
            throw new IllegalArgumentException("Length of allele must be equal to fixed length set (" + this.getLength() + ")");
        }
        if (this.getConstraintChecker() != null && !this.getConstraintChecker().verify(this, a_newValue, null, -1)) {
            return;
        }
        int[] bits = (int[])a_newValue;
        for (int i = 0; i < bits.length; ++i) {
            this.setBit(i, bits[i]);
        }
    }

    @Override
    public Object getAllele() {
        int[] bits = new int[this.getLength()];
        for (int i = 0; i < this.getLength(); ++i) {
            bits[i] = this.getBit(i) ? 1 : 0;
        }
        return bits;
    }

    public int[] getIntValues() {
        return this.m_value;
    }

    public boolean getBit(int a_index) {
        this.checkIndex(a_index);
        return this.getUnchecked(a_index);
    }

    public void setBit(int a_index, boolean a_value) {
        this.checkIndex(a_index);
        this.setUnchecked(a_index, a_value);
    }

    public void setBit(int a_index, int a_value) {
        if (a_value > 0) {
            if (a_value != 1) {
                throw new IllegalArgumentException("Only values 0 and 1 are valid!");
            }
            this.setBit(a_index, true);
        } else {
            if (a_value != 0) {
                throw new IllegalArgumentException("Only values 0 and 1 are valid!");
            }
            this.setBit(a_index, false);
        }
    }

    public void setBit(int a_from, int a_to, boolean a_value) {
        this.checkSubLength(a_from, a_to);
        for (int i = a_from; i < a_to; ++i) {
            this.setUnchecked(i, a_value);
        }
    }

    public void setBit(int a_from, int a_to, FixedBinaryGene a_values) {
        if (a_values.getLength() == 0) {
            throw new IllegalArgumentException("Length of values must be > 0");
        }
        this.checkSubLength(a_from, a_to);
        int iV = 0;
        int i = a_from;
        while (i <= a_to) {
            if (iV >= a_values.getLength()) {
                iV = 0;
            }
            this.setUnchecked(i, a_values.getUnchecked(iV));
            ++i;
            ++iV;
        }
    }

    public FixedBinaryGene substring(int a_from, int a_to) {
        try {
            int len = this.checkSubLength(a_from, a_to);
            FixedBinaryGene substring = new FixedBinaryGene(this.getConfiguration(), len);
            for (int i = a_from; i <= a_to; ++i) {
                substring.setUnchecked(i - a_from, this.getUnchecked(i));
            }
            return substring;
        }
        catch (InvalidConfigurationException iex) {
            throw new IllegalStateException(iex.getMessage());
        }
    }

    public void flip(int a_index) {
        this.checkIndex(a_index);
        int segment = a_index / 32;
        int offset = a_index % 32;
        int mask = 1 << 32 - offset - 1;
        int n = segment;
        this.m_value[n] = this.m_value[n] ^ mask;
    }

    protected int checkSubLength(int a_from, int a_to) {
        this.checkIndex(a_from);
        this.checkIndex(a_to);
        int sublen = a_to - a_from + 1;
        if (0 >= sublen) {
            throw new IllegalArgumentException("must have 'from' <= 'to', but has " + a_from + " > " + a_to);
        }
        return sublen;
    }

    protected void checkIndex(int a_index) {
        if (a_index < 0 || a_index >= this.getLength()) {
            throw new IndexOutOfBoundsException("index is " + a_index + ", but must be in [0, " + (this.getLength() - 1) + "]");
        }
    }

    protected boolean getUnchecked(int a_index) {
        int segment = a_index / 32;
        int offset = a_index % 32;
        int mask = 1 << 32 - offset - 1;
        return 0 != (this.m_value[segment] & mask);
    }

    public void setUnchecked(int a_index, boolean a_value) {
        int segment = a_index / 32;
        int offset = a_index % 32;
        int mask = 1 << 32 - offset - 1;
        if (a_value) {
            int n = segment;
            this.m_value[n] = this.m_value[n] | mask;
        } else {
            int n = segment;
            this.m_value[n] = this.m_value[n] & ~mask;
        }
    }

    @Override
    public String getPersistentRepresentation() {
        return this.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setValueFromPersistentRepresentation(String a_representation) throws UnsupportedRepresentationException {
        if (a_representation == null) throw new UnsupportedRepresentationException("The input parameter must not be null!");
        if (!this.isValidRepresentation(a_representation)) throw new UnsupportedRepresentationException("Invalid gene representation: " + a_representation);
        a_representation = a_representation.substring(1, a_representation.length() - 1);
        StringTokenizer st = new StringTokenizer(a_representation, ",");
        int index = 0;
        while (st.hasMoreTokens()) {
            int i = Integer.parseInt(st.nextToken());
            this.setBit(index++, i);
        }
        if (index >= this.getLength()) return;
        throw new UnsupportedRepresentationException("Invalid gene representation: " + a_representation);
    }

    private boolean isValidRepresentation(String a_representation) {
        return a_representation.startsWith("[") && a_representation.endsWith("]");
    }

    @Override
    public void setToRandomValue(RandomGenerator a_numberGenerator) {
        if (a_numberGenerator == null) {
            throw new IllegalArgumentException("Random Generator must not be null!");
        }
        int len = this.getLength();
        for (int i = 0; i < len; ++i) {
            this.setBit(i, a_numberGenerator.nextBoolean());
        }
    }

    @Override
    public String toString() {
        int len = this.getLength();
        String s = "FixedBinaryGene[";
        for (int i = 0; i < len; ++i) {
            int value = this.getBit(i) ? 1 : 0;
            s = i == 0 ? s + value : s + "," + value;
        }
        return s + "]";
    }

    @Override
    public String getBusinessKey() {
        return this.toString();
    }

    @Override
    public int size() {
        return this.m_value.length;
    }

    @Override
    public void applyMutation(int a_index, double a_percentage) {
        if (a_index < 0 || a_index >= this.getLength()) {
            throw new IllegalArgumentException("Index must be between 0 and getLength() - 1");
        }
        if (a_percentage > 0.0) {
            if (!this.getBit(a_index)) {
                this.setBit(a_index, true);
            }
        } else if (a_percentage < 0.0 && this.getBit(a_index)) {
            this.setBit(a_index, false);
        }
    }

    public int compareTo(Object a_other) {
        int otherLen;
        FixedBinaryGene otherGene = (FixedBinaryGene)a_other;
        if (otherGene == null) {
            return 1;
        }
        int thisLen = this.getLength();
        if (thisLen != (otherLen = otherGene.getLength())) {
            if (thisLen > otherLen) {
                return 1;
            }
            return -1;
        }
        for (int i = 0; i < thisLen; ++i) {
            boolean b1 = this.getBit(i);
            boolean b2 = otherGene.getBit(i);
            if (b1) {
                if (b2) continue;
                return 1;
            }
            if (!b2) continue;
            return -1;
        }
        if (this.isCompareApplicationData()) {
            return this.compareApplicationData(this.getApplicationData(), otherGene.getApplicationData());
        }
        return 0;
    }

    @Override
    protected Object getInternalValue() {
        return this.m_value;
    }

    @Override
    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.m_value.length; ++i) {
            if (this.m_value[i] == 0) {
                result += 31 * result + 47;
                continue;
            }
            result += 31 * result + 91;
        }
        return result;
    }
}

