/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.FitnessEvaluator;
import org.jgap.IChromosome;
import org.jgap.InvalidConfigurationException;
import org.jgap.Population;
import org.jgap.distr.IPopulationMerger;

public class FittestPopulationMerger
implements IPopulationMerger {
    private static final String CVS_REVISION = "$Revision: 1.17 $";

    @Override
    public Population mergePopulations(Population a_population1, Population a_population2, int a_new_population_size) {
        try {
            a_population1.addChromosomes(a_population2);
            List<IChromosome> allChromosomes = a_population1.getChromosomes();
            Collections.sort(allChromosomes, new FitnessChromosomeComparator(a_population1.getConfiguration()));
            Chromosome[] chromosomes = allChromosomes.toArray(new Chromosome[0]);
            Population mergedPopulation = new Population(a_population1.getConfiguration(), a_new_population_size);
            for (int i = 0; i < a_new_population_size && i < chromosomes.length; ++i) {
                mergedPopulation.addChromosome(chromosomes[i]);
            }
            return mergedPopulation;
        }
        catch (InvalidConfigurationException iex) {
            throw new IllegalStateException(iex.getMessage());
        }
    }

    private class FitnessChromosomeComparator
    implements Comparator {
        private transient Configuration m_config;
        private FitnessEvaluator m_fEvaluator;

        public FitnessChromosomeComparator(Configuration a_config) {
            this.m_config = a_config;
            this.m_fEvaluator = this.m_config.getFitnessEvaluator();
        }

        public int compare(Object a_o1, Object a_o2) {
            IChromosome chr1 = (IChromosome)a_o1;
            IChromosome chr2 = (IChromosome)a_o2;
            if (this.m_fEvaluator.isFitter(chr2.getFitnessValue(), chr1.getFitnessValue())) {
                return 1;
            }
            if (this.m_fEvaluator.isFitter(chr1.getFitnessValue(), chr2.getFitnessValue())) {
                return -1;
            }
            return 0;
        }
    }
}

