/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.util.Iterator;
import org.jgap.BulkFitnessFunction;
import org.jgap.FitnessFunction;
import org.jgap.IChromosome;
import org.jgap.Population;

public class BulkFitnessOffsetRemover
extends BulkFitnessFunction {
    private static final String CVS_REVISION = "$Revision: 1.12 $";
    private FitnessFunction m_ff;
    private double m_previousOffset;

    public BulkFitnessOffsetRemover(FitnessFunction a_ff) {
        if (a_ff == null) {
            throw new IllegalArgumentException("Fitness function must not be null!");
        }
        this.m_ff = a_ff;
    }

    @Override
    public void evaluate(Population a_chromosomes) {
        IChromosome chromosome;
        double offset = Double.MAX_VALUE;
        Iterator itChromosomes = a_chromosomes.iterator();
        while (itChromosomes.hasNext()) {
            chromosome = (IChromosome)itChromosomes.next();
            double curFitness = chromosome.getFitnessValueDirectly();
            if (curFitness < 0.0) {
                curFitness = this.m_ff.getFitnessValue(chromosome);
                chromosome.setFitnessValue(curFitness);
            } else {
                chromosome.setFitnessValue(curFitness += this.m_previousOffset);
            }
            offset = offset < curFitness ? offset : curFitness;
        }
        this.m_previousOffset = offset -= 1.0;
        itChromosomes = a_chromosomes.iterator();
        while (itChromosomes.hasNext()) {
            chromosome = (IChromosome)itChromosomes.next();
            chromosome.setFitnessValue(chromosome.getFitnessValue() - offset);
        }
    }

    public double getAbsoluteFitness(IChromosome a_individuum) {
        double fitness = a_individuum.getFitnessValue();
        if (fitness < 0.0) {
            fitness = this.m_ff.getFitnessValue(a_individuum);
            a_individuum.setFitnessValue(fitness);
        } else {
            fitness += this.m_previousOffset;
        }
        return fitness;
    }

    @Override
    public Object clone() {
        FitnessFunction ff = (FitnessFunction)this.m_ff.clone();
        BulkFitnessOffsetRemover result = new BulkFitnessOffsetRemover(ff);
        return result;
    }
}

