/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import org.jgap.BaseGene;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.IPersistentRepresentation;
import org.jgap.InvalidConfigurationException;
import org.jgap.RandomGenerator;
import org.jgap.UnsupportedRepresentationException;

public class BooleanGene
extends BaseGene
implements IPersistentRepresentation {
    private static final String CVS_REVISION = "$Revision: 1.32 $";
    protected static final Boolean TRUE_BOOLEAN = true;
    protected static final Boolean FALSE_BOOLEAN = false;
    private Boolean m_value;

    public BooleanGene() throws InvalidConfigurationException {
        this(Genotype.getStaticConfiguration());
    }

    public BooleanGene(Configuration a_config) throws InvalidConfigurationException {
        super(a_config);
    }

    public BooleanGene(Configuration a_config, boolean a_value) throws InvalidConfigurationException {
        super(a_config);
        this.m_value = new Boolean(a_value);
    }

    public BooleanGene(Configuration a_config, Boolean a_value) throws InvalidConfigurationException {
        super(a_config);
        if (a_value == null) {
            throw new IllegalArgumentException("Allele value must not be null. Use no argument constructor if you need to set allele to null initially.");
        }
        this.m_value = a_value;
    }

    @Override
    protected Gene newGeneInternal() {
        try {
            return new BooleanGene(this.getConfiguration());
        }
        catch (InvalidConfigurationException iex) {
            throw new IllegalStateException(iex.getMessage());
        }
    }

    @Override
    public void setAllele(Object a_newValue) {
        this.m_value = (Boolean)a_newValue;
    }

    @Override
    public String getPersistentRepresentation() {
        String s = this.getInternalValue() == null ? "null" : this.getInternalValue().toString();
        return s;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setValueFromPersistentRepresentation(String a_representation) throws UnsupportedRepresentationException {
        if (a_representation == null) throw new UnsupportedRepresentationException("The input parameter must not be null!");
        if (a_representation.equals("null")) {
            this.m_value = null;
            return;
        } else if (a_representation.equals("true")) {
            this.m_value = TRUE_BOOLEAN;
            return;
        } else {
            if (!a_representation.equals("false")) throw new UnsupportedRepresentationException("Unknown boolean gene representation: " + a_representation);
            this.m_value = FALSE_BOOLEAN;
        }
    }

    public boolean booleanValue() {
        return this.m_value;
    }

    @Override
    public void setToRandomValue(RandomGenerator a_numberGenerator) {
        this.m_value = a_numberGenerator.nextBoolean() ? TRUE_BOOLEAN : FALSE_BOOLEAN;
    }

    public int compareTo(Object a_other) {
        BooleanGene otherBooleanGene = (BooleanGene)a_other;
        if (otherBooleanGene == null) {
            return 1;
        }
        if (otherBooleanGene.m_value == null) {
            if (this.m_value != null) {
                return 1;
            }
            if (this.isCompareApplicationData()) {
                return this.compareApplicationData(this.getApplicationData(), otherBooleanGene.getApplicationData());
            }
            return 0;
        }
        if (this.m_value == null) {
            if (otherBooleanGene.m_value == null) {
                if (this.isCompareApplicationData()) {
                    return this.compareApplicationData(this.getApplicationData(), otherBooleanGene.getApplicationData());
                }
                return 0;
            }
            return -1;
        }
        if (!this.m_value.booleanValue()) {
            if (!otherBooleanGene.m_value.booleanValue()) {
                if (this.isCompareApplicationData()) {
                    return this.compareApplicationData(this.getApplicationData(), otherBooleanGene.getApplicationData());
                }
                return 0;
            }
            return -1;
        }
        if (otherBooleanGene.m_value.booleanValue()) {
            if (this.isCompareApplicationData()) {
                return this.compareApplicationData(this.getApplicationData(), otherBooleanGene.getApplicationData());
            }
            return 0;
        }
        return 1;
    }

    @Override
    public void applyMutation(int a_index, double a_percentage) {
        if (this.m_value == null) {
            this.m_value = false;
        } else if (a_percentage > 0.0) {
            if (!this.m_value.booleanValue()) {
                this.m_value = true;
            }
        } else if (a_percentage < 0.0 && this.m_value.booleanValue()) {
            this.m_value = false;
        }
    }

    @Override
    protected Object getInternalValue() {
        return this.m_value;
    }

    @Override
    public int hashCode() {
        if (this.getInternalValue() == null) {
            return -2;
        }
        return super.hashCode();
    }

    @Override
    public String toString() {
        String s = "BooleanGene=";
        s = this.getInternalValue() == null ? s + "null" : s + this.getInternalValue().toString();
        return s;
    }
}

