/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;
import org.jgap.ICloneHandler;
import org.jgap.IJGAPFactory;
import org.jgap.InvalidConfigurationException;
import org.jgap.RandomGenerator;
import org.jgap.gp.CommandGene;
import org.jgap.gp.GPProgramBase;
import org.jgap.gp.IGPFitnessEvaluator;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.IProgramCreator;
import org.jgap.gp.impl.DefaultProgramCreator;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.GPProgram;
import org.jgap.gp.impl.GPProgramFitnessComparator;
import org.jgap.util.StringKit;

public class GPPopulation
implements Serializable,
Comparable {
    private static final String CVS_REVISION = "$Revision: 1.41 $";
    static final String GPPROGRAM_DELIMITER_HEADING = "<";
    static final String GPPROGRAM_DELIMITER_CLOSING = ">";
    static final String GPPROGRAM_DELIMITER = "#";
    public static final double DELTA = 1.0E-7;
    private transient Logger LOGGER = Logger.getLogger(GPPopulation.class);
    private IGPProgram[] m_programs;
    private float[] m_fitnessRank;
    private int m_popSize;
    private transient IGPProgram m_fittestProgram;
    private GPConfiguration m_config;
    private boolean m_changed;
    private boolean m_sorted;
    private IGPProgram m_fittestToAdd;

    public GPPopulation() throws Exception {
    }

    public GPPopulation(GPConfiguration a_config, int a_size) throws InvalidConfigurationException {
        if (a_config == null) {
            throw new InvalidConfigurationException("Configuration must not be null!");
        }
        if (a_size < 1) {
            throw new InvalidConfigurationException("Population size must be greater zero!");
        }
        this.m_config = a_config;
        this.m_programs = new GPProgram[a_size];
        this.m_popSize = a_size;
        this.m_fitnessRank = new float[a_size];
        for (int i = 0; i < a_size; ++i) {
            this.m_fitnessRank[i] = 0.5f;
        }
    }

    public GPPopulation(GPPopulation a_pop) throws InvalidConfigurationException {
        this(a_pop, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GPPopulation(GPPopulation a_pop, boolean a_keepPrograms) throws InvalidConfigurationException {
        this.m_config = a_pop.getGPConfiguration();
        this.m_popSize = a_pop.getPopSize();
        this.m_programs = new GPProgram[this.m_popSize];
        this.m_fitnessRank = new float[this.m_popSize];
        if (a_keepPrograms) {
            IGPProgram[] iGPProgramArray = this.m_programs;
            synchronized (this.m_programs) {
                for (int i = 0; i < this.m_popSize; ++i) {
                    this.m_programs[i] = a_pop.getGPProgram(i);
                    this.m_fitnessRank[i] = a_pop.getFitnessRank(i);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                this.m_fittestProgram = a_pop.determineFittestProgramComputed();
                if (this.m_fittestProgram != null) {
                    this.m_fittestProgram = (IGPProgram)this.m_fittestProgram.clone();
                }
                this.setChanged(a_pop.isChanged());
                if (!this.m_changed) {
                    this.m_sorted = true;
                }
            }
        } else {
            for (int i = 0; i < this.m_popSize; ++i) {
                this.m_fitnessRank[i] = 0.5f;
            }
        }
    }

    public void sort(Comparator c) {
        Arrays.sort(this.m_programs, c);
        float f = 0.0f;
        for (int i = 0; i < this.m_programs.length; ++i) {
            if (this.m_fitnessRank.length > i) {
                this.m_fitnessRank[i] = f;
            }
            if (this.m_programs[i] == null) continue;
            f = (float)((double)f + this.m_programs[i].getFitnessValue());
        }
    }

    public void create(Class[] a_types, Class[][] a_argTypes, CommandGene[][] a_nodeSets, int[] a_minDepths, int[] a_maxDepths, int a_maxNodes, boolean[] a_fullModeAllowed) throws InvalidConfigurationException {
        this.create(a_types, a_argTypes, a_nodeSets, a_minDepths, a_maxDepths, a_maxNodes, a_fullModeAllowed, new DefaultProgramCreator());
    }

    public void create(Class[] a_types, Class[][] a_argTypes, CommandGene[][] a_nodeSets, int[] a_minDepths, int[] a_maxDepths, int a_maxNodes, boolean[] a_fullModeAllowed, IProgramCreator a_programCreator) throws InvalidConfigurationException {
        this.create(a_types, a_argTypes, a_nodeSets, a_minDepths, a_maxDepths, a_maxNodes, a_fullModeAllowed, a_programCreator, 0);
    }

    public void create(Class[] a_types, Class[][] a_argTypes, CommandGene[][] a_nodeSets, int[] a_minDepths, int[] a_maxDepths, int a_maxNodes, boolean[] a_fullModeAllowed, IProgramCreator a_programCreator, int a_offset) throws InvalidConfigurationException {
        int divisor = this.m_popSize < 2 ? 1 : this.m_popSize - 1;
        int genNr = this.getGPConfiguration().getGenerationNr();
        int genI = new Random().nextInt(this.m_popSize);
        RandomGenerator generator = this.getGPConfiguration().getRandomGenerator();
        int minDepth = this.getGPConfiguration().getMinInitDepth();
        int maxDepth = this.getGPConfiguration().getMaxInitDepth();
        for (int i = a_offset; i < this.m_popSize; ++i) {
            IGPProgram program = null;
            int depth = minDepth + (maxDepth - minDepth) * i / divisor;
            int tries = 0;
            int maxTries = this.getGPConfiguration().getProgramCreationMaxtries();
            while (true) {
                try {
                    boolean grow = i % 2 == 0 || generator.nextInt(8) > 6;
                    program = this.create(i, a_types, a_argTypes, a_nodeSets, a_minDepths, a_maxDepths, depth, grow, a_maxNodes, a_fullModeAllowed, tries, a_programCreator);
                    if (program != null && this.getGPConfiguration().getPrototypeProgram() == null) {
                        this.getGPConfiguration().setPrototypeProgram(program);
                        this.LOGGER.info((Object)"Prototype program set");
                        break;
                    }
                    if (genNr % 5 != 0 || genNr <= 0 || i != genI) break;
                    double protoFitness = this.getGPConfiguration().getPrototypeProgram().getFitnessValue();
                    if (!this.getGPConfiguration().getGPFitnessEvaluator().isFitter(program.getFitnessValue(), protoFitness)) break;
                    this.getGPConfiguration().setPrototypeProgram(program);
                }
                catch (IllegalStateException iex) {
                    if (depth < maxDepth) {
                        depth += generator.nextInt(2);
                        continue;
                    }
                    if ((depth -= generator.nextInt(4)) >= minDepth) continue;
                    depth = minDepth;
                    if ((maxTries < 0 || ++tries <= maxTries) && (i <= a_offset || tries <= 40)) continue;
                    IGPProgram prototype = this.getGPConfiguration().getPrototypeProgram();
                    if (prototype != null) {
                        ICloneHandler cloner = this.getGPConfiguration().getJGAPFactory().getCloneHandlerFor(prototype, null);
                        if (cloner != null) {
                            try {
                                program = (IGPProgram)cloner.perform(prototype, null, null);
                                this.LOGGER.warn((Object)"Prototype program reused because random program did not satisfy constraints");
                                break;
                            }
                            catch (Exception ex) {
                                throw iex;
                            }
                        }
                        this.LOGGER.warn((Object)("Warning: no clone handler found for prototype program type " + prototype));
                    }
                    throw iex;
                }
                break;
            }
            this.setGPProgram(i, program);
        }
        this.setChanged(true);
    }

    public IGPProgram create(Class[] a_types, Class[][] a_argTypes, CommandGene[][] a_nodeSets, int[] a_minDepths, int[] a_maxDepths, int a_depth, boolean a_grow, int a_maxNodes, boolean[] a_fullModeAllowed, int a_tries) throws InvalidConfigurationException {
        return this.create(0, a_types, a_argTypes, a_nodeSets, a_minDepths, a_maxDepths, a_depth, a_grow, a_maxNodes, a_fullModeAllowed, a_tries);
    }

    public IGPProgram create(int a_programIndex, Class[] a_types, Class[][] a_argTypes, CommandGene[][] a_nodeSets, int[] a_minDepths, int[] a_maxDepths, int a_depth, boolean a_grow, int a_maxNodes, boolean[] a_fullModeAllowed, int a_tries) throws InvalidConfigurationException {
        return this.create(a_programIndex, a_types, a_argTypes, a_nodeSets, a_minDepths, a_maxDepths, a_depth, a_grow, a_maxNodes, a_fullModeAllowed, a_tries, new DefaultProgramCreator());
    }

    public IGPProgram create(int a_programIndex, Class[] a_types, Class[][] a_argTypes, CommandGene[][] a_nodeSets, int[] a_minDepths, int[] a_maxDepths, int a_depth, boolean a_grow, int a_maxNodes, boolean[] a_fullModeAllowed, int a_tries, IProgramCreator a_programCreator) throws InvalidConfigurationException {
        if (this.m_fittestToAdd != null) {
            IGPProgram program;
            ICloneHandler cloner = this.getGPConfiguration().getJGAPFactory().getCloneHandlerFor(this.m_fittestToAdd, null);
            if (cloner == null) {
                program = this.m_fittestToAdd;
            } else {
                try {
                    program = (IGPProgram)cloner.perform(this.m_fittestToAdd, null, null);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    program = this.m_fittestToAdd;
                }
            }
            this.m_fittestToAdd = null;
            return program;
        }
        IGPProgram program = a_programCreator.create(this.getGPConfiguration(), a_programIndex, a_types, a_argTypes, a_nodeSets, a_minDepths, a_maxDepths, a_maxNodes, a_depth, a_grow, a_tries, a_fullModeAllowed);
        return program;
    }

    public int getPopSize() {
        return this.m_popSize;
    }

    public GPConfiguration getGPConfiguration() {
        return this.m_config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGPProgram(int a_index, IGPProgram a_program) {
        IGPProgram[] iGPProgramArray = this.m_programs;
        synchronized (this.m_programs) {
            this.m_programs[a_index] = a_program;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.setChanged(true);
            return;
        }
    }

    public IGPProgram getGPProgram(int a_index) {
        return this.m_programs[a_index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGPPrograms(GPPopulation a_pop) {
        IGPProgram[] iGPProgramArray = this.m_programs;
        synchronized (this.m_programs) {
            this.m_programs = a_pop.m_programs;
            this.m_popSize = this.m_programs.length;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.setChanged(true);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGPPrograms(IGPProgram[] a_progs) {
        IGPProgram[] iGPProgramArray = this.m_programs;
        synchronized (this.m_programs) {
            this.m_programs = a_progs;
            this.m_popSize = this.m_programs.length;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.setChanged(true);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyGPPrograms(GPPopulation a_pop) {
        int size = a_pop.size();
        IGPProgram[] iGPProgramArray = this.m_programs;
        synchronized (this.m_programs) {
            for (int i = 0; i < size; ++i) {
                this.m_programs[i] = a_pop.getGPProgram(i);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.setChanged(true);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGPPrograms(List a_pop) {
        IGPProgram[] iGPProgramArray = this.m_programs;
        synchronized (this.m_programs) {
            int size = a_pop.size();
            this.m_programs = new GPProgram[size];
            for (int i = 0; i < size; ++i) {
                this.m_programs[i] = (IGPProgram)a_pop.get(i);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.setChanged(true);
            return;
        }
    }

    public IGPProgram[] getGPPrograms() {
        return this.m_programs;
    }

    public int size() {
        return this.m_programs.length;
    }

    public IGPProgram determineFittestProgram() {
        if (!this.m_changed && this.m_fittestProgram != null) {
            return this.m_fittestProgram;
        }
        double bestFitness = -1.0;
        IGPFitnessEvaluator evaluator = this.getGPConfiguration().getGPFitnessEvaluator();
        for (int i = 0; i < this.m_programs.length && this.m_programs[i] != null; ++i) {
            double fitness;
            IGPProgram program = this.m_programs[i];
            try {
                fitness = program.getFitnessValue();
            }
            catch (IllegalStateException iex) {
                fitness = Double.NaN;
            }
            if (Double.isNaN(fitness) || !(Math.abs(-1.0 - fitness) > 1.0E-7) || this.m_fittestProgram != null && !evaluator.isFitter(fitness, bestFitness)) continue;
            bestFitness = fitness;
            this.m_fittestProgram = program;
        }
        this.setChanged(false);
        if (this.m_fittestProgram != null) {
            IJGAPFactory factory = this.getGPConfiguration().getJGAPFactory();
            if (factory == null) {
                throw new IllegalStateException("JGAPFactory must not be null!");
            }
            ICloneHandler cloner = factory.getCloneHandlerFor(this.m_fittestProgram, null);
            if (cloner != null) {
                try {
                    this.m_fittestProgram = (IGPProgram)cloner.perform(this.m_fittestProgram, null, null);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        return this.m_fittestProgram;
    }

    public IGPProgram determineFittestProgramComputed() {
        double bestFitness = -1.0;
        IGPFitnessEvaluator evaluator = this.getGPConfiguration().getGPFitnessEvaluator();
        IGPProgram fittest = null;
        for (int i = 0; i < this.m_programs.length && this.m_programs[i] != null; ++i) {
            double fitness;
            IGPProgram program = this.m_programs[i];
            if (program instanceof GPProgramBase) {
                GPProgramBase program1 = (GPProgramBase)program;
                fitness = program1.getFitnessValueDirectly();
            } else {
                fitness = program.getFitnessValue();
            }
            if (!(Math.abs(fitness - -1.0) > 1.0E-7) || fittest != null && !evaluator.isFitter(fitness, bestFitness)) continue;
            fittest = program;
            bestFitness = fitness;
        }
        return fittest;
    }

    public List determineFittestChromosomes(int a_numberOfPrograms) {
        int numberOfChromosomes = Math.min(a_numberOfPrograms, this.m_programs.length);
        if (numberOfChromosomes <= 0) {
            return null;
        }
        if (!this.m_changed && this.m_sorted) {
            return Arrays.asList(this.m_programs).subList(0, numberOfChromosomes);
        }
        this.sortByFitness();
        return Arrays.asList(this.m_programs).subList(0, numberOfChromosomes);
    }

    public void sortByFitness() {
        this.sort(new GPProgramFitnessComparator(this.getGPConfiguration().getGPFitnessEvaluator()));
        this.setChanged(false);
        this.setSorted(true);
        this.m_fittestProgram = this.m_programs[0];
    }

    public float[] getFitnessRanks() {
        return this.m_fitnessRank;
    }

    public float getFitnessRank(int a_index) {
        return this.m_fitnessRank[a_index];
    }

    protected void setChanged(boolean a_changed) {
        this.m_changed = a_changed;
        this.setSorted(false);
    }

    public boolean isChanged() {
        return this.m_changed;
    }

    protected void setSorted(boolean a_sorted) {
        this.m_sorted = a_sorted;
    }

    public int compareTo(Object a_pop) {
        int size2;
        GPPopulation other = (GPPopulation)a_pop;
        if (a_pop == null) {
            return 1;
        }
        int size1 = this.size();
        if (size1 != (size2 = other.size())) {
            if (size1 < size2) {
                return -1;
            }
            return 1;
        }
        IGPProgram[] progs2 = other.getGPPrograms();
        for (int i = 0; i < size1; ++i) {
            if (this.containedInArray(progs2, this.m_programs[i])) continue;
            return 1;
        }
        return 0;
    }

    protected boolean containedInArray(IGPProgram[] a_progs, IGPProgram a_prog) {
        for (int i = 0; i < a_progs.length; ++i) {
            if (a_progs[i] == null) {
                return false;
            }
            if (!a_progs[i].equals(a_prog)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object a_pop) {
        try {
            return this.compareTo(a_pop) == 0;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public void addFittestProgram(IGPProgram a_toAdd) {
        if (a_toAdd != null) {
            this.m_fittestToAdd = a_toAdd;
        }
    }

    public void clear() {
        for (int i = 0; i < this.m_programs.length; ++i) {
            this.m_programs[i] = null;
        }
        this.m_changed = true;
        this.m_sorted = true;
        this.m_fittestProgram = null;
    }

    public boolean isFirstEmpty() {
        if (this.size() < 1) {
            return true;
        }
        return this.m_programs[0] == null;
    }

    public String getPersistentRepresentation() {
        StringBuffer b = new StringBuffer();
        for (IGPProgram program : this.m_programs) {
            b.append(GPPROGRAM_DELIMITER_HEADING);
            b.append(this.encode(program.getClass().getName() + GPPROGRAM_DELIMITER + program.getPersistentRepresentation()));
            b.append(GPPROGRAM_DELIMITER_CLOSING);
        }
        return b.toString();
    }

    protected String encode(String a_string) {
        return StringKit.encode(a_string);
    }

    protected String decode(String a_string) {
        return StringKit.decode(a_string);
    }
}

