/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.function;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.jgap.InvalidConfigurationException;
import org.jgap.RandomGenerator;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.IMutateable;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class SubProgram
extends CommandGene
implements ICloneable,
IMutateable {
    private static final String CVS_REVISION = "$Revision: 1.18 $";
    private int m_subtrees;
    private int m_minArity;
    private int m_maxArity;
    private Class[] m_types;
    private boolean m_mutateable;
    private int m_mode;

    public SubProgram(GPConfiguration a_conf, Class[] a_types) throws InvalidConfigurationException {
        this(a_conf, a_types, 0, null);
    }

    public SubProgram(GPConfiguration a_conf, int a_arity, Class a_types) throws InvalidConfigurationException {
        this(a_conf, a_arity, a_types, false);
    }

    public SubProgram(GPConfiguration a_conf, int a_arity, Class a_types, boolean a_mutateable) throws InvalidConfigurationException {
        this(a_conf, a_arity, a_types, a_arity, a_arity + 5, a_mutateable);
    }

    public SubProgram(GPConfiguration a_conf, int a_arity, Class a_types, int a_minArity, int a_maxArity, boolean a_mutateable) throws InvalidConfigurationException {
        super(a_conf, a_arity, a_types, 0, null);
        if (a_arity < 1) {
            throw new IllegalArgumentException("Arity must be >= 1");
        }
        if (a_minArity > a_arity) {
            throw new IllegalArgumentException("Arity must not be smaller than min. arity");
        }
        if (a_maxArity < a_arity) {
            throw new IllegalArgumentException("Arity must not be bigger than max. arity");
        }
        this.m_mode = 2;
        this.m_types = new Class[a_arity];
        for (int i = 0; i < a_arity; ++i) {
            this.m_types[i] = a_types;
        }
        this.m_subtrees = a_arity;
        this.m_mutateable = a_mutateable;
        this.m_minArity = a_minArity;
        this.m_maxArity = a_maxArity;
    }

    public SubProgram(GPConfiguration a_conf, Class[] a_types, boolean a_mutateable) throws InvalidConfigurationException {
        this(a_conf, a_types, 0, null, a_mutateable);
    }

    public SubProgram(GPConfiguration a_conf, Class[] a_types, int a_subReturnType, int[] a_subChildTypes) throws InvalidConfigurationException {
        this(a_conf, a_types, a_subReturnType, a_subChildTypes, false);
    }

    public SubProgram(GPConfiguration a_conf, Class[] a_types, int a_subReturnType, int[] a_subChildTypes, boolean a_mutateable) throws InvalidConfigurationException {
        super(a_conf, a_types.length, a_types[a_types.length - 1], a_subReturnType, a_subChildTypes);
        if (a_types.length < 1) {
            throw new IllegalArgumentException("Number of subtrees must be >= 1");
        }
        this.m_mode = 1;
        this.m_minArity = a_types.length;
        this.m_maxArity = this.m_minArity + 5;
        this.m_types = a_types;
        this.m_subtrees = a_types.length;
        this.m_mutateable = a_mutateable;
    }

    @Override
    public String toString() {
        String ret = "sub[";
        for (int i = 1; i < this.m_subtrees; ++i) {
            ret = ret + "&" + i + " --> ";
        }
        ret = ret + "&" + this.m_subtrees + "]";
        return ret;
    }

    @Override
    public String getName() {
        return "Sub program";
    }

    @Override
    public int execute_int(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        int value = -1;
        for (int i = 0; i < this.m_subtrees; ++i) {
            if (i < this.m_subtrees - 1) {
                c.execute_void(n, i, args);
                continue;
            }
            value = c.execute_int(n, i, args);
        }
        return value;
    }

    @Override
    public void execute_void(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        for (int i = 0; i < this.m_subtrees; ++i) {
            c.execute_void(n, i, args);
        }
    }

    @Override
    public long execute_long(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        long value = -1L;
        for (int i = 0; i < this.m_subtrees; ++i) {
            value = c.execute_long(n, i, args);
        }
        return value;
    }

    @Override
    public float execute_float(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        float value = -1.0f;
        for (int i = 0; i < this.m_subtrees; ++i) {
            value = c.execute_float(n, i, args);
        }
        return value;
    }

    @Override
    public double execute_double(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        double value = -1.0;
        for (int i = 0; i < this.m_subtrees; ++i) {
            value = c.execute_double(n, i, args);
        }
        return value;
    }

    @Override
    public Object execute_object(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        Object value = null;
        for (int i = 0; i < this.m_subtrees; ++i) {
            value = c.execute_object(n, i, args);
        }
        return value;
    }

    @Override
    public boolean isValid(ProgramChromosome a_program) {
        return true;
    }

    @Override
    public Class getChildType(IGPProgram a_ind, int a_chromNum) {
        try {
            return this.m_types[a_chromNum];
        }
        catch (ArrayIndexOutOfBoundsException aex) {
            return null;
        }
    }

    @Override
    public int compareTo(Object a_other) {
        int result = super.compareTo(a_other);
        if (result != 0) {
            return result;
        }
        SubProgram other = (SubProgram)a_other;
        return new CompareToBuilder().append((Object[])this.m_types, (Object[])other.m_types).toComparison();
    }

    @Override
    public boolean equals(Object a_other) {
        try {
            SubProgram other = (SubProgram)a_other;
            return super.equals(a_other) && new EqualsBuilder().append((Object[])this.m_types, (Object[])other.m_types).isEquals();
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    @Override
    public Object clone() {
        try {
            SubProgram result;
            if (this.m_mode == 1) {
                Class[] types = new Class[this.m_subtrees];
                for (int i = 0; i < this.m_subtrees; ++i) {
                    types[i] = this.m_types[this.m_types.length - 1];
                }
                int[] subChildTypes = this.getSubChildTypes();
                if (subChildTypes != null) {
                    subChildTypes = (int[])subChildTypes.clone();
                }
                result = new SubProgram(this.getGPConfiguration(), types, this.getSubReturnType(), subChildTypes, this.m_mutateable);
            } else {
                result = new SubProgram(this.getGPConfiguration(), this.m_subtrees, this.m_types[0], this.m_minArity, this.m_maxArity, this.m_mutateable);
            }
            return result;
        }
        catch (Throwable t) {
            throw new CloneException(t);
        }
    }

    @Override
    public CommandGene applyMutation(int index, double a_percentage) throws InvalidConfigurationException {
        if (!this.m_mutateable) {
            return this;
        }
        RandomGenerator randomGen = this.getGPConfiguration().getRandomGenerator();
        double random = randomGen.nextDouble();
        if (random < a_percentage) {
            return this.applyMutation();
        }
        return this;
    }

    public CommandGene applyMutation() throws InvalidConfigurationException {
        SubProgram result;
        int size = this.getGPConfiguration().getRandomGenerator().nextInt(this.m_maxArity + 1 - this.m_minArity) + this.m_minArity;
        if (this.m_types.length == size) {
            return this;
        }
        if (this.m_mode == 1) {
            Class[] types = new Class[size];
            for (int i = 0; i < size; ++i) {
                types[i] = this.m_types[this.m_types.length - 1];
            }
            int[] subChildTypes = this.getSubChildTypes();
            if (subChildTypes != null) {
                subChildTypes = (int[])subChildTypes.clone();
            }
            result = new SubProgram(this.getGPConfiguration(), types, this.getSubReturnType(), subChildTypes, this.m_mutateable);
        } else {
            result = new SubProgram(this.getGPConfiguration(), size, this.m_types[0], this.m_minArity, this.m_maxArity, this.m_mutateable);
        }
        return result;
    }
}

