/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.function;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class ReadTerminalIndexed
extends CommandGene
implements ICloneable {
    private static final String CVS_REVISION = "$Revision: 1.5 $";
    private int m_index;

    public ReadTerminalIndexed(GPConfiguration a_conf, Class a_returnType, int a_index) throws InvalidConfigurationException {
        this(a_conf, a_returnType, a_index, 0);
    }

    public ReadTerminalIndexed(GPConfiguration a_conf, Class a_returnType, int a_index, int a_subReturnType) throws InvalidConfigurationException {
        super(a_conf, 0, a_returnType, a_subReturnType, null);
        if (a_index < 0 || a_index > this.getGPConfiguration().getMemorySize()) {
            throw new IllegalArgumentException("Memory index invalid!");
        }
        this.m_index = a_index;
    }

    @Override
    public String toString() {
        return "read_from_index(" + this.m_index + ")";
    }

    @Override
    public String getName() {
        return "Read Terminal Indexed";
    }

    @Override
    public int execute_int(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        try {
            try {
                return (Integer)this.getGPConfiguration().readIndexedMemory(this.m_index);
            }
            catch (NullPointerException nex) {
                throw new IllegalArgumentException();
            }
        }
        catch (IllegalArgumentException iex) {
            throw new IllegalStateException("ReadTerminalIndexed without preceeding StoreTerminalIndexed");
        }
    }

    @Override
    public long execute_long(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        try {
            try {
                return (Long)this.getGPConfiguration().readIndexedMemory(this.m_index);
            }
            catch (NullPointerException nex) {
                throw new IllegalArgumentException();
            }
        }
        catch (IllegalArgumentException iex) {
            throw new IllegalStateException("ReadTerminalIndexed without preceeding StoreTerminalIndexed");
        }
    }

    @Override
    public double execute_double(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        try {
            try {
                return (Double)this.getGPConfiguration().readIndexedMemory(this.m_index);
            }
            catch (NullPointerException nex) {
                throw new IllegalArgumentException();
            }
        }
        catch (IllegalArgumentException iex) {
            throw new IllegalStateException("ReadTerminalIndexed without preceeding StoreTerminalIndexed");
        }
    }

    @Override
    public float execute_float(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        try {
            try {
                return ((Float)this.getGPConfiguration().readIndexedMemory(this.m_index)).floatValue();
            }
            catch (NullPointerException nex) {
                throw new IllegalArgumentException();
            }
        }
        catch (IllegalArgumentException iex) {
            throw new IllegalStateException("ReadTerminalIndexed without preceeding StoreTerminalIndexed");
        }
    }

    @Override
    public Object execute_object(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        try {
            try {
                return this.getGPConfiguration().readIndexedMemory(this.m_index);
            }
            catch (NullPointerException nex) {
                throw new IllegalArgumentException();
            }
        }
        catch (IllegalArgumentException iex) {
            throw new IllegalStateException("ReadTerminalIndexed without preceeding StoreTerminalIndexed");
        }
    }

    @Override
    public int compareTo(Object a_other) {
        int result = super.compareTo(a_other);
        if (result != 0) {
            return result;
        }
        ReadTerminalIndexed other = (ReadTerminalIndexed)a_other;
        return new CompareToBuilder().append(this.m_index, other.m_index).toComparison();
    }

    @Override
    public boolean equals(Object a_other) {
        try {
            ReadTerminalIndexed other = (ReadTerminalIndexed)a_other;
            return super.equals(a_other) && new EqualsBuilder().append(this.m_index, other.m_index).isEquals();
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    @Override
    public Object clone() {
        try {
            ReadTerminalIndexed result = new ReadTerminalIndexed(this.getGPConfiguration(), this.getReturnType(), this.m_index, this.getSubReturnType());
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }
}

