/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.function;

import org.jgap.InvalidConfigurationException;
import org.jgap.gp.MathCommand;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class Pow
extends MathCommand
implements ICloneable {
    private static final String CVS_REVISION = "$Revision: 1.8 $";

    public Pow(GPConfiguration a_conf, Class a_returnType) throws InvalidConfigurationException {
        super(a_conf, 2, a_returnType);
    }

    @Override
    public String toString() {
        return "&1 ^ &2";
    }

    @Override
    public String getName() {
        return "Power";
    }

    @Override
    public int execute_int(ProgramChromosome c, int n, Object[] args) {
        int i = c.execute_int(n, 0, args);
        int j = c.execute_int(n, 1, args);
        return (int)Math.pow(Math.max(-10000.0f, Math.min((float)i, 20.0f)), Math.max(-10000.0f, Math.min((float)j, 20.0f)));
    }

    @Override
    public float execute_float(ProgramChromosome c, int n, Object[] args) {
        float f = c.execute_float(n, 0, args);
        float g = c.execute_float(n, 1, args);
        return (float)Math.pow(Math.max(-10000.0f, Math.min(f, 20.0f)), Math.max(-10000.0f, Math.min(g, 20.0f)));
    }

    @Override
    public double execute_double(ProgramChromosome c, int n, Object[] args) {
        double f = c.execute_double(n, 0, args);
        double g = c.execute_double(n, 1, args);
        return Math.pow(Math.max(-10000.0, Math.min(f, 20.0)), Math.max(-10000.0, Math.min(g, 20.0)));
    }

    @Override
    public Object execute_object(ProgramChromosome c, int n, Object[] args) {
        return ((Compatible)c.execute_object(n, 0, args)).execute_pow(c.execute_object(n, 1, args));
    }

    @Override
    public Object clone() {
        try {
            Pow result = new Pow(this.getGPConfiguration(), this.getReturnType());
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }

    protected static interface Compatible {
        public Object execute_pow(Object var1);
    }
}

