/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.data.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.jgap.data.config.ConfigProperty;
import org.jgap.data.config.MetaConfigException;

public class MetaConfig {
    private static final String METACON_FILENAME = "jgap-meta.con";
    private static final String CN = "MetaConfig";
    private static MetaConfig instance;
    private Hashtable m_metaMap = new Hashtable();
    private int m_state = 0;
    private static final int INIT = 0;
    private static final int CLASS = 1;
    private static final int PROPERTY = 2;
    private static final int VALUES = 3;
    private String m_currName;
    private ConfigProperty m_currProperty;

    public static MetaConfig getInstance() throws MetaConfigException, IOException {
        if (null == instance) {
            instance = new MetaConfig();
        }
        return instance;
    }

    private MetaConfig() throws MetaConfigException, IOException {
        this.init();
    }

    public List getConfigProperty(String className) {
        return (List)this.m_metaMap.get(className);
    }

    protected void init() throws MetaConfigException, IOException {
        Reader fr = this.getReader(METACON_FILENAME);
        LineNumberReader lr = new LineNumberReader(fr);
        String line = lr.readLine();
        while (line != null) {
            if (!this.isComment(line)) {
                this.parseLine(line);
            }
            line = lr.readLine();
        }
        this.endState();
        lr.close();
    }

    public Reader getReader(String a_filename) throws IOException {
        File metaFile = new File(a_filename);
        FileReader fr = new FileReader(metaFile);
        return fr;
    }

    private boolean isComment(String line) {
        String tmpLine = line.trim();
        StringBuffer sb = new StringBuffer(tmpLine);
        return sb.charAt(0) == '#';
    }

    private void parseLine(String a_line) throws MetaConfigException {
        String[] tokens = a_line.split("=");
        if (tokens == null || tokens.length != 2) {
            throw new MetaConfigException("MetaConfig.parseLine():Exception while parsing jgap-meta.con line " + a_line + " is invalid");
        }
        if (this.m_state == 0 && tokens[0].equals("class")) {
            this.handleClass(tokens[1]);
        } else if (this.m_state == 1 && tokens[0].equals("property")) {
            this.handleProperty(tokens[1]);
        } else if (this.m_state == 2 && tokens[0].equals("values")) {
            this.handleValues(tokens[1]);
        } else if (this.m_state == 2 && tokens[0].equals("class")) {
            this.handleClass(tokens[1]);
        } else if (this.m_state == 3 && tokens[0].equals("class")) {
            this.handleClass(tokens[1]);
        } else if (this.m_state == 3 && tokens[0].equals("property")) {
            this.handleProperty(tokens[1]);
        } else {
            throw new MetaConfigException("MetaConfig.parseLine():Exception while parsing jgap-meta.con state " + this.m_state + " incompatible with line " + a_line);
        }
    }

    private void handleClass(String a_token) {
        this.m_state = 1;
        if (this.m_currProperty != null) {
            this.add(this.m_currName, this.m_currProperty);
        }
        this.m_currProperty = new ConfigProperty();
        this.m_currName = a_token;
    }

    private void handleProperty(String a_token) throws MetaConfigException {
        int prevState = this.m_state;
        if (prevState == 3 && this.m_currProperty != null) {
            this.add(this.m_currName, this.m_currProperty);
        }
        this.m_currProperty = new ConfigProperty();
        this.m_state = 2;
        String[] tokens = a_token.split(",");
        if (tokens.length < 2 || tokens.length > 3) {
            throw new MetaConfigException("Invalid format of property line: " + a_token);
        }
        this.m_currProperty.setName(tokens[0].trim());
        this.m_currProperty.setWidget(tokens[1].trim());
        if (tokens.length == 3) {
            this.m_currProperty.setLabel(tokens[2]);
        }
    }

    private void handleValues(String a_token) throws MetaConfigException {
        this.m_state = 3;
        String[] tokens = a_token.split(",");
        if (tokens.length == 0) {
            throw new MetaConfigException("Invalid format of property line: " + a_token);
        }
        for (int i = 0; i < tokens.length; ++i) {
            this.m_currProperty.addValue(tokens[i].trim());
        }
    }

    private void endState() throws MetaConfigException {
        if (this.m_state != 2 && this.m_state != 3) {
            throw new MetaConfigException("Invalid format of JGAP MetaConfig file: jgap-meta.conEnding in Invalid state : " + this.m_state);
        }
        if (this.m_currProperty != null) {
            this.add(this.m_currName, this.m_currProperty);
        }
    }

    private void add(String currName, ConfigProperty a_cp) {
        List<ConfigProperty> props = (List<ConfigProperty>)this.m_metaMap.get(currName);
        if (null == props) {
            props = Collections.synchronizedList(new ArrayList());
            this.m_metaMap.put(currName, props);
        }
        props.add(a_cp);
    }
}

