/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.audit;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.jgap.Configuration;
import org.jgap.Genotype;
import org.jgap.IChromosome;
import org.jgap.InvalidConfigurationException;
import org.jgap.Population;
import org.jgap.audit.KeyedValues2D;
import org.jgap.audit.PermutingConfiguration;

public class Evaluator
implements Serializable {
    private static final String CVS_REVISION = "$Revision: 1.12 $";
    private Map<Object, KeyedValues2D> m_permutationData;
    private Map<Integer, Map> m_permutationRuns;
    private KeyedValues2D m_data;
    private PermutingConfiguration m_permConf;
    private Map<String, GenotypeData> m_genotypeData;
    private List<GenotypeDataAvg> m_genotypeDataAvg;

    public Evaluator(PermutingConfiguration a_conf) {
        if (a_conf == null) {
            throw new IllegalArgumentException("Permuting Configuration must not be null!");
        }
        this.m_permConf = a_conf;
        this.m_data = new KeyedValues2D();
        this.m_permutationData = new Hashtable<Object, KeyedValues2D>();
        this.m_permutationRuns = new Hashtable<Integer, Map>();
        this.m_genotypeData = new Hashtable<String, GenotypeData>();
        this.m_genotypeDataAvg = new Vector<GenotypeDataAvg>();
    }

    public boolean hasNext() {
        return this.m_permConf.hasNext();
    }

    public Configuration next() throws InvalidConfigurationException {
        return this.m_permConf.next();
    }

    public void setValue(double a_value, Comparable a_rowKey, Comparable a_columnKey) {
        this.m_data.setValue(new Double(a_value), a_rowKey, a_columnKey);
    }

    public Number getValue(Comparable rowKey, Comparable columnKey) {
        return this.m_data.getValue(rowKey, columnKey);
    }

    public void setValue(int a_permutation, int a_run, double a_value, Comparable a_rowKey, Comparable a_columnKey) {
        Object key = this.createKey(a_permutation, a_run);
        KeyedValues2D a_data = this.m_permutationData.get(key);
        if (a_data == null) {
            a_data = new KeyedValues2D();
            this.m_permutationData.put(key, a_data);
        }
        this.addRunNumber(a_permutation, a_run);
        a_data.setValue(new Double(a_value), a_rowKey, a_columnKey);
    }

    protected void addRunNumber(int a_permutation, int a_run) {
        Hashtable<Integer, Integer> v = this.m_permutationRuns.get(new Integer(a_permutation));
        if (v == null) {
            v = new Hashtable<Integer, Integer>();
        }
        v.put(new Integer(a_run), new Integer(a_run));
        this.m_permutationRuns.put(new Integer(a_permutation), v);
    }

    public Number getValue(int a_permutation, int a_run, Comparable rowKey, Comparable columnKey) {
        KeyedValues2D a_data = this.m_permutationData.get(this.createKey(a_permutation, a_run));
        if (a_data == null) {
            return null;
        }
        return a_data.getValue(rowKey, columnKey);
    }

    public KeyedValues2D getData() {
        return this.m_data;
    }

    protected Object createKey(int a_permutation, int a_run) {
        return a_permutation + "_" + a_run;
    }

    public KeyedValues2D calcAvgFitness(int a_permutation) {
        if (a_permutation == -1) {
            Iterator<Integer> it = this.m_permutationRuns.keySet().iterator();
            KeyedValues2D result = new KeyedValues2D();
            while (it.hasNext()) {
                Integer permNumberI = it.next();
                int permNumber = permNumberI;
                this.calcAvgFitnessHelper(permNumber, result);
            }
            return result;
        }
        KeyedValues2D a_data = new KeyedValues2D();
        this.calcAvgFitnessHelper(a_permutation, a_data);
        return a_data;
    }

    protected void calcAvgFitnessHelper(int a_permutation, KeyedValues2D result) {
        Map runNumbers = this.m_permutationRuns.get(new Integer(a_permutation));
        if (runNumbers == null) {
            return;
        }
        Iterator it = runNumbers.keySet().iterator();
        int numRuns = runNumbers.keySet().size();
        while (it.hasNext()) {
            Integer runI = (Integer)it.next();
            KeyedValues2D a_data = this.m_permutationData.get(this.createKey(a_permutation, runI));
            for (int col = 0; col < a_data.getColumnCount(); ++col) {
                for (int row = 0; row < a_data.getRowCount(); ++row) {
                    Double d = (Double)result.getValue(a_data.getRowKey(row), a_data.getColumnKey(col));
                    double newValue = d == null ? 0.0 : d;
                    result.setValue(new Double(newValue += a_data.getValue(a_data.getRowKey(row), a_data.getColumnKey(col)).doubleValue() / (double)numRuns), a_data.getRowKey(row), a_data.getColumnKey(col));
                }
            }
        }
    }

    public KeyedValues2D calcAvgFitnessImpr(int a_permutation) {
        Map runNumbers = this.m_permutationRuns.get(new Integer(a_permutation));
        if (runNumbers == null) {
            return null;
        }
        for (Integer runI : runNumbers.keySet()) {
            KeyedValues2D a_data = this.m_permutationData.get(this.createKey(a_permutation, runI));
            for (int col = 0; col < a_data.getColumnCount(); ++col) {
                for (int row = 0; row < a_data.getRowCount(); ++row) {
                }
            }
        }
        return null;
    }

    public int getNumberOfRuns(int a_permutation) {
        Map runNumbers = this.m_permutationRuns.get(new Integer(a_permutation));
        if (runNumbers == null) {
            return 0;
        }
        return runNumbers.keySet().size();
    }

    public void storeGenotype(int a_permutation, int a_run, Genotype a_genotype) {
        this.storePopulation(a_permutation, a_run, a_genotype.getPopulation());
    }

    public void storePopulation(int a_permutation, int a_run, Population a_pop) {
        int generation;
        GenotypeData data = new GenotypeData();
        data.generation = generation = a_pop.getConfiguration().getGenerationNr();
        Population pop = a_pop;
        data.hashCode = a_pop.hashCode();
        int popSize = pop.size();
        data.chromosomeData = new ChromosomeData[popSize];
        data.size = popSize;
        for (int i = 0; i < popSize; ++i) {
            IChromosome chrom = pop.getChromosome(i);
            ChromosomeData chromData = new ChromosomeData();
            chromData.fitnessValue = chrom.getFitnessValue();
            chromData.size = chrom.size();
            chromData.index = i;
            data.chromosomeData[i] = chromData;
        }
        String key = a_permutation + "_" + a_run;
        this.m_genotypeData.put(key, data);
        this.addRunNumber(a_permutation, a_run);
    }

    public GenotypeData retrieveGenotype(int a_permutation, int a_run) {
        return this.m_genotypeData.get(a_permutation + "_" + a_run);
    }

    public GenotypeDataAvg calcPerformance(int a_permutation) {
        int numRuns = this.getNumberOfRuns(a_permutation);
        GenotypeDataAvg dataAvg = new GenotypeDataAvg();
        dataAvg.permutation = a_permutation;
        double sizeAvg = 0.0;
        double fitnessAvg = 0.0;
        double fitnessBest = -1.0;
        double fitnessBestOld = -1.0;
        int fitnessBestGen = -1;
        double fitnessDiversityChromsOld = -1.0;
        double fitnessBestDeltaAvg = 0.0;
        double fitnessDiversityAvg = 0.0;
        for (int i = 0; i < numRuns; ++i) {
            GenotypeData data = this.retrieveGenotype(a_permutation, i);
            if (i == 0) {
                dataAvg.generation = data.generation;
            }
            sizeAvg += (double)data.size / (double)numRuns;
            int size = data.size;
            double fitnessAvgChroms = 0.0;
            double fitnessDiversity = 0.0;
            double fitnessBestLocal = -1.0;
            for (int j = 0; j < size; ++j) {
                ChromosomeData chrom = data.chromosomeData[j];
                double fitness = chrom.fitnessValue;
                if (j > 0) {
                    fitnessDiversity += Math.abs(fitness - fitnessDiversityChromsOld) / (double)(size - 1);
                }
                fitnessDiversityChromsOld = fitness;
                fitnessAvgChroms += fitness / (double)size;
                if (fitnessBest < fitness) {
                    fitnessBest = fitness;
                    fitnessBestGen = data.generation;
                }
                if (!(fitnessBestLocal < fitness)) continue;
                fitnessBestLocal = fitness;
            }
            fitnessAvg += fitnessAvgChroms / (double)numRuns;
            fitnessDiversityAvg += fitnessDiversity / (double)numRuns;
            if (i > 0) {
                fitnessBestDeltaAvg += Math.abs(fitnessBestLocal - fitnessBestOld) / (double)(numRuns - 1);
            }
            fitnessBestOld = fitnessBestLocal;
        }
        dataAvg.sizeAvg = sizeAvg;
        dataAvg.avgFitnessValue = fitnessAvg;
        dataAvg.bestFitnessValue = fitnessBest;
        dataAvg.bestFitnessValueGeneration = fitnessBestGen;
        dataAvg.avgDiversityFitnessValue = fitnessDiversityAvg;
        dataAvg.avgBestDeltaFitnessValue = fitnessBestDeltaAvg;
        this.m_genotypeDataAvg.add(dataAvg);
        return dataAvg;
    }

    public List<GenotypeDataAvg> getGenotypeAverageData() {
        return this.m_genotypeDataAvg;
    }

    public class ChromosomeData {
        public int index;
        public int size;
        public double fitnessValue;
    }

    public class GenotypeData {
        public int generation;
        public int hashCode;
        public int size;
        public ChromosomeData[] chromosomeData;
    }

    public class GenotypeDataAvg {
        public int permutation;
        public int generation;
        public double sizeAvg;
        public double bestFitnessValue;
        public double avgFitnessValue;
        public int bestFitnessValueGeneration;
        public double avgDiversityFitnessValue;
        public double avgBestDeltaFitnessValue;
    }
}

