/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jgap.Configuration;
import org.jgap.FitnessEvaluator;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.IChromosome;
import org.jgap.ICompositeGene;
import org.jgap.IPersistentRepresentation;
import org.jgap.InvalidConfigurationException;
import org.jgap.UnsupportedRepresentationException;
import org.jgap.audit.IEvolutionMonitor;
import org.jgap.util.ChromosomeFitnessComparator;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;
import org.jgap.util.StringKit;

public class Population
implements Serializable,
ICloneable,
IPersistentRepresentation {
    private static final String CVS_REVISION = "$Revision: 1.66 $";
    private List<IChromosome> m_chromosomes;
    private IChromosome m_fittestChromosome;
    private boolean m_changed;
    private boolean m_sorted;
    private Configuration m_config;
    public static final String CHROM_DELIMITER = "~";
    public static final String CHROM_DELIMITER_HEADING = "[";
    public static final String CHROM_DELIMITER_CLOSING = "]";

    public Population(Configuration a_config) throws InvalidConfigurationException {
        this(a_config, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Population(Configuration a_config, IChromosome[] a_chromosomes) throws InvalidConfigurationException {
        this(a_config, a_chromosomes.length);
        List<IChromosome> list = this.m_chromosomes;
        synchronized (list) {
            for (int i = 0; i < a_chromosomes.length; ++i) {
                this.m_chromosomes.add(a_chromosomes[i]);
            }
        }
        this.setChanged(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Population(Configuration a_config, IChromosome a_chromosome) throws InvalidConfigurationException {
        this(a_config, 1);
        if (a_chromosome == null) {
            throw new IllegalArgumentException("Chromosome passed must not be null!");
        }
        List<IChromosome> list = this.m_chromosomes;
        synchronized (list) {
            this.m_chromosomes.add(a_chromosome);
        }
        this.setChanged(true);
    }

    public Population(Configuration a_config, int a_size) throws InvalidConfigurationException {
        if (a_config == null) {
            throw new InvalidConfigurationException("Configuration must not be null!");
        }
        this.m_config = a_config;
        this.m_chromosomes = new Vector<IChromosome>(a_size);
        this.setChanged(true);
    }

    public Population() throws InvalidConfigurationException {
        this(Genotype.getStaticConfiguration());
    }

    public Configuration getConfiguration() {
        return this.m_config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChromosome(IChromosome a_toAdd) {
        if (a_toAdd != null) {
            List<IChromosome> list = this.m_chromosomes;
            synchronized (list) {
                this.m_chromosomes.add(a_toAdd);
            }
            this.setChanged(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChromosomes(Population a_population) {
        if (a_population != null) {
            List<IChromosome> list = this.m_chromosomes;
            synchronized (list) {
                this.m_chromosomes.addAll(a_population.getChromosomes());
            }
            this.setChanged(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChromosomes(List a_chromosomes) {
        List<IChromosome> list = this.m_chromosomes;
        synchronized (list) {
            this.m_chromosomes = a_chromosomes;
        }
        this.setChanged(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChromosome(int a_index, IChromosome a_chromosome) {
        if (this.m_chromosomes.size() == a_index) {
            this.addChromosome(a_chromosome);
        } else {
            List<IChromosome> list = this.m_chromosomes;
            synchronized (list) {
                this.m_chromosomes.set(a_index, a_chromosome);
            }
            this.setChanged(true);
        }
    }

    public List<IChromosome> getChromosomes() {
        return this.m_chromosomes;
    }

    public IChromosome getChromosome(int a_index) {
        return this.m_chromosomes.get(a_index);
    }

    public int size() {
        return this.m_chromosomes.size();
    }

    public Iterator iterator() {
        return this.m_chromosomes.iterator();
    }

    public IChromosome[] toChromosomes() {
        return this.m_chromosomes.toArray(new IChromosome[this.m_chromosomes.size()]);
    }

    public IChromosome determineFittestChromosome() {
        if (!this.m_changed && this.m_fittestChromosome != null) {
            return this.m_fittestChromosome;
        }
        Iterator<IChromosome> it = this.m_chromosomes.iterator();
        FitnessEvaluator evaluator = this.getConfiguration().getFitnessEvaluator();
        double bestFitness = evaluator.isFitter(2.0, 1.0) ? -1.0 : Double.MAX_VALUE;
        while (it.hasNext()) {
            IChromosome chrom = it.next();
            double fitness = chrom.getFitnessValue();
            if (!evaluator.isFitter(fitness, bestFitness) && this.m_fittestChromosome != null) continue;
            this.m_fittestChromosome = chrom;
            bestFitness = fitness;
        }
        this.setChanged(false);
        return this.m_fittestChromosome;
    }

    public IChromosome determineFittestChromosome(int a_startIndex, int a_endIndex) {
        double bestFitness = -1.0;
        FitnessEvaluator evaluator = this.getConfiguration().getFitnessEvaluator();
        int startIndex = Math.max(0, a_startIndex);
        int endIndex = Math.min(this.m_chromosomes.size() - 1, a_endIndex);
        this.m_fittestChromosome = null;
        for (int i = startIndex; i <= endIndex; ++i) {
            IChromosome chrom = this.m_chromosomes.get(i);
            double fitness = chrom.getFitnessValue();
            if (!evaluator.isFitter(fitness, bestFitness) && this.m_fittestChromosome != null) continue;
            this.m_fittestChromosome = chrom;
            bestFitness = fitness;
        }
        return this.m_fittestChromosome;
    }

    protected void setChanged(boolean a_changed) {
        this.m_changed = a_changed;
        this.setSorted(false);
    }

    public boolean isChanged() {
        return this.m_changed;
    }

    protected void setSorted(boolean a_sorted) {
        this.m_sorted = a_sorted;
    }

    public boolean contains(IChromosome a_chromosome) {
        return this.m_chromosomes.contains(a_chromosome);
    }

    IChromosome removeChromosome(int a_index) {
        if (a_index < 0 || a_index >= this.size()) {
            throw new IllegalArgumentException("Index must be within bounds!");
        }
        this.setChanged(true);
        return this.m_chromosomes.remove(a_index);
    }

    public void keepPopSizeConstant() throws InvalidConfigurationException {
        boolean monitorActive;
        int maxSize = this.getConfiguration().getPopulationSize();
        IEvolutionMonitor monitor = this.getConfiguration().getMonitor();
        boolean bl = monitorActive = monitor != null;
        for (int popSize = this.size(); popSize > maxSize; --popSize) {
            if (monitorActive) {
                monitor.event("remove_chromosome", this.getConfiguration().getGenerationNr(), new Object[]{this, new Integer(0)});
            }
            this.removeChromosome(0);
        }
    }

    public List determineFittestChromosomes(int a_numberOfChromosomes) {
        int numberOfChromosomes = Math.min(a_numberOfChromosomes, this.getChromosomes().size());
        if (numberOfChromosomes <= 0) {
            return null;
        }
        if (!this.m_changed && this.m_sorted) {
            return this.getChromosomes().subList(0, numberOfChromosomes);
        }
        this.sortByFitness();
        return this.getChromosomes().subList(0, numberOfChromosomes);
    }

    public void sortByFitness() {
        this.sort(new ChromosomeFitnessComparator(this.getConfiguration().getFitnessEvaluator()));
        this.setChanged(false);
        this.setSorted(true);
        this.m_fittestChromosome = this.m_chromosomes.get(0);
    }

    protected void sort(Comparator a_comparator) {
        Collections.sort(this.getChromosomes(), a_comparator);
    }

    public List getGenome(boolean a_resolveCompositeGenes) {
        Vector result = new Vector();
        List<IChromosome> chroms = this.getChromosomes();
        int len = chroms.size();
        for (int i = 0; i < len; ++i) {
            IChromosome chrom = chroms.get(i);
            for (Gene gene : chrom.getGenes()) {
                if (a_resolveCompositeGenes && gene instanceof ICompositeGene) {
                    this.addCompositeGene(result, (ICompositeGene)gene);
                    continue;
                }
                this.addAtomicGene(result, gene);
            }
        }
        return result;
    }

    private void addCompositeGene(List a_result, Gene a_gene) {
        if (a_gene instanceof ICompositeGene) {
            int len = a_gene.size();
            for (int i = 0; i < len; ++i) {
                this.addCompositeGene(a_result, ((ICompositeGene)a_gene).geneAt(i));
            }
        } else {
            this.addAtomicGene(a_result, a_gene);
        }
    }

    private void addAtomicGene(List a_result, Gene a_gene) {
        a_result.add(a_gene);
    }

    public boolean isSorted() {
        return this.m_sorted;
    }

    public boolean equals(Object a_pop) {
        try {
            return this.compareTo(a_pop) == 0;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int compareTo(Object a_pop) {
        int size2;
        Population other = (Population)a_pop;
        if (a_pop == null) {
            return 1;
        }
        int size1 = this.size();
        if (size1 != (size2 = other.size())) {
            if (size1 < size2) {
                return -1;
            }
            return 1;
        }
        List<IChromosome> chroms2 = other.getChromosomes();
        for (int i = 0; i < size1; ++i) {
            if (chroms2.contains(this.m_chromosomes.get(i))) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public Object clone() {
        try {
            Population result = new Population(this.m_config);
            result.m_changed = true;
            result.m_sorted = false;
            result.m_fittestChromosome = this.m_fittestChromosome;
            int size = this.m_chromosomes.size();
            for (int i = 0; i < size; ++i) {
                IChromosome chrom = this.m_chromosomes.get(i);
                result.addChromosome((IChromosome)chrom.clone());
            }
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }

    public void clear() {
        this.m_chromosomes.clear();
        this.m_changed = true;
        this.m_sorted = true;
        this.m_fittestChromosome = null;
    }

    @Override
    public String getPersistentRepresentation() {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < this.m_chromosomes.size(); ++i) {
            IChromosome chrom = this.m_chromosomes.get(i);
            if (!(chrom instanceof IPersistentRepresentation)) {
                throw new RuntimeException("Population contains a chromosome of type " + chrom.getClass().getName() + " which does not implement" + " IPersistentRepresentation!");
            }
            b.append(CHROM_DELIMITER_HEADING);
            b.append(StringKit.encode(chrom.getClass().getName() + CHROM_DELIMITER + ((IPersistentRepresentation)((Object)chrom)).getPersistentRepresentation()));
            b.append(CHROM_DELIMITER_CLOSING);
        }
        return b.toString();
    }

    @Override
    public void setValueFromPersistentRepresentation(String a_representation) throws UnsupportedRepresentationException {
        if (a_representation != null) {
            try {
                List r = Population.split(a_representation);
                this.m_chromosomes = new Vector<IChromosome>();
                Iterator iter = r.iterator();
                while (iter.hasNext()) {
                    String g = StringKit.decode((String)iter.next());
                    StringTokenizer st = new StringTokenizer(g, CHROM_DELIMITER);
                    if (st.countTokens() != 2) {
                        throw new UnsupportedRepresentationException("In " + g + ", " + "expecting two tokens, separated by " + CHROM_DELIMITER);
                    }
                    String clas = st.nextToken();
                    String representation = st.nextToken();
                    IChromosome chrom = this.createChromosome(clas, representation);
                    this.m_chromosomes.add(chrom);
                }
                this.setChanged(true);
            }
            catch (Exception ex) {
                throw new UnsupportedRepresentationException(ex.toString());
            }
        }
    }

    protected IChromosome createChromosome(String a_chromClassName, String a_persistentRepresentation) throws Exception {
        Class<?> chromClass = Class.forName(a_chromClassName);
        Constructor<?> constr = chromClass.getConstructor(Configuration.class);
        IChromosome chrom = (IChromosome)constr.newInstance(this.getConfiguration());
        ((IPersistentRepresentation)((Object)chrom)).setValueFromPersistentRepresentation(a_persistentRepresentation);
        return chrom;
    }

    protected static final List split(String a_string) throws UnsupportedRepresentationException {
        List<String> a = Collections.synchronizedList(new ArrayList());
        StringTokenizer st = new StringTokenizer(a_string, "[]", true);
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equals(CHROM_DELIMITER_HEADING)) {
                throw new UnsupportedRepresentationException(a_string + " no open tag");
            }
            String n = st.nextToken();
            if (n.equals(CHROM_DELIMITER_CLOSING)) {
                a.add("");
                continue;
            }
            a.add(n);
            if (st.nextToken().equals(CHROM_DELIMITER_CLOSING)) continue;
            throw new UnsupportedRepresentationException(a_string + " no close tag");
        }
        return a;
    }

    public int hashCode() {
        int size = this.size();
        int twopower = 1;
        int localHashCode = -593;
        int i = 0;
        while (i < size) {
            IChromosome s = this.getChromosome(i);
            localHashCode = 31 * localHashCode + s.hashCode();
            ++i;
            twopower = 2 * twopower;
        }
        return localHashCode;
    }
}

