/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.GeneticOperator;
import org.jgap.IBreeder;
import org.jgap.IChromosome;
import org.jgap.IInitializer;
import org.jgap.InvalidConfigurationException;
import org.jgap.NaturalSelector;
import org.jgap.Population;
import org.jgap.audit.IEvolutionMonitor;
import org.jgap.distr.IPopulationMerger;
import org.jgap.impl.job.EvolveData;
import org.jgap.impl.job.EvolveJob;
import org.jgap.impl.job.EvolveResult;
import org.jgap.impl.job.IEvolveJob;
import org.jgap.impl.job.IPopulationSplitter;

public class Genotype
implements Serializable,
Runnable {
    private static final String CVS_REVISION = "$Revision: 1.107 $";
    private Configuration m_activeConfiguration;
    private static transient Configuration m_staticConfiguration;
    private Population m_population;

    public Genotype(Configuration a_configuration, IChromosome[] a_initialChromosomes) throws InvalidConfigurationException {
        this(a_configuration, new Population(a_configuration, a_initialChromosomes));
    }

    public Genotype(Configuration a_configuration, Population a_population) throws InvalidConfigurationException {
        if (a_configuration == null) {
            throw new IllegalArgumentException("The Configuration instance must not be null.");
        }
        if (a_population == null) {
            throw new IllegalArgumentException("The Population must not be null.");
        }
        for (int i = 0; i < a_population.size(); ++i) {
            if (a_population.getChromosome(i) != null) continue;
            throw new IllegalArgumentException("The Chromosome instance at index " + i + " of the array of " + "Chromosomes is null. No Chromosomes instance in this array " + "must not be null.");
        }
        this.m_population = a_population;
        a_configuration.lockSettings();
        this.m_activeConfiguration = a_configuration;
    }

    public Genotype(Configuration a_configuration) throws InvalidConfigurationException {
    }

    public synchronized IChromosome[] getChromosomes() {
        Iterator it = this.getPopulation().iterator();
        IChromosome[] result = new Chromosome[this.getPopulation().size()];
        int i = 0;
        while (it.hasNext()) {
            result[i++] = (IChromosome)it.next();
        }
        return result;
    }

    public Population getPopulation() {
        return this.m_population;
    }

    public synchronized IChromosome getFittestChromosome() {
        return this.getPopulation().determineFittestChromosome();
    }

    public synchronized IChromosome getFittestChromosome(int a_startIndex, int a_endIndex) {
        return this.getPopulation().determineFittestChromosome(a_startIndex, a_endIndex);
    }

    public synchronized List getFittestChromosomes(int a_numberOfChromosomes) {
        return this.getPopulation().determineFittestChromosomes(a_numberOfChromosomes);
    }

    public synchronized void evolve() {
        IBreeder breeder = this.getConfiguration().getBreeder();
        Population newPop = breeder.evolve(this.getPopulation(), this.getConfiguration());
        this.setPopulation(newPop);
    }

    public void evolve(int a_numberOfEvolutions) {
        for (int i = 0; i < a_numberOfEvolutions; ++i) {
            this.evolve();
        }
        if (this.m_activeConfiguration.isKeepPopulationSizeConstant()) {
            this.keepPopSizeConstant(this.getPopulation(), this.m_activeConfiguration.getPopulationSize());
        }
    }

    public List<String> evolve(IEvolutionMonitor a_monitor) {
        boolean goon;
        a_monitor.start(this.getConfiguration());
        this.getConfiguration().setMonitor(a_monitor);
        Vector<String> messages = new Vector<String>();
        do {
            this.evolve();
        } while (goon = a_monitor.nextCycle(this.getPopulation(), messages));
        return messages;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.getPopulation().size(); ++i) {
            buffer.append(this.getPopulation().getChromosome(i).toString());
            buffer.append(" [");
            buffer.append(this.getPopulation().getChromosome(i).getFitnessValueDirectly());
            buffer.append("]\n");
        }
        return buffer.toString();
    }

    public static Genotype randomInitialGenotype(Configuration a_configuration) throws InvalidConfigurationException {
        if (a_configuration == null) {
            throw new IllegalArgumentException("The Configuration instance may not be null.");
        }
        a_configuration.lockSettings();
        int populationSize = a_configuration.getPopulationSize();
        Population pop = new Population(a_configuration, populationSize);
        Genotype result = new Genotype(a_configuration, pop);
        result.fillPopulation(populationSize);
        return result;
    }

    public void fillPopulation(int a_num) throws InvalidConfigurationException {
        IChromosome sampleChrom = this.getConfiguration().getSampleChromosome();
        Class<?> sampleClass = sampleChrom.getClass();
        IInitializer chromIniter = this.getConfiguration().getJGAPFactory().getInitializerFor(sampleChrom, sampleClass);
        if (chromIniter == null) {
            throw new InvalidConfigurationException("No initializer found for class " + sampleClass);
        }
        try {
            for (int i = 0; i < a_num; ++i) {
                this.getPopulation().addChromosome((IChromosome)chromIniter.perform(sampleChrom, sampleClass, null));
            }
        }
        catch (Exception ex) {
            if (ex.getCause() != null) {
                throw new IllegalStateException(ex.getCause().toString());
            }
            throw new IllegalStateException(ex.getMessage());
        }
    }

    public boolean equals(Object a_other) {
        try {
            if (a_other == null) {
                return false;
            }
            Genotype otherGenotype = (Genotype)a_other;
            if (this.getPopulation().size() != otherGenotype.getPopulation().size()) {
                return false;
            }
            Collections.sort(this.getPopulation().getChromosomes());
            Collections.sort(otherGenotype.getPopulation().getChromosomes());
            for (int i = 0; i < this.getPopulation().size(); ++i) {
                if (this.getPopulation().getChromosome(i).equals(otherGenotype.getPopulation().getChromosome(i))) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    protected void applyNaturalSelectors(boolean a_processBeforeGeneticOperators) {
        try {
            int selectorSize = this.m_activeConfiguration.getNaturalSelectorsSize(a_processBeforeGeneticOperators);
            if (selectorSize > 0) {
                int population_size = this.m_activeConfiguration.getPopulationSize();
                if (a_processBeforeGeneticOperators) {
                    population_size = (int)Math.round((double)population_size * this.getConfiguration().getSelectFromPrevGen());
                }
                Population new_population = new Population(this.m_activeConfiguration, population_size);
                for (int i = 0; i < selectorSize; ++i) {
                    NaturalSelector selector = this.m_activeConfiguration.getNaturalSelector(a_processBeforeGeneticOperators, i);
                    int single_selection_size = i == selectorSize - 1 && i > 0 ? population_size - this.getPopulation().size() : population_size / selectorSize;
                    selector.select(single_selection_size, this.getPopulation(), new_population);
                    selector.empty();
                }
                this.setPopulation(new Population(this.m_activeConfiguration));
                this.getPopulation().addChromosomes(new_population);
            }
        }
        catch (InvalidConfigurationException iex) {
            throw new IllegalStateException(iex.getMessage());
        }
    }

    public void applyGeneticOperators() {
        List geneticOperators = this.m_activeConfiguration.getGeneticOperators();
        for (GeneticOperator operator : geneticOperators) {
            this.applyGeneticOperator(operator, this.getPopulation(), this.getPopulation().getChromosomes());
        }
    }

    public static Configuration getStaticConfiguration() {
        return m_staticConfiguration;
    }

    public static void setStaticConfiguration(Configuration a_configuration) {
        m_staticConfiguration = a_configuration;
    }

    public Configuration getConfiguration() {
        return this.m_activeConfiguration;
    }

    public int hashCode() {
        int size = this.getPopulation().size();
        int twopower = 1;
        int localHashCode = -573;
        int i = 0;
        while (i < size) {
            IChromosome s = this.getPopulation().getChromosome(i);
            localHashCode = 31 * localHashCode + s.hashCode();
            ++i;
            twopower = 2 * twopower;
        }
        return localHashCode;
    }

    protected void setPopulation(Population a_pop) {
        this.m_population = a_pop;
    }

    protected void applyGeneticOperator(GeneticOperator a_operator, Population a_population, List a_chromosomes) {
        a_operator.operate(a_population, a_chromosomes);
    }

    protected void keepPopSizeConstant(Population a_pop, int a_maxSize) {
        for (int popSize = a_pop.size(); popSize > a_maxSize; --popSize) {
            a_pop.removeChromosome(0);
        }
    }

    @Override
    public void run() {
        while (true) {
            Thread.currentThread();
            if (Thread.interrupted()) break;
            this.evolve();
        }
    }

    public List<IEvolveJob> getEvolves(IPopulationSplitter a_splitter) throws Exception {
        Vector<IEvolveJob> result = new Vector<IEvolveJob>();
        Population[] pops = a_splitter.split(this.getPopulation());
        for (int i = 0; i < pops.length; ++i) {
            Configuration newConf = (Configuration)this.getConfiguration().clone();
            EvolveData data = new EvolveData(newConf);
            if (pops[i] == null) {
                throw new IllegalStateException("Population must no be null (Index: " + i + ", Splitter: " + a_splitter.getClass().getName() + ")");
            }
            data.setPopulation(pops[i]);
            data.setBreeder(newConf.getBreeder());
            EvolveJob evolver = new EvolveJob(data);
            result.add(evolver);
        }
        this.getPopulation().clear();
        return result;
    }

    public void mergeResults(IPopulationMerger a_merger, EvolveResult[] a_results) throws Exception {
        int size = a_results.length;
        Population target = new Population(this.getConfiguration());
        for (int i = 0; i < size; ++i) {
            EvolveResult singleResult = a_results[i];
            if (singleResult == null) {
                throw new IllegalStateException("Single result is null!");
            }
            Population pop = singleResult.getPopulation();
            List goodOnes = pop.determineFittestChromosomes(3);
            for (int j = 0; j < goodOnes.size(); ++j) {
                IChromosome goodOne = (IChromosome)goodOnes.get(j);
                target.addChromosome(goodOne);
            }
        }
        this.setPopulation(target);
    }
}

