/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.IBusinessKey;
import org.jgap.IChromosome;
import org.jgap.IInitializer;
import org.jgap.IJGAPFactory;
import org.jgap.IPersistentRepresentation;
import org.jgap.InvalidConfigurationException;
import org.jgap.UnsupportedRepresentationException;
import org.jgap.impl.JGAPFactory;
import org.jgap.util.StringKit;

public abstract class BaseChromosome
implements IChromosome,
IInitializer,
IPersistentRepresentation,
IBusinessKey {
    private static final String CVS_REVISION = "$Revision: 1.15 $";
    public static final String GENE_DELIMITER = "#";
    public static final String GENE_DELIMITER_HEADING = "<";
    public static final String GENE_DELIMITER_CLOSING = ">";
    public static final String CHROM_DELIMITER = "#";
    private Configuration m_configuration;
    private Gene[] m_genes;
    private int m_age;
    private int m_operatedOn;
    private String m_uniqueID;
    private Map<Integer, String> m_uniqueIDTemplates;

    public BaseChromosome(Configuration a_configuration) throws InvalidConfigurationException {
        if (a_configuration == null) {
            throw new InvalidConfigurationException("Configuration to be set must not be null!");
        }
        this.m_configuration = a_configuration;
        if (this.m_configuration.isUniqueKeysActive()) {
            this.m_uniqueIDTemplates = new HashMap<Integer, String>();
            IJGAPFactory factory = this.m_configuration.getJGAPFactory();
            if (JGAPFactory.class.isAssignableFrom(factory.getClass())) {
                this.m_uniqueID = ((JGAPFactory)this.m_configuration.getJGAPFactory()).getUniqueKey(this.getClass().getName());
            }
        }
    }

    @Override
    public String getUniqueID() {
        return this.m_uniqueID;
    }

    @Override
    public void setUniqueIDTemplate(String a_templateID, int a_index) {
        this.m_uniqueIDTemplates.put(a_index, a_templateID);
    }

    @Override
    public String getUniqueIDTemplate(int a_index) {
        return this.m_uniqueIDTemplates.get(a_index);
    }

    @Override
    public Configuration getConfiguration() {
        return this.m_configuration;
    }

    @Override
    public abstract Object clone();

    @Override
    public void increaseAge() {
        ++this.m_age;
    }

    @Override
    public void resetAge() {
        this.m_age = 0;
    }

    @Override
    public int getAge() {
        return this.m_age;
    }

    @Override
    public void setAge(int a_age) {
        this.m_age = a_age;
    }

    @Override
    public void increaseOperatedOn() {
        ++this.m_operatedOn;
    }

    @Override
    public void resetOperatedOn() {
        this.m_operatedOn = 0;
    }

    @Override
    public int operatedOn() {
        return this.m_operatedOn;
    }

    @Override
    public synchronized Gene[] getGenes() {
        return this.m_genes;
    }

    @Override
    public void setGenes(Gene[] a_genes) throws InvalidConfigurationException {
        this.m_genes = a_genes;
    }

    @Override
    public synchronized Gene getGene(int a_desiredLocus) {
        return this.m_genes[a_desiredLocus];
    }

    public void setGene(int a_index, Gene a_gene) {
        this.m_genes[a_index] = a_gene;
    }

    @Override
    public int size() {
        if (this.m_genes == null) {
            return 0;
        }
        return this.m_genes.length;
    }

    @Override
    public String getPersistentRepresentation() {
        StringBuffer b = new StringBuffer();
        b.append(this.getFitnessValueDirectly());
        b.append("#");
        b.append(this.size());
        b.append("#");
        this.getGenesPersistentRepresentation(b);
        return b.toString();
    }

    public StringBuffer getGenesPersistentRepresentation() {
        StringBuffer b = new StringBuffer();
        this.getGenesPersistentRepresentation(b);
        return b;
    }

    @Override
    public String getBusinessKey() {
        return this.getGenesPersistentRepresentation().toString();
    }

    public void getGenesPersistentRepresentation(StringBuffer a_buffer) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Gene gene = this.getGene(i);
            a_buffer.append(GENE_DELIMITER_HEADING);
            a_buffer.append(this.encode(gene.getClass().getName() + "#" + gene.getPersistentRepresentation()));
            a_buffer.append(GENE_DELIMITER_CLOSING);
        }
    }

    protected String encode(String a_string) {
        return StringKit.encode(a_string);
    }

    protected String decode(String a_string) throws UnsupportedEncodingException {
        return StringKit.decode(a_string);
    }

    @Override
    public void setValueFromPersistentRepresentation(String a_representation) throws UnsupportedRepresentationException {
        if (a_representation != null) {
            try {
                List r = BaseChromosome.split(a_representation);
                String g = this.decode((String)r.get(0));
                this.setFitnessValue(Double.parseDouble(g));
                r.remove(0);
                g = this.decode((String)r.get(0));
                int count = Integer.parseInt(g);
                this.setGenes(new Gene[count]);
                r.remove(0);
                Iterator iter = r.iterator();
                int index = 0;
                while (iter.hasNext()) {
                    g = this.decode((String)iter.next());
                    StringTokenizer st = new StringTokenizer(g, "#");
                    if (st.countTokens() != 2) {
                        throw new UnsupportedRepresentationException("In " + g + ", " + "expecting two tokens, separated by " + "#");
                    }
                    String clas = st.nextToken();
                    String representation = st.nextToken();
                    Gene gene = this.createGene(clas, representation);
                    this.setGene(index++, gene);
                }
            }
            catch (Exception ex) {
                throw new UnsupportedRepresentationException(ex.toString());
            }
        }
    }

    protected Gene createGene(String a_geneClassName, String a_persistentRepresentation) throws Exception {
        Class<?> geneClass = Class.forName(a_geneClassName);
        Constructor<?> constr = geneClass.getConstructor(Configuration.class);
        Gene gene = (Gene)constr.newInstance(this.getConfiguration());
        gene.setValueFromPersistentRepresentation(a_persistentRepresentation);
        return gene;
    }

    protected static final List split(String a_string) throws UnsupportedRepresentationException {
        List<String> a = Collections.synchronizedList(new ArrayList());
        int index = 0;
        StringTokenizer st0 = new StringTokenizer(a_string, "#", false);
        if (!st0.hasMoreTokens()) {
            throw new UnsupportedRepresentationException("Fitness value expected!");
        }
        String fitnessS = st0.nextToken();
        a.add(fitnessS);
        index += fitnessS.length();
        if (!st0.hasMoreTokens()) {
            throw new UnsupportedRepresentationException("Number of genes expected!");
        }
        String numGenes = st0.nextToken();
        a.add(numGenes);
        index += numGenes.length();
        index += 2;
        if (!st0.hasMoreTokens()) {
            throw new UnsupportedRepresentationException("Gene data missing!");
        }
        a_string = a_string.substring(index);
        StringTokenizer st = new StringTokenizer(a_string, "<>", true);
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equals(GENE_DELIMITER_HEADING)) {
                throw new UnsupportedRepresentationException(a_string + " no open tag");
            }
            String n = st.nextToken();
            if (n.equals(GENE_DELIMITER_CLOSING)) {
                a.add("");
                continue;
            }
            a.add(n);
            if (st.nextToken().equals(GENE_DELIMITER_CLOSING)) continue;
            throw new UnsupportedRepresentationException(a_string + " no close tag");
        }
        return a;
    }
}

