/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.parametric;

import vmm3d.core.RealParamAnimateable;
import vmm3d.core3D.Vector3D;
import vmm3d.surface.parametric.SurfaceParametric;

public class SievertEnneper
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", "0.0", "2.5", "-2.5");

    public SievertEnneper() {
        this.uPatchCount.setValueAndDefault(12);
        this.vPatchCount.setValueAndDefault(12);
        this.umin.reset("-1.5608");
        this.umax.reset("1.5608");
        this.vmin.reset("0.02");
        this.vmax.reset("3.12159");
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setDefaultWindow(-2.5, 2.5, -2.5, 2.5);
        this.setDefaultOrientation(2);
        this.addParameter(this.aa);
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        double AA = Math.exp(this.aa.getValue());
        double phiu = -u / Math.sqrt(AA + 1.0) + Math.atan(Math.sqrt(AA + 1.0) * Math.tan(u));
        double cu = Math.cos(u);
        double su = Math.sin(u);
        double sv = Math.sin(v);
        double auv = 2.0 / (AA + 1.0 - AA * sv * sv * cu * cu);
        double ruv = auv * Math.sqrt((AA + 1.0) * (1.0 + AA * su * su)) * sv / Math.sqrt(AA);
        double x = ruv * Math.cos(phiu);
        double z = ruv * Math.sin(phiu);
        double y = (Math.log(Math.tan(v / 2.0)) + (AA + 1.0) * auv * Math.cos(v)) / Math.sqrt(AA);
        return new Vector3D(x, y, z);
    }
}

