/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.parametric;

import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import vmm3d.actions.AbstractActionVMM;
import vmm3d.actions.ActionList;
import vmm3d.core.BasicAnimator;
import vmm3d.core.I18n;
import vmm3d.core.Parameter;
import vmm3d.core.Quaternion;
import vmm3d.core.RealParamAnimateable;
import vmm3d.core.View;
import vmm3d.core3D.Vector3D;
import vmm3d.surface.parametric.SurfaceParametric;

public class DoublyHopfFiberedTori
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm3d.surface.parametric.DoublyHopfFiberedTori.aa", 0.7853981633974483, 0.7853981633974483, 1.413716694115407);
    private RealParamAnimateable bb = new RealParamAnimateable("vmm3d.surface.parametric.DoublyHopfFiberedTori.bb", 0.0, 0.0, 0.0);
    double AA;
    double BB;
    Quaternion q0;
    boolean in2ndMorph = false;

    public DoublyHopfFiberedTori() {
        this.uPatchCount.setValueAndDefault(24);
        this.vPatchCount.setValueAndDefault(12);
        this.umin.reset("0");
        this.umax.reset("2 pi");
        this.vmin.reset("0");
        this.vmax.reset("pi");
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setDefaultWindow(-2.5, 2.5, -2.5, 2.5);
        this.setDefaultOrientation(0);
        this.addParameter(this.bb);
        this.addParameter(this.aa);
    }

    @Override
    public void parameterChanged(Parameter param, Object oldValue, Object newValue) {
        super.parameterChanged(param, oldValue, newValue);
        this.AA = this.aa.getValue();
        this.BB = this.bb.getValue();
        this.q0 = new Quaternion(Math.cos(this.AA) * Math.cos(0.0), Math.cos(this.AA) * Math.sin(0.0), Math.sin(this.AA) * Math.cos(0.0), -Math.sin(this.AA) * Math.sin(0.0));
    }

    @Override
    public ActionList getAdditionalAnimationsForView(final View view) {
        ActionList actions = super.getAdditionalAnimationsForView(view);
        final BasicAnimator animation = new BasicAnimator();
        animation.setLooping(1);
        animation.setUseFilmstrip(this.getUseFilmstripForMorphing());
        animation.setFrames(this.getFramesForMorphing());
        animation.setMillisecondsPerFrame(200);
        animation.addWithCustomLimits(this.bb, 0.0, Math.PI * 2);
        animation.addWithCustomValue(this.vmin, 0.0);
        animation.addWithCustomValue(this.vmax, Math.PI);
        animation.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DoublyHopfFiberedTori.this.in2ndMorph = animation.isRunning();
            }
        });
        actions.add(new AbstractActionVMM(I18n.tr("vmm3d.surface.parametric.DoublyHopfFiberedTori.RotateAroundCircle")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                view.getDisplay().installAnimation(animation);
            }
        });
        return actions;
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        Quaternion eiu = new Quaternion(Math.cos(u), Math.sin(u), 0.0, 0.0);
        Quaternion qv = new Quaternion(Math.cos(this.AA) * Math.cos(v), Math.cos(this.AA) * Math.sin(v), Math.sin(this.AA) * Math.cos(v), -Math.sin(this.AA) * Math.sin(v));
        Quaternion uv = eiu.times(qv);
        Quaternion uvb = uv.rotateAroundHopfFibre(this.BB, this.q0);
        return new Vector3D(uvb.StereographicProjection());
    }
}

