/*
 * Decompiled with CFR 0.152.
 */
package vmm3d.surface.parametric;

import vmm3d.core.RealParamAnimateable;
import vmm3d.core3D.Vector3D;
import vmm3d.surface.parametric.SurfaceParametric;

public class Conoid
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm3d.surface.parametric.Conoid.aa", "1", "1", "1");
    private RealParamAnimateable bb = new RealParamAnimateable("vmm3d.surface.parametric.Conoid.bb", 1.0, 1.0, 12.0);

    public Conoid() {
        this.uPatchCount.setValueAndDefault(16);
        this.vPatchCount.setValueAndDefault(16);
        this.umin.reset("-1");
        this.umax.reset("1");
        this.vmin.reset("-pi");
        this.vmax.reset("pi");
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setDefaultWindow(-2.5, 2.5, -2.5, 2.5);
        this.addParameter(this.aa);
        this.addParameter(this.bb);
        this.setFramesForMorphing(11);
    }

    private static double cos(double t) {
        return Math.cos(t);
    }

    private static double sin(double t) {
        return Math.sin(t);
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        double AA = this.aa.getValue();
        double BB = this.bb.getValue();
        double x = u * Conoid.cos(v);
        double y = u * Conoid.sin(v);
        double z = AA * Conoid.sin(BB * v);
        return new Vector3D(x, y, z);
    }
}

